/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class DependencyRequirement {
    public static final String MIN_CORE_VERSION = "1.1.1-R0.11-SNAPSHOT";

    public static boolean meetsVersion(String requiredVersion, String providedVersion) {
        List<Integer> required = DependencyRequirement.splitVersion(requiredVersion);
        List<Integer> provided = DependencyRequirement.splitVersion(providedVersion);
        if (required.isEmpty()) {
            return true;
        }
        if (provided.isEmpty()) {
            return false;
        }
        int size = Math.min(required.size(), provided.size());
        for (int i = 0; i < size; ++i) {
            if (provided.get(i) > required.get(i)) {
                return true;
            }
            if (provided.get(i) >= required.get(i)) continue;
            return false;
        }
        return true;
    }

    private static List<Integer> splitVersion(String version) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String a : version.split("-")) {
            result.addAll(Arrays.stream(a.split("\\.")).map(str -> {
                try {
                    return Integer.parseInt(str.replace("R", "").replace("SNAPSHOT", ""));
                }
                catch (NumberFormatException e) {
                    return 0;
                }
            }).collect(Collectors.toList()));
        }
        return result;
    }
}

