/**
 * Fabled
 * studio.magemonkey.fabled.dynamic.mechanic.HealMechanic
 * <p>
 * The MIT License (MIT)
 * <p>
 * Copyright (c) 2024 MageMonkeyStudio
 * <p>
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software") to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * <p>
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * <p>
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package studio.magemonkey.fabled.dynamic.mechanic;

import org.bukkit.Bukkit;
import org.bukkit.entity.LivingEntity;
import studio.magemonkey.fabled.api.event.SkillHealEvent;

import java.util.List;

/**
 * Heals each target
 */
public class HealMechanic extends MechanicComponent {
    private static final String TYPE  = "type";
    private static final String VALUE = "value";

    @Override
    public String getKey() {
        return "heal";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        boolean percent = settings.getString(TYPE, "health").toLowerCase().equals("percent");
        double  value   = parseValues(caster, VALUE, level, 1.0);
        if (value < 0) {
            return false;
        }
        for (LivingEntity target : targets) {
            if (target.isDead()) {
                continue;
            }

            double amount = value;
            if (percent) {
                amount = target.getMaxHealth() * value / 100;
            }

            SkillHealEvent event = new SkillHealEvent(caster, target, amount);
            Bukkit.getPluginManager().callEvent(event);
            if (!event.isCancelled()) {
                target.setHealth(Math.min(target.getHealth() + event.getAmount(), target.getMaxHealth()));
            }
        }
        return targets.size() > 0;
    }
}
