/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.utils.actions.executors;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.util.actions.actions.IActionExecutor;
import studio.magemonkey.codex.util.actions.params.IParamResult;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.config.EngineCfg;
import studio.magemonkey.divinity.utils.ParticleUtils;

public class ActionParticleLine
extends IActionExecutor {
    public ActionParticleLine(@NotNull Divinity plugin) {
        super((CodexPlugin)plugin, "PARTICLE_LINE");
    }

    public void registerParams() {
        this.registerParam("DELAY");
        this.registerParam("NAME");
        this.registerParam("TARGET");
        this.registerParam("AMOUNT");
        this.registerParam("SPEED");
        this.registerParam("OFFSET");
    }

    protected void execute(Entity exe, Set<Entity> targets, IParamResult result) {
        String name = result.getParamValue("NAME").getString(null);
        if (name == null) {
            return;
        }
        double[] offset = result.getParamValue("OFFSET").getDoubleArray();
        int amount = result.getParamValue("AMOUNT").getInt(30);
        float speed = (float)result.getParamValue("SPEED").getDouble(0.1);
        if (!targets.isEmpty()) {
            for (Entity e : targets) {
                Location loc = e instanceof LivingEntity ? ((LivingEntity)e).getEyeLocation() : e.getLocation();
                ParticleUtils.drawParticleLine(exe.getLocation(), loc, name, (float)offset[0], (float)offset[1], (float)offset[2], speed, amount);
            }
        } else if (exe instanceof LivingEntity) {
            LivingEntity caster = (LivingEntity)exe;
            Location to = caster.getTargetBlock(null, (int)EngineCfg.COMBAT_MAX_GET_TARGET_DISTANCE).getLocation();
            ParticleUtils.drawParticleLine(caster.getEyeLocation().clone().add(0.0, -0.5, 0.0), to, name, (float)offset[0], (float)offset[1], (float)offset[2], speed, amount);
        }
    }

    public boolean mustHaveTarget() {
        return false;
    }

    @NotNull
    public List<String> getDescription() {
        return Arrays.asList("Draws a particle line");
    }
}

