/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.stats.items.attributes.api;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.compat.VersionManager;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.NumberUT;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.config.EngineCfg;
import studio.magemonkey.divinity.modules.list.gems.GemManager;
import studio.magemonkey.divinity.modules.list.refine.RefineManager;
import studio.magemonkey.divinity.stats.bonus.BonusCalculator;
import studio.magemonkey.divinity.stats.bonus.BonusMap;
import studio.magemonkey.divinity.stats.bonus.StatBonus;
import studio.magemonkey.divinity.stats.items.ItemStats;
import studio.magemonkey.divinity.stats.items.api.DuplicableItemLoreStat;
import studio.magemonkey.divinity.stats.items.api.DynamicStat;
import studio.magemonkey.divinity.stats.items.attributes.api.TypedStat;
import studio.magemonkey.divinity.utils.ItemUtils;

public class SimpleStat
extends DuplicableItemLoreStat<StatBonus>
implements TypedStat,
DynamicStat<StatBonus> {
    protected TypedStat.Type statType;
    private double cap;

    public SimpleStat(@NotNull TypedStat.Type statType, @NotNull String name, @NotNull String format, double cap) {
        super(statType.name(), name, format, "%ITEM_STAT_" + statType.name() + "%", "ITEM_STAT_", StatBonus.DATA_TYPE);
        this.statType = statType;
        this.cap = cap;
        ItemStats.registerDynamicStat(this);
        this.keys.add(NamespacedKey.fromString((String)("prorpgitems:item_stat_" + this.getId())));
        this.keys.add(NamespacedKey.fromString((String)("prorpgitems:qrpg_item_stat_" + this.getId())));
        this.keys.add(NamespacedKey.fromString((String)("quantumrpg:qrpg_item_stat_" + this.getId())));
    }

    @Override
    @NotNull
    public Class<StatBonus> getParameterClass() {
        return StatBonus.class;
    }

    public double getTotal(@NotNull ItemStack item, @Nullable Player player, double def) {
        List<BiFunction<Boolean, Double, Double>> bonuses = this.get(item, player);
        double value = bonuses.isEmpty() ? def : BonusCalculator.SIMPLE_FULL.apply(0.0, bonuses);
        return value;
    }

    public double getTotal(@NotNull ItemStack item, @Nullable Player player) {
        return this.getTotal(item, player, 0.0);
    }

    @NotNull
    public List<BiFunction<Boolean, Double, Double>> get(@NotNull ItemStack item, @Nullable Player player) {
        RefineManager refineManager;
        StatBonus baseLine;
        GemManager gems;
        ArrayList<BiFunction<Boolean, Double, Double>> bonuses = new ArrayList<BiFunction<Boolean, Double, Double>>();
        double base = 0.0;
        double percent = 0.0;
        boolean has = false;
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            PersistentDataContainer container = meta.getPersistentDataContainer();
            for (NamespacedKey namespacedKey : this.keys) {
                Double value;
                if (!container.has(namespacedKey, PersistentDataType.DOUBLE) || (value = (Double)container.get(namespacedKey, PersistentDataType.DOUBLE)) == null) continue;
                base += value.doubleValue();
                has = true;
                break;
            }
        }
        for (Object bonus : this.getAllRaw(item)) {
            if (!((StatBonus)bonus).meetsRequirement(player)) continue;
            double[] dArray = ((StatBonus)bonus).getValue();
            if (dArray.length == 1 && ((StatBonus)bonus).isPercent()) {
                percent += dArray[0];
                continue;
            }
            base += dArray[0];
            has = true;
        }
        if (has) {
            double finalBase = base;
            bonuses.add((isPercent, input) -> isPercent != false ? input : input + finalBase);
            double d = percent;
            bonuses.add((isPercent, input) -> isPercent != false ? input + finalPercent : input);
        }
        if ((gems = Divinity.getInstance().getModuleCache().getGemManager()) != null) {
            for (Map.Entry entry : gems.getItemSockets(item)) {
                BiFunction<Boolean, Double, Double> bif;
                BonusMap bMap = ((GemManager.Gem)entry.getKey()).getBonusMap((Integer)entry.getValue());
                if (bMap == null || (bif = bMap.getBonus(this)) == null) continue;
                bonuses.add(bif);
            }
        }
        if ((baseLine = (StatBonus)this.getRaw(meta, 0)) != null && baseLine.isBaseStat() && (refineManager = Divinity.getInstance().getModuleCache().getRefineManager()) != null && has) {
            bonuses.add(refineManager.getRefinedBonus(item, this));
        }
        return bonuses;
    }

    public static double getDefaultAttackSpeed(@NotNull ItemStack item, double def) {
        double value = SimpleStat.getDefaultAttackSpeed(item);
        return value == 0.0 ? def : value;
    }

    public static double getDefaultAttackSpeed(@NotNull ItemStack item) {
        return VersionManager.getNms().getDefaultSpeed(item);
    }

    @Override
    @NotNull
    public TypedStat.Type getType() {
        return this.statType;
    }

    @Override
    public double getCapability() {
        return this.cap;
    }

    @Override
    public void setCapability(double cap) {
        this.cap = cap;
    }

    @Override
    @NotNull
    public ItemType getItemType() {
        return this.statType.getItemType();
    }

    @Override
    public boolean isPercent() {
        return this.statType.isPercent();
    }

    @Override
    public boolean canBeNegative() {
        return this.statType.canBeNegative();
    }

    @Override
    @Deprecated
    public boolean isMainItem(@NotNull ItemStack item) {
        if (this.isPercent() || this.getItemType() == ItemType.BOTH) {
            return true;
        }
        if (this.getItemType() == ItemType.ARMOR && ItemUtils.isArmor(item)) {
            return true;
        }
        return this.getItemType() == ItemType.WEAPON && ItemUtils.isWeapon(item);
    }

    @Override
    @Nullable
    public TypedStat.Type getDependStat() {
        switch (this.statType) {
            case BLOCK_RATE: {
                return TypedStat.Type.BLOCK_DAMAGE;
            }
            case BLOCK_DAMAGE: {
                return TypedStat.Type.BLOCK_RATE;
            }
            case CRITICAL_RATE: {
                return TypedStat.Type.CRITICAL_DAMAGE;
            }
            case CRITICAL_DAMAGE: {
                return TypedStat.Type.CRITICAL_RATE;
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String formatValue(@NotNull ItemStack item, StatBonus statBonus) {
        RefineManager refine;
        boolean baseAttackAdd;
        boolean isBaseAttack = this.statType == TypedStat.Type.BASE_ATTACK_SPEED;
        double val = this.fineValue(statBonus.getValue()[0]);
        if (val == 0.0 && !isBaseAttack) {
            return "";
        }
        boolean bonus = !this.isMainItem(item);
        Object sVal = NumberUT.format((double)val);
        boolean baseBonus = isBaseAttack && ItemUtils.isArmor(item);
        boolean bl = baseAttackAdd = isBaseAttack && baseBonus;
        if (baseAttackAdd || !isBaseAttack && (this.canBeNegative() || bonus)) {
            sVal = (val > 0.0 ? EngineCfg.LORE_CHAR_POSITIVE : EngineCfg.LORE_CHAR_NEGATIVE) + (String)sVal;
        }
        if (this.isPercent()) {
            sVal = (String)sVal + EngineCfg.LORE_CHAR_PERCENT;
        } else if (this.statType == TypedStat.Type.CRITICAL_DAMAGE) {
            sVal = (String)sVal + EngineCfg.LORE_CHAR_MULTIPLIER;
        }
        if (statBonus.isBaseStat() && (refine = Divinity.getInstance().getModuleCache().getRefineManager()) != null) {
            sVal = (String)sVal + refine.getFormatLoreStat(item, this, statBonus.getValue()[0]);
        }
        return sVal;
    }

    @Override
    @NotNull
    public ItemStack updateItem(@Nullable Player p, @NotNull ItemStack item) {
        int amount;
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        for (NamespacedKey key : this.keys) {
            if (!container.has(key, PersistentDataType.DOUBLE)) continue;
            Double value = Objects.requireNonNull((Double)container.get(key, PersistentDataType.DOUBLE));
            this.add(item, new StatBonus(new double[]{value}, false, null), -1, -1);
            meta = item.getItemMeta();
            break;
        }
        if ((amount = this.getAmount(item)) == 0) {
            return item;
        }
        List lore = meta.getLore();
        if (lore == null) {
            return item;
        }
        for (int i = 0; i < amount; ++i) {
            StatBonus arr;
            NamespacedKey key;
            int loreIndex = -1;
            Object metaId = "";
            Iterator iterator = this.keys.iterator();
            while (iterator.hasNext() && (loreIndex = ItemUT.getLoreIndex((ItemStack)item, (String)(metaId = (key = (NamespacedKey)iterator.next()).getKey() + i))) < 0) {
            }
            if (loreIndex < 0 || (arr = (StatBonus)this.getRaw(item, i)) == null) continue;
            String formatNew = this.getFormat(p, item, arr);
            lore.set(loreIndex, formatNew);
            meta.setLore(lore);
            item.setItemMeta(meta);
            ItemUT.addLoreTag((ItemStack)item, (String)metaId, (String)formatNew);
        }
        return item;
    }

    @Override
    @NotNull
    public String getFormat(@Nullable Player p, @NotNull ItemStack item, @NotNull StatBonus value) {
        StatBonus.Condition<?> condition = value.getCondition();
        return StringUT.colorFix((String)super.getFormat(item, value).replace("%condition%", condition == null || !EngineCfg.LORE_STYLE_REQ_USER_DYN_UPDATE ? "" : condition.getFormat(p, item)));
    }

    public static enum ItemType {
        ARMOR,
        WEAPON,
        BOTH;

    }
}

