/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.stats.items.attributes;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import lombok.Generated;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Biome;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.compat.VersionManager;
import studio.magemonkey.codex.util.DataUT;
import studio.magemonkey.codex.util.EnumUT;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.NumberUT;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.codex.util.actions.ActionManipulator;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.config.EngineCfg;
import studio.magemonkey.divinity.modules.list.gems.GemManager;
import studio.magemonkey.divinity.modules.list.refine.RefineManager;
import studio.magemonkey.divinity.stats.bonus.BonusCalculator;
import studio.magemonkey.divinity.stats.bonus.BonusMap;
import studio.magemonkey.divinity.stats.bonus.StatBonus;
import studio.magemonkey.divinity.stats.items.ItemStats;
import studio.magemonkey.divinity.stats.items.api.DuplicableItemLoreStat;
import studio.magemonkey.divinity.stats.items.api.DynamicStat;
import studio.magemonkey.divinity.stats.items.attributes.DefenseAttribute;
import studio.magemonkey.divinity.utils.ItemUtils;

public class DamageAttribute
extends DuplicableItemLoreStat<StatBonus>
implements DynamicStat<StatBonus> {
    private final ActionManipulator actionEngine;
    private final Set<String> attachedDamageCauses;
    private final Map<String, Double> biomeModifier;
    private final Map<String, Double> entityTypeModifier;
    private final Map<String, Double> mythicFactionModifier;
    private int priority;
    private DefenseAttribute defenseAttached;

    public DamageAttribute(@NotNull String id, @NotNull String name, @NotNull String format, int priority, @NotNull ActionManipulator actionEngine, @NotNull Set<String> attachedDamageCauses, @NotNull Map<String, Double> biome, @NotNull Map<String, Double> entityTypeModifier, @NotNull Map<String, Double> mythicFactionModifier) {
        super(id, name, format, "%DAMAGE_" + id + "%", "ITEM_DAMAGE_", StatBonus.DATA_TYPE);
        this.priority = priority;
        this.actionEngine = actionEngine;
        this.attachedDamageCauses = attachedDamageCauses;
        this.biomeModifier = biome;
        this.entityTypeModifier = entityTypeModifier;
        this.mythicFactionModifier = mythicFactionModifier;
        this.defenseAttached = null;
        ItemStats.registerDynamicStat(this);
        this.keys.add(NamespacedKey.fromString((String)("prorpgitems:item_damage_" + this.getId())));
        this.keys.add(NamespacedKey.fromString((String)("prorpgitems:qrpg_item_damage_" + this.getId())));
        this.keys.add(NamespacedKey.fromString((String)("quantumrpg:qrpg_item_damage_" + this.getId())));
    }

    @Override
    @NotNull
    public Class<StatBonus> getParameterClass() {
        return StatBonus.class;
    }

    public boolean isDefault() {
        return this.equals(ItemStats.getDamageByDefault());
    }

    public boolean isAttached(@NotNull EntityDamageEvent.DamageCause cause) {
        return this.attachedDamageCauses.contains(cause.name()) || this.attachedDamageCauses.contains("*");
    }

    public boolean isAttached(@NotNull DefenseAttribute def) {
        return this.defenseAttached != null && this.defenseAttached.getId().equalsIgnoreCase(def.getId());
    }

    public void setAttachedDefense(@Nullable DefenseAttribute defense) {
        this.defenseAttached = defense;
    }

    @Nullable
    public DefenseAttribute getAttachedDefense() {
        return this.defenseAttached;
    }

    public static double getVanillaDamage(@NotNull ItemStack item) {
        return VersionManager.getNms().getDefaultDamage(item);
    }

    public double[] getTotal(@NotNull ItemStack item, @Nullable Player player) {
        return BonusCalculator.RANGE_FULL.apply(new double[]{0.0, 0.0}, this.get(item, player));
    }

    @NotNull
    public List<BiFunction<Boolean, double[], double[]>> get(@NotNull ItemStack item, @Nullable Player player) {
        GemManager gems;
        RefineManager refineManager;
        ArrayList<BiFunction<Boolean, double[], double[]>> bonuses = new ArrayList<BiFunction<Boolean, double[], double[]>>();
        double[] base = new double[]{0.0, 0.0};
        double percent = 0.0;
        boolean has = false;
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            PersistentDataContainer container = meta.getPersistentDataContainer();
            for (NamespacedKey namespacedKey : this.keys) {
                double[] value;
                if (!container.has(namespacedKey, DataUT.DOUBLE_ARRAY) || (value = (double[])container.get(namespacedKey, DataUT.DOUBLE_ARRAY)) == null) continue;
                base[0] = base[0] + value[0];
                base[1] = base[1] + value[1];
                has = true;
                break;
            }
        }
        for (StatBonus bonus : this.getAllRaw(item)) {
            if (!bonus.meetsRequirement(player)) continue;
            double[] dArray = bonus.getValue();
            if (dArray.length == 1) {
                if (bonus.isPercent()) {
                    percent += dArray[0];
                    continue;
                }
                base[0] = base[0] + dArray[0];
                base[1] = base[1] + dArray[0];
                has = true;
                continue;
            }
            base[0] = base[0] + dArray[0];
            base[1] = base[1] + dArray[1];
            has = true;
        }
        base[0] = Math.max(0.0, base[0]);
        base[1] = Math.max(base[0], base[1]);
        if (base[1] == 0.0 && ItemUtils.isWeapon(item) && this.isDefault() && ItemStats.getDamages().stream().filter(damageAttribute -> !damageAttribute.isDefault()).noneMatch(damageAttribute -> ItemStats.hasDamage(item, player, damageAttribute))) {
            base[0] = base[1] = DamageAttribute.getVanillaDamage(item);
            has = true;
        }
        bonuses.add((isPercent, input) -> {
            double[] dArray;
            if (isPercent.booleanValue()) {
                dArray = input;
            } else if (((double[])input).length == 2) {
                double[] dArray2 = new double[2];
                dArray2[0] = input[0] + base[0];
                dArray = dArray2;
                dArray2[1] = input[1] + base[1];
            } else {
                double[] dArray3 = new double[2];
                dArray3[0] = input[0] + base[0];
                dArray = dArray3;
                dArray3[1] = input[0] + base[1];
            }
            return dArray;
        });
        double finalPercent = percent;
        bonuses.add((isPercent, input) -> {
            double[] dArray;
            if (isPercent.booleanValue()) {
                double[] dArray2 = new double[1];
                dArray = dArray2;
                dArray2[0] = input[0] + finalPercent;
            } else {
                dArray = input;
            }
            return dArray;
        });
        StatBonus baseLine = (StatBonus)this.getRaw(meta, 0);
        if (baseLine != null && baseLine.isBaseStat() && (refineManager = Divinity.getInstance().getModuleCache().getRefineManager()) != null && has) {
            BiFunction<Boolean, Double, Double> biFunction = refineManager.getRefinedBonus(item, this);
            bonuses.add((isPercent, input) -> {
                double[] dArray;
                if (((double[])input).length == 2) {
                    double[] dArray2 = new double[2];
                    dArray2[0] = (Double)refineManagerBonus.apply((Boolean)isPercent, input[0]);
                    dArray = dArray2;
                    dArray2[1] = (Double)refineManagerBonus.apply((Boolean)isPercent, input[1]);
                } else {
                    double[] dArray3 = new double[1];
                    dArray = dArray3;
                    dArray3[0] = (Double)refineManagerBonus.apply((Boolean)isPercent, input[0]);
                }
                return dArray;
            });
        }
        if ((gems = Divinity.getInstance().getModuleCache().getGemManager()) != null) {
            for (Map.Entry entry : gems.getItemSockets(item)) {
                BiFunction<Boolean, Double, Double> gemBonus;
                BonusMap bMap = ((GemManager.Gem)entry.getKey()).getBonusMap((Integer)entry.getValue());
                if (bMap == null || (gemBonus = bMap.getBonus(this)) == null) continue;
                bonuses.add((isPercent, input) -> {
                    double[] dArray;
                    if (((double[])input).length == 2) {
                        double[] dArray2 = new double[2];
                        dArray2[0] = (Double)gemBonus.apply((Boolean)isPercent, input[0]);
                        dArray = dArray2;
                        dArray2[1] = (Double)gemBonus.apply((Boolean)isPercent, input[1]);
                    } else {
                        double[] dArray3 = new double[1];
                        dArray = dArray3;
                        dArray3[0] = (Double)gemBonus.apply((Boolean)isPercent, input[0]);
                    }
                    return dArray;
                });
            }
        }
        return bonuses;
    }

    @NotNull
    public ActionManipulator getHitActions() {
        return this.actionEngine;
    }

    @NotNull
    public Map<String, Double> getBiomeDamageModifiers() {
        return this.biomeModifier;
    }

    public double getDamageModifierByBiome(@NotNull Biome b) {
        return this.biomeModifier.getOrDefault(EnumUT.getName((Object)b), 1.0);
    }

    public double getDamageModifierByEntityType(@NotNull Entity e) {
        return this.entityTypeModifier.getOrDefault(e.getType().name(), 1.0);
    }

    public double getDamageModifierByMythicFaction(@Nullable String faction) {
        if (faction == null) {
            return 1.0;
        }
        return this.mythicFactionModifier.getOrDefault(faction.toLowerCase(), 1.0);
    }

    @Override
    @NotNull
    public String formatValue(@NotNull ItemStack item, @NotNull StatBonus value) {
        Object sVal;
        double[] array = value.getValue();
        if (array.length == 1) {
            RefineManager refine;
            sVal = NumberUT.format((double)array[0]);
            if (value.isPercent()) {
                sVal = (String)sVal + EngineCfg.LORE_CHAR_PERCENT;
            } else if (value.isBaseStat() && (refine = Divinity.getInstance().getModuleCache().getRefineManager()) != null) {
                sVal = (String)sVal + refine.getFormatLoreStat(item, this, array[0]);
            }
            sVal = EngineCfg.LORE_STYLE_DAMAGE_FORMAT_SINGLE.replace("%value%", (CharSequence)sVal);
        } else {
            RefineManager refine;
            Object sMin = NumberUT.format((double)array[0]);
            Object sMax = NumberUT.format((double)array[1]);
            if (value.isBaseStat() && (refine = Divinity.getInstance().getModuleCache().getRefineManager()) != null) {
                sMin = (String)sMin + refine.getFormatLoreStat(item, this, array[0]);
                sMax = (String)sMax + refine.getFormatLoreStat(item, this, array[1]);
            }
            sVal = EngineCfg.LORE_STYLE_DAMAGE_FORMAT_RANGE.replace("%min%", (CharSequence)sMin).replace("%max%", (CharSequence)sMax);
        }
        return sVal;
    }

    @Override
    @NotNull
    public String getFormat(@Nullable Player p, @NotNull ItemStack item, @NotNull StatBonus value) {
        StatBonus.Condition<?> condition = value.getCondition();
        return StringUT.colorFix((String)super.getFormat(item, value).replace("%condition%", condition == null || !EngineCfg.LORE_STYLE_REQ_USER_DYN_UPDATE ? "" : condition.getFormat(p, item)));
    }

    @Override
    @NotNull
    public ItemStack updateItem(@Nullable Player p, @NotNull ItemStack item) {
        int amount;
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        for (NamespacedKey key : this.keys) {
            Object value;
            if (container.has(key, PersistentDataType.DOUBLE)) {
                value = Objects.requireNonNull((Double)container.get(key, PersistentDataType.DOUBLE));
                this.add(item, new StatBonus(new double[]{(Double)value}, false, null), -1, -1);
                meta = item.getItemMeta();
                break;
            }
            if (!container.has(key, DataUT.DOUBLE_ARRAY)) continue;
            value = Objects.requireNonNull((double[])container.get(key, DataUT.DOUBLE_ARRAY));
            this.add(item, new StatBonus((double[])value, false, null), -1, -1);
            meta = item.getItemMeta();
            break;
        }
        if ((amount = this.getAmount(item)) == 0) {
            return item;
        }
        List lore = meta.getLore();
        if (lore == null) {
            return item;
        }
        for (int i = 0; i < amount; ++i) {
            StatBonus arr;
            NamespacedKey key;
            int loreIndex = -1;
            Object metaId = "";
            Iterator iterator = this.keys.iterator();
            while (iterator.hasNext() && (loreIndex = ItemUT.getLoreIndex((ItemStack)item, (String)(metaId = (key = (NamespacedKey)iterator.next()).getKey() + i))) < 0) {
            }
            if (loreIndex < 0 || (arr = (StatBonus)this.getRaw(item, i)) == null) continue;
            String formatNew = this.getFormat(p, item, arr);
            lore.set(loreIndex, formatNew);
            meta.setLore(lore);
            item.setItemMeta(meta);
            ItemUT.addLoreTag((ItemStack)item, (String)metaId, (String)formatNew);
        }
        return item;
    }

    @Generated
    public int getPriority() {
        return this.priority;
    }
}

