/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.stats.items.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.config.EngineCfg;
import studio.magemonkey.divinity.stats.items.ItemStats;
import studio.magemonkey.divinity.stats.items.api.DuplicableItemLoreStat;
import studio.magemonkey.divinity.stats.items.api.DynamicStat;
import studio.magemonkey.divinity.stats.items.attributes.api.TypedStat;
import studio.magemonkey.divinity.utils.LoreUT;

public abstract class ItemLoreStat<Z> {
    private final String id;
    protected String name;
    protected final String format;
    protected final String placeholder;
    protected final List<NamespacedKey> keys;
    protected PersistentDataType<?, Z> dataType;
    protected final String metaId;

    public ItemLoreStat(@NotNull String id, @NotNull String name, @NotNull String format, @NotNull String placeholder, @NotNull String uniqueTag, @NotNull PersistentDataType<?, Z> dataType) {
        this.id = id.toLowerCase();
        this.name = StringUT.color((String)name);
        this.format = StringUT.color((String)format.replace("%name%", this.getName()));
        this.placeholder = placeholder.toUpperCase();
        this.keys = new ArrayList<NamespacedKey>();
        uniqueTag = uniqueTag.toLowerCase();
        this.metaId = uniqueTag.endsWith(this.id) ? uniqueTag : uniqueTag + this.id;
        this.keys.add(new NamespacedKey((Plugin)Divinity.getInstance(), this.metaId));
        this.dataType = dataType;
    }

    @NotNull
    public abstract Class<Z> getParameterClass();

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final String getMetaId(@NotNull ItemStack item) {
        Object id = this.metaId;
        if (this instanceof DuplicableItemLoreStat) {
            DuplicableItemLoreStat duplic = (DuplicableItemLoreStat)this;
            id = (String)id + duplic.getAmount(item);
        }
        return id;
    }

    public final String getMetaId(@NotNull ItemStack item, int index) {
        if (!(this instanceof DuplicableItemLoreStat)) {
            return this.getMetaId(item);
        }
        return this.metaId + index;
    }

    protected boolean isSingle() {
        return false;
    }

    @NotNull
    public final List<NamespacedKey> getKeys() {
        this.validateMethod();
        return Collections.unmodifiableList(this.keys);
    }

    @NotNull
    public final NamespacedKey getKey() {
        this.validateMethod();
        return this.keys.get(0);
    }

    @NotNull
    public final String getPlaceholder() {
        return this.placeholder;
    }

    @NotNull
    public String getFormat() {
        return this.format;
    }

    @NotNull
    public String getFormat(@NotNull ItemStack item, @NotNull Z value) {
        String sVal = this.formatValue(item, value);
        if (sVal.isEmpty()) {
            return "";
        }
        String[] colorFixer = this.format.split("%value%");
        String valueColor = colorFixer.length > 0 ? ChatColor.getLastColors((String)colorFixer[0]) : "";
        return StringUT.colorFix((String)this.format.replace("%value%", valueColor + sVal));
    }

    public boolean add(@NotNull ItemStack item, @NotNull Z value, int line) {
        int pos = this.getLoreIndex(item);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        ArrayList<String> lore = meta.getLore();
        if (lore == null) {
            lore = new ArrayList<String>();
        }
        if (!lore.contains(this.getPlaceholder()) && !this.formatValue(item, value).equals(EngineCfg.LORE_STYLE_ATT_CHARGES_FORMAT_UNLIMITED)) {
            LoreUT.addOrReplace(lore, pos, line, this.getPlaceholder());
        }
        pos = lore.indexOf(this.getPlaceholder());
        PersistentDataContainer container = meta.getPersistentDataContainer();
        for (NamespacedKey key : this.keys) {
            if (!container.has(key, this.dataType)) continue;
            container.remove(key);
        }
        String[] format = StringUT.colorFix((String)(this instanceof DynamicStat ? ((DynamicStat)((Object)this)).getFormat(null, item, value) : this.getFormat(item, value))).split("\n");
        boolean isEmpty = true;
        for (String formatLine : format) {
            if (formatLine.isEmpty()) continue;
            isEmpty = false;
            break;
        }
        if (isEmpty) {
            if (pos != -1) {
                lore.remove(pos);
            }
        } else {
            container.set(this.getKey(), this.dataType, value);
            if (pos != -1) {
                lore.set(pos, format[0]);
                for (int i = 1; i < format.length; ++i) {
                    lore.add(pos + i, format[i]);
                }
            }
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        if (this instanceof DuplicableItemLoreStat) {
            int amount = ((DuplicableItemLoreStat)this).getAmount(item);
            for (NamespacedKey key : this.keys) {
                ItemUT.delLoreTag((ItemStack)item, (String)(key.getKey() + amount));
            }
        } else {
            for (NamespacedKey key : this.keys) {
                ItemUT.delLoreTag((ItemStack)item, (String)key.getKey());
            }
        }
        if (!isEmpty) {
            ItemUT.addLoreTag((ItemStack)item, (String)this.getMetaId(item), (String)format[0]);
            for (int i = 1; i < format.length; ++i) {
                ItemUT.addLoreTag((ItemStack)item, (String)(this.getMetaId(item) + i), (String)format[i]);
            }
        }
        ItemStats.updateVanillaAttributes(item, null);
        return !isEmpty;
    }

    public final void remove(@NotNull ItemStack item) {
        this.validateMethod();
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        boolean foundAny = false;
        PersistentDataContainer container = meta.getPersistentDataContainer();
        for (NamespacedKey key : this.keys) {
            if (!container.has(key, this.dataType)) continue;
            container.remove(key);
            foundAny = true;
        }
        if (foundAny) {
            int pos;
            List lore = meta.getLore();
            if (lore != null && !lore.contains(this.getPlaceholder()) && (pos = this.getLoreIndex(item)) >= 0) {
                lore.remove(pos);
                meta.setLore(lore);
            }
            item.setItemMeta(meta);
            if (this instanceof TypedStat) {
                ItemStats.updateVanillaAttributes(item, null);
            }
        }
        if (this instanceof DuplicableItemLoreStat) {
            int amount = ((DuplicableItemLoreStat)this).getAmount(item);
            for (NamespacedKey key : this.keys) {
                ItemUT.delLoreTag((ItemStack)item, (String)(key.getKey() + amount));
            }
        } else {
            for (NamespacedKey key : this.keys) {
                ItemUT.delLoreTag((ItemStack)item, (String)key.getKey());
            }
        }
        if (this.isSingle()) {
            // empty if block
        }
    }

    @Nullable
    public final Z getRaw(@NotNull ItemStack item) {
        this.validateMethod();
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        for (NamespacedKey key : this.keys) {
            if (!container.has(key, this.dataType)) continue;
            return (Z)container.get(key, this.dataType);
        }
        return null;
    }

    public final int getLoreIndex(@NotNull ItemStack item) {
        if (this instanceof DuplicableItemLoreStat) {
            int amount = ((DuplicableItemLoreStat)this).getAmount(item);
            for (NamespacedKey key : this.keys) {
                int found = ItemUT.getLoreIndex((ItemStack)item, (String)(key.getKey() + amount));
                if (found < 0) continue;
                return found;
            }
        } else {
            for (NamespacedKey key : this.keys) {
                int found = ItemUT.getLoreIndex((ItemStack)item, (String)key.getKey());
                if (found < 0) continue;
                return found;
            }
        }
        return -1;
    }

    public final boolean isApplied(@NotNull ItemStack item) {
        return this.getLoreIndex(item) >= 0;
    }

    public final boolean hasPlaceholder(@NotNull ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        List lore = meta.getLore();
        if (lore == null) {
            return false;
        }
        return lore.contains(this.getPlaceholder());
    }

    protected final void preparePlaceholder(@NotNull ItemStack item, int line) {
        this.validateMethod();
        if (!this.hasPlaceholder(item)) {
            int pos = this.getLoreIndex(item);
            ItemMeta meta = item.getItemMeta();
            if (meta == null) {
                return;
            }
            ArrayList<String> lore = meta.getLore();
            if (lore == null) {
                lore = new ArrayList<String>();
            }
            LoreUT.addOrReplace(lore, pos, line, this.getPlaceholder());
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
    }

    @NotNull
    public abstract String formatValue(@NotNull ItemStack var1, @NotNull Z var2);

    private void validateMethod() {
        if (this instanceof DuplicableItemLoreStat) {
            throw new UnsupportedOperationException("Attempt to manage duplicable stat at NULL index. Index must be provided.");
        }
    }
}

