/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.stats.bonus;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.util.DataUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.stats.items.requirements.ItemRequirements;
import studio.magemonkey.divinity.stats.items.requirements.api.DynamicUserRequirement;
import studio.magemonkey.divinity.stats.items.requirements.user.ClassRequirement;

public class StatBonus {
    private static final List<NamespacedKey> VALUE = List.of(new NamespacedKey((Plugin)Divinity.getInstance(), "value"), Objects.requireNonNull(NamespacedKey.fromString((String)"prorpgitems:value")));
    private static final List<NamespacedKey> PERCENT = List.of(new NamespacedKey((Plugin)Divinity.getInstance(), "percent"), Objects.requireNonNull(NamespacedKey.fromString((String)"prorpgitems:percent")));
    private static final List<NamespacedKey> EMPTY = List.of(new NamespacedKey((Plugin)Divinity.getInstance(), "empty"));
    private static final List<NamespacedKey> CLASS_CONDITION = List.of(new NamespacedKey((Plugin)Divinity.getInstance(), "class"), Objects.requireNonNull(NamespacedKey.fromString((String)"prorpgitems:class")), Objects.requireNonNull(NamespacedKey.fromString((String)"prorpgitems:item_user_class")), Objects.requireNonNull(NamespacedKey.fromString((String)"prorpgitems:qrpg_item_user_classclass")), Objects.requireNonNull(NamespacedKey.fromString((String)"quantumrpg:qrpg_item_user_classclass")));
    public static PersistentDataType<PersistentDataContainer, StatBonus> DATA_TYPE = new PersistentDataType<PersistentDataContainer, StatBonus>(){

        @NotNull
        public Class<PersistentDataContainer> getPrimitiveType() {
            return PersistentDataContainer.class;
        }

        @NotNull
        public Class<StatBonus> getComplexType() {
            return StatBonus.class;
        }

        @NotNull
        public PersistentDataContainer toPrimitive(@NotNull StatBonus complex, @NotNull PersistentDataAdapterContext context) {
            PersistentDataContainer container = DataUT.itemPersistentDataContainer();
            if (complex.value.length == 1) {
                container.set(VALUE.get(0), PersistentDataType.DOUBLE, (Object)complex.value[0]);
            } else if (complex.value.length == 2) {
                container.set(VALUE.get(0), DataUT.DOUBLE_ARRAY, (Object)complex.value);
            }
            if (complex.percent) {
                container.set(PERCENT.get(0), DataUT.BOOLEAN, (Object)true);
            }
            if (complex.condition != null) {
                if (complex.condition.requirement == null) {
                    container.set(EMPTY.get(0), DataUT.BOOLEAN, (Object)true);
                }
                if (complex.condition.requirement instanceof ClassRequirement) {
                    container.set(CLASS_CONDITION.get(0), DataUT.STRING_ARRAY, (Object)((String[])complex.condition.value));
                }
            }
            return container;
        }

        @NotNull
        public StatBonus fromPrimitive(@NotNull PersistentDataContainer primitive, @NotNull PersistentDataAdapterContext context) {
            boolean bl;
            double[] array = null;
            for (NamespacedKey namespacedKey : VALUE) {
                if (!primitive.has(namespacedKey, DataUT.DOUBLE_ARRAY)) continue;
                array = (double[])primitive.get(namespacedKey, DataUT.DOUBLE_ARRAY);
                break;
            }
            if (array == null) {
                for (NamespacedKey namespacedKey : VALUE) {
                    Double simple;
                    if (!primitive.has(namespacedKey, PersistentDataType.DOUBLE) || (simple = (Double)primitive.get(namespacedKey, PersistentDataType.DOUBLE)) == null) continue;
                    array = new double[]{simple};
                    break;
                }
            }
            if (array == null) {
                array = new double[]{0.0, 0.0};
            }
            Condition<Object> condition = null;
            for (NamespacedKey key : EMPTY) {
                if (!primitive.has(key, DataUT.BOOLEAN)) continue;
                condition = new Condition();
            }
            for (NamespacedKey key : CLASS_CONDITION) {
                String[] classCondition;
                if (!primitive.has(key, DataUT.STRING_ARRAY) || (classCondition = (String[])primitive.get(key, DataUT.STRING_ARRAY)) == null) continue;
                condition = new Condition<String[]>(ItemRequirements.getUserRequirement(ClassRequirement.class), classCondition);
                break;
            }
            boolean bl2 = false;
            if (array.length == 1) {
                for (NamespacedKey key : PERCENT) {
                    Boolean value;
                    if (!primitive.has(key, DataUT.BOOLEAN) || (value = (Boolean)primitive.get(key, DataUT.BOOLEAN)) == null) continue;
                    bl = value;
                    break;
                }
            }
            return new StatBonus(array, bl, condition);
        }
    };
    private final double[] value;
    private final boolean percent;
    @Nullable
    private final Condition<?> condition;

    public StatBonus(double[] value, boolean percent, @Nullable Condition<?> condition) {
        if (value.length == 2) {
            this.value = value[0] == value[1] ? new double[]{value[0]} : new double[]{Math.min(value[0], value[1]), Math.max(value[0], value[1])};
        } else if (value.length == 1) {
            this.value = new double[]{value[0]};
        } else {
            throw new IllegalArgumentException();
        }
        this.percent = percent;
        this.condition = condition;
    }

    @Nullable
    public Condition<?> getCondition() {
        return this.condition;
    }

    public boolean isBaseStat() {
        return this.condition == null && !this.percent;
    }

    public boolean meetsRequirement(@Nullable Player player) {
        return this.condition == null || player != null && this.condition.meetsRequirement(player);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatBonus statBonus = (StatBonus)o;
        return this.percent == statBonus.percent && Arrays.equals(this.value, statBonus.value) && Objects.equals(this.condition, statBonus.condition);
    }

    public int hashCode() {
        int result = Objects.hash(this.percent, this.condition);
        result = 31 * result + Arrays.hashCode(this.value);
        return result;
    }

    @Generated
    public double[] getValue() {
        return this.value;
    }

    @Generated
    public boolean isPercent() {
        return this.percent;
    }

    public static final class Condition<Z> {
        private final DynamicUserRequirement<Z> requirement;
        private final Z value;

        public Condition() {
            this.requirement = null;
            this.value = null;
        }

        public Condition(DynamicUserRequirement<Z> requirement, Z value) {
            this.requirement = requirement;
            this.value = value;
        }

        public boolean meetsRequirement(@NotNull Player p) {
            return this.requirement == null || this.requirement.canUse(p, this.value);
        }

        @NotNull
        public String getFormat(@Nullable Player p, @NotNull ItemStack item) {
            return this.requirement == null ? "" : this.requirement.getFormat(p, item, this.value);
        }

        public boolean equals(Object o) {
            if (this.requirement == null) {
                return super.equals(o);
            }
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Condition condition = (Condition)o;
            if (this.requirement != condition.requirement) {
                return false;
            }
            if (this.value instanceof long[] && condition.value instanceof long[]) {
                return Arrays.equals((long[])this.value, (long[])condition.value);
            }
            if (this.value instanceof int[] && condition.value instanceof int[]) {
                return Arrays.equals((int[])this.value, (int[])condition.value);
            }
            if (this.value instanceof short[] && condition.value instanceof short[]) {
                return Arrays.equals((short[])this.value, (short[])condition.value);
            }
            if (this.value instanceof char[] && condition.value instanceof char[]) {
                return Arrays.equals((char[])this.value, (char[])condition.value);
            }
            if (this.value instanceof byte[] && condition.value instanceof byte[]) {
                return Arrays.equals((byte[])this.value, (byte[])condition.value);
            }
            if (this.value instanceof boolean[] && condition.value instanceof boolean[]) {
                return Arrays.equals((boolean[])this.value, (boolean[])condition.value);
            }
            if (this.value instanceof double[] && condition.value instanceof double[]) {
                return Arrays.equals((double[])this.value, (double[])condition.value);
            }
            if (this.value instanceof float[] && condition.value instanceof float[]) {
                return Arrays.equals((float[])this.value, (float[])condition.value);
            }
            if (this.value instanceof Object[] && condition.value instanceof Object[]) {
                return Arrays.equals((Object[])this.value, (Object[])condition.value);
            }
            return Objects.equals(this.value, condition.value);
        }

        public int hashCode() {
            if (this.requirement == null) {
                return super.hashCode();
            }
            int result = 31;
            result = this.value instanceof long[] ? (result += Arrays.hashCode((long[])this.value)) : (this.value instanceof int[] ? (result += Arrays.hashCode((int[])this.value)) : (this.value instanceof short[] ? (result += Arrays.hashCode((short[])this.value)) : (this.value instanceof char[] ? (result += Arrays.hashCode((char[])this.value)) : (this.value instanceof byte[] ? (result += Arrays.hashCode((byte[])this.value)) : (this.value instanceof boolean[] ? (result += Arrays.hashCode((boolean[])this.value)) : (this.value instanceof double[] ? (result += Arrays.hashCode((double[])this.value)) : (this.value instanceof float[] ? (result += Arrays.hashCode((float[])this.value)) : (this.value instanceof Object[] ? (result += Arrays.hashCode((Object[])this.value)) : (result += this.value.hashCode())))))))));
            return 31 * result + this.requirement.hashCode();
        }
    }
}

