/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.party.compat.quest;

import java.util.Set;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.manager.IListener;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.list.party.PartyManager;

public abstract class IPartyObjective
extends IListener<Divinity> {
    protected PartyManager partyManager;

    public IPartyObjective(@NotNull Divinity plugin, @NotNull PartyManager partyManager) {
        super((JavaPlugin)plugin);
        this.partyManager = partyManager;
    }

    public void setup() {
        this.registerListeners();
    }

    public void shutdown() {
        this.partyManager = null;
        this.unregisterListeners();
    }

    @EventHandler
    public void onMobKillObjective(EntityDeathEvent e) {
        if (!this.partyManager.getSettings().isQuestMobKillEnabled()) {
            return;
        }
        LivingEntity entity = e.getEntity();
        Player killer = entity.getKiller();
        if (killer == null) {
            return;
        }
        PartyManager.PartyMember member = this.partyManager.getPartyMember(killer);
        if (member == null) {
            return;
        }
        PartyManager.Party party = member.getParty();
        int killDistance = this.partyManager.getSettings().getMaxQuestMobKillDistance();
        Set<PartyManager.PartyMember> objGeters = party.getMembersByDistance(member, killDistance);
        this.progressObjective(killer, objGeters, (Event)e);
    }

    public abstract void progressObjective(@NotNull Player var1, @NotNull Set<PartyManager.PartyMember> var2, @NotNull Event var3);
}

