/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.party;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Keyed;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.commands.api.ISubCommand;
import studio.magemonkey.codex.config.api.ILangMsg;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.hooks.Hooks;
import studio.magemonkey.codex.manager.api.task.ITask;
import studio.magemonkey.codex.util.CollectionsUT;
import studio.magemonkey.codex.util.SoundUT;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.codex.util.TimeUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.config.EngineCfg;
import studio.magemonkey.divinity.hooks.HookLevel;
import studio.magemonkey.divinity.hooks.external.FabledHook;
import studio.magemonkey.divinity.hooks.internal.DivinityHook;
import studio.magemonkey.divinity.modules.api.QModule;
import studio.magemonkey.divinity.modules.list.party.PartyGUI;
import studio.magemonkey.divinity.modules.list.party.command.PartyChatCmd;
import studio.magemonkey.divinity.modules.list.party.command.PartyCreateCmd;
import studio.magemonkey.divinity.modules.list.party.command.PartyDisbandCmd;
import studio.magemonkey.divinity.modules.list.party.command.PartyDropCmd;
import studio.magemonkey.divinity.modules.list.party.command.PartyExpCmd;
import studio.magemonkey.divinity.modules.list.party.command.PartyInviteCmd;
import studio.magemonkey.divinity.modules.list.party.command.PartyJoinCmd;
import studio.magemonkey.divinity.modules.list.party.command.PartyKickCmd;
import studio.magemonkey.divinity.modules.list.party.command.PartyLeaveCmd;
import studio.magemonkey.divinity.modules.list.party.command.PartyMenuCmd;
import studio.magemonkey.divinity.modules.list.party.command.PartyRollCmd;
import studio.magemonkey.divinity.modules.list.party.command.PartyTpCmd;
import studio.magemonkey.divinity.modules.list.party.compat.level.IPEFabled;
import studio.magemonkey.divinity.modules.list.party.compat.level.IPEInternal;
import studio.magemonkey.divinity.modules.list.party.compat.level.IPartyLevelManager;
import studio.magemonkey.divinity.modules.list.party.compat.quest.IPOMangoQuest;
import studio.magemonkey.divinity.modules.list.party.compat.quest.IPartyObjective;
import studio.magemonkey.divinity.modules.list.party.event.PlayerLeavePartyEvent;

public class PartyManager
extends QModule {
    private Map<String, Party> parties;
    private Map<String, Map<String, Long>> invites;
    private Map<String, Long> tpCooldown;
    private PartyGUI gui;
    private PartySettings settings;
    private IPartyLevelManager iLevelManager;
    private IPartyObjective iQuestObjective;
    private QuitTask taskQuit;

    public PartyManager(@NotNull Divinity plugin) {
        super(plugin);
    }

    @NotNull
    public String getId() {
        return "party";
    }

    @NotNull
    public String version() {
        return "2.0.0";
    }

    public void setup() {
        this.parties = new HashMap<String, Party>();
        this.invites = new HashMap<String, Map<String, Long>>();
        this.tpCooldown = new HashMap<String, Long>();
        this.moduleCommand.addSubCommand((ISubCommand)new PartyChatCmd(this));
        this.moduleCommand.addSubCommand((ISubCommand)new PartyCreateCmd(this));
        this.moduleCommand.addSubCommand((ISubCommand)new PartyDisbandCmd(this));
        this.moduleCommand.addSubCommand((ISubCommand)new PartyExpCmd(this));
        this.moduleCommand.addSubCommand((ISubCommand)new PartyInviteCmd(this));
        this.moduleCommand.addSubCommand((ISubCommand)new PartyJoinCmd(this));
        this.moduleCommand.addSubCommand((ISubCommand)new PartyKickCmd(this));
        this.moduleCommand.addSubCommand((ISubCommand)new PartyLeaveCmd(this));
        this.moduleCommand.addSubCommand((ISubCommand)new PartyMenuCmd(this));
        this.moduleCommand.addSubCommand((ISubCommand)new PartyTpCmd(this));
        if (!((Divinity)this.plugin).cfg().isModuleEnabled("loot")) {
            this.info("Loot module is disabled. Party drop mode will disabled.");
        } else {
            this.moduleCommand.addSubCommand((ISubCommand)new PartyDropCmd(this));
            this.moduleCommand.addSubCommand((ISubCommand)new PartyRollCmd(this));
        }
        this.settings = new PartySettings(this.cfg);
        this.gui = new PartyGUI(this);
        if (this.settings.isLevelHooksEnabled() && this.settings.isLevelExpBalance()) {
            HookLevel hLvl = EngineCfg.HOOK_PLAYER_LEVEL_PLUGIN;
            if (hLvl instanceof FabledHook) {
                this.iLevelManager = new IPEFabled((Divinity)this.plugin, this);
            } else if (hLvl instanceof DivinityHook) {
                this.iLevelManager = new IPEInternal((Divinity)this.plugin, this);
            }
            if (this.iLevelManager != null) {
                this.iLevelManager.setup();
            }
        }
        if (this.settings.isQuestHooksEnabled()) {
            if (Hooks.hasPlugin((String)"MangoQuest")) {
                this.iQuestObjective = new IPOMangoQuest((Divinity)this.plugin, this);
            }
            if (this.iQuestObjective != null) {
                this.iQuestObjective.setup();
            }
        }
        this.taskQuit = new QuitTask((Divinity)this.plugin);
        this.taskQuit.start();
    }

    public void shutdown() {
        if (this.taskQuit != null) {
            this.taskQuit.stop();
            this.taskQuit = null;
        }
        if (this.gui != null) {
            this.gui.shutdown();
            this.gui = null;
        }
        if (this.iLevelManager != null) {
            this.iLevelManager.shutdown();
            this.iLevelManager = null;
        }
        if (this.iQuestObjective != null) {
            this.iQuestObjective.shutdown();
            this.iQuestObjective = null;
        }
        for (Party p : this.getParties()) {
            p.disband();
        }
        if (this.parties != null) {
            this.parties.clear();
            this.parties = null;
        }
        if (this.invites != null) {
            this.invites.clear();
            this.invites = null;
        }
        if (this.tpCooldown != null) {
            this.tpCooldown.clear();
            this.tpCooldown = null;
        }
        this.settings = null;
    }

    public void toggleChat(@NotNull Player player) {
        PartyMember member = this.getPartyMember(player);
        if (member == null) {
            ((Divinity)this.plugin).lang().Party_Error_NotInParty.send((CommandSender)player);
            return;
        }
        member.toggleChat();
    }

    public boolean isInParty(@NotNull Player player) {
        return this.getPartyMember(player) != null;
    }

    @Nullable
    public Party getPlayerParty(@NotNull Player player) {
        for (Party party : this.getParties()) {
            if (!party.isMember(player)) continue;
            return party;
        }
        return null;
    }

    @Nullable
    public PartyMember getPartyMember(@NotNull Player player) {
        Party party = this.getPlayerParty(player);
        if (party != null) {
            return party.getMember(player);
        }
        return null;
    }

    public void createParty(@NotNull Player creator, String name) {
        if (this.isInParty(creator)) {
            ((Divinity)this.plugin).lang().Party_Error_AlreadyIn.send((CommandSender)creator);
            return;
        }
        if (name == null) {
            name = creator.getName();
        }
        if (this.getPartyById(name = StringUT.oneSpace((String)name).replace(" ", "_").trim().toLowerCase()) != null) {
            ((Divinity)this.plugin).lang().Party_Create_Error_Exist.send((CommandSender)creator);
            return;
        }
        int size = this.settings.getPartyPermSize(creator);
        Party party = new Party(name, creator, size);
        this.parties.put(party.getId(), party);
        ((Divinity)this.plugin).lang().Party_Create_Done.replace("%party%", (Object)name).send((CommandSender)creator);
        this.settings.playSound(creator, PartyAction.CREATE);
    }

    public void joinParty(@NotNull Player player, @NotNull String id) {
        this.updateInvites(player);
        if (this.isInParty(player)) {
            ((Divinity)this.plugin).lang().Party_Error_AlreadyIn.send((CommandSender)player);
            return;
        }
        Party party = this.getPartyById(id);
        if (party == null) {
            ((Divinity)this.plugin).lang().Party_Error_Invalid.send((CommandSender)player);
            return;
        }
        if (!this.hasInvite(player, party)) {
            ((Divinity)this.plugin).lang().Party_Invite_Another.send((CommandSender)player);
            return;
        }
        if (party.getMembers().size() >= party.getSize()) {
            ((Divinity)this.plugin).lang().Party_Error_MaxPlayers.send((CommandSender)player);
            return;
        }
        party.addMember(player);
    }

    public void invitePlayer(@NotNull Player from, @Nullable Player to) {
        PartyMember leader = this.getPartyMember(from);
        if (leader == null) {
            ((Divinity)this.plugin).lang().Party_Error_NotInParty.send((CommandSender)from);
            return;
        }
        if (!leader.isLeader()) {
            ((Divinity)this.plugin).lang().Party_Error_LeaderOnly.send((CommandSender)from);
            return;
        }
        if (to == null) {
            ((Divinity)this.plugin).lang().Error_NoPlayer.send((CommandSender)from);
            return;
        }
        if (this.isInParty(to)) {
            ((Divinity)this.plugin).lang().Party_Error_Player_AlreadyIn.replace("%player%", (Object)to.getName()).send((CommandSender)from);
            return;
        }
        Party party = leader.getParty();
        if (party.getMembers().size() >= party.getSize()) {
            ((Divinity)this.plugin).lang().Party_Error_MaxPlayers.send((CommandSender)from);
            return;
        }
        if (this.hasInvite(to, party)) {
            ((Divinity)this.plugin).lang().Party_Invite_Already.send((CommandSender)from);
            return;
        }
        this.addInvite(to, party);
        ((Divinity)this.plugin).lang().Party_Invite_Send.replace("%player%", (Object)to.getName()).send((CommandSender)from);
        ((Divinity)this.plugin).lang().Party_Invite_Get.replace("%leader%", (Object)from.getName()).replace("%party%", (Object)party.getId()).send((CommandSender)to);
        this.settings.playSound(to, PartyAction.INVITE);
    }

    private void addInvite(@NotNull Player player, @NotNull Party party) {
        String key = player.getName();
        Map<String, Long> map = this.invites.containsKey(key) ? this.invites.get(key) : new HashMap<String, Long>();
        map.put(party.getId(), System.currentTimeMillis() + (long)this.settings.partyInviteTime * 1000L);
        this.invites.put(key, map);
    }

    public boolean hasInvite(@NotNull Player p, @NotNull Party party) {
        this.updateInvites(p);
        String key = p.getName();
        if (this.invites.containsKey(key)) {
            Map<String, Long> map = this.invites.get(key);
            return map.containsKey(party.getId());
        }
        return false;
    }

    private void updateInvites(@NotNull Player player) {
        String key = player.getName();
        if (this.invites.containsKey(key)) {
            Map<String, Long> map = this.invites.get(key);
            for (Map.Entry<String, Long> e : new HashSet<Map.Entry<String, Long>>(map.entrySet())) {
                if (System.currentTimeMillis() <= e.getValue() && this.getPartyById(e.getKey()) != null) continue;
                map.remove(e.getKey());
            }
            if (map.isEmpty()) {
                this.invites.remove(key);
            } else {
                this.invites.put(key, map);
            }
        }
    }

    public void kickFromParty(@NotNull Player lead, @Nullable Player who) {
        PartyMember leader = this.getPartyMember(lead);
        if (leader == null) {
            ((Divinity)this.plugin).lang().Party_Error_NotInParty.send((CommandSender)lead);
            return;
        }
        if (!leader.isLeader()) {
            ((Divinity)this.plugin).lang().Party_Error_LeaderOnly.send((CommandSender)lead);
            return;
        }
        if (who == null) {
            ((Divinity)this.plugin).lang().Error_NoPlayer.send((CommandSender)lead);
            return;
        }
        Party party = leader.getParty();
        PartyMember liver = this.getPartyMember(who);
        if (liver == null || !party.isMember(liver)) {
            ((Divinity)this.plugin).lang().Party_Error_Player_NotIn.replace("%player%", (Object)who.getName()).send((CommandSender)lead);
            return;
        }
        if (leader.equals(liver)) {
            ((Divinity)this.plugin).lang().Party_Kick_Error_Self.send((CommandSender)lead);
            return;
        }
        party.delMember(liver);
        for (PartyMember pm : party.getMembers()) {
            Player p1 = pm.getPlayer();
            if (p1 == null) continue;
            ((Divinity)this.plugin).lang().Party_Kick_Other.replace("%leader%", (Object)lead.getName()).replace("%player%", (Object)who.getName()).send((CommandSender)p1);
            this.settings.playSound(p1, PartyAction.KICK);
        }
        ((Divinity)this.plugin).lang().Party_Kick_You.replace("%leader%", (Object)lead.getName()).replace("%party%", (Object)party.getId()).send((CommandSender)who);
        this.settings.playSound(who, PartyAction.KICK);
    }

    public void disbandParty(@NotNull Player leader) {
        PartyMember member = this.getPartyMember(leader);
        if (member == null) {
            ((Divinity)this.plugin).lang().Party_Error_NotInParty.send((CommandSender)leader);
            return;
        }
        if (!member.isLeader()) {
            ((Divinity)this.plugin).lang().Party_Error_LeaderOnly.send((CommandSender)leader);
            return;
        }
        Party party = member.getParty();
        party.disband();
        party = null;
    }

    public void teleport(@NotNull Player from, @Nullable Player to) {
        long time_cd;
        PartyMember member = this.getPartyMember(from);
        if (member == null) {
            ((Divinity)this.plugin).lang().Party_Error_NotInParty.send((CommandSender)from);
            return;
        }
        if (to == null) {
            ((Divinity)this.plugin).lang().Error_NoPlayer.send((CommandSender)from);
            return;
        }
        if (from.equals((Object)to)) {
            ((Divinity)this.plugin).lang().Party_Teleport_Error_Self.send((CommandSender)from);
            return;
        }
        long time = System.currentTimeMillis();
        if (this.tpCooldown.containsKey(from.getName()) && time < (time_cd = this.tpCooldown.get(from.getName()).longValue())) {
            String lost = TimeUT.formatTimeLeft((long)time_cd, (long)time);
            ((Divinity)this.plugin).lang().Party_Teleport_Error_Cooldown.replace("%time%", (Object)lost).send((CommandSender)from);
            return;
        }
        Party party = member.getParty();
        if (!party.isMember(to)) {
            ((Divinity)this.plugin).lang().Party_Error_Player_NotIn.replace("%player%", (Object)to.getName()).send((CommandSender)from);
            return;
        }
        party.teleport(from, to);
    }

    public void togglePartyDrop(@NotNull Player player) {
        PartyMember member = this.getMembership(player);
        if (member != null) {
            member.getParty().toggleDrop();
        }
    }

    public void togglePartyExp(@NotNull Player player) {
        PartyMember member = this.getMembership(player);
        if (member != null) {
            member.getParty().toggleExp();
        }
    }

    public PartyMember getMembership(Player player) {
        PartyMember member = this.getPartyMember(player);
        if (member == null) {
            ((Divinity)this.plugin).lang().Party_Error_NotInParty.send((CommandSender)player);
        } else if (!member.isLeader()) {
            ((Divinity)this.plugin).lang().Party_Error_LeaderOnly.send((CommandSender)player);
            return null;
        }
        return member;
    }

    @Nullable
    public Party getPartyById(String id) {
        return this.parties.get(id.toLowerCase());
    }

    @NotNull
    public Collection<String> getPartyIds() {
        return this.parties.keySet();
    }

    @NotNull
    public Collection<Party> getParties() {
        return this.parties.values();
    }

    public void openPartyGUI(@NotNull Player player) {
        this.gui.open(player, 1);
    }

    @NotNull
    public PartySettings getSettings() {
        return this.settings;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onPartyChat(AsyncPlayerChatEvent e) {
        Player player = e.getPlayer();
        PartyMember member = this.getPartyMember(player);
        if (member == null) {
            return;
        }
        if (!member.isInChat()) {
            return;
        }
        e.getRecipients().clear();
        String format = this.settings.getChatFormat().replace("{player}", "%1$s").replace("{message}", "%2$s");
        if (Hooks.hasPlaceholderAPI()) {
            format = PlaceholderAPI.setPlaceholders((Player)player, (String)format);
        }
        if (this.settings.cancelMainChatEvent()) {
            format = format.replace("%1$s", player.getDisplayName()).replace("%2$s", e.getMessage());
            e.setCancelled(true);
            for (PartyMember mem : member.getParty().getMembers()) {
                Player friend = mem.getPlayer();
                if (friend == null) continue;
                friend.sendMessage(format);
            }
        } else {
            e.setFormat(format);
            for (PartyMember friend : member.getParty().getMembers()) {
                Player pFriend = friend.getPlayer();
                if (pFriend == null) continue;
                e.getRecipients().add(pFriend);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPartyMemberDamage(EntityDamageByEntityEvent e) {
        Projectile pj;
        ProjectileSource ps;
        Entity e1 = e.getEntity();
        if (!(e1 instanceof Player)) {
            return;
        }
        Player victim = (Player)e1;
        Player damager = null;
        Entity e2 = e.getDamager();
        if (e2 instanceof Player) {
            damager = (Player)e2;
        } else if (e2 instanceof Projectile && (ps = (pj = (Projectile)e2).getShooter()) != null && ps instanceof Player) {
            damager = (Player)ps;
        }
        if (damager == null) {
            return;
        }
        Party partyVictim = this.getPlayerParty(victim);
        Party partyDamager = this.getPlayerParty(damager);
        if (partyVictim != null && partyDamager != null && partyVictim.equals(partyDamager)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPartyQuitGame(PlayerQuitEvent e) {
        Player player = e.getPlayer();
        PartyMember member = this.getPartyMember(player);
        if (member == null) {
            return;
        }
        if (this.settings.autoLeaveOnQuit()) {
            member.leaveParty();
        } else {
            Party party = member.getParty();
            for (PartyMember friend : party.getMembers()) {
                Player pFriend = friend.getPlayer();
                if (pFriend == null) continue;
                ((Divinity)this.plugin).lang().Party_Leave_QuitGame.replace("%player%", (Object)member.getName()).send((CommandSender)pFriend);
                this.settings.playSound(pFriend, PartyAction.QUIT);
            }
            if (member.isLeader()) {
                party.transferLeader();
            }
            member.setQuitTime();
        }
    }

    @EventHandler
    public void onPartyJoinBack(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        PartyMember memberBack = this.getPartyMember(player);
        if (memberBack == null) {
            return;
        }
        memberBack.resetQuitTime();
        for (PartyMember member : memberBack.getParty().getMembers()) {
            Player pFriend = member.getPlayer();
            if (pFriend == null || member.equals(memberBack)) continue;
            ((Divinity)this.plugin).lang().Party_Leave_ComeBack.replace("%player%", (Object)memberBack.getName()).send((CommandSender)pFriend);
            this.settings.playSound(pFriend, PartyAction.BACK);
        }
    }

    public class PartySettings {
        private final int partyMaxSize;
        private final boolean partyLeadQuitDisband;
        private final int partyInviteTime;
        private final boolean partyQuitInstLeave;
        private final int partyQuitWaitTime;
        private final int partyTeleportCd;
        private final boolean partyChatEnabled;
        private final String partyChatFormat;
        private final boolean partyChatCancel;
        private final Map<String, Integer> partySizeByRank;
        private final boolean hookLevelEnabled;
        private final boolean hookLevelBalanceExp;
        private final int hookLevelBalanceExpDistance;
        private final boolean hookQuestsEnabled;
        private final boolean hookQuestObjMobKill;
        private final int hookQuestObjMobKillpDistance;
        private final Map<PartyAction, Keyed> sounds;

        public PartySettings(JYML cfg) {
            String path = "party.";
            this.partyMaxSize = cfg.getInt(path + "max-size");
            this.partyLeadQuitDisband = cfg.getBoolean(path + "leader-leave-disband");
            this.partyInviteTime = cfg.getInt(path + "invite-timeout");
            this.partyQuitInstLeave = cfg.getBoolean(path + "quit-auto-leave");
            this.partyQuitWaitTime = cfg.getInt(path + "quit-timeout");
            this.partyTeleportCd = cfg.getInt(path + "tp-cooldown");
            path = "chat.";
            this.partyChatEnabled = cfg.getBoolean(path + "enabled");
            this.partyChatFormat = cfg.getString(path + "format");
            this.partyChatCancel = cfg.getBoolean(path + "cancel-main-event", true);
            this.partySizeByRank = new LinkedHashMap<String, Integer>();
            for (String rank : cfg.getSection("size-permissions")) {
                int size = cfg.getInt("size-permissions." + rank);
                this.partySizeByRank.put(rank, size);
            }
            path = "hooks.level-plugins.";
            this.hookLevelEnabled = cfg.getBoolean(path + "enabled");
            this.hookLevelBalanceExp = cfg.getBoolean(path + "balance-exp.enabled");
            this.hookLevelBalanceExpDistance = cfg.getInt(path + "balance-exp.max-distance", 25);
            path = "hooks.quest-plugins.";
            this.hookQuestsEnabled = cfg.getBoolean(path + "enabled");
            this.hookQuestObjMobKill = cfg.getBoolean(path + "objectives.mob-kill.enabled");
            this.hookQuestObjMobKillpDistance = cfg.getInt(path + "objectives.mob-kill.max-distance", 25);
            this.sounds = new HashMap<PartyAction, Keyed>();
            for (PartyAction action : PartyAction.values()) {
                if (!cfg.contains("sounds." + action.name())) continue;
                Keyed sound = null;
                String sName = cfg.getString("sounds." + action.name(), "none").toUpperCase();
                try {
                    sound = SoundUT.getSound((String)sName);
                }
                catch (IllegalArgumentException ex) {
                    continue;
                }
                this.sounds.put(action, sound);
            }
        }

        public int getPartyMaxSize() {
            return this.partyMaxSize;
        }

        public boolean disbandOnLeaderQuit() {
            return this.partyLeadQuitDisband;
        }

        public int getPartyInviteTime() {
            return this.partyInviteTime;
        }

        public boolean autoLeaveOnQuit() {
            return this.partyQuitInstLeave;
        }

        public int getQuitTimeout() {
            return this.partyQuitWaitTime;
        }

        public int getTeleportCooldown() {
            return this.partyTeleportCd;
        }

        public boolean isChatEnabled() {
            return this.partyChatEnabled;
        }

        public String getChatFormat() {
            return this.partyChatFormat;
        }

        public boolean cancelMainChatEvent() {
            return this.partyChatCancel;
        }

        public Map<String, Integer> getSizePerms() {
            return this.partySizeByRank;
        }

        public boolean isLevelHooksEnabled() {
            return this.hookLevelEnabled;
        }

        public boolean isLevelExpBalance() {
            return this.hookLevelBalanceExp;
        }

        public int getMaxLevelExpBalanceDistance() {
            return this.hookLevelBalanceExpDistance;
        }

        public boolean isQuestHooksEnabled() {
            return this.hookQuestsEnabled;
        }

        public boolean isQuestMobKillEnabled() {
            return this.hookQuestObjMobKill;
        }

        public int getMaxQuestMobKillDistance() {
            return this.hookQuestObjMobKillpDistance;
        }

        public void playSound(@NotNull Player player, @NotNull PartyAction action) {
            Keyed sound = this.sounds.get((Object)action);
            if (sound != null) {
                player.playSound(player.getLocation(), sound.getKey().toString(), 0.8f, 0.8f);
            }
        }

        public int getPartyPermSize(@NotNull Player player) {
            int maxSize = this.getPartyMaxSize();
            String group = Hooks.getPermGroup((Player)player);
            for (String rank : this.partySizeByRank.keySet()) {
                if (!rank.equalsIgnoreCase(group)) continue;
                maxSize = this.partySizeByRank.get(rank);
            }
            return maxSize;
        }
    }

    class QuitTask
    extends ITask<Divinity> {
        public QuitTask(Divinity plugin) {
            super((CodexPlugin)plugin, 60, false);
        }

        public void action() {
            for (Party party : PartyManager.this.getParties()) {
                for (PartyMember member : new HashSet<PartyMember>(party.getMembers())) {
                    if (!member.isQuitTime()) continue;
                    member.leaveParty();
                }
            }
        }
    }

    public class Party {
        private final String id;
        private final Map<UUID, PartyMember> members;
        private int size;
        private PartyDropMode drop;
        private PartyExpMode expMode;

        public Party(@NotNull String id, Player leader, int size) {
            this.id = id.toLowerCase();
            this.members = new LinkedHashMap<UUID, PartyMember>();
            this.setSize(size);
            this.drop = PartyDropMode.FREE;
            this.expMode = PartyExpMode.SHARED;
            this.addMember(leader).setLeader(true);
        }

        @NotNull
        public String getId() {
            return this.id;
        }

        @Nullable
        public PartyMember getLeader() {
            for (PartyMember member : this.getMembers()) {
                if (!member.isLeader) continue;
                return member;
            }
            return null;
        }

        public void setLeader(@NotNull PartyMember leader) {
            for (PartyMember member : this.getMembers()) {
                if (!member.isLeader) continue;
                member.setLeader(false);
            }
            leader.setLeader(true);
        }

        public void transferLeader() {
            for (PartyMember member : this.getMembers()) {
                Player player;
                if (member.isLeader() || (player = member.getPlayer()) == null) continue;
                this.setLeader(member);
                ((Divinity)PartyManager.this.plugin).lang().Party_Leader_Transfer.send((CommandSender)player);
            }
        }

        public int getOnline() {
            int online = 0;
            for (PartyMember member : this.getMembers()) {
                Player player = member.getPlayer();
                if (player == null) continue;
                ++online;
            }
            return online;
        }

        @NotNull
        public Collection<PartyMember> getMembers() {
            return this.members.values();
        }

        @Nullable
        public PartyMember getMember(@NotNull Player player) {
            return this.getMember(player.getUniqueId());
        }

        @Nullable
        public PartyMember getMember(UUID uuid) {
            return this.members.get(uuid);
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        @NotNull
        public PartyDropMode getDropMode() {
            return this.drop;
        }

        public void setDropMode(@NotNull PartyDropMode drop) {
            this.drop = drop;
        }

        @NotNull
        public PartyExpMode getExpMode() {
            return this.expMode;
        }

        public boolean isMember(@NotNull Player player) {
            return this.members.containsKey(player.getUniqueId());
        }

        public boolean isMember(@NotNull PartyMember member) {
            return this.members.containsKey(member.getUUID());
        }

        public PartyMember addMember(@NotNull Player player) {
            ((Divinity)PartyManager.this.plugin).lang().Party_Join_Done.replace("%party%", (Object)this.getId()).send((CommandSender)player);
            for (PartyMember member : this.getMembers()) {
                Player pFriend = member.getPlayer();
                if (pFriend == null) continue;
                ((Divinity)PartyManager.this.plugin).lang().Party_Join_New.replace("%player%", (Object)player.getName()).send((CommandSender)pFriend);
                PartyManager.this.settings.playSound(pFriend, PartyAction.JOIN);
            }
            PartyMember member = new PartyMember(player, this);
            this.members.put(member.getUUID(), member);
            return member;
        }

        public void delMember(@NotNull PartyMember member) {
            this.members.remove(member.getUUID());
        }

        public void disband() {
            Player lead;
            PartyMember leader = this.getLeader();
            if (leader != null && (lead = leader.getPlayer()) != null) {
                ((Divinity)PartyManager.this.plugin).lang().Party_Disband_Done.replace("%party%", (Object)this.getId()).send((CommandSender)lead);
            }
            for (PartyMember member : this.getMembers()) {
                Player player = member.getPlayer();
                if (player == null) continue;
                if (!member.isLeader()) {
                    ((Divinity)PartyManager.this.plugin).lang().Party_Disband_Leader.replace("%leader%", (Object)(leader != null ? leader.getName() : "???")).send((CommandSender)player);
                }
                PartyManager.this.settings.playSound(player, PartyAction.DISBAND);
            }
            this.members.clear();
            PartyManager.this.parties.remove(this.id);
        }

        public void teleport(@NotNull Player from, @NotNull Player to) {
            from.teleport((Entity)to);
            ((Divinity)PartyManager.this.plugin).lang().Party_Teleport_Done_To.replace("%player%", (Object)to.getName()).send((CommandSender)from);
            ((Divinity)PartyManager.this.plugin).lang().Party_Teleport_Done_From.replace("%player%", (Object)from.getName()).send((CommandSender)to);
            PartyManager.this.settings.playSound(from, PartyAction.TP);
            PartyManager.this.settings.playSound(to, PartyAction.TP);
            PartyManager.this.tpCooldown.put(from.getName(), System.currentTimeMillis() + 1000L * (long)PartyManager.this.settings.getTeleportCooldown());
        }

        public void sendMessage(ILangMsg msg) {
            for (PartyMember member : this.getMembers()) {
                Player player = member.getPlayer();
                if (player == null) continue;
                msg.send((CommandSender)player);
            }
        }

        public void sendMessage(@NotNull PartyMember from, ILangMsg msg, int dist) {
            for (PartyMember member : this.getMembersByDistance(from, dist)) {
                Player player = member.getPlayer();
                if (player == null) continue;
                msg.send((CommandSender)player);
            }
        }

        public void toggleDrop() {
            this.drop = (PartyDropMode)CollectionsUT.toggleEnum((Enum)this.drop);
            for (PartyMember pm : this.getMembers()) {
                Player p = pm.getPlayer();
                if (p == null) continue;
                String dropMode = ((Divinity)PartyManager.this.plugin).lang().getEnum(this.drop);
                ((Divinity)PartyManager.this.plugin).lang().Party_Drop_Toggle.replace("%mode%", (Object)dropMode).send((CommandSender)p);
            }
        }

        public void toggleExp() {
            this.expMode = (PartyExpMode)CollectionsUT.toggleEnum((Enum)this.expMode);
            for (PartyMember pm : this.getMembers()) {
                Player p = pm.getPlayer();
                if (p == null) continue;
                String dropMode = ((Divinity)PartyManager.this.plugin).lang().getEnum(this.expMode);
                ((Divinity)PartyManager.this.plugin).lang().Party_Exp_Toggle.replace("%mode%", (Object)dropMode).send((CommandSender)p);
            }
        }

        public Set<PartyMember> getMembersByDistance(@NotNull PartyMember from, int dist) {
            Player killer = from.getPlayer();
            if (killer == null) {
                return Collections.emptySet();
            }
            HashSet<PartyMember> objGeters = new HashSet<PartyMember>();
            for (PartyMember member : this.getMembers()) {
                Player player;
                if (member.equals(from) || (player = member.getPlayer()) == null || dist > 0 && (!player.getWorld().equals((Object)killer.getWorld()) || player.getLocation().distance(killer.getLocation()) > (double)dist)) continue;
                objGeters.add(member);
            }
            return objGeters;
        }
    }

    public class PartyMember {
        private final UUID uuid;
        private final String name;
        private boolean chat;
        private long quitTime;
        private boolean isLeader;
        private final Party party;

        public PartyMember(@NotNull Player player, Party party) {
            this.uuid = player.getUniqueId();
            this.name = player.getName();
            this.chat = false;
            this.quitTime = 0L;
            this.isLeader = false;
            this.party = party;
        }

        @NotNull
        public UUID getUUID() {
            return this.uuid;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        public boolean isInChat() {
            return this.chat;
        }

        public boolean isLeader() {
            return this.isLeader;
        }

        public void setLeader(boolean isLeader) {
            this.isLeader = isLeader;
        }

        public void toggleChat() {
            this.chat = !this.chat;
            Player p = this.getPlayer();
            if (p == null) {
                return;
            }
            ((Divinity)PartyManager.this.plugin).lang().Party_Chat_Toggle.replace("%state%", (Object)((Divinity)PartyManager.this.plugin).lang().getBool(this.isInChat())).send((CommandSender)p);
        }

        public void setQuitTime() {
            this.quitTime = System.currentTimeMillis() + (long)PartyManager.this.settings.getQuitTimeout() * 60L * 1000L;
        }

        public void resetQuitTime() {
            this.quitTime = 0L;
        }

        public boolean isQuitTime() {
            return this.quitTime > 0L && System.currentTimeMillis() >= this.quitTime;
        }

        @Nullable
        public Player getPlayer() {
            return ((Divinity)PartyManager.this.plugin).getServer().getPlayer(this.uuid);
        }

        @NotNull
        public Party getParty() {
            return this.party;
        }

        public void leaveParty() {
            PlayerLeavePartyEvent event = new PlayerLeavePartyEvent(this.getPlayer(), this);
            ((Divinity)PartyManager.this.plugin).getPluginManager().callEvent((Event)event);
            this.party.delMember(this);
            Player player = this.getPlayer();
            if (player != null) {
                ((Divinity)PartyManager.this.plugin).lang().Party_Leave_Done.replace("%party%", (Object)this.party.getId()).send((CommandSender)player);
            }
            if (this.party.getMembers().isEmpty() || PartyManager.this.settings.disbandOnLeaderQuit() && this.isLeader()) {
                this.party.disband();
                return;
            }
            for (PartyMember member : this.party.getMembers()) {
                Player pFriend = member.getPlayer();
                if (pFriend == null) continue;
                ((Divinity)PartyManager.this.plugin).lang().Party_Leave_Member.replace("%player%", (Object)this.getName()).send((CommandSender)pFriend);
                PartyManager.this.settings.playSound(pFriend, PartyAction.LEAVE);
            }
            if (this.isLeader()) {
                this.party.transferLeader();
            }
        }
    }

    static enum PartyAction {
        CREATE,
        INVITE,
        JOIN,
        LEAVE,
        KICK,
        DISBAND,
        QUIT,
        BACK,
        TP;

    }

    public static enum PartyExpMode {
        PRIVATE,
        SHARED;

    }

    public static enum PartyDropMode {
        FREE,
        LEADER,
        AUTO,
        ROLL;

    }
}

