/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.loot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.filoghost.holographicdisplays.api.HolographicDisplaysAPI;
import me.filoghost.holographicdisplays.api.hologram.Hologram;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.manager.IListener;
import studio.magemonkey.codex.manager.api.task.ITask;
import studio.magemonkey.codex.modules.IModuleExecutor;
import studio.magemonkey.codex.util.ClickText;
import studio.magemonkey.codex.util.DataUT;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.LocUT;
import studio.magemonkey.codex.util.TimeUT;
import studio.magemonkey.codex.util.random.Rnd;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.list.loot.LootManager;
import studio.magemonkey.divinity.modules.list.party.PartyManager;

public class LootHolder
extends IListener<Divinity>
implements InventoryHolder {
    protected LootManager manager;
    protected final Location boxLoc;
    protected final String title;
    protected int size;
    protected long despawnTime;
    protected UUID ownerId = null;
    protected UUID invId;
    protected String ownerName = "";
    protected Inventory inv;
    protected Set<Player> viewers;
    private RollTask rollTask = null;
    private HologramExpansion holoEx = null;
    private static final NamespacedKey KEY_META_OWNER = new NamespacedKey((Plugin)Divinity.getInstance(), "QRPG_LOOT_ITEM_OWNER");

    public LootHolder(LootManager manager, @NotNull Location boxLoc, @Nullable LivingEntity killer, @NotNull LivingEntity dead, @NotNull List<ItemStack> loot) {
        super((JavaPlugin)((Divinity)manager.plugin));
        this.manager = manager;
        this.boxLoc = boxLoc;
        this.title = dead.getCustomName() != null ? dead.getCustomName() : ((Divinity)this.plugin).lang().getEnum((Enum)dead.getType());
        int lootSize = loot.size();
        this.size = 54;
        if (lootSize < 55) {
            this.size = 54;
        }
        if (lootSize < 46) {
            this.size = 45;
        }
        if (lootSize < 37) {
            this.size = 36;
        }
        if (lootSize < 28) {
            this.size = 27;
        }
        if (lootSize < 19) {
            this.size = 18;
        }
        if (lootSize < 10) {
            this.size = 9;
        }
        this.despawnTime = System.currentTimeMillis() + (long)manager.getLootTime() * 1000L;
        this.ownerName = ((Divinity)this.plugin).lang().Loot_Box_Owner_None.getMsg();
        if (manager.isDropProtect() && killer != null) {
            Player kill;
            PartyManager.PartyMember member;
            this.ownerId = killer.getUniqueId();
            this.ownerName = killer.getName();
            PartyManager partyManager = ((Divinity)this.plugin).getModuleCache().getPartyManager();
            if (partyManager != null && killer instanceof Player && (member = partyManager.getPartyMember(kill = (Player)killer)) != null) {
                PartyManager.Party party = member.getParty();
                UUID uuid = null;
                String name = "";
                PartyManager.PartyMember leader = party.getLeader();
                PartyManager.PartyDropMode dropMode = party.getDropMode();
                if (dropMode == PartyManager.PartyDropMode.LEADER && leader != null) {
                    uuid = leader.getUUID();
                    name = leader.getName();
                } else if (dropMode == PartyManager.PartyDropMode.AUTO) {
                    ArrayList<PartyManager.PartyMember> memList = new ArrayList<PartyManager.PartyMember>(party.getMembers());
                    PartyManager.PartyMember rMem = (PartyManager.PartyMember)Rnd.get(memList);
                    if (rMem == null) {
                        rMem = (PartyManager.PartyMember)memList.get(0);
                    }
                    uuid = rMem.getUUID();
                    name = rMem.getName();
                } else {
                    uuid = member.getUUID();
                    name = member.getName();
                }
                this.ownerId = uuid;
                this.ownerName = name;
            }
        }
        this.invId = UUID.randomUUID();
        this.viewers = new HashSet<Player>();
        this.getInventory();
        for (int slot = 0; slot < lootSize && slot < this.size; ++slot) {
            ItemStack item = loot.get(slot);
            if (item == null || item.getType() == Material.AIR) continue;
            this.inv.setItem(slot, item);
        }
        if (this.manager.boxHoloEnabled) {
            this.holoEx = new HologramExpansion();
        }
        this.registerListeners();
    }

    public final void shutdown() {
        if (this.rollTask != null) {
            this.rollTask.cancel();
            this.rollTask = null;
        }
        for (Player p : this.viewers) {
            p.closeInventory();
        }
        this.removeHolo();
        this.unregisterListeners();
        this.inv = null;
    }

    @NotNull
    public Inventory getInventory() {
        if (this.inv == null) {
            this.inv = ((Divinity)this.plugin).getServer().createInventory((InventoryHolder)this, this.size, this.title);
        }
        return this.inv;
    }

    public void open(@NotNull Player player) {
        if (!this.isOwner(player)) {
            ((Divinity)this.plugin).lang().Loot_Box_Error_NotOwner.send((CommandSender)player);
            return;
        }
        if (!this.viewers.isEmpty()) {
            ((Divinity)this.plugin).lang().Loot_Box_Error_Locked.send((CommandSender)player);
            return;
        }
        player.openInventory(this.getInventory());
        this.viewers.add(player);
    }

    public boolean isOwner(@NotNull Player player) {
        PartyManager.Party party;
        if (this.ownerId == null) {
            return true;
        }
        PartyManager partyManager = ((Divinity)this.plugin).getModuleCache().getPartyManager();
        if (partyManager != null && (party = partyManager.getPlayerParty(player)) != null && party.getDropMode() != PartyManager.PartyDropMode.LEADER && party.getDropMode() != PartyManager.PartyDropMode.AUTO && party.getMember(this.ownerId) != null) {
            return true;
        }
        return player.getUniqueId().equals(this.ownerId);
    }

    public boolean isExpired() {
        return System.currentTimeMillis() >= this.despawnTime;
    }

    public void updateHolo() {
        if (this.holoEx == null) {
            return;
        }
        this.holoEx.update();
    }

    public void removeHolo() {
        if (this.holoEx == null) {
            return;
        }
        this.holoEx.remove();
    }

    private boolean hasItemOwner(@NotNull ItemStack item) {
        return this.getItemOwner(item) != null;
    }

    @Nullable
    private String getItemOwner(@NotNull ItemStack item) {
        return DataUT.getStringData((ItemStack)item, (NamespacedKey)KEY_META_OWNER);
    }

    private boolean isItemOwner(@NotNull Player player, @NotNull ItemStack item) {
        String uuid = player.getUniqueId().toString();
        String owner = this.getItemOwner(item);
        return owner != null && owner.equalsIgnoreCase(uuid);
    }

    @EventHandler(ignoreCancelled=true)
    public void onLootDrag(InventoryDragEvent e) {
        InventoryHolder holder = e.getInventory().getHolder();
        if (holder == null || !holder.getClass().isInstance((Object)this)) {
            return;
        }
        LootHolder lootHolder = (LootHolder)holder;
        if (!lootHolder.invId.equals(this.invId)) {
            return;
        }
        e.setCancelled(true);
    }

    @EventHandler(ignoreCancelled=true)
    public void onLootClick(InventoryClickEvent e) {
        ItemStack item;
        InventoryHolder holder = e.getInventory().getHolder();
        if (holder == null || !holder.getClass().isInstance((Object)this)) {
            return;
        }
        LootHolder lootHolder = (LootHolder)holder;
        if (!lootHolder.invId.equals(this.invId)) {
            return;
        }
        int slot = e.getRawSlot();
        ItemStack cursor = e.getCursor();
        InventoryAction ea = e.getAction();
        if (ea == InventoryAction.HOTBAR_MOVE_AND_READD || ea == InventoryAction.SWAP_WITH_CURSOR || ea == InventoryAction.HOTBAR_SWAP || cursor != null && cursor.getType() != Material.AIR && slot < this.size) {
            e.setCancelled(true);
        }
        if ((item = e.getCurrentItem()) == null || item.getType() == Material.AIR) {
            return;
        }
        if (this.rollTask != null && this.rollTask.slot == slot) {
            e.setCancelled(true);
            return;
        }
        Player clicker = (Player)e.getWhoClicked();
        if (this.hasItemOwner(item)) {
            if (!this.isItemOwner(clicker, item)) {
                e.setCancelled(true);
                ((Divinity)this.plugin).lang().Loot_Party_Roll_NotOwner.send((CommandSender)clicker);
                return;
            }
            DataUT.removeData((ItemStack)item, (NamespacedKey)KEY_META_OWNER);
            e.setCurrentItem(item);
            return;
        }
        PartyManager partyManager = ((Divinity)this.plugin).getModuleCache().getPartyManager();
        if (partyManager == null) {
            return;
        }
        PartyManager.PartyMember member = partyManager.getPartyMember(clicker);
        if (member == null) {
            return;
        }
        PartyManager.Party party = member.getParty();
        if (party.getDropMode() == PartyManager.PartyDropMode.ROLL && party.getOnline() > 1 && slot < this.size) {
            e.setCancelled(true);
            if (this.rollTask != null || this.manager.getPartyRollTask(clicker) != null) {
                ((Divinity)this.plugin).lang().Loot_Party_Roll_AlreadyStarted.send((CommandSender)clicker);
                return;
            }
            this.rollTask = new RollTask(clicker, slot);
            this.rollTask.start();
            clicker.closeInventory();
            return;
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onLootClose(InventoryCloseEvent e) {
        InventoryHolder inventoryHolder = e.getInventory().getHolder();
        if (inventoryHolder == null || !inventoryHolder.getClass().isInstance((Object)this)) {
            return;
        }
        LootHolder lootHolder = (LootHolder)inventoryHolder;
        if (!lootHolder.invId.equals(this.invId)) {
            return;
        }
        this.viewers.remove(e.getPlayer());
        for (ItemStack item : this.inv.getContents()) {
            if (ItemUT.isAir((ItemStack)item)) continue;
            return;
        }
        this.manager.despawnLoot(this.boxLoc);
    }

    @Nullable
    public RollTask getRollTask() {
        return this.rollTask;
    }

    public class RollTask
    extends ITask<Divinity> {
        PartyManager.Party party;
        Player roller;
        int slot;
        ItemStack item;
        Map<UUID, Integer> rollMap;
        int timeEnd;

        public RollTask(Player clicker, int slot) {
            PartyManager.PartyMember member;
            super((CodexPlugin)((Divinity)LootHolder.this.plugin), 1, false);
            this.roller = clicker;
            this.slot = slot;
            this.item = LootHolder.this.inv.getItem(this.slot);
            this.rollMap = new HashMap<UUID, Integer>();
            this.timeEnd = LootHolder.this.manager.partyDropRollTime;
            PartyManager partyManager = ((Divinity)this.plugin).getModuleCache().getPartyManager();
            PartyManager.PartyMember partyMember = member = partyManager != null ? partyManager.getPartyMember(clicker) : null;
            if (member == null) {
                throw new IllegalArgumentException("Null Party for Roll task!");
            }
            this.party = member.getParty();
        }

        public void addRoll(@NotNull Player player, int roll) {
            UUID uuid = player.getUniqueId();
            if (this.rollMap.containsKey(uuid)) {
                int value = this.rollMap.get(uuid);
                ((Divinity)this.plugin).lang().Loot_Party_Roll_AlreadyRoll.replace("%value%", (Object)String.valueOf(value)).send((CommandSender)player);
                return;
            }
            this.rollMap.put(uuid, roll);
            this.party.sendMessage(((Divinity)this.plugin).lang().Loot_Party_Roll_MemberRoll.replace("%player%", (Object)player.getName()).replace("%value%", (Object)String.valueOf(roll)));
        }

        public void rollNotify() {
            PartyManager partyManager = ((Divinity)this.plugin).getModuleCache().getPartyManager();
            if (partyManager == null) {
                return;
            }
            IModuleExecutor exec = partyManager.getExecutor();
            if (exec == null) {
                return;
            }
            String label = exec.labels()[0];
            for (PartyManager.PartyMember mem : this.party.getMembers()) {
                Player p = mem.getPlayer();
                if (p == null) continue;
                ClickText ct = new ClickText(((Divinity)this.plugin).lang().Loot_Party_Roll_Notify_List.getMsg());
                ct.createPlaceholder("%roll%", ((Divinity)this.plugin).lang().Loot_Party_Roll_Notify_Roll_Name.getMsg()).hint(((Divinity)this.plugin).lang().Loot_Party_Roll_Notify_Roll_Hint.getMsg()).execCmd("/" + label + " roll");
                ct.createPlaceholder("%item%", ItemUT.getItemName((ItemStack)this.item)).showItem(this.item);
                ct.send((CommandSender)p);
            }
        }

        public void action() {
            if (this.party == null || this.party.getOnline() <= 0) {
                this.cancel();
                return;
            }
            if (this.timeEnd <= 0 || this.rollMap.size() >= this.party.getOnline()) {
                UUID winner = null;
                int best = 0;
                for (Map.Entry<UUID, Integer> e : this.rollMap.entrySet()) {
                    if (e.getValue() <= best) continue;
                    winner = e.getKey();
                    best = e.getValue();
                }
                PartyManager.PartyMember winnerMember = null;
                if (winner == null || (winnerMember = this.party.getMember(winner)) == null) {
                    this.party.sendMessage(((Divinity)this.plugin).lang().Loot_Party_Roll_NoRoll);
                    this.cancel();
                    return;
                }
                DataUT.setData((ItemStack)this.item, (NamespacedKey)KEY_META_OWNER, (Object)winner.toString());
                LootHolder.this.inv.setItem(this.slot, this.item);
                this.party.sendMessage(((Divinity)this.plugin).lang().Loot_Party_Roll_Winner.replace("%item%", (Object)ItemUT.getItemName((ItemStack)this.item)).replace("%player%", (Object)winnerMember.getName()));
                this.cancel();
                return;
            }
            double div = (double)LootHolder.this.manager.partyDropRollTime * 1.0 / (double)this.timeEnd * 1.0;
            if (div == 1.0 || div == 2.0) {
                this.rollNotify();
            }
            if (this.timeEnd % 5 == 0 || this.timeEnd <= 5) {
                this.party.sendMessage(((Divinity)this.plugin).lang().Loot_Party_Roll_RollIn.replace("%time%", (Object)String.valueOf(this.timeEnd)));
            }
            --this.timeEnd;
        }

        public void cancel() {
            this.stop();
            LootHolder.this.rollTask = null;
        }
    }

    class HologramExpansion {
        private Hologram holo;

        public HologramExpansion() {
            this.holo = HolographicDisplaysAPI.get((Plugin)LootHolder.this.plugin).createHologram(LocUT.getCenter((Location)LootHolder.this.boxLoc.clone()).add(0.0, 1.25, 0.0));
            this.update();
        }

        public void update() {
            if (this.holo == null) {
                return;
            }
            this.holo.getLines().clear();
            for (String s : LootHolder.this.manager.getHoloText()) {
                this.holo.getLines().appendText(s.replace("%entity%", LootHolder.this.title).replace("%owner%", LootHolder.this.ownerName).replace("%time%", TimeUT.formatTimeLeft((long)LootHolder.this.despawnTime)));
            }
        }

        public void remove() {
            if (this.holo == null) {
                return;
            }
            this.holo.delete();
            this.holo = null;
        }
    }
}

