/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.itemgenerator.editor.sockets;

import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import studio.magemonkey.codex.manager.api.menu.Slot;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.AbstractEditorGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.EditorGUI;
import studio.magemonkey.divinity.stats.items.ItemStats;
import studio.magemonkey.divinity.stats.items.attributes.SocketAttribute;

public class SocketListGUI
extends AbstractEditorGUI {
    private final String name;
    private final String path;

    public SocketListGUI(Player player, AbstractEditorGUI.ItemGeneratorReference itemGenerator, String name) {
        super(player, 6, "Editor/" + EditorGUI.ItemType.SOCKETS.getTitle(), itemGenerator);
        this.name = name;
        this.path = EditorGUI.ItemType.SOCKETS.getPath() + "." + this.name + ".list.";
    }

    public void setContents() {
        ArrayList<String> list = new ArrayList<String>();
        for (SocketAttribute socketAttribute : ItemStats.getSockets(SocketAttribute.Type.valueOf(this.name))) {
            list.add(socketAttribute.getId());
        }
        int i = 0;
        for (final String entry : list) {
            if (++i % this.inventory.getSize() == 53) {
                this.setSlot(i, this.getNextButton());
                ++i;
            } else if (i % 9 == 8) {
                ++i;
            }
            if (i % this.inventory.getSize() == 45) {
                this.setSlot(i, this.getPrevButton());
                ++i;
            } else if (i % 9 == 0) {
                ++i;
            }
            this.setSlot(i, new Slot(SocketListGUI.createItem(Material.EMERALD, "&e" + entry, "&bCurrent: &a" + this.itemGenerator.getConfig().getDouble(this.path + entry + ".chance"), "&eModify")){

                public void onLeftClick() {
                    SocketListGUI.this.sendSetMessage("chance for a " + entry + " " + SocketListGUI.this.name + " socket", String.valueOf(SocketListGUI.this.itemGenerator.getConfig().getDouble(SocketListGUI.this.path + entry + ".chance")), s -> {
                        SocketListGUI.this.itemGenerator.getConfig().set(SocketListGUI.this.path + entry + ".chance", (Object)Double.parseDouble(s));
                        SocketListGUI.this.saveAndReopen();
                    });
                }
            });
        }
        this.setSlot(this.getPages() * this.inventory.getSize() - 9, this.getPrevButton());
        this.setSlot(this.getPages() * this.inventory.getSize() - 1, this.getNextButton());
    }
}

