/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.itemgenerator.editor.enchantments;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import studio.magemonkey.codex.manager.api.menu.Slot;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.AbstractEditorGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.EditorGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.enchantments.NewEnchantmentGUI;

public class EnchantmentListGUI
extends AbstractEditorGUI {
    public EnchantmentListGUI(Player player, AbstractEditorGUI.ItemGeneratorReference itemGenerator) {
        super(player, 6, "Editor/" + EditorGUI.ItemType.ENCHANTMENTS.getTitle(), itemGenerator);
    }

    public void setContents() {
        final LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        ConfigurationSection section = this.itemGenerator.getConfig().getConfigurationSection(EditorGUI.ItemType.ENCHANTMENTS.getPath() + ".list");
        if (section != null) {
            for (String key : section.getKeys(false)) {
                map.put(key, section.getString(key));
            }
        }
        ArrayList list = new ArrayList(map.keySet());
        Enchantment[] vanillaEnchantments = Enchantment.values();
        if (list.size() < vanillaEnchantments.length) {
            list.add(null);
        }
        final ArrayList<String> missingList = new ArrayList<String>();
        for (Enchantment enchantment : vanillaEnchantments) {
            String key = enchantment.getKey().toString().substring("minecraft:".length());
            if (list.contains(key)) continue;
            missingList.add(key);
        }
        int i = 0;
        for (final String key : list) {
            if (++i % this.inventory.getSize() == 53) {
                this.setSlot(i, this.getNextButton());
                ++i;
            } else if (i % 9 == 8) {
                ++i;
            }
            if (i % this.inventory.getSize() == 45) {
                this.setSlot(i, this.getPrevButton());
                ++i;
            } else if (i % 9 == 0) {
                ++i;
            }
            this.setSlot(i, key == null ? new Slot(EnchantmentListGUI.createItem(Material.REDSTONE, "&eAdd new enchantment", new String[0])){

                public void onLeftClick() {
                    EnchantmentListGUI.this.openSubMenu(new NewEnchantmentGUI(EnchantmentListGUI.this.player, EnchantmentListGUI.this.itemGenerator, missingList));
                }
            } : new Slot(EnchantmentListGUI.createItem(Material.ENCHANTED_BOOK, "&e" + key, "&bCurrent: &a" + (String)map.get(key), "&6Left-Click: &eSet", "&6Right-Click: &eRemove")){

                public void onLeftClick() {
                    EnchantmentListGUI.this.sendSetMessage("desired level range", (String)map.get(key), s -> {
                        String[] strings = s.split(":");
                        if (strings.length > 2) {
                            throw new IllegalArgumentException();
                        }
                        for (String string : strings) {
                            Integer.parseInt(string);
                        }
                        EnchantmentListGUI.this.itemGenerator.getConfig().set(EditorGUI.ItemType.ENCHANTMENTS.getPath() + ".list." + key, s);
                        EnchantmentListGUI.this.saveAndReopen();
                    });
                }

                public void onDrop() {
                    EnchantmentListGUI.this.itemGenerator.getConfig().remove(EditorGUI.ItemType.ENCHANTMENTS.getPath() + ".list." + key);
                    EnchantmentListGUI.this.saveAndReopen();
                }
            });
        }
        if (list.get(list.size() - 1) == null) {
            list.remove(list.size() - 1);
        }
        this.setSlot(this.getPages() * this.inventory.getSize() - 9, this.getPrevButton());
        this.setSlot(this.getPages() * this.inventory.getSize() - 1, this.getNextButton());
    }
}

