/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.itemgenerator;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.api.items.ItemType;
import studio.magemonkey.codex.api.items.exception.MissingItemException;
import studio.magemonkey.codex.api.items.exception.MissingProviderException;
import studio.magemonkey.codex.api.items.providers.ICodexItemProvider;
import studio.magemonkey.codex.api.items.providers.VanillaProvider;
import studio.magemonkey.codex.commands.api.ISubCommand;
import studio.magemonkey.codex.compat.VersionManager;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.core.Version;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.Reflex;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.codex.util.random.Rnd;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.config.Config;
import studio.magemonkey.divinity.config.EngineCfg;
import studio.magemonkey.divinity.hooks.external.FabledHook;
import studio.magemonkey.divinity.modules.LimitedItem;
import studio.magemonkey.divinity.modules.api.QModuleDrop;
import studio.magemonkey.divinity.modules.list.itemgenerator.ItemAbilityHandler;
import studio.magemonkey.divinity.modules.list.itemgenerator.ResourceManager;
import studio.magemonkey.divinity.modules.list.itemgenerator.api.IAttributeGenerator;
import studio.magemonkey.divinity.modules.list.itemgenerator.command.CreateCommand;
import studio.magemonkey.divinity.modules.list.itemgenerator.command.EditCommand;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.AbstractEditorGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.generators.AbilityGenerator;
import studio.magemonkey.divinity.modules.list.itemgenerator.generators.AttributeGenerator;
import studio.magemonkey.divinity.modules.list.itemgenerator.generators.SingleAttributeGenerator;
import studio.magemonkey.divinity.modules.list.itemgenerator.generators.TypedStatGenerator;
import studio.magemonkey.divinity.modules.list.sets.SetManager;
import studio.magemonkey.divinity.stats.bonus.BonusMap;
import studio.magemonkey.divinity.stats.bonus.StatBonus;
import studio.magemonkey.divinity.stats.items.ItemStats;
import studio.magemonkey.divinity.stats.items.api.ItemLoreStat;
import studio.magemonkey.divinity.stats.items.attributes.AmmoAttribute;
import studio.magemonkey.divinity.stats.items.attributes.DamageAttribute;
import studio.magemonkey.divinity.stats.items.attributes.DefenseAttribute;
import studio.magemonkey.divinity.stats.items.attributes.HandAttribute;
import studio.magemonkey.divinity.stats.items.attributes.SocketAttribute;
import studio.magemonkey.divinity.stats.items.attributes.api.TypedStat;
import studio.magemonkey.divinity.stats.items.requirements.ItemRequirements;
import studio.magemonkey.divinity.stats.items.requirements.api.DynamicUserRequirement;
import studio.magemonkey.divinity.stats.items.requirements.user.BannedClassRequirement;
import studio.magemonkey.divinity.stats.items.requirements.user.ClassRequirement;
import studio.magemonkey.divinity.stats.items.requirements.user.LevelRequirement;
import studio.magemonkey.divinity.stats.items.requirements.user.SoulboundRequirement;
import studio.magemonkey.divinity.stats.tiers.Tier;
import studio.magemonkey.divinity.utils.ItemUtils;
import studio.magemonkey.divinity.utils.LoreUT;

public class ItemGeneratorManager
extends QModuleDrop<GeneratorItem> {
    public static YamlConfiguration commonItemGenerator;
    private static ResourceManager resourceManager;
    private ItemAbilityHandler abilityHandler;
    public static final String PLACE_GEN_DAMAGE = "%GENERATOR_DAMAGE%";
    public static final String PLACE_GEN_DEFENSE = "%GENERATOR_DEFENSE%";
    public static final String PLACE_GEN_STATS = "%GENERATOR_STATS%";
    public static final String PLACE_GEN_SOCKETS = "%GENERATOR_SOCKETS_%TYPE%%";
    public static final String PLACE_GEN_ABILITY = "%GENERATOR_SKILLS%";
    public static final String PLACE_GEN_FABLED_ATTR = "%GENERATOR_FABLED_ATTR%";

    public ItemGeneratorManager(@NotNull Divinity plugin) {
        super(plugin, GeneratorItem.class);
    }

    @NotNull
    public String getId() {
        return "item_generator";
    }

    @NotNull
    public String version() {
        return "2.0.0";
    }

    public void setup() {
        Closeable in;
        if (commonItemGenerator == null) {
            try {
                in = new InputStreamReader(Objects.requireNonNull(((Object)((Object)((Divinity)this.plugin))).getClass().getResourceAsStream(this.getPath() + "items/common.yml")));
                try {
                    commonItemGenerator = YamlConfiguration.loadConfiguration((Reader)in);
                }
                finally {
                    ((InputStreamReader)in).close();
                }
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
        try {
            in = ((Object)((Object)((Divinity)this.plugin))).getClass().getResourceAsStream(this.getPath() + "settings.yml");
            try {
                YamlConfiguration configuration = new YamlConfiguration();
                configuration.loadFromString(new String(((InputStream)in).readAllBytes()));
                this.cfg.addMissing("editor-gui", configuration.get("editor-gui"));
                this.cfg.saveChanges();
            }
            finally {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        resourceManager = new ResourceManager(this);
        this.abilityHandler = new ItemAbilityHandler(this);
        this.abilityHandler.setup();
    }

    @Override
    protected void onPostSetup() {
        super.onPostSetup();
        this.moduleCommand.addSubCommand((ISubCommand)new CreateCommand(this));
        this.moduleCommand.addSubCommand((ISubCommand)new EditCommand(this));
    }

    public void shutdown() {
        AbstractEditorGUI editorGUI = AbstractEditorGUI.getInstance();
        if (editorGUI != null) {
            editorGUI.shutdown();
        }
        this.unregisterListeners();
        if (this.abilityHandler != null) {
            this.abilityHandler.shutdown();
            this.abilityHandler = null;
        }
        if (resourceManager != null) {
            resourceManager.shutdown();
            resourceManager = null;
        }
    }

    @Override
    protected void loadItems() {
        super.loadItems();
        resourceManager.setup();
    }

    @NotNull
    public GeneratorItem load(String id, JYML cfg) {
        GeneratorItem itemGenerator = new GeneratorItem((Divinity)this.plugin, cfg);
        this.items.put(id, itemGenerator);
        return itemGenerator;
    }

    public static List<String> getMatchingTierPrefixes(Tier tier) {
        return new ArrayList<String>(resourceManager.getPrefix(ResourceManager.ResourceCategory.TIER, tier.getId()));
    }

    public static List<String> getMatchingTierSuffixes(Tier tier) {
        return new ArrayList<String>(resourceManager.getSuffix(ResourceManager.ResourceCategory.TIER, tier.getId()));
    }

    public static List<String> getMatchingMaterialPrefixes(Material material) {
        return new ArrayList<String>(resourceManager.getPrefix(ResourceManager.ResourceCategory.MATERIAL, material.name()));
    }

    public static List<String> getMatchingMaterialSuffixes(Material material) {
        return new ArrayList<String>(resourceManager.getSuffix(ResourceManager.ResourceCategory.MATERIAL, material.name()));
    }

    public static List<String> getMatchingTypePrefixes(ItemStack item) {
        return new ArrayList<String>(resourceManager.getPrefix(ResourceManager.ResourceCategory.SUBTYPE, ItemUtils.getItemGroupIdFor(item)));
    }

    public static List<String> getMatchingTypeSuffixes(ItemStack item) {
        return new ArrayList<String>(resourceManager.getSuffix(ResourceManager.ResourceCategory.SUBTYPE, ItemUtils.getItemGroupIdFor(item)));
    }

    public static Map<ResourceManager.ResourceCategory, List<String>> getMatchingPrefixes(Material material, Collection<Tier> tiers) {
        HashMap<ResourceManager.ResourceCategory, List<String>> entries = new HashMap<ResourceManager.ResourceCategory, List<String>>();
        entries.put(ResourceManager.ResourceCategory.TIER, new ArrayList());
        tiers.forEach(tier -> ((List)entries.get((Object)ResourceManager.ResourceCategory.TIER)).addAll(ItemGeneratorManager.getMatchingTierPrefixes(tier)));
        entries.put(ResourceManager.ResourceCategory.MATERIAL, resourceManager.getPrefix(ResourceManager.ResourceCategory.MATERIAL, material.name()));
        entries.put(ResourceManager.ResourceCategory.SUBTYPE, resourceManager.getPrefix(ResourceManager.ResourceCategory.SUBTYPE, ItemUtils.getItemGroupIdFor(new ItemStack(material))));
        return entries;
    }

    public static Map<ResourceManager.ResourceCategory, List<String>> getMatchingSuffixes(Material material, Collection<Tier> tiers) {
        HashMap<ResourceManager.ResourceCategory, List<String>> entries = new HashMap<ResourceManager.ResourceCategory, List<String>>();
        entries.put(ResourceManager.ResourceCategory.TIER, new ArrayList());
        tiers.forEach(tier -> ((List)entries.get((Object)ResourceManager.ResourceCategory.TIER)).addAll(ItemGeneratorManager.getMatchingTierSuffixes(tier)));
        entries.put(ResourceManager.ResourceCategory.MATERIAL, resourceManager.getSuffix(ResourceManager.ResourceCategory.MATERIAL, material.name()));
        entries.put(ResourceManager.ResourceCategory.SUBTYPE, resourceManager.getSuffix(ResourceManager.ResourceCategory.SUBTYPE, ItemUtils.getItemGroupIdFor(new ItemStack(material))));
        return entries;
    }

    public static List<String> getAllCombinations(GeneratorItem item, Material material) {
        String modifiedName;
        String modifiedName2;
        String name = item.getName();
        String itemGroupName = ItemUtils.getItemGroupNameFor(new ItemStack(material));
        ArrayList<String> names = new ArrayList<String>();
        Map<ResourceManager.ResourceCategory, List<String>> prefixes = ItemGeneratorManager.getMatchingPrefixes(material, Config.getTiers());
        Map<ResourceManager.ResourceCategory, List<String>> suffixes = ItemGeneratorManager.getMatchingSuffixes(material, Config.getTiers());
        names.add(name.replace("%item_type%", itemGroupName).replace("%prefix_tier%", "").replace("%prefix_material%", "").replace("%prefix_type%", "").replace("%suffix_tier%", "").replace("%suffix_material%", "").replace("%suffix_type%", ""));
        if (name.contains("%prefix_tier%") && !name.contains("%prefix_material%") && !name.contains("%prefix_type%")) {
            for (String _prefixTier : prefixes.get((Object)ResourceManager.ResourceCategory.TIER)) {
                modifiedName2 = name.replace("%item_type%", itemGroupName).replace("%prefix_tier%", _prefixTier).replace("%prefix_material%", "").replace("%prefix_type%", "");
                names.add(modifiedName2.replace("%suffix_tier%", "").replace("%suffix_material%", "").replace("%suffix_type%", ""));
                names.addAll(ItemGeneratorManager.interpolatePrefixWithAllSuffixes(modifiedName2, suffixes));
            }
        }
        if (!name.contains("%prefix_tier%") && !name.contains("%prefix_material%") && name.contains("%prefix_type%")) {
            for (String _prefixMaterial : prefixes.get((Object)ResourceManager.ResourceCategory.MATERIAL)) {
                modifiedName2 = name.replace("%item_type%", itemGroupName).replace("%prefix_tier%", "").replace("%prefix_material%", _prefixMaterial).replace("%prefix_type%", "");
                names.add(modifiedName2.replace("%suffix_tier%", "").replace("%suffix_material%", "").replace("%suffix_type%", ""));
                names.addAll(ItemGeneratorManager.interpolatePrefixWithAllSuffixes(modifiedName2, suffixes));
            }
        }
        if (!name.contains("%prefix_tier%") && name.contains("%prefix_material%") && !name.contains("%prefix_type%")) {
            for (String _prefixItemType : prefixes.get((Object)ResourceManager.ResourceCategory.SUBTYPE)) {
                modifiedName2 = name.replace("%item_type%", itemGroupName).replace("%prefix_tier%", "").replace("%prefix_material%", "").replace("%prefix_type%", _prefixItemType);
                names.add(modifiedName2.replace("%suffix_tier%", "").replace("%suffix_material%", "").replace("%suffix_type%", ""));
                names.addAll(ItemGeneratorManager.interpolatePrefixWithAllSuffixes(modifiedName2, suffixes));
            }
        }
        if (name.contains("%prefix_tier%") && name.contains("%prefix_material%") && !name.contains("%prefix_type%")) {
            for (String _prefixTier : prefixes.get((Object)ResourceManager.ResourceCategory.TIER)) {
                for (String _prefixMaterial : prefixes.get((Object)ResourceManager.ResourceCategory.MATERIAL)) {
                    modifiedName = name.replace("%item_type%", itemGroupName).replace("%prefix_tier%", _prefixTier).replace("%prefix_material%", _prefixMaterial).replace("%prefix_type%", "");
                    names.add(modifiedName.replace("%suffix_tier%", "").replace("%suffix_material%", "").replace("%suffix_type%", ""));
                    names.addAll(ItemGeneratorManager.interpolatePrefixWithAllSuffixes(modifiedName, suffixes));
                }
            }
        }
        if (name.contains("%prefix_tier%") && !name.contains("%prefix_material%") && name.contains("%prefix_type%")) {
            for (String _prefixTier : prefixes.get((Object)ResourceManager.ResourceCategory.TIER)) {
                for (String _prefixItemType : prefixes.get((Object)ResourceManager.ResourceCategory.SUBTYPE)) {
                    modifiedName = name.replace("%item_type%", itemGroupName).replace("%prefix_tier%", _prefixTier).replace("%prefix_material%", "").replace("%prefix_type%", _prefixItemType);
                    names.add(modifiedName.replace("%suffix_tier%", "").replace("%suffix_material%", "").replace("%suffix_type%", ""));
                    names.addAll(ItemGeneratorManager.interpolatePrefixWithAllSuffixes(modifiedName, suffixes));
                }
            }
        }
        if (!name.contains("%prefix_tier%") && name.contains("%prefix_material%") && name.contains("%prefix_type%")) {
            for (String _prefixMaterial : prefixes.get((Object)ResourceManager.ResourceCategory.MATERIAL)) {
                for (String _prefixItemType : prefixes.get((Object)ResourceManager.ResourceCategory.SUBTYPE)) {
                    modifiedName = name.replace("%item_type%", itemGroupName).replace("%prefix_tier%", "").replace("%prefix_material%", _prefixMaterial).replace("%prefix_type%", _prefixItemType);
                    names.add(modifiedName.replace("%suffix_tier%", "").replace("%suffix_material%", "").replace("%suffix_type%", ""));
                    names.addAll(ItemGeneratorManager.interpolatePrefixWithAllSuffixes(modifiedName, suffixes));
                }
            }
        }
        if (name.contains("%prefix_tier%") && name.contains("%prefix_material%") && name.contains("%prefix_type%")) {
            for (String _prefixTier : prefixes.get((Object)ResourceManager.ResourceCategory.TIER)) {
                for (String _prefixMaterial : prefixes.get((Object)ResourceManager.ResourceCategory.MATERIAL)) {
                    for (String _prefixItemType : prefixes.get((Object)ResourceManager.ResourceCategory.SUBTYPE)) {
                        String modifiedName3 = name.replace("%item_type%", itemGroupName).replace("%prefix_tier%", _prefixTier).replace("%prefix_material%", _prefixMaterial).replace("%prefix_type%", _prefixItemType);
                        names.add(modifiedName3.replace("%suffix_tier%", "").replace("%suffix_material%", "").replace("%suffix_type%", ""));
                        names.addAll(ItemGeneratorManager.interpolatePrefixWithAllSuffixes(modifiedName3, suffixes));
                    }
                }
            }
        }
        if (name.contains("%suffix_tier%") && !name.contains("%suffix_material%") && !name.contains("%suffix_type%")) {
            for (String _suffixTier : suffixes.get((Object)ResourceManager.ResourceCategory.TIER)) {
                names.add(name.replace("%item_type%", itemGroupName).replace("%prefix_tier%", "").replace("%prefix_material%", "").replace("%prefix_type%", "").replace("%suffix_tier%", _suffixTier).replace("%suffix_material%", "").replace("%suffix_type%", ""));
            }
        }
        if (!name.contains("%suffix_tier%") && !name.contains("%suffix_material%") && name.contains("%suffix_type%")) {
            for (String _suffixMaterial : suffixes.get((Object)ResourceManager.ResourceCategory.MATERIAL)) {
                names.add(name.replace("%item_type%", itemGroupName).replace("%prefix_tier%", "").replace("%prefix_material%", "").replace("%prefix_type%", "").replace("%suffix_tier%", "").replace("%suffix_material%", _suffixMaterial).replace("%suffix_type%", ""));
            }
        }
        if (!name.contains("%suffix_tier%") && name.contains("%suffix_material%") && !name.contains("%suffix_type%")) {
            for (String _suffixItemType : suffixes.get((Object)ResourceManager.ResourceCategory.SUBTYPE)) {
                names.add(name.replace("%item_type%", itemGroupName).replace("%prefix_tier%", "").replace("%prefix_material%", "").replace("%prefix_type%", "").replace("%suffix_tier%", "").replace("%suffix_material%", "").replace("%suffix_type%", _suffixItemType));
            }
        }
        if (name.contains("%suffix_tier%") && name.contains("%suffix_material%") && !name.contains("%suffix_type%")) {
            for (String _suffixTier : suffixes.get((Object)ResourceManager.ResourceCategory.TIER)) {
                for (String _suffixMaterial : suffixes.get((Object)ResourceManager.ResourceCategory.MATERIAL)) {
                    names.add(name.replace("%item_type%", itemGroupName).replace("%prefix_tier%", "").replace("%prefix_material%", "").replace("%prefix_type%", "").replace("%suffix_tier%", _suffixTier).replace("%suffix_material%", _suffixMaterial).replace("%suffix_type%", ""));
                }
            }
        }
        if (name.contains("%suffix_tier%") && !name.contains("%suffix_material%") && name.contains("%suffix_type%")) {
            for (String _suffixTier : suffixes.get((Object)ResourceManager.ResourceCategory.TIER)) {
                for (String _suffixItemType : suffixes.get((Object)ResourceManager.ResourceCategory.SUBTYPE)) {
                    names.add(name.replace("%item_type%", itemGroupName).replace("%prefix_tier%", "").replace("%prefix_material%", "").replace("%prefix_type%", "").replace("%suffix_tier%", _suffixTier).replace("%suffix_material%", "").replace("%suffix_type%", _suffixItemType));
                }
            }
        }
        if (!name.contains("%suffix_tier%") && name.contains("%suffix_material%") && name.contains("%suffix_type%")) {
            for (String _suffixMaterial : suffixes.get((Object)ResourceManager.ResourceCategory.MATERIAL)) {
                for (String _suffixItemType : suffixes.get((Object)ResourceManager.ResourceCategory.SUBTYPE)) {
                    names.add(name.replace("%item_type%", itemGroupName).replace("%prefix_tier%", "").replace("%prefix_material%", "").replace("%prefix_type%", "").replace("%suffix_tier%", "").replace("%suffix_material%", _suffixMaterial).replace("%suffix_type%", _suffixItemType));
                }
            }
        }
        if (name.contains("%suffix_tier%") && name.contains("%suffix_material%") && name.contains("%suffix_type%")) {
            for (String _suffixTier : suffixes.get((Object)ResourceManager.ResourceCategory.MATERIAL)) {
                for (String _suffixMaterial : suffixes.get((Object)ResourceManager.ResourceCategory.MATERIAL)) {
                    for (String _suffixItemType : suffixes.get((Object)ResourceManager.ResourceCategory.SUBTYPE)) {
                        names.add(name.replace("%item_type%", itemGroupName).replace("%prefix_tier%", "").replace("%prefix_material%", "").replace("%prefix_type%", "").replace("%suffix_tier%", _suffixTier).replace("%suffix_material%", _suffixMaterial).replace("%suffix_type%", _suffixItemType));
                    }
                }
            }
        }
        return names;
    }

    private static List<String> interpolatePrefixWithAllSuffixes(String modifiedName, Map<ResourceManager.ResourceCategory, List<String>> suffixes) {
        ArrayList<String> names = new ArrayList<String>();
        if (modifiedName.contains("%suffix_tier%") && !modifiedName.contains("%suffix_material%") && !modifiedName.contains("%suffix_type%")) {
            for (String _suffixTier : suffixes.get((Object)ResourceManager.ResourceCategory.TIER)) {
                names.add(modifiedName.replace("%suffix_tier%", _suffixTier).replace("%suffix_material%", "").replace("%suffix_type%", ""));
            }
        }
        if (!modifiedName.contains("%suffix_tier%") && !modifiedName.contains("%suffix_material%") && modifiedName.contains("%suffix_type%")) {
            for (String _suffixMaterial : suffixes.get((Object)ResourceManager.ResourceCategory.MATERIAL)) {
                names.add(modifiedName.replace("%suffix_tier%", "").replace("%suffix_material%", _suffixMaterial).replace("%suffix_type%", ""));
            }
        }
        if (!modifiedName.contains("%suffix_tier%") && modifiedName.contains("%suffix_material%") && !modifiedName.contains("%suffix_type%")) {
            for (String _suffixItemType : suffixes.get((Object)ResourceManager.ResourceCategory.SUBTYPE)) {
                names.add(modifiedName.replace("%suffix_tier%", "").replace("%suffix_material%", "").replace("%suffix_type%", _suffixItemType));
            }
        }
        if (modifiedName.contains("%suffix_tier%") && modifiedName.contains("%suffix_material%") && !modifiedName.contains("%suffix_type%")) {
            for (String _suffixTier : suffixes.get((Object)ResourceManager.ResourceCategory.TIER)) {
                for (String _suffixMaterial : suffixes.get((Object)ResourceManager.ResourceCategory.MATERIAL)) {
                    names.add(modifiedName.replace("%suffix_tier%", _suffixTier).replace("%suffix_material%", _suffixMaterial).replace("%suffix_type%", ""));
                }
            }
        }
        if (modifiedName.contains("%suffix_tier%") && !modifiedName.contains("%suffix_material%") && modifiedName.contains("%suffix_type%")) {
            for (String _suffixTier : suffixes.get((Object)ResourceManager.ResourceCategory.TIER)) {
                for (String _suffixItemType : suffixes.get((Object)ResourceManager.ResourceCategory.SUBTYPE)) {
                    names.add(modifiedName.replace("%suffix_tier%", _suffixTier).replace("%suffix_material%", "").replace("%suffix_type%", _suffixItemType));
                }
            }
        }
        if (!modifiedName.contains("%suffix_tier%") && modifiedName.contains("%suffix_material%") && modifiedName.contains("%suffix_type%")) {
            for (String _suffixMaterial : suffixes.get((Object)ResourceManager.ResourceCategory.MATERIAL)) {
                for (String _suffixItemType : suffixes.get((Object)ResourceManager.ResourceCategory.SUBTYPE)) {
                    names.add(modifiedName.replace("%suffix_tier%", "").replace("%suffix_material%", _suffixMaterial).replace("%suffix_type%", _suffixItemType));
                }
            }
        }
        for (String _suffixTier : suffixes.get((Object)ResourceManager.ResourceCategory.MATERIAL)) {
            for (String _suffixMaterial : suffixes.get((Object)ResourceManager.ResourceCategory.MATERIAL)) {
                for (String _suffixItemType : suffixes.get((Object)ResourceManager.ResourceCategory.SUBTYPE)) {
                    names.add(modifiedName.replace("%suffix_tier%", _suffixTier).replace("%suffix_material%", _suffixMaterial).replace("%suffix_type%", _suffixItemType));
                }
            }
        }
        return names;
    }

    public static void updateGeneratorItemLore(ItemStack item) {
        if (item.getItemMeta() == null) {
            return;
        }
        String itemId = Divinity.getInstance().getModuleCache().getTierManager().getItemId(item);
        if (itemId == null) {
            return;
        }
        GeneratorItem reference = (GeneratorItem)Divinity.getInstance().getModuleCache().getTierManager().getItemById(itemId);
        if (reference == null) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        if (lore == null) {
            return;
        }
        for (Enchantment enchantment : Enchantment.values()) {
            String value = EngineCfg.LORE_STYLE_ENCHANTMENTS_FORMAT_MAIN.replace("%name%", Divinity.getInstance().lang().getEnchantment(enchantment)).replace("%value%", "");
            lore.removeIf(line -> {
                if (!lore.contains("%ENCHANTS%") && line.contains(value)) {
                    if (lore.contains(line)) {
                        lore.set(lore.indexOf(line), "%ENCHANTS%");
                    }
                    return false;
                }
                return line.contains(value);
            });
        }
        if (!lore.contains("%ENCHANTS%") && !reference.getFlags().contains(ItemFlag.HIDE_ENCHANTS) && reference.getLore().contains("%ENCHANTS%")) {
            lore.add("%ENCHANTS%");
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        LoreUT.replaceEnchants(item);
    }

    @Generated
    public static ResourceManager getResourceManager() {
        return resourceManager;
    }

    public class GeneratorItem
    extends LimitedItem {
        private double prefixChance;
        private double suffixChance;
        private boolean materialsWhitelist;
        private Set<ItemType> materialsList;
        private List<Integer> modelDataList;
        private Map<String, List<Integer>> modelDataSpecial;
        private Map<String, BonusMap> materialModifiers;
        private Map<String, Map<ItemLoreStat<?>, String>> materialBonuses;
        private Map<String, Map<ItemLoreStat<?>, String>> classBonuses;
        private Map<String, Map<ItemLoreStat<?>, String>> rarityBonuses;
        private TreeMap<Integer, String[]> reqUserLvl;
        private TreeMap<Integer, String[]> reqUserClass;
        private TreeMap<Integer, String[]> reqBannedUserClass;
        private int enchantsMinAmount;
        private int enchantsMaxAmount;
        private boolean enchantsSafeOnly;
        private boolean enchantsSafeLevels;
        private Map<Enchantment, String[]> enchantsList;
        private final TreeMap<Double, String> armorTrims;
        private boolean randomShieldPatterns;
        private List<String> shieldBaseColors;
        private List<String> shieldPatternColors;
        private List<String> shieldPatterns;
        private Set<IAttributeGenerator> attributeGenerators;
        private AbilityGenerator abilityGenerator;

        public GeneratorItem(@NotNull Divinity plugin, JYML cfg) {
            String reqRaw;
            double val;
            String sVal;
            ItemLoreStat mainStat;
            String[] split;
            String sVal2;
            Object dt;
            HashMap<ItemLoreStat, CallSite> statMap;
            String path2;
            super(plugin, cfg, ItemGeneratorManager.this);
            this.armorTrims = new TreeMap();
            this.randomShieldPatterns = true;
            this.shieldBaseColors = new ArrayList<String>();
            this.shieldPatternColors = new ArrayList<String>();
            this.shieldPatterns = new ArrayList<String>();
            String path = "generator.";
            this.prefixChance = cfg.getDouble(path + "prefix-chance");
            this.suffixChance = cfg.getDouble(path + "suffix-chance");
            this.materialsWhitelist = cfg.getBoolean(path + "materials.reverse");
            if (this.materialsWhitelist) {
                this.materialsList = new HashSet<ItemType>();
                HashSet<String> startWildcards = new HashSet<String>();
                HashSet<String> endWildcards = new HashSet<String>();
                for (String mat : cfg.getStringList(path + "materials.black-list")) {
                    String[] split2 = mat.split("\\*", 2);
                    if (split2.length == 2) {
                        if (split2[0].isEmpty()) {
                            startWildcards.add(split2[1].toUpperCase());
                            continue;
                        }
                        if (!split2[1].isEmpty()) continue;
                        endWildcards.add(split2[0].toUpperCase());
                        continue;
                    }
                    try {
                        ItemType itemType = CodexEngine.get().getItemManager().getItemType(mat);
                        if (itemType.getNamespace().equals("DIVINITY")) continue;
                        this.materialsList.add(itemType);
                    }
                    catch (MissingItemException | MissingProviderException itemType) {}
                }
                for (ItemType itemType : Config.getAllRegisteredMaterials()) {
                    Iterator name = itemType.getNamespacedID().toUpperCase();
                    if (!startWildcards.stream().anyMatch(((String)((Object)name))::endsWith)) {
                        if (!endWildcards.stream().anyMatch(((String)((Object)name))::startsWith)) continue;
                    }
                    this.materialsList.add(itemType);
                }
            } else {
                this.materialsList = new HashSet<ItemType>(Config.getAllRegisteredMaterials());
                HashSet materials = new HashSet(cfg.getStringList(path + "materials.black-list"));
                this.materialsList.removeIf(matAll -> {
                    String namespacedID = matAll.getNamespacedID();
                    String upperCaseNamespacedID = namespacedID.toUpperCase();
                    for (String mat : materials) {
                        String[] split = mat.split("\\*", 2);
                        if (split.length == 2) {
                            if (split[0].isEmpty() && upperCaseNamespacedID.endsWith(split[1])) {
                                return true;
                            }
                            if (split[1].isEmpty() && upperCaseNamespacedID.startsWith(split[0])) {
                                return true;
                            }
                        }
                        if (!namespacedID.equals(mat)) continue;
                        return true;
                    }
                    return false;
                });
            }
            path = "generator.materials.model-data.";
            this.modelDataList = cfg.getIntegerList(path + "default");
            this.modelDataSpecial = new HashMap<String, List<Integer>>();
            for (String specGroup : cfg.getSection(path + "special")) {
                List specList = cfg.getIntegerList(path + "special." + specGroup);
                this.modelDataSpecial.put(specGroup.toLowerCase(), specList);
            }
            if (cfg.isConfigurationSection("generator.materials.stat-modifiers")) {
                ConfigurationSection section = cfg.getConfigurationSection("generator.materials.stat-modifiers");
                cfg.remove("generator.materials.stat-modifiers");
                cfg.set("generator.bonuses.material", (Object)section);
                cfg.save();
            }
            path = "generator.bonuses.material-modifiers.";
            this.materialModifiers = new HashMap<String, BonusMap>();
            for (String group : cfg.getSection("generator.bonuses.material-modifiers")) {
                if (!ItemUtils.parseItemGroup(group)) {
                    ItemGeneratorManager.this.error("Invalid item group provided: '" + group + "' in '" + path + "'. File: " + cfg.getFile().getName());
                    continue;
                }
                BonusMap bMap = new BonusMap();
                path2 = path + group + ".";
                bMap.loadDamages(cfg, path2 + "damage-types");
                bMap.loadDefenses(cfg, path2 + "defense-types");
                bMap.loadStats(cfg, path2 + "item-stats");
                bMap.loadFabledAttributes(cfg, path2 + "fabled-attributes");
                bMap.loadAmmo(cfg, path2 + "ammo");
                bMap.loadHands(cfg, path2 + "hands");
                this.materialModifiers.put(group.toLowerCase(), bMap);
            }
            path = "generator.bonuses.material.";
            this.materialBonuses = new HashMap();
            for (String group : cfg.getSection("generator.bonuses.material")) {
                double val2;
                boolean perc;
                statMap = new HashMap<ItemLoreStat, CallSite>();
                path2 = path + group + ".damage-types";
                for (String id : cfg.getSection(path2)) {
                    dt = ItemStats.getDamageById(id);
                    if (dt == null || (sVal2 = cfg.getString(path2 + "." + id)) == null) continue;
                    split = sVal2.split("%", 2);
                    perc = split.length == 2 && split[1].isEmpty();
                    val2 = StringUT.getDouble((String)split[0], (double)0.0, (boolean)true);
                    statMap.put((ItemLoreStat)dt, (CallSite)((Object)(val2 + (perc ? "%" : ""))));
                }
                path2 = path + group + ".defense-types";
                for (String id : cfg.getSection(path2)) {
                    dt = ItemStats.getDefenseById(id);
                    if (dt == null || (sVal2 = cfg.getString(path2 + "." + id)) == null) continue;
                    split = sVal2.split("%", 2);
                    perc = split.length == 2 && split[1].isEmpty();
                    val2 = StringUT.getDouble((String)split[0], (double)0.0, (boolean)true);
                    statMap.put((ItemLoreStat)dt, (CallSite)((Object)(val2 + (perc ? "%" : ""))));
                }
                path2 = path + group + ".item-stats";
                for (String id : cfg.getSection(path2)) {
                    dt = TypedStat.Type.getByName(id);
                    if (dt == null) continue;
                    mainStat = (ItemLoreStat)((Object)ItemStats.getStat((TypedStat.Type)((Object)dt)));
                    sVal = cfg.getString(path2 + "." + id);
                    if (sVal == null) continue;
                    String[] split3 = sVal.split("%", 2);
                    boolean perc2 = split3.length == 2 && split3[1].isEmpty();
                    val = StringUT.getDouble((String)split3[0], (double)0.0, (boolean)true);
                    statMap.put(mainStat, (CallSite)((Object)(val + (perc2 ? "%" : ""))));
                }
                this.materialBonuses.put(group, statMap);
            }
            path = "generator.bonuses.class.";
            this.classBonuses = new HashMap();
            for (String group : cfg.getSection("generator.bonuses.class")) {
                statMap = new HashMap();
                path2 = path + group + ".damage-types";
                for (String id : cfg.getSection(path2)) {
                    dt = ItemStats.getDamageById(id);
                    if (dt == null || (sVal2 = cfg.getString(path2 + "." + id)) == null) continue;
                    split = sVal2.split("%", 2);
                    boolean perc = split.length == 2 && split[1].isEmpty();
                    double val3 = StringUT.getDouble((String)split[0], (double)0.0, (boolean)true);
                    statMap.put((ItemLoreStat)dt, (CallSite)((Object)(val3 + (perc ? "%" : ""))));
                }
                path2 = path + group + ".defense-types";
                for (String id : cfg.getSection(path2)) {
                    dt = ItemStats.getDefenseById(id);
                    if (dt == null || (sVal2 = cfg.getString(path2 + "." + id)) == null) continue;
                    split = sVal2.split("%", 2);
                    boolean perc = split.length == 2 && split[1].isEmpty();
                    double val4 = StringUT.getDouble((String)split[0], (double)0.0, (boolean)true);
                    statMap.put((ItemLoreStat)dt, (CallSite)((Object)(val4 + (perc ? "%" : ""))));
                }
                path2 = path + group + ".item-stats";
                for (String id : cfg.getSection(path2)) {
                    dt = TypedStat.Type.getByName(id);
                    if (dt == null) continue;
                    mainStat = (ItemLoreStat)((Object)ItemStats.getStat((TypedStat.Type)((Object)dt)));
                    sVal = cfg.getString(path2 + "." + id);
                    if (sVal == null) continue;
                    String[] split4 = sVal.split("%", 2);
                    boolean perc = split4.length == 2 && split4[1].isEmpty();
                    val = StringUT.getDouble((String)split4[0], (double)0.0, (boolean)true);
                    statMap.put(mainStat, (CallSite)((Object)(val + (perc ? "%" : ""))));
                }
                this.classBonuses.put(group, statMap);
            }
            path = "generator.bonuses.rarity.";
            this.rarityBonuses = new HashMap();
            for (String group : cfg.getSection("generator.bonuses.rarity")) {
                statMap = new HashMap();
                path2 = path + group + ".damage-types";
                for (String id : cfg.getSection(path2)) {
                    dt = ItemStats.getDamageById(id);
                    if (dt == null || (sVal2 = cfg.getString(path2 + "." + id)) == null) continue;
                    split = sVal2.split("%", 2);
                    boolean perc = split.length == 2 && split[1].isEmpty();
                    double val5 = StringUT.getDouble((String)split[0], (double)0.0, (boolean)true);
                    statMap.put((ItemLoreStat)dt, (CallSite)((Object)(val5 + (perc ? "%" : ""))));
                }
                path2 = path + group + ".defense-types";
                for (String id : cfg.getSection(path2)) {
                    dt = ItemStats.getDefenseById(id);
                    if (dt == null || (sVal2 = cfg.getString(path2 + "." + id)) == null) continue;
                    split = sVal2.split("%", 2);
                    boolean perc = split.length == 2 && split[1].isEmpty();
                    double val6 = StringUT.getDouble((String)split[0], (double)0.0, (boolean)true);
                    statMap.put((ItemLoreStat)dt, (CallSite)((Object)(val6 + (perc ? "%" : ""))));
                }
                path2 = path + group + ".item-stats";
                for (String id : cfg.getSection(path2)) {
                    dt = TypedStat.Type.getByName(id);
                    if (dt == null) continue;
                    mainStat = (ItemLoreStat)((Object)ItemStats.getStat((TypedStat.Type)((Object)dt)));
                    sVal = cfg.getString(path2 + "." + id);
                    if (sVal == null) continue;
                    String[] split5 = sVal.split("%", 2);
                    boolean perc = split5.length == 2 && split5[1].isEmpty();
                    val = StringUT.getDouble((String)split5[0], (double)0.0, (boolean)true);
                    statMap.put(mainStat, (CallSite)((Object)(val + (perc ? "%" : ""))));
                }
                this.rarityBonuses.put(group, statMap);
            }
            path = "generator.user-requirements-by-level.";
            if (ItemRequirements.isRegisteredUser(LevelRequirement.class)) {
                this.reqUserLvl = new TreeMap();
                for (String sLvl : cfg.getSection(path + "level")) {
                    int itemLvl = StringUT.getInteger((String)sLvl, (int)-1);
                    if (itemLvl <= 0 || (reqRaw = cfg.getString(path + "level." + sLvl)) == null || reqRaw.isEmpty()) continue;
                    this.reqUserLvl.put(itemLvl, Arrays.stream(reqRaw.split(":")).filter(s -> !s.isBlank()).collect(Collectors.toList()).toArray(new String[0]));
                }
            }
            if (ItemRequirements.isRegisteredUser(ClassRequirement.class)) {
                this.reqUserClass = new TreeMap();
                for (String sLvl : cfg.getSection(path + "class")) {
                    int itemLvl = StringUT.getInteger((String)sLvl, (int)-1);
                    if (itemLvl <= 0) continue;
                    reqRaw = cfg.getString(path + "class." + sLvl, "");
                    this.reqUserClass.put(itemLvl, Arrays.stream(reqRaw.split(",")).filter(s -> !s.isBlank()).collect(Collectors.toList()).toArray(new String[0]));
                }
            }
            if (ItemRequirements.isRegisteredUser(BannedClassRequirement.class)) {
                this.reqBannedUserClass = new TreeMap();
                for (String sLvl : cfg.getSection(path + "banned-class")) {
                    int itemLvl = StringUT.getInteger((String)sLvl, (int)-1);
                    if (itemLvl <= 0) continue;
                    reqRaw = cfg.getString(path + "banned-class." + sLvl, "");
                    this.reqBannedUserClass.put(itemLvl, reqRaw.split(","));
                }
            }
            path = "generator.enchantments.";
            cfg.addMissing(path + "safe-levels", (Object)true);
            this.enchantsMinAmount = Math.max(0, cfg.getInt(path + "minimum"));
            this.enchantsMaxAmount = Math.max(0, cfg.getInt(path + "maximum"));
            this.enchantsSafeOnly = cfg.getBoolean(path + "safe-only");
            this.enchantsSafeLevels = cfg.getBoolean(path + "safe-levels");
            this.enchantsList = new HashMap<Enchantment, String[]>();
            for (String sId : cfg.getSection(path + "list")) {
                Enchantment en = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)sId.toLowerCase()));
                if (en == null) {
                    ItemGeneratorManager.this.error("Invalid enchantment provided: " + sId + " (" + cfg.getFile().getName() + ")");
                    continue;
                }
                reqRaw = cfg.getString(path + "list." + sId);
                if (reqRaw == null || reqRaw.isEmpty()) continue;
                this.enchantsList.put(en, reqRaw.split(":"));
            }
            path = "generator.shield-patterns.";
            cfg.addMissing(path + "random", (Object)true);
            cfg.addMissing(path + "base-colors", List.of("LIGHT_GRAY", "GRAY"));
            cfg.addMissing(path + "pattern-colors", List.of("LIGHT_GRAY", "GRAY"));
            cfg.addMissing(path + "patterns", List.of("BASE", "BORDER"));
            this.randomShieldPatterns = cfg.getBoolean(path + "random");
            this.shieldBaseColors = cfg.getStringList(path + "base-colors");
            this.shieldPatternColors = cfg.getStringList(path + "pattern-colors");
            this.shieldPatterns = cfg.getStringList(path + "patterns");
            if (Version.CURRENT.isHigher(Version.V1_19_R3)) {
                path = "generator.armor-trimmings";
                double totalWeight = 0.0;
                for (String key : cfg.getSection(path)) {
                    double weight = cfg.getDouble(path + "." + key);
                    if (weight == 0.0) continue;
                    if (key.equals("none")) {
                        this.armorTrims.put(totalWeight += weight, null);
                        continue;
                    }
                    String[] split6 = key.toLowerCase().split(":");
                    if (split6.length != 2 || !split6[0].equals("*") && VersionManager.getArmorUtil().getTrimMaterial(NamespacedKey.minecraft((String)split6[0])) == null || !split6[1].equals("*") && VersionManager.getArmorUtil().getTrimPattern(NamespacedKey.minecraft((String)split6[1])) == null) continue;
                    this.armorTrims.put(totalWeight += weight, key);
                }
            }
            this.attributeGenerators = new HashSet<IAttributeGenerator>();
            this.addAttributeGenerator(new SingleAttributeGenerator<AmmoAttribute>(this.plugin, this, "generator.ammo-types.", ItemStats.getAmmos(), "%ITEM_AMMO%"));
            this.addAttributeGenerator(new SingleAttributeGenerator<HandAttribute>(this.plugin, this, "generator.hand-types.", ItemStats.getHands(), "%ITEM_HAND%"));
            this.addAttributeGenerator(new AttributeGenerator<DamageAttribute>(this.plugin, this, "generator.damage-types.", ItemStats.getDamages(), ItemGeneratorManager.PLACE_GEN_DAMAGE));
            this.addAttributeGenerator(new AttributeGenerator<DefenseAttribute>(this.plugin, this, "generator.defense-types.", ItemStats.getDefenses(), ItemGeneratorManager.PLACE_GEN_DEFENSE));
            this.addAttributeGenerator(new TypedStatGenerator(this.plugin, this, "generator.item-stats.", ItemStats.getStats(), ItemGeneratorManager.PLACE_GEN_STATS));
            this.abilityGenerator = new AbilityGenerator(this.plugin, this, ItemGeneratorManager.PLACE_GEN_ABILITY);
            this.addAttributeGenerator(this.abilityGenerator);
            FabledHook fabledHook = (FabledHook)Divinity.getInstance().getHook("Fabled");
            this.addAttributeGenerator(new AttributeGenerator(this.plugin, this, "generator.fabled-attributes.", fabledHook != null && fabledHook.isFabledLoaded() ? fabledHook.getAttributes() : List.of(), ItemGeneratorManager.PLACE_GEN_FABLED_ATTR));
            if (fabledHook != null) {
                cfg.addMissing("generator.fabled-attributes", commonItemGenerator.get("generator.fabled-attributes"));
                cfg.addMissing("generator.skills", commonItemGenerator.get("generator.skills"));
            }
            for (SocketAttribute.Type socketType : SocketAttribute.Type.values()) {
                this.addAttributeGenerator(new AttributeGenerator<SocketAttribute>(this.plugin, this, "generator.sockets." + socketType.name() + ".", ItemStats.getSockets(socketType), ItemGeneratorManager.PLACE_GEN_SOCKETS.replace("%TYPE%", socketType.name())));
            }
            cfg.saveChanges();
        }

        protected final int[] getUserLevelRequirement(int itemLvl) {
            if (this.reqUserLvl == null) {
                return new int[]{0};
            }
            Map.Entry<Integer, String[]> e = this.reqUserLvl.floorEntry(itemLvl);
            if (e == null) {
                return new int[]{0};
            }
            return this.doMathExpression(itemLvl, e.getValue());
        }

        @Nullable
        protected final String[] getUserClassRequirement(int itemLvl) {
            if (this.reqUserClass == null) {
                return null;
            }
            Map.Entry<Integer, String[]> e = this.reqUserClass.floorEntry(itemLvl);
            if (e == null) {
                return null;
            }
            return e.getValue();
        }

        @Nullable
        protected final String[] getUserBannedClassRequirement(int itemLvl) {
            if (this.reqBannedUserClass == null) {
                return null;
            }
            Map.Entry<Integer, String[]> e = this.reqBannedUserClass.floorEntry(itemLvl);
            if (e == null) {
                return null;
            }
            return e.getValue();
        }

        public boolean isMaterialReversed() {
            return this.materialsWhitelist;
        }

        @NotNull
        public Set<ItemType> getMaterialsList() {
            return this.materialsList;
        }

        public int getMinEnchantments() {
            return this.enchantsMinAmount;
        }

        public int getMaxEnchantments() {
            return this.enchantsMaxAmount;
        }

        public boolean isSafeEnchant() {
            return this.enchantsSafeOnly;
        }

        @NotNull
        public BiFunction<Boolean, Double, Double> getMaterialModifiers(@NotNull ItemStack item, @NotNull ItemLoreStat<?> stat) {
            for (Map.Entry<String, BonusMap> e : this.materialModifiers.entrySet()) {
                BonusMap bMap;
                BiFunction<Boolean, Double, Double> bif;
                if (!ItemUtils.compareItemGroup(item, e.getKey()) || (bif = (bMap = e.getValue()).getBonus(stat)) == null) continue;
                return bif;
            }
            return (isBonus, result) -> result;
        }

        public Collection<StatBonus> getMaterialBonuses(ItemStack item, ItemLoreStat<?> stat) {
            ArrayList<StatBonus> list = new ArrayList<StatBonus>();
            for (Map.Entry<String, Map<ItemLoreStat<?>, String>> entry : this.materialBonuses.entrySet()) {
                if (!ItemUtils.compareItemGroup(item, entry.getKey())) continue;
                for (Map.Entry<ItemLoreStat<?>, String> entry1 : entry.getValue().entrySet()) {
                    if (!entry1.getKey().equals(stat)) continue;
                    String sVal = entry1.getValue();
                    String[] split = sVal.split("%", 2);
                    list.add(new StatBonus(new double[]{Double.parseDouble(split[0])}, split.length == 2 && split[1].isEmpty(), new StatBonus.Condition()));
                }
            }
            return list;
        }

        public Collection<StatBonus> getClassBonuses(ItemLoreStat<?> stat) {
            ArrayList<StatBonus> list = new ArrayList<StatBonus>();
            for (Map.Entry<String, Map<ItemLoreStat<?>, String>> entry : this.classBonuses.entrySet()) {
                for (Map.Entry<ItemLoreStat<?>, String> entry1 : entry.getValue().entrySet()) {
                    if (!entry1.getKey().equals(stat)) continue;
                    String sVal = entry1.getValue();
                    String[] split = sVal.split("%", 2);
                    list.add(new StatBonus(new double[]{Double.parseDouble(split[0])}, split.length == 2 && split[1].isEmpty(), new StatBonus.Condition<String[]>(ItemRequirements.getUserRequirement(ClassRequirement.class), new String[]{entry.getKey()})));
                }
            }
            return list;
        }

        public Collection<StatBonus> getRarityBonuses(ItemLoreStat<?> stat) {
            ArrayList<StatBonus> list = new ArrayList<StatBonus>();
            for (Map.Entry<String, Map<ItemLoreStat<?>, String>> entry : this.rarityBonuses.entrySet()) {
                for (Map.Entry<ItemLoreStat<?>, String> entry1 : entry.getValue().entrySet()) {
                    if (!entry1.getKey().equals(stat)) continue;
                    String sVal = entry1.getValue();
                    String[] split = sVal.split("%", 2);
                    list.add(new StatBonus(new double[]{Double.parseDouble(split[0])}, split.length == 2 && split[1].isEmpty(), new StatBonus.Condition()));
                }
            }
            return list;
        }

        @NotNull
        public Set<IAttributeGenerator> getAttributeGenerators() {
            return this.attributeGenerators;
        }

        public boolean addAttributeGenerator(@NotNull IAttributeGenerator generator) {
            return this.attributeGenerators.add(generator);
        }

        @NotNull
        public AbilityGenerator getAbilityGenerator() {
            return this.abilityGenerator;
        }

        public double getScaleOfLevel(double scale, int itemLevel) {
            return scale == 1.0 ? scale : (scale * 100.0 - 100.0) * (double)(itemLevel - 1) / 100.0 + 1.0;
        }

        @Override
        @NotNull
        public ItemStack create(int lvl, int uses) {
            return this.create(lvl, uses, null);
        }

        @NotNull
        public ItemStack create(int lvl, int uses, @Nullable ItemType mat) {
            lvl = this.validateLevel(lvl);
            if (uses < 1) {
                uses = this.getCharges(lvl);
            }
            return this.build(lvl, uses, mat);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        protected ItemStack build(int itemLvl, int uses, @Nullable ItemType mat) {
            SetManager setManager;
            String trimString;
            List lore;
            Integer mInt;
            ItemType itemType2;
            ItemStack item = mat != null && this.materialsList.contains(mat) ? super.build(mat.create(), itemLvl, uses) : super.build((itemType2 = (ItemType)Rnd.get(new ArrayList<ItemType>(this.materialsList))) == null ? null : itemType2.create(), itemLvl, uses);
            ItemMeta meta = item.getItemMeta();
            if (meta == null) {
                return item;
            }
            ArrayList<Integer> dataValues = new ArrayList<Integer>();
            for (Map.Entry<String, List<Integer>> e : this.modelDataSpecial.entrySet()) {
                if (!ItemUtils.compareItemGroup(item, e.getKey())) continue;
                dataValues.addAll((Collection)e.getValue());
            }
            if (dataValues.isEmpty()) {
                dataValues.addAll(this.modelDataList);
            }
            if (!dataValues.isEmpty() && (mInt = (Integer)Rnd.get(dataValues)) != null) {
                meta.setCustomModelData(Integer.valueOf(mInt));
            }
            String prefixTier = "";
            String suffixTier = "";
            String prefixMaterial = "";
            String suffixMaterial = "";
            String prefixItemType = "";
            String suffixItemType = "";
            String itemGroupId = ItemUtils.getItemGroupIdFor(item);
            String itemGroupName = ItemUtils.getItemGroupNameFor(item);
            String itemMaterial = CodexEngine.get().getItemManager().getItemTypes(item).stream().filter(itemType -> itemType.getCategory() != ICodexItemProvider.Category.PRO).max(Comparator.comparing(ItemType::getCategory)).orElseGet(() -> new VanillaProvider.VanillaItemType(item.getType())).getNamespacedID();
            if ((double)Rnd.get((boolean)true) <= this.prefixChance) {
                prefixTier = (String)Rnd.get(resourceManager.getPrefix(ResourceManager.ResourceCategory.TIER, this.getTier().getId()));
                prefixMaterial = (String)Rnd.get(resourceManager.getPrefix(ResourceManager.ResourceCategory.MATERIAL, itemMaterial));
                prefixItemType = (String)Rnd.get(resourceManager.getPrefix(ResourceManager.ResourceCategory.SUBTYPE, itemGroupId));
            }
            if ((double)Rnd.get((boolean)true) <= this.suffixChance) {
                suffixTier = (String)Rnd.get(resourceManager.getSuffix(ResourceManager.ResourceCategory.TIER, this.getTier().getId()));
                suffixMaterial = (String)Rnd.get(resourceManager.getSuffix(ResourceManager.ResourceCategory.MATERIAL, itemMaterial));
                suffixItemType = (String)Rnd.get(resourceManager.getSuffix(ResourceManager.ResourceCategory.SUBTYPE, itemGroupId));
            }
            if (meta.hasDisplayName()) {
                String metaName = meta.getDisplayName().replace("%item_type%", itemGroupName).replace("%suffix_tier%", suffixTier != null ? suffixTier : "").replace("%prefix_tier%", prefixTier != null ? prefixTier : "").replace("%prefix_type%", prefixItemType != null ? prefixItemType : "").replace("%suffix_type%", suffixItemType != null ? suffixItemType : "").replace("%prefix_material%", prefixMaterial != null ? prefixMaterial : "").replace("%suffix_material%", suffixMaterial != null ? suffixMaterial : "");
                metaName = StringUT.oneSpace((String)metaName);
                meta.setDisplayName(metaName);
            }
            if ((lore = meta.getLore()) != null) {
                lore.replaceAll(line -> line.replace("%item_type%", itemGroupName));
                meta.setLore(lore);
            }
            if (this.randomShieldPatterns && meta instanceof BlockStateMeta) {
                BlockStateMeta bmeta = (BlockStateMeta)meta;
                Banner banner = (Banner)bmeta.getBlockState();
                DyeColor bBaseColor = DyeColor.valueOf((String)((String)Rnd.get(this.shieldBaseColors)));
                DyeColor bPatternColor = DyeColor.valueOf((String)((String)Rnd.get(this.shieldPatternColors)));
                banner.setBaseColor(bBaseColor);
                try {
                    PatternType patternType = PatternType.valueOf((String)((String)Rnd.get(this.shieldPatterns)));
                    banner.addPattern(new Pattern(bPatternColor, patternType));
                }
                catch (IncompatibleClassChangeError incompatibleClassChangeError) {
                    try {
                        Class pattern = Reflex.getClass((String)"org.bukkit.block.banner.PatternType");
                        Object[] patterns = (Object[])pattern.getMethod("values", new Class[0]).invoke(null, new Object[0]);
                        Object bPattern = Rnd.get((Object[])patterns);
                        banner.addPattern((Pattern)Pattern.class.getConstructor(DyeColor.class, pattern).newInstance(bPatternColor, bPattern));
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        this.plugin.getLogger().warning("Failed to create banner pattern: " + e.getMessage());
                        e.printStackTrace();
                    }
                }
                banner.update();
                bmeta.setBlockState((BlockState)banner);
            }
            if (!this.armorTrims.isEmpty() && (trimString = this.armorTrims.ceilingEntry(Rnd.nextDouble() * this.armorTrims.lastKey()).getValue()) != null) {
                VersionManager.getArmorUtil().addTrim(meta, trimString.split(":")[0], trimString.split(":")[1]);
            }
            item.setItemMeta(meta);
            int enchRoll = Rnd.get((int)this.getMinEnchantments(), (int)this.getMaxEnchantments());
            int enchCount = 0;
            ArrayList<Map.Entry<Enchantment, String[]>> enchants = new ArrayList<Map.Entry<Enchantment, String[]>>(this.enchantsList.entrySet());
            Collections.shuffle(enchants);
            for (Map.Entry entry : enchants) {
                if (enchCount >= enchRoll) break;
                Enchantment enchant = (Enchantment)entry.getKey();
                int[] enchLevels = this.doMathExpression(itemLvl, (String[])entry.getValue());
                int enchLevel = Rnd.get((int)enchLevels[0], (int)enchLevels[1]);
                if (enchLevel < 1 || this.isSafeEnchant() && (!enchant.canEnchantItem(item) || !ItemUtils.checkEnchantConflict(item, enchant))) continue;
                if (this.isEnchantsSafeLevels()) {
                    enchLevel = Math.min(enchant.getMaxLevel(), enchLevel);
                }
                item.addUnsafeEnchantment(enchant, enchLevel);
                ++enchCount;
            }
            ItemUT.addSkullTexture((ItemStack)item, (String)this.hash, (String)this.getId());
            this.getAttributeGenerators().forEach(generator -> generator.generate(item, itemLvl));
            LoreUT.replacePlaceholder(item, ItemGeneratorManager.PLACE_GEN_DAMAGE, null);
            LoreUT.replacePlaceholder(item, ItemGeneratorManager.PLACE_GEN_DEFENSE, null);
            LevelRequirement reqLevel = ItemRequirements.getUserRequirement(LevelRequirement.class);
            if (reqLevel != null) {
                reqLevel.add(item, this.getUserLevelRequirement(itemLvl), -1);
            }
            String[] stringArray = this.getUserClassRequirement(itemLvl);
            DynamicUserRequirement reqClass = null;
            if (stringArray == null || stringArray.length == 0) {
                String[] stringArray2 = this.getUserBannedClassRequirement(itemLvl);
                if (stringArray2 != null && stringArray2.length > 0) {
                    reqClass = ItemRequirements.getUserRequirement(BannedClassRequirement.class);
                }
            } else {
                reqClass = ItemRequirements.getUserRequirement(ClassRequirement.class);
            }
            if (reqClass != null) {
                void var21_30;
                reqClass.add(item, var21_30, -1);
            }
            LoreUT.replacePlaceholder(item, "%USER_LEVEL%", null);
            LoreUT.replacePlaceholder(item, "%USER_CLASS%", null);
            LoreUT.replacePlaceholder(item, "%USER_BANNED_CLASS%", null);
            SoulboundRequirement reqSoul = ItemRequirements.getUserRequirement(SoulboundRequirement.class);
            if (reqSoul != null && reqSoul.hasPlaceholder(item)) {
                reqSoul.add(item, -1);
            }
            if ((setManager = this.plugin.getModuleCache().getSetManager()) != null) {
                setManager.updateItemSet(item, null);
            }
            LoreUT.replacePlaceholder(item, "%ITEM_SET%", null);
            LoreUT.replaceEnchants(item);
            LoreUT.replacePlaceholder(item, "%TYPE%", itemGroupName);
            LoreUT.replacePlaceholder(item, "%MATERIAL%", this.plugin.lang().getEnum((Enum)item.getType()));
            meta = item.getItemMeta();
            if (meta == null) {
                return item;
            }
            lore = meta.getLore();
            if (lore == null) {
                return item;
            }
            for (TypedStat typedStat : ItemStats.getStats()) {
                lore.remove(typedStat.getPlaceholder());
            }
            for (ItemLoreStat itemLoreStat : ItemStats.getDamages()) {
                lore.remove(itemLoreStat.getPlaceholder());
            }
            for (ItemLoreStat itemLoreStat : ItemStats.getDefenses()) {
                lore.remove(itemLoreStat.getPlaceholder());
            }
            FabledHook fabledHook = (FabledHook)Divinity.getInstance().getHook("Fabled");
            if (fabledHook != null) {
                for (ItemLoreStat itemLoreStat : fabledHook.getAttributes()) {
                    lore.remove(itemLoreStat.getPlaceholder());
                }
            }
            for (SocketAttribute.Type socketType : SocketAttribute.Type.values()) {
                for (ItemLoreStat itemLoreStat : ItemStats.getSockets(socketType)) {
                    lore.remove(itemLoreStat.getPlaceholder());
                }
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
            return item;
        }

        @Generated
        public double getPrefixChance() {
            return this.prefixChance;
        }

        @Generated
        public double getSuffixChance() {
            return this.suffixChance;
        }

        @Generated
        public boolean isEnchantsSafeLevels() {
            return this.enchantsSafeLevels;
        }
    }
}

