/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.extractor;

import java.util.HashMap;
import java.util.Map;
import net.citizensnpcs.api.trait.TraitInfo;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.commands.api.ISubCommand;
import studio.magemonkey.codex.compat.VersionManager;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.hooks.external.VaultHK;
import studio.magemonkey.codex.hooks.external.citizens.CitizensHK;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.actions.ActionManipulator;
import studio.magemonkey.codex.util.eval.Evaluator;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.LimitedItem;
import studio.magemonkey.divinity.modules.api.QModuleDrop;
import studio.magemonkey.divinity.modules.list.extractor.ExtractGUI;
import studio.magemonkey.divinity.modules.list.extractor.ExtractorTrait;
import studio.magemonkey.divinity.modules.list.extractor.command.ExtractorOpenCmd;
import studio.magemonkey.divinity.modules.list.extractor.event.PlayerExtractSocketEvent;
import studio.magemonkey.divinity.stats.items.ItemStats;
import studio.magemonkey.divinity.stats.items.attributes.SocketAttribute;

public class ExtractorManager
extends QModuleDrop<ExtractorTool> {
    private Map<SocketAttribute.Type, Map<String, String>> extractPrice;
    private ActionManipulator extractActionsComplete;
    private ActionManipulator extractActionsError;
    private ExtractGUI gui;

    public ExtractorManager(@NotNull Divinity plugin) {
        super(plugin, ExtractorTool.class);
    }

    @NotNull
    public String getId() {
        return "extractor";
    }

    @NotNull
    public String version() {
        return "1.3.0";
    }

    public void setup() {
        this.moduleCommand.addSubCommand((ISubCommand)new ExtractorOpenCmd(this));
        VaultHK vh = ((Divinity)this.plugin).getVault();
        if (vh != null && vh.getEconomy() != null) {
            this.extractPrice = new HashMap<SocketAttribute.Type, Map<String, String>>();
            for (SocketAttribute.Type type : SocketAttribute.Type.values()) {
                HashMap<String, String> socketPrices = new HashMap<String, String>();
                for (String socketCategory : this.cfg.getSection("extraction.price." + type.name())) {
                    String path = "extraction.price." + type.name() + "." + socketCategory;
                    String priceFormula = this.cfg.getString(path, "75 * %socket_level%");
                    socketPrices.put(socketCategory.toLowerCase(), priceFormula);
                }
                this.extractPrice.put(type, socketPrices);
            }
        } else {
            this.warn("No economy found. Extraction will be free.");
        }
        this.extractActionsComplete = new ActionManipulator((CodexPlugin)this.plugin, this.cfg, "extraction.actions-complete");
        this.extractActionsError = new ActionManipulator((CodexPlugin)this.plugin, this.cfg, "extraction.actions-error");
        CitizensHK citizens = ((Divinity)this.plugin).getCitizens();
        if (citizens != null) {
            TraitInfo trait = TraitInfo.create(ExtractorTrait.class).withName("extractor");
            citizens.registerTrait((CodexPlugin)this.plugin, trait);
        }
        this.gui = new ExtractGUI(this);
    }

    public void shutdown() {
        if (this.gui != null) {
            this.gui.shutdown();
            this.gui = null;
        }
        if (this.extractPrice != null) {
            this.extractPrice.clear();
            this.extractPrice = null;
        }
        this.extractActionsComplete = null;
        this.extractActionsError = null;
    }

    public final boolean openExtraction(@NotNull Player player, @Nullable ItemStack target, @Nullable ItemStack src, @Nullable SocketAttribute.Type type, boolean force) {
        if (!force && !player.hasPermission("quantumrpg.extractor.gui")) {
            ((Divinity)this.plugin).lang().Error_NoPerm.send((CommandSender)player);
            return false;
        }
        if (target != null) {
            if (!this.canExtract(target)) {
                ((Divinity)this.plugin).lang().Extractor_Open_Error_NoSockets.replace("%item%", (Object)ItemUT.getItemName((ItemStack)target)).send((CommandSender)player);
                return false;
            }
            this.splitDragItem(player, src, target);
        }
        this.gui.open(player, target, src, type);
        return true;
    }

    public double getExtractionPrice(@NotNull SocketAttribute.Type type, @NotNull String socketCat, int level) {
        if (this.extractPrice == null) {
            return 0.0;
        }
        Map<String, String> map = this.extractPrice.get((Object)type);
        if (map == null) {
            return 0.0;
        }
        String formula = map.get(socketCat);
        if (formula == null) {
            return 0.0;
        }
        formula = formula.replace("%socket_level%", String.valueOf(level));
        return Evaluator.eval((String)formula, (int)1);
    }

    public boolean canExtract(@NotNull ItemStack item) {
        if (item.getType() == Material.AIR) {
            return true;
        }
        for (SocketAttribute.Type m : SocketAttribute.Type.values()) {
            for (SocketAttribute socketAtt : ItemStats.getSockets(m)) {
                if (socketAtt.getFilledAmount(item) <= 0) continue;
                return true;
            }
        }
        return false;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onExtractComplete(PlayerExtractSocketEvent e) {
        Player player = e.getPlayer();
        if (e.isFailed()) {
            this.extractActionsError.process((Entity)player);
            return;
        }
        ((Divinity)this.plugin).lang().Extractor_Extract_Complete.send((CommandSender)player);
        this.extractActionsComplete.process((Entity)player);
    }

    @Override
    protected boolean onDragDrop(@NotNull Player player, @NotNull ItemStack src, @NotNull ItemStack target, @NotNull ExtractorTool mItem, @NotNull InventoryClickEvent e) {
        VersionManager.getCompat().setCursor((InventoryEvent)e, null);
        boolean open = this.openExtraction(player, target, src, null, true);
        if (open) {
            src.setAmount(0);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)Divinity.getInstance(), () -> ((Player)player).updateInventory(), 1L);
        return open;
    }

    public class ExtractorTool
    extends LimitedItem {
        public ExtractorTool(@NotNull Divinity plugin, JYML cfg) {
            super(plugin, cfg, ExtractorManager.this);
        }
    }
}

