/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.classes.gui;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageClass;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.manager.api.gui.ContentType;
import studio.magemonkey.codex.manager.api.gui.GuiClick;
import studio.magemonkey.codex.manager.api.gui.GuiItem;
import studio.magemonkey.codex.manager.api.gui.JIcon;
import studio.magemonkey.codex.manager.api.gui.NGUI;
import studio.magemonkey.codex.util.CollectionsUT;
import studio.magemonkey.codex.util.DataUT;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.hooks.external.MagicHK;
import studio.magemonkey.divinity.modules.list.classes.ClassManager;
import studio.magemonkey.divinity.modules.list.classes.ComboManager;
import studio.magemonkey.divinity.modules.list.classes.api.IAbstractSkill;
import studio.magemonkey.divinity.modules.list.classes.api.UserClassData;
import studio.magemonkey.divinity.modules.list.classes.api.UserSkillData;

public class SkillListGUI
extends NGUI<Divinity> {
    private ClassManager classManager;
    private int[] objSlots;
    private String previewName;
    private List<String> previewLore;
    private static final NamespacedKey TAG_PREVIEW = new NamespacedKey((Plugin)Divinity.getInstance(), "QRPG_SKILL_PREVIEW");

    public SkillListGUI(@NotNull ClassManager classManager, @NotNull JYML cfg, @NotNull String path) {
        super((CodexPlugin)((Divinity)classManager.plugin), cfg, path);
        this.classManager = classManager;
        this.objSlots = cfg.getIntArray(path + "skill-slots");
        this.previewName = StringUT.color((String)cfg.getString(path + "upgrade-preview.name", "%name%"));
        this.previewLore = StringUT.color((List)cfg.getStringList(path + "upgrade-preview.lore"));
        GuiClick click = (p, type, e) -> {
            if (type == null) {
                return;
            }
            if (type == GSkillType.RESET) {
                classManager.reallocateSkillPoints(p);
                this.open(p, this.getUserPage(p, 0));
                return;
            }
            ContentType type2 = (ContentType)type;
            switch (type2) {
                case EXIT: {
                    p.closeInventory();
                    break;
                }
                case NEXT: {
                    this.open(p, this.getUserPage(p, 0) + 1);
                    break;
                }
                case BACK: {
                    this.open(p, this.getUserPage(p, 0) - 1);
                    break;
                }
                case RETURN: {
                    classManager.openStatsGUI(p);
                    break;
                }
            }
        };
        for (String sId : cfg.getSection(path + "content")) {
            GuiItem guiItem = cfg.getGuiItem(path + "content." + sId, GSkillType.class);
            if (guiItem == null) continue;
            if (guiItem.getType() != null) {
                guiItem.setClick(click);
            }
            this.addButton(guiItem);
        }
    }

    protected void onCreate(@NotNull Player player, @NotNull Inventory inv, int page) {
        MageController api;
        Mage mage;
        MageClass mageClass;
        MagicHK magicHook;
        UserClassData data = this.classManager.getUserData(player);
        if (data == null) {
            return;
        }
        boolean isMagic = this.classManager.hasMagic();
        if (isMagic && (magicHook = this.classManager.getMagic()) != null && (mageClass = (mage = (api = magicHook.getAPI().getController()).getMage(player)).unlockClass("mage")) != null) {
            for (String spellId : mageClass.getSpells()) {
                if (spellId == null) continue;
                Spell spell = mageClass.getSpell(spellId);
                int level = spell.getSpellKey().getLevel();
                if (data.getSkillData(spellId) != null) continue;
                data.getSkillsMap().put(spellId, new UserSkillData(spellId, level, new ComboManager.ComboKey[0]));
            }
        }
        int len = this.objSlots.length;
        List<UserSkillData> list = new ArrayList<UserSkillData>(data.getSkills());
        List split = CollectionsUT.split(list, (int)len);
        int pages = split.size();
        if (pages < 1) {
            list = Collections.emptyList();
        } else {
            if (page > pages) {
                page = pages;
            }
            list = (List)split.get(page - 1);
        }
        int count = 0;
        for (UserSkillData sData : list) {
            IAbstractSkill skill = this.classManager.getSkillById(sData.getId());
            ItemStack icon2 = null;
            if (skill == null) {
                MageController api2;
                Mage mage2;
                MageClass mageClass2;
                MagicHK magicHook2;
                if (isMagic && (magicHook2 = this.classManager.getMagic()) != null && (mageClass2 = (mage2 = (api2 = magicHook2.getAPI().getController()).getMage(player)).unlockClass("mage")) != null) {
                    Collection spells = mageClass2.getSpells();
                    if (!spells.contains(sData.getId())) {
                        data.getSkillsMap().remove(sData.getId());
                        continue;
                    }
                    icon2 = api2.createItem(sData.getId());
                }
            } else {
                icon2 = skill.getIcon(player, sData.getLevel());
            }
            if (icon2 == null) continue;
            JIcon icon = new JIcon(icon2);
            icon.setClick((p, type, e) -> {
                if (e.isRightClick() && skill != null) {
                    boolean isPreview;
                    if (sData.getLevel() >= skill.getMaxLevel()) {
                        return;
                    }
                    ItemStack iconCur = e.getCurrentItem();
                    if (iconCur == null) {
                        return;
                    }
                    boolean bl = isPreview = DataUT.getStringData((ItemStack)iconCur, (NamespacedKey)TAG_PREVIEW) != null;
                    if (!isPreview) {
                        ItemStack iconUp = skill.getIcon(p, sData.getLevel() + 1);
                        ItemMeta meta1 = iconCur.getItemMeta();
                        ItemMeta meta2 = iconUp.getItemMeta();
                        if (meta1 == null || meta2 == null) {
                            return;
                        }
                        ArrayList<String> loreCur = new ArrayList<String>();
                        List loreUp = meta2.getLore();
                        meta1.setDisplayName(this.previewName.replace("%name%", meta2.getDisplayName()));
                        for (String s : this.previewLore) {
                            if (s.contains("%lore%") && loreUp != null) {
                                for (String s2 : loreUp) {
                                    loreCur.add(s2);
                                }
                                continue;
                            }
                            loreCur.add(s.replace("%cost%", String.valueOf(skill.getSkillPointsCost(sData.getLevel()))));
                        }
                        meta1.setLore(loreCur);
                        iconCur.setItemMeta(meta1);
                        DataUT.setData((ItemStack)iconCur, (NamespacedKey)TAG_PREVIEW, (Object)"true");
                        e.getInventory().setItem(e.getRawSlot(), iconCur);
                        return;
                    }
                    this.classManager.addSkill(p, skill, sData.getLevel() + 1, false);
                    this.open(p, 1);
                } else if (e.isLeftClick()) {
                    ComboManager comboManager = this.classManager.getComboManager();
                    if (comboManager == null) {
                        return;
                    }
                    if (isMagic || skill != null && !skill.isPassive()) {
                        comboManager.openGUI(p, sData);
                    }
                }
            });
            this.addButton(player, icon, new int[]{this.objSlots[count++]});
        }
        this.setUserPage(player, page, pages);
    }

    protected boolean cancelClick(int slot) {
        return true;
    }

    protected boolean cancelPlayerClick() {
        return true;
    }

    protected boolean ignoreNullClick() {
        return true;
    }

    static enum GSkillType {
        RESET;

    }
}

