/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.arrows;

import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.manager.api.task.ITask;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.NamespaceResolver;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.codex.util.actions.ActionManipulator;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.api.event.DivinityProjectileLaunchEvent;
import studio.magemonkey.divinity.modules.LeveledItem;
import studio.magemonkey.divinity.modules.api.QModuleDrop;
import studio.magemonkey.divinity.stats.bonus.BonusMap;
import studio.magemonkey.divinity.stats.items.ItemStats;
import studio.magemonkey.divinity.stats.items.api.ItemLoreStat;
import studio.magemonkey.divinity.stats.items.attributes.DefenseAttribute;

public class ArrowManager
extends QModuleDrop<QArrow> {
    private static final String META_ARROW_ID = "QRPG_ARROW_ID";
    private static final String META_ARROW_LEVEL = "QRPG_ARROW_LEVEL";
    private Set<Map.Entry<Projectile, QArrow>> flyList;
    private ArrowTask taskFly;
    private boolean generalAllowInfinity;

    public ArrowManager(@NotNull Divinity plugin) {
        super(plugin, QArrow.class);
    }

    @NotNull
    public String getId() {
        return "arrows";
    }

    @NotNull
    public String version() {
        return "2.0.0";
    }

    public void setup() {
        this.flyList = new HashSet<Map.Entry<Projectile, QArrow>>();
        this.cfg.addMissing("settings.allow-infinity-enchant", (Object)true);
        this.cfg.saveChanges();
        this.generalAllowInfinity = this.cfg.getBoolean("settings.allow-infinity-enchant");
        this.taskFly = new ArrowTask((Divinity)this.plugin);
        this.taskFly.start();
    }

    public void shutdown() {
        if (this.taskFly != null) {
            this.taskFly.stop();
            this.taskFly = null;
        }
        if (this.flyList != null) {
            this.flyList.clear();
            this.flyList = null;
        }
    }

    @Nullable
    public QArrow getArrow(@NotNull Projectile pj) {
        if (pj.hasMetadata(META_ARROW_ID)) {
            String id = ((MetadataValue)pj.getMetadata(META_ARROW_ID).get(0)).asString();
            return (QArrow)this.getItemById(id);
        }
        return null;
    }

    public int getArrowLevel(@NotNull Projectile pj) {
        if (!pj.hasMetadata(META_ARROW_LEVEL)) {
            return 0;
        }
        return ((MetadataValue)pj.getMetadata(META_ARROW_LEVEL).get(0)).asInt();
    }

    @Nullable
    public final ItemStack getFirstArrow(@NotNull Player p, boolean checkAll) {
        int i;
        ItemStack off = p.getInventory().getItemInOffHand();
        if (!ItemUT.isAir((ItemStack)off) && this.isItemOfThisModule(off)) {
            return off;
        }
        ItemStack main = p.getInventory().getItemInMainHand();
        if (!ItemUT.isAir((ItemStack)main) && this.isItemOfThisModule(main)) {
            return main;
        }
        if (checkAll && (i = p.getInventory().first(Material.ARROW)) >= 0) {
            return p.getInventory().getItem(i);
        }
        return null;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onQuantumArrowLaunch(DivinityProjectileLaunchEvent e) {
        if (!(e.getProjectile() instanceof Projectile)) {
            return;
        }
        if (!(e.getShooter() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getShooter();
        ItemStack arrow = this.getFirstArrow(p, e.isBowEvent());
        if (arrow == null) {
            return;
        }
        QArrow qarrow = (QArrow)this.getModuleItem(arrow);
        if (qarrow == null) {
            return;
        }
        ItemStack bow = e.getWeapon();
        if (e.isBowEvent() && !this.generalAllowInfinity && bow != null && bow.containsEnchantment(NamespaceResolver.getEnchantment((String[])new String[]{"INFINITY", "ARROW_INFINITE"}))) {
            arrow.setAmount(arrow.getAmount() - 1);
        }
        String id = qarrow.getId();
        Projectile pj = (Projectile)e.getProjectile();
        int level = ItemStats.getLevel(arrow);
        this.markArrow(pj, id, level);
        this.flyList.add(new AbstractMap.SimpleEntry<Projectile, QArrow>(pj, qarrow));
    }

    public void markArrow(@NotNull Projectile pj, @NotNull String id, int lvl) {
        pj.setMetadata(META_ARROW_ID, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)id));
        pj.setMetadata(META_ARROW_LEVEL, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)lvl));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onQuantumArrowHit(ProjectileHitEvent e) {
        Projectile pj = e.getEntity();
        QArrow arrow = this.getArrow(pj);
        if (arrow == null) {
            return;
        }
        Entity ee = e.getHitEntity();
        if (ee != null) {
            Location eLoc = ee.getLocation().clone();
            Vector from = eLoc.toVector();
            Vector to = pj.getLocation().toVector();
            Vector direction = to.subtract(from);
            direction.normalize();
            direction.multiply(2);
            eLoc.setDirection(direction);
            pj.teleport(eLoc);
            pj.setVelocity(direction);
        }
        arrow.executeHitActions(pj);
    }

    public class QArrow
    extends LeveledItem {
        private final TreeMap<Integer, BonusMap> bonusMap;
        private final ActionManipulator fly;
        private final ActionManipulator hit;

        public QArrow(@NotNull Divinity plugin, JYML cfg) {
            super(plugin, cfg, ArrowManager.this);
            cfg.addMissing("material", (Object)"ARROW");
            cfg.saveChanges();
            this.bonusMap = new TreeMap();
            for (String sLvl : cfg.getSection("bonuses-by-level")) {
                int itemLvl = StringUT.getInteger((String)sLvl, (int)-1);
                if (itemLvl <= 0) continue;
                String path = "bonuses-by-level." + sLvl + ".";
                BonusMap bMap = new BonusMap();
                bMap.loadStats(cfg, path + "additional-stats");
                bMap.loadDamages(cfg, path + "additional-damage");
                bMap.loadDefenses(cfg, path + "defense-ignoring");
                bMap.getBonuses().forEach((stat, func) -> {
                    if (stat instanceof DefenseAttribute) {
                        bMap.getBonuses().compute((ItemLoreStat<?>)stat, (kStat, vFunc) -> vFunc.andThen(result -> -result.doubleValue()));
                    }
                });
                this.bonusMap.put(itemLvl, bMap);
            }
            this.fly = new ActionManipulator((CodexPlugin)plugin, cfg, "on-fly-actions");
            this.hit = new ActionManipulator((CodexPlugin)plugin, cfg, "on-hit-actions");
        }

        @Nullable
        public BonusMap getBonusMap(int lvl) {
            Map.Entry<Integer, BonusMap> e = this.bonusMap.floorEntry(lvl);
            if (e == null) {
                return null;
            }
            return e.getValue();
        }

        public void executeFlyActions(@NotNull Projectile arrow) {
            this.fly.process((Entity)arrow);
        }

        public void executeHitActions(@NotNull Projectile arrow) {
            this.hit.process((Entity)arrow);
        }
    }

    class ArrowTask
    extends ITask<Divinity> {
        public ArrowTask(Divinity plugin) {
            super((CodexPlugin)plugin, 1L, false);
        }

        public void action() {
            for (Map.Entry<Projectile, QArrow> e : new HashSet<Map.Entry<Projectile, QArrow>>(ArrowManager.this.flyList)) {
                Projectile pj = e.getKey();
                if (pj.isOnGround() || !pj.isValid()) {
                    ArrowManager.this.flyList.remove(e);
                    continue;
                }
                QArrow arrow = e.getValue();
                arrow.executeFlyActions(pj);
            }
        }
    }
}

