/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.data;

import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.UUID;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.data.DataTypes;
import studio.magemonkey.codex.data.IDataHandler;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.data.api.DivinityUser;
import studio.magemonkey.divinity.data.api.UserProfile;
import studio.magemonkey.divinity.data.api.serialize.SkillDataSerializer;
import studio.magemonkey.divinity.data.api.serialize.UserProfileSerializer;
import studio.magemonkey.divinity.modules.list.classes.api.UserSkillData;

public class DivinityUserData
extends IDataHandler<Divinity, DivinityUser> {
    private static DivinityUserData instance;
    private final Function<ResultSet, DivinityUser> FUNC_USER = rs -> {
        try {
            UUID uuid = UUID.fromString(rs.getString("uuid"));
            String name = rs.getString("name");
            long lastOnline = rs.getLong("last_online");
            LinkedHashMap profiles = (LinkedHashMap)this.gson.fromJson(rs.getString("profiles"), new TypeToken<LinkedHashMap<String, UserProfile>>(){}.getType());
            return new DivinityUser(plugin, uuid, name, lastOnline, profiles);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return null;
        }
    };

    protected DivinityUserData(@NotNull Divinity plugin) throws SQLException {
        super((CodexPlugin)plugin);
    }

    public static DivinityUserData getInstance(@NotNull Divinity plugin) throws SQLException {
        if (instance == null) {
            instance = new DivinityUserData(plugin);
        }
        return instance;
    }

    public static void destroy() {
        instance = null;
    }

    @NotNull
    protected GsonBuilder registerAdapters(@NotNull GsonBuilder builder) {
        return super.registerAdapters(builder.registerTypeAdapter(UserProfile.class, (Object)new UserProfileSerializer()).registerTypeAdapter(UserSkillData.class, (Object)new SkillDataSerializer()));
    }

    @NotNull
    protected LinkedHashMap<String, String> getColumnsToCreate() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("profiles", DataTypes.STRING.build(this.dataType));
        return map;
    }

    @NotNull
    protected LinkedHashMap<String, String> getColumnsToSave(@NotNull DivinityUser user) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("profiles", this.gson.toJson(user.getProfileMap()));
        return map;
    }

    @NotNull
    protected Function<ResultSet, DivinityUser> getFunctionToUser() {
        return this.FUNC_USER;
    }
}

