/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.utils.actions.executors;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.DoubleUnaryOperator;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.util.actions.actions.IActionExecutor;
import studio.magemonkey.codex.util.actions.params.IParamResult;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.manager.effects.main.AdjustStatEffect;
import studio.magemonkey.divinity.stats.items.ItemStats;

public class ActionDamage
extends IActionExecutor {
    public ActionDamage(@NotNull Divinity plugin) {
        super((CodexPlugin)plugin, "DAMAGE");
    }

    public void registerParams() {
        this.registerParam("DELAY");
        this.registerParam("TARGET");
        this.registerParam("AMOUNT");
    }

    protected void execute(Entity exe, Set<Entity> targets, IParamResult result) {
        ProjectileSource src;
        double dmgAdd = result.getParamValue("AMOUNT").getDouble(0.0);
        if (dmgAdd == 0.0) {
            return;
        }
        boolean perc = result.getParamValue("AMOUNT").getBoolean();
        Entity eDamager = exe;
        Projectile pj = null;
        if (eDamager instanceof Projectile && (src = (pj = (Projectile)eDamager).getShooter()) instanceof LivingEntity) {
            eDamager = (Entity)src;
        }
        LivingEntity damager = eDamager instanceof LivingEntity ? (LivingEntity)eDamager : null;
        DoubleUnaryOperator operator = d -> d == 0.0 ? d : (perc ? d * (dmgAdd / 100.0) : d + dmgAdd);
        for (Entity eTarget : targets) {
            if (!(eTarget instanceof LivingEntity)) continue;
            LivingEntity victim = (LivingEntity)eTarget;
            if (damager != null) {
                AdjustStatEffect adjust = ((AdjustStatEffect.Builder)new AdjustStatEffect.Builder(-1.0).withCharges(1)).withAdjust(ItemStats.getDamages(), operator).build();
                adjust.applyTo(damager);
            }
            victim.damage(1.0, eDamager);
        }
    }

    public boolean mustHaveTarget() {
        return true;
    }

    @NotNull
    public List<String> getDescription() {
        return Arrays.asList("Inflicts damage");
    }
}

