/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.stats.items.attributes.stats;

import java.util.function.Function;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.util.NumberUT;
import studio.magemonkey.codex.util.eval.Evaluator;
import studio.magemonkey.divinity.manager.effects.main.BleedEffect;
import studio.magemonkey.divinity.stats.EntityStats;
import studio.magemonkey.divinity.stats.items.attributes.api.SimpleStat;
import studio.magemonkey.divinity.stats.items.attributes.api.TypedStat;

public class BleedStat
extends SimpleStat {
    private String damageFormula;
    private boolean ofMaxHealth;
    private double duration;

    public BleedStat(@NotNull String name, @NotNull String format, double cap, @NotNull String damageFormula, boolean ofMaxHealth, double duration) {
        super(TypedStat.Type.BLEED_RATE, name, format, cap);
        this.damageFormula = damageFormula;
        this.ofMaxHealth = ofMaxHealth;
        this.duration = duration;
    }

    @NotNull
    public String getDamageFormula() {
        return this.damageFormula;
    }

    public boolean damageOfMaxHealth() {
        return this.ofMaxHealth;
    }

    public double getDuration() {
        return this.duration;
    }

    public void bleed(@NotNull LivingEntity target, double damage) {
        double dmgTick = Evaluator.eval((String)this.damageFormula.replace("%damage%", NumberUT.format((double)damage)), (int)1);
        Function<LivingEntity, Double> dmgFunc = entity -> {
            if (this.ofMaxHealth) {
                return EntityStats.getEntityMaxHealth(target) * dmgTick / 100.0;
            }
            return dmgTick;
        };
        BleedEffect bleed = new BleedEffect.Builder(this.duration, 1.25, dmgFunc).build();
        bleed.applyTo(target);
    }
}

