/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.stats.items.attributes.api;

import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.divinity.stats.items.attributes.api.SimpleStat;

public interface TypedStat {
    public String getId();

    public String getPlaceholder();

    public boolean hasPlaceholder(@NotNull ItemStack var1);

    public boolean isApplied(@NotNull ItemStack var1);

    @NotNull
    public Type getType();

    public double getCapability();

    public void setCapability(double var1);

    public SimpleStat.ItemType getItemType();

    public boolean isPercent();

    public boolean canBeNegative();

    @Deprecated
    public boolean isMainItem(@NotNull ItemStack var1);

    @Nullable
    public Type getDependStat();

    default public double fineValue(double value) {
        if (this.getType() == Type.DURABILITY) {
            return value;
        }
        if (this.getCapability() >= 0.0 && value > this.getCapability()) {
            value = this.getCapability();
        }
        if (value < 0.0 && !this.canBeNegative()) {
            value = 0.0;
        }
        return value;
    }

    public static enum Type {
        ARMOR(SimpleStat.ItemType.ARMOR, false, true, true),
        ARMOR_TOUGHNESS(SimpleStat.ItemType.ARMOR, false, true, true),
        ATTACK_SPEED(SimpleStat.ItemType.BOTH, true, true, true),
        BASE_ATTACK_SPEED(SimpleStat.ItemType.BOTH, false, true, true),
        KNOCKBACK_RESISTANCE(SimpleStat.ItemType.BOTH, false, true, true),
        MAX_HEALTH(SimpleStat.ItemType.BOTH, false, true, true),
        MOVEMENT_SPEED(SimpleStat.ItemType.ARMOR, true, true, true),
        AOE_DAMAGE(SimpleStat.ItemType.WEAPON, true, false, true),
        PVP_DAMAGE(SimpleStat.ItemType.WEAPON, true, true, true),
        PVE_DAMAGE(SimpleStat.ItemType.WEAPON, true, true, true),
        DODGE_RATE(SimpleStat.ItemType.ARMOR, true, true, true),
        ACCURACY_RATE(SimpleStat.ItemType.WEAPON, true, true, true),
        BLOCK_RATE(SimpleStat.ItemType.BOTH, true, true, true),
        BLOCK_DAMAGE(SimpleStat.ItemType.ARMOR, true, true, true),
        LOOT_RATE(SimpleStat.ItemType.BOTH, true, true, true),
        BURN_RATE(SimpleStat.ItemType.WEAPON, true, true, true),
        PVP_DEFENSE(SimpleStat.ItemType.ARMOR, true, false, true),
        PVE_DEFENSE(SimpleStat.ItemType.ARMOR, true, true, true),
        CRITICAL_RATE(SimpleStat.ItemType.WEAPON, true, true, true),
        CRITICAL_DAMAGE(SimpleStat.ItemType.WEAPON, false, false, true),
        DURABILITY(SimpleStat.ItemType.BOTH, false, true, false),
        PENETRATION(SimpleStat.ItemType.WEAPON, true, true, true),
        VAMPIRISM(SimpleStat.ItemType.WEAPON, true, true, true),
        BLEED_RATE(SimpleStat.ItemType.WEAPON, true, true, true),
        DISARM_RATE(SimpleStat.ItemType.WEAPON, true, true, true),
        SALE_PRICE(SimpleStat.ItemType.BOTH, true, true, false),
        THORNMAIL(SimpleStat.ItemType.ARMOR, true, false, true),
        HEALTH_REGEN(SimpleStat.ItemType.BOTH, true, true, true),
        MANA_REGEN(SimpleStat.ItemType.BOTH, true, true, true);

        private final SimpleStat.ItemType type;
        private final boolean perc;
        private final boolean canNegate;
        private final boolean isGlobal;

        private Type(SimpleStat.ItemType type, boolean perc, boolean nega, boolean isGlobal) {
            this.type = type;
            this.perc = perc;
            this.canNegate = nega;
            this.isGlobal = isGlobal;
        }

        @Nullable
        public static Type getByName(@NotNull String s) {
            try {
                return Type.valueOf(s.toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        }

        @NotNull
        public SimpleStat.ItemType getItemType() {
            return this.type;
        }

        public boolean isPercent() {
            return this.perc;
        }

        public boolean canBeNegative() {
            return this.canNegate;
        }

        public boolean isGlobal() {
            return this.isGlobal;
        }
    }
}

