/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.stats.items.attributes;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import lombok.Generated;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.compat.VersionManager;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.NumberUT;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.config.EngineCfg;
import studio.magemonkey.divinity.modules.list.gems.GemManager;
import studio.magemonkey.divinity.modules.list.refine.RefineManager;
import studio.magemonkey.divinity.stats.bonus.BonusCalculator;
import studio.magemonkey.divinity.stats.bonus.BonusMap;
import studio.magemonkey.divinity.stats.bonus.StatBonus;
import studio.magemonkey.divinity.stats.items.ItemStats;
import studio.magemonkey.divinity.stats.items.api.DuplicableItemLoreStat;
import studio.magemonkey.divinity.stats.items.api.DynamicStat;
import studio.magemonkey.divinity.stats.items.attributes.DamageAttribute;

public class DefenseAttribute
extends DuplicableItemLoreStat<StatBonus>
implements DynamicStat<StatBonus> {
    private final Set<String> blockDamageType;
    private int priority;
    private double protectionFactor;

    public DefenseAttribute(@NotNull String id, @NotNull String name, @NotNull String format, int priority, @NotNull Set<String> blockDamageType, double protectionFactor) {
        super(id, name, format, "%DEFENSE_" + id + "%", "ITEM_DEFENSE_", StatBonus.DATA_TYPE);
        this.priority = priority;
        this.blockDamageType = blockDamageType;
        this.protectionFactor = protectionFactor;
        ItemStats.registerDynamicStat(this);
        this.keys.add(NamespacedKey.fromString((String)("prorpgitems:item_defense_" + this.getId())));
        this.keys.add(NamespacedKey.fromString((String)("prorpgitems:qrpg_item_defense_" + this.getId())));
        this.keys.add(NamespacedKey.fromString((String)("quantumrpg:qrpg_item_defense_" + this.getId())));
    }

    @Override
    @NotNull
    public Class<StatBonus> getParameterClass() {
        return StatBonus.class;
    }

    public boolean isBlockable(@NotNull DamageAttribute dmg) {
        return this.blockDamageType.contains(dmg.getId()) || this.blockDamageType.contains("*");
    }

    public double getTotal(@NotNull ItemStack item, @Nullable Player player) {
        return BonusCalculator.SIMPLE_FULL.apply(0.0, this.get(item, player));
    }

    @NotNull
    public List<BiFunction<Boolean, Double, Double>> get(@NotNull ItemStack item, @Nullable Player player) {
        GemManager gems;
        RefineManager refine;
        ArrayList<BiFunction<Boolean, Double, Double>> bonuses = new ArrayList<BiFunction<Boolean, Double, Double>>();
        double base = 0.0;
        double percent = 0.0;
        boolean has = false;
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            PersistentDataContainer container = meta.getPersistentDataContainer();
            for (NamespacedKey namespacedKey : this.keys) {
                Double value;
                if (!container.has(namespacedKey, PersistentDataType.DOUBLE) || (value = (Double)container.get(namespacedKey, PersistentDataType.DOUBLE)) == null) continue;
                base += value.doubleValue();
                has = true;
                break;
            }
        }
        for (StatBonus bonus : this.getAllRaw(item)) {
            if (!bonus.meetsRequirement(player)) continue;
            double[] dArray = bonus.getValue();
            if (dArray.length == 1 && bonus.isPercent()) {
                percent += dArray[0];
                continue;
            }
            base += dArray[0];
            has = true;
        }
        if (base == 0.0 && this.isDefault() && ItemStats.getDefenses().stream().filter(defenseAttribute -> !defenseAttribute.isDefault()).noneMatch(defenseAttribute -> ItemStats.hasDefense(item, player, defenseAttribute))) {
            base += DefenseAttribute.getVanillaArmor(item);
        }
        double finalBase = base;
        bonuses.add((isPercent, input) -> isPercent != false ? input : input + finalBase);
        double d = percent;
        bonuses.add((isPercent, input) -> isPercent != false ? input + finalPercent : input);
        StatBonus baseLine = (StatBonus)this.getRaw(meta, 0);
        if (baseLine != null && baseLine.isBaseStat() && (refine = Divinity.getInstance().getModuleCache().getRefineManager()) != null && has) {
            bonuses.add(refine.getRefinedBonus(item, this));
        }
        if ((gems = Divinity.getInstance().getModuleCache().getGemManager()) != null) {
            for (Map.Entry entry : gems.getItemSockets(item)) {
                BiFunction<Boolean, Double, Double> bonus;
                BonusMap bMap = ((GemManager.Gem)entry.getKey()).getBonusMap((Integer)entry.getValue());
                if (bMap == null || (bonus = bMap.getBonus(this)) == null) continue;
                bonuses.add(bonus);
            }
        }
        return bonuses;
    }

    public static double getVanillaArmor(@NotNull ItemStack item) {
        return VersionManager.getNms().getDefaultArmor(item);
    }

    public static double getVanillaToughness(@NotNull ItemStack item) {
        return VersionManager.getNms().getDefaultToughness(item);
    }

    public boolean isDefault() {
        DefenseAttribute def = ItemStats.getDefenseByDefault();
        return def != null && def.getId().equalsIgnoreCase(this.getId());
    }

    @Override
    @NotNull
    public String formatValue(@NotNull ItemStack item, @NotNull StatBonus statBonus) {
        RefineManager refine;
        Object sVal = NumberUT.format((double)statBonus.getValue()[0]);
        if (statBonus.isPercent()) {
            sVal = (String)sVal + EngineCfg.LORE_CHAR_PERCENT;
        } else if (statBonus.isBaseStat() && (refine = Divinity.getInstance().getModuleCache().getRefineManager()) != null) {
            sVal = (String)sVal + refine.getFormatLoreStat(item, this, statBonus.getValue()[0]);
        }
        return sVal;
    }

    @Override
    @NotNull
    public String getFormat(@Nullable Player p, @NotNull ItemStack item, @NotNull StatBonus value) {
        StatBonus.Condition<?> condition = value.getCondition();
        return StringUT.colorFix((String)super.getFormat(item, value).replace("%condition%", condition == null || !EngineCfg.LORE_STYLE_REQ_USER_DYN_UPDATE ? "" : condition.getFormat(p, item)));
    }

    @Override
    @NotNull
    public ItemStack updateItem(@Nullable Player p, @NotNull ItemStack item) {
        int amount;
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        for (NamespacedKey key : this.keys) {
            if (!container.has(key, PersistentDataType.DOUBLE)) continue;
            Double value = Objects.requireNonNull((Double)container.get(key, PersistentDataType.DOUBLE));
            this.add(item, new StatBonus(new double[]{value}, false, null), -1, -1);
            meta = item.getItemMeta();
            break;
        }
        if ((amount = this.getAmount(item)) == 0) {
            return item;
        }
        List lore = meta.getLore();
        if (lore == null) {
            return item;
        }
        for (int i = 0; i < amount; ++i) {
            StatBonus arr;
            NamespacedKey key;
            int loreIndex = -1;
            Object metaId = "";
            Iterator iterator = this.keys.iterator();
            while (iterator.hasNext() && (loreIndex = ItemUT.getLoreIndex((ItemStack)item, (String)(metaId = (key = (NamespacedKey)iterator.next()).getKey() + i))) < 0) {
            }
            if (loreIndex < 0 || (arr = (StatBonus)this.getRaw(item, i)) == null) continue;
            String formatNew = this.getFormat(p, item, arr);
            lore.set(loreIndex, formatNew);
            meta.setLore(lore);
            item.setItemMeta(meta);
            ItemUT.addLoreTag((ItemStack)item, (String)metaId, (String)formatNew);
        }
        return item;
    }

    @Generated
    public int getPriority() {
        return this.priority;
    }

    @Generated
    public double getProtectionFactor() {
        return this.protectionFactor;
    }
}

