/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.stats.items.attributes;

import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.LlamaSpit;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.WitherSkull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.divinity.stats.items.api.ItemLoreStat;
import studio.magemonkey.divinity.utils.ItemUtils;

public class AmmoAttribute
extends ItemLoreStat<String> {
    private Type type;

    public AmmoAttribute(@NotNull Type type, @NotNull String name, @NotNull String format) {
        super(type.name(), name, format, "%ITEM_AMMO%", "ITEM_AMMO_", PersistentDataType.STRING);
        this.type = type;
        this.keys.add(NamespacedKey.fromString((String)("prorpgitems:item_ammo_" + this.getId())));
        this.keys.add(NamespacedKey.fromString((String)("prorpgitems:item_ammo" + this.getId())));
        this.keys.add(NamespacedKey.fromString((String)("prorpgitems:qrpg_item_ammo" + this.getId())));
        this.keys.add(NamespacedKey.fromString((String)("quantumrpg:qrpg_item_ammo" + this.getId())));
    }

    @Override
    @NotNull
    public Class<String> getParameterClass() {
        return String.class;
    }

    @Override
    protected boolean isSingle() {
        return true;
    }

    @NotNull
    public Type getType() {
        return this.type;
    }

    @Override
    public boolean add(@NotNull ItemStack item, @NotNull String value, int line) {
        return this.add(item, line);
    }

    public boolean add(@NotNull ItemStack item, int line) {
        return super.add(item, this.getType().name(), line);
    }

    @NotNull
    public Projectile getProjectile(@NotNull LivingEntity shooter) {
        switch (this.type.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                return shooter.launchProjectile(this.getType().clazz);
            }
            case 5: 
            case 6: 
            case 8: {
                Location eye = shooter.getEyeLocation();
                Projectile sb = (Projectile)shooter.getWorld().spawnEntity(eye.add(eye.getDirection()), this.getType().eType);
                return sb;
            }
        }
        return shooter.launchProjectile(this.type.clazz);
    }

    @Override
    @NotNull
    public String formatValue(@NotNull ItemStack item, @NotNull String value) {
        if (!ItemUtils.isBow(item)) {
            return "";
        }
        return value;
    }

    public static enum Type {
        ARROW(Arrow.class, EntityType.ARROW),
        SNOWBALL(Snowball.class, EntityType.SNOWBALL),
        EGG(Egg.class, EntityType.EGG),
        FIREBALL(Fireball.class, EntityType.FIREBALL),
        WITHER_SKULL(WitherSkull.class, EntityType.WITHER_SKULL),
        SHULKER_BULLET(ShulkerBullet.class, EntityType.SHULKER_BULLET),
        LLAMA_SPIT(LlamaSpit.class, EntityType.LLAMA_SPIT),
        ENDER_PEARL(EnderPearl.class, EntityType.ENDER_PEARL),
        EXP_POTION(ThrownExpBottle.class, EntityType.fromName((String)"experience_bottle"));

        private Class<? extends Projectile> clazz;
        private EntityType eType;

        private Type(Class<? extends Projectile> clazz, EntityType eType) {
            this.clazz = clazz;
            this.eType = eType;
        }
    }
}

