/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.stats.items;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.api.meta.NBTAttribute;
import studio.magemonkey.codex.compat.VersionManager;
import studio.magemonkey.codex.core.Version;
import studio.magemonkey.codex.modules.IModule;
import studio.magemonkey.codex.util.DataUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.config.EngineCfg;
import studio.magemonkey.divinity.modules.api.QModuleDrop;
import studio.magemonkey.divinity.stats.items.api.DuplicableItemLoreStat;
import studio.magemonkey.divinity.stats.items.api.DynamicStat;
import studio.magemonkey.divinity.stats.items.api.ItemLoreStat;
import studio.magemonkey.divinity.stats.items.attributes.AmmoAttribute;
import studio.magemonkey.divinity.stats.items.attributes.DamageAttribute;
import studio.magemonkey.divinity.stats.items.attributes.DefenseAttribute;
import studio.magemonkey.divinity.stats.items.attributes.HandAttribute;
import studio.magemonkey.divinity.stats.items.attributes.SocketAttribute;
import studio.magemonkey.divinity.stats.items.attributes.api.SimpleStat;
import studio.magemonkey.divinity.stats.items.attributes.api.TypedStat;
import studio.magemonkey.divinity.stats.items.attributes.stats.DurabilityStat;
import studio.magemonkey.divinity.utils.ItemUtils;

public class ItemStats {
    private static final Map<String, DamageAttribute> DAMAGES = new LinkedHashMap<String, DamageAttribute>();
    private static final Map<String, DefenseAttribute> DEFENSES = new LinkedHashMap<String, DefenseAttribute>();
    private static final Map<TypedStat.Type, TypedStat> STATS = new HashMap<TypedStat.Type, TypedStat>();
    private static final Map<AmmoAttribute.Type, AmmoAttribute> AMMO = new HashMap<AmmoAttribute.Type, AmmoAttribute>();
    private static final Map<HandAttribute.Type, HandAttribute> HANDS = new HashMap<HandAttribute.Type, HandAttribute>();
    private static final Map<SocketAttribute.Type, Map<String, SocketAttribute>> SOCKETS = new HashMap<SocketAttribute.Type, Map<String, SocketAttribute>>();
    private static final Map<String, ItemLoreStat<?>> ATTRIBUTES = new HashMap();
    private static final Map<String, DuplicableItemLoreStat<?>> MULTI_ATTRIBUTES = new HashMap();
    private static final Set<DynamicStat> DYNAMIC_STATS = new HashSet<DynamicStat>();
    private static final Divinity plugin = Divinity.getInstance();
    private static final List<NamespacedKey> KEY_ID = List.of(new NamespacedKey((Plugin)plugin, "ITEM_ID"), Objects.requireNonNull(NamespacedKey.fromString((String)("prorpgitems:" + "ITEM_ID".toLowerCase()))), Objects.requireNonNull(NamespacedKey.fromString((String)("prorpgitems:qrpg_" + "ITEM_ID".toLowerCase()))), Objects.requireNonNull(NamespacedKey.fromString((String)("quantumrpg:qrpg_" + "ITEM_ID".toLowerCase()))));
    private static final List<NamespacedKey> KEY_MODULE = List.of(new NamespacedKey((Plugin)plugin, "ITEM_MODULE"), Objects.requireNonNull(NamespacedKey.fromString((String)("prorpgitems:" + "ITEM_MODULE".toLowerCase()))), Objects.requireNonNull(NamespacedKey.fromString((String)("prorpgitems:qrpg_" + "ITEM_MODULE".toLowerCase()))), Objects.requireNonNull(NamespacedKey.fromString((String)("quantumrpg:qrpg_" + "ITEM_MODULE".toLowerCase()))));
    private static final List<NamespacedKey> KEY_LEVEL = List.of(new NamespacedKey((Plugin)plugin, "ITEM_LEVEL"), Objects.requireNonNull(NamespacedKey.fromString((String)("prorpgitems:" + "ITEM_LEVEL".toLowerCase()))), Objects.requireNonNull(NamespacedKey.fromString((String)("prorpgitems:qrpg_" + "ITEM_LEVEL".toLowerCase()))), Objects.requireNonNull(NamespacedKey.fromString((String)("quantumrpg:qrpg_" + "ITEM_LEVEL".toLowerCase()))));
    private static final List<NamespacedKey> KEY_SOCKET = List.of(new NamespacedKey((Plugin)plugin, "ITEM_SOCKET_RATE"), Objects.requireNonNull(NamespacedKey.fromString((String)("prorpgitems:" + "ITEM_SOCKET_RATE".toLowerCase()))), Objects.requireNonNull(NamespacedKey.fromString((String)("prorpgitems:qrpg_" + "ITEM_SOCKET_RATE".toLowerCase()))), Objects.requireNonNull(NamespacedKey.fromString((String)("quantumrpg:qrpg_" + "ITEM_SOCKET_RATE".toLowerCase()))));
    private static DamageAttribute DAMAGE_DEFAULT;
    private static DefenseAttribute DEFENSE_DEFAULT;
    private static final double DEFAULT_ATTACK_SPEED = 4.0;

    public static void clear() {
        DAMAGES.clear();
        DEFENSES.clear();
        STATS.clear();
        AMMO.clear();
        HANDS.clear();
        SOCKETS.clear();
        ATTRIBUTES.clear();
        MULTI_ATTRIBUTES.clear();
        DAMAGE_DEFAULT = null;
        DEFENSE_DEFAULT = null;
    }

    public static void registerDamage(@NotNull DamageAttribute dmg) {
        DAMAGES.put(dmg.getId(), dmg);
        if (DAMAGE_DEFAULT == null || dmg.getPriority() >= DAMAGE_DEFAULT.getPriority()) {
            DAMAGE_DEFAULT = dmg;
        } else {
            DAMAGES.remove(DAMAGE_DEFAULT.getId());
            DAMAGES.put(DAMAGE_DEFAULT.getId(), DAMAGE_DEFAULT);
        }
        ItemStats.updateDefenseByDefault();
    }

    public static void registerDefense(@NotNull DefenseAttribute def) {
        DEFENSES.put(def.getId(), def);
        ItemStats.updateDefenseByDefault();
    }

    public static void registerStat(@NotNull TypedStat stat) {
        if (stat.getCapability() == 0.0) {
            return;
        }
        STATS.put(stat.getType(), stat);
    }

    public static void registerAmmo(@NotNull AmmoAttribute ammo) {
        AMMO.put(ammo.getType(), ammo);
    }

    public static void registerHand(@NotNull HandAttribute hand) {
        HANDS.put(hand.getType(), hand);
    }

    public static void registerDynamicStat(@NotNull DynamicStat stat) {
        DYNAMIC_STATS.add(stat);
    }

    public static Collection<DynamicStat> getDynamicStats() {
        return Collections.unmodifiableSet(DYNAMIC_STATS);
    }

    private static void updateDefenseByDefault() {
        if (DAMAGES.isEmpty()) {
            return;
        }
        for (DamageAttribute dmg : ItemStats.getDamages()) {
            Optional<DefenseAttribute> opt = ItemStats.getDefenses().stream().filter(def -> def.isBlockable(dmg)).sorted((def1, def2) -> def2.getPriority() - def1.getPriority()).findFirst();
            if (!opt.isPresent()) continue;
            dmg.setAttachedDefense(opt.get());
        }
        DEFENSE_DEFAULT = ItemStats.getDamageByDefault().getAttachedDefense();
    }

    @NotNull
    public static Collection<DamageAttribute> getDamages() {
        return DAMAGES.values();
    }

    @Nullable
    public static DamageAttribute getDamageById(@NotNull String id) {
        return DAMAGES.get(id.toLowerCase());
    }

    @Nullable
    public static DamageAttribute getDamageByCause(@NotNull EntityDamageEvent.DamageCause cause) {
        Optional<DamageAttribute> opt = ItemStats.getDamages().stream().filter(dmg -> dmg.isAttached(cause)).sorted((dmg1, dmg2) -> dmg2.getPriority() - dmg1.getPriority()).findFirst();
        return opt.isPresent() ? opt.get() : null;
    }

    @NotNull
    public static DamageAttribute getDamageByDefault() {
        return DAMAGE_DEFAULT;
    }

    public static boolean hasDamage(@NotNull ItemStack item, @Nullable Player player) {
        return ItemStats.getDamages().stream().anyMatch(dmg -> ItemStats.hasDamage(item, player, dmg));
    }

    public static boolean hasDamage(@NotNull ItemStack item, @Nullable Player player, @NotNull String id) {
        DamageAttribute dmgType = ItemStats.getDamageById(id);
        if (dmgType == null) {
            return false;
        }
        return ItemStats.hasDamage(item, player, dmgType);
    }

    public static boolean hasDamage(@NotNull ItemStack item, @Nullable Player player, @NotNull DamageAttribute dmgType) {
        return dmgType.getTotal(item, player)[1] > 0.0;
    }

    public static double getDamageMinOrMax(@NotNull ItemStack item, @Nullable Player player, @NotNull String id, int index) {
        DamageAttribute dmgType = ItemStats.getDamageById(id);
        if (dmgType == null) {
            return 0.0;
        }
        return dmgType.getTotal(item, player)[index];
    }

    @NotNull
    public static Collection<DefenseAttribute> getDefenses() {
        return DEFENSES.values();
    }

    @Nullable
    public static DefenseAttribute getDefenseById(@NotNull String id) {
        return DEFENSES.get(id.toLowerCase());
    }

    public static boolean hasDefense(@NotNull ItemStack item, @Nullable Player player, @NotNull String id) {
        DefenseAttribute defType = ItemStats.getDefenseById(id);
        if (defType == null) {
            return false;
        }
        return ItemStats.hasDefense(item, player, defType);
    }

    public static boolean hasDefense(@NotNull ItemStack item, @Nullable Player player, @NotNull DefenseAttribute defType) {
        return defType.getTotal(item, player) != 0.0;
    }

    @Nullable
    public static DefenseAttribute getDefenseByDefault() {
        return DEFENSE_DEFAULT;
    }

    public static double getDefense(@NotNull ItemStack item, @Nullable Player player, @NotNull String id) {
        DefenseAttribute defType = ItemStats.getDefenseById(id);
        if (defType == null) {
            return 0.0;
        }
        return defType.getTotal(item, player);
    }

    @NotNull
    public static Collection<TypedStat> getStats() {
        return STATS.values();
    }

    @Nullable
    public static TypedStat getStat(@NotNull TypedStat.Type type) {
        return STATS.get((Object)type);
    }

    public static double getStat(@NotNull ItemStack item, @Nullable Player player, @NotNull TypedStat.Type type) {
        return ItemStats.getStat(item, player, type, 0.0);
    }

    public static double getStat(@NotNull ItemStack item, @Nullable Player player, @NotNull TypedStat.Type type, double def) {
        TypedStat stat = ItemStats.getStat(type);
        if (stat instanceof SimpleStat) {
            return ((SimpleStat)stat).getTotal(item, player, def);
        }
        if (stat instanceof DurabilityStat) {
            double[] arr = (double[])((DurabilityStat)stat).getRaw(item);
            return arr == null ? def : arr[0];
        }
        return def;
    }

    @Nullable
    public static <T extends TypedStat> T getStat(@NotNull Class<T> clazz) {
        for (TypedStat stat : ItemStats.getStats()) {
            Class<?> clazz2 = stat.getClass();
            if (!clazz.isAssignableFrom(clazz2)) continue;
            return (T)stat;
        }
        return null;
    }

    public static boolean hasStat(@NotNull ItemStack item, @Nullable Player player, @NotNull TypedStat.Type type) {
        TypedStat stat = ItemStats.getStat(type);
        if (stat == null) {
            return false;
        }
        if (stat instanceof SimpleStat) {
            SimpleStat rs = (SimpleStat)stat;
            double d = rs.getTotal(item, player);
            return d != 0.0;
        }
        if (stat instanceof DurabilityStat) {
            DurabilityStat rs = (DurabilityStat)stat;
            double[] arr = (double[])rs.getRaw(item);
            return arr != null && arr.length == 2;
        }
        return false;
    }

    public static void updateVanillaAttributes(@NotNull ItemStack item, @Nullable Player player) {
        if (EngineCfg.FULL_LEGACY || EngineCfg.LEGACY_COMBAT) {
            return;
        }
        ItemStats.addAttribute(item, player, NBTAttribute.MAX_HEALTH, ItemStats.getStat(item, player, TypedStat.Type.MAX_HEALTH));
        ItemStats.addAttribute(item, player, NBTAttribute.MOVEMENT_SPEED, ItemStats.getStat(item, player, TypedStat.Type.MOVEMENT_SPEED));
        ItemStats.addAttribute(item, player, NBTAttribute.ATTACK_SPEED, ItemStats.getStat(item, player, TypedStat.Type.ATTACK_SPEED));
        ItemStats.addAttribute(item, player, NBTAttribute.KNOCKBACK_RESISTANCE, ItemStats.getStat(item, player, TypedStat.Type.KNOCKBACK_RESISTANCE));
        double vanilla = DamageAttribute.getVanillaDamage(item);
        if (vanilla > 1.0) {
            ItemStats.addAttribute(item, player, NBTAttribute.ATTACK_DAMAGE, vanilla);
        }
        if (ItemUtils.isArmor(item)) {
            double armor = ItemStats.getStat(item, player, TypedStat.Type.ARMOR);
            ItemStats.addAttribute(item, player, NBTAttribute.ARMOR, armor == 0.0 ? DefenseAttribute.getVanillaArmor(item) : armor);
            double toughness = ItemStats.getStat(item, player, TypedStat.Type.ARMOR_TOUGHNESS);
            ItemStats.addAttribute(item, player, NBTAttribute.ARMOR_TOUGHNESS, toughness == 0.0 ? DefenseAttribute.getVanillaToughness(item) : toughness);
        }
        ItemMeta im = item.getItemMeta();
        if (Version.CURRENT.isAtLeast(Version.V1_20_R4)) {
            Attribute moveSpeed = VersionManager.getNms().getAttribute("MOVEMENT_SPEED");
            if (im.getAttributeModifiers(VersionManager.getNms().getAttribute("MOVEMENT_SPEED")) == null) {
                im.addAttributeModifier(moveSpeed, new AttributeModifier(moveSpeed.getKey().getKey(), 0.0, AttributeModifier.Operation.ADD_NUMBER));
            }
        }
        im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS});
        item.setItemMeta(im);
    }

    private static void addAttribute(@NotNull ItemStack item, @Nullable Player player, @NotNull NBTAttribute att, double value) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        if (att == NBTAttribute.ATTACK_DAMAGE && ItemUtils.isBow(item)) {
            return;
        }
        if (value == 0.0) {
            boolean isAttackSpeed;
            boolean isWeapon = ItemUtils.isWeapon(item);
            boolean bl = isAttackSpeed = att == NBTAttribute.ATTACK_SPEED;
            if (!isAttackSpeed && isWeapon) {
                return;
            }
            double defaultAttackSpeed = SimpleStat.getDefaultAttackSpeed(item, 4.0);
            double baseAttackSpeed = ItemStats.getStat(item, player, TypedStat.Type.BASE_ATTACK_SPEED, 4.0);
            if (baseAttackSpeed == defaultAttackSpeed) {
                return;
            }
        }
        if (att == NBTAttribute.MOVEMENT_SPEED) {
            value = 0.1 * (1.0 + value / 100.0) - 0.1;
        } else if (att == NBTAttribute.ATTACK_SPEED) {
            value /= 100.0;
            boolean isArmor = ItemUtils.isArmor(item);
            double weaponModifier = SimpleStat.getDefaultAttackSpeed(item, 4.0) + 4.0;
            double baseSpeedModifier = ItemStats.getStat(item, player, TypedStat.Type.BASE_ATTACK_SPEED, weaponModifier);
            double baseSpeed = baseSpeedModifier - 4.0;
            if (isArmor) {
                baseSpeed = baseSpeedModifier;
            }
            value = baseSpeed * (1.0 + value);
        }
        for (EquipmentSlot slot : ItemUtils.getItemSlots(item)) {
            if (slot == EquipmentSlot.OFF_HAND && (att == NBTAttribute.ATTACK_DAMAGE || att == NBTAttribute.ATTACK_SPEED) || slot != EquipmentSlot.HAND && !ItemUtils.isArmor(item) && att == NBTAttribute.ATTACK_SPEED) continue;
            AttributeModifier am = new AttributeModifier(att.getUUID(slot), att.getNmsName(), value, AttributeModifier.Operation.ADD_NUMBER, slot);
            meta.removeAttributeModifier(att.getAttribute());
            meta.addAttributeModifier(att.getAttribute(), am);
        }
        item.setItemMeta(meta);
    }

    @NotNull
    public static Collection<AmmoAttribute> getAmmos() {
        return AMMO.values();
    }

    @Nullable
    public static AmmoAttribute getAmmo(@NotNull AmmoAttribute.Type type) {
        return AMMO.get((Object)type);
    }

    @Nullable
    public static AmmoAttribute getAmmo(@NotNull ItemStack item) {
        for (AmmoAttribute ammo : ItemStats.getAmmos()) {
            String value = (String)ammo.getRaw(item);
            if (value == null) continue;
            return ammo;
        }
        return null;
    }

    @NotNull
    public static Collection<HandAttribute> getHands() {
        return HANDS.values();
    }

    @Nullable
    public static HandAttribute getHand(@NotNull HandAttribute.Type type) {
        return HANDS.get((Object)type);
    }

    @Nullable
    public static HandAttribute getHand(@NotNull ItemStack item) {
        for (HandAttribute hand : ItemStats.getHands()) {
            String value = (String)hand.getRaw(item);
            if (value == null) continue;
            return hand;
        }
        return null;
    }

    public static void registerAttribute(@NotNull ItemLoreStat<?> att) {
        ATTRIBUTES.put(att.getId(), att);
    }

    @NotNull
    public static Collection<ItemLoreStat<?>> getAttributes() {
        return ATTRIBUTES.values();
    }

    @Nullable
    public static ItemLoreStat<?> getAttribute(@NotNull String id) {
        return ATTRIBUTES.get(id.toLowerCase());
    }

    @Nullable
    public static <T extends ItemLoreStat<?>> T getAttribute(@NotNull Class<T> clazz) {
        for (ItemLoreStat<?> stat : ItemStats.getAttributes()) {
            Class<?> clazz2 = stat.getClass();
            if (!clazz.isAssignableFrom(clazz2)) continue;
            return (T)stat;
        }
        return null;
    }

    public static void registerSocket(@NotNull SocketAttribute socket) {
        SocketAttribute.Type type = socket.getType();
        Map<String, SocketAttribute> map = SOCKETS.get((Object)type);
        if (map == null) {
            map = new HashMap<String, SocketAttribute>();
        }
        map.put(socket.getId(), socket);
        SOCKETS.put(type, map);
    }

    @Nullable
    public static SocketAttribute getSocket(@NotNull SocketAttribute.Type type, @NotNull String id) {
        Map<String, SocketAttribute> map = SOCKETS.get((Object)type);
        if (map == null) {
            return null;
        }
        return map.get(id.toLowerCase());
    }

    @NotNull
    public static Collection<SocketAttribute> getSockets(@NotNull SocketAttribute.Type type) {
        Map<String, SocketAttribute> map = SOCKETS.get((Object)type);
        if (map == null) {
            return Collections.emptySet();
        }
        return map.values();
    }

    public static void setId(@NotNull ItemStack item, @NotNull String id) {
        DataUT.setData((ItemStack)item, (NamespacedKey)KEY_ID.get(0), (Object)id);
    }

    @Nullable
    public static String getId(@NotNull ItemStack item) {
        for (NamespacedKey key : KEY_ID) {
            String data = DataUT.getStringData((ItemStack)item, (NamespacedKey)key);
            if (data == null) continue;
            return data;
        }
        return null;
    }

    public static void setLevel(@NotNull ItemStack item, int lvl) {
        if (lvl < 1) {
            for (NamespacedKey key : KEY_LEVEL) {
                DataUT.removeData((ItemStack)item, (NamespacedKey)key);
            }
            return;
        }
        DataUT.setData((ItemStack)item, (NamespacedKey)KEY_LEVEL.get(0), (Object)lvl);
    }

    public static int getLevel(@NotNull ItemStack item) {
        for (NamespacedKey key : KEY_LEVEL) {
            int data = DataUT.getIntData((ItemStack)item, (NamespacedKey)key);
            if (data == 0) continue;
            return data;
        }
        return 0;
    }

    public static void setModule(@NotNull ItemStack item, @NotNull String mod) {
        DataUT.setData((ItemStack)item, (NamespacedKey)KEY_MODULE.get(0), (Object)mod);
    }

    @Nullable
    public static QModuleDrop<?> getModule(@NotNull ItemStack item) {
        NamespacedKey key;
        String data = null;
        Iterator<NamespacedKey> iterator = KEY_MODULE.iterator();
        while (iterator.hasNext() && (data = DataUT.getStringData((ItemStack)item, (NamespacedKey)(key = iterator.next()))) == null) {
        }
        if (data == null) {
            return null;
        }
        IModule mod = plugin.getModuleManager().getModule(data);
        if (mod instanceof QModuleDrop) {
            return (QModuleDrop)mod;
        }
        return null;
    }

    public static void setSocketRate(@NotNull ItemStack item, int rate) {
        DataUT.setData((ItemStack)item, (NamespacedKey)KEY_SOCKET.get(0), (Object)rate);
    }

    public static int getSocketRate(@NotNull ItemStack item) {
        for (NamespacedKey key : KEY_SOCKET) {
            int data = DataUT.getIntData((ItemStack)item, (NamespacedKey)key);
            if (data == 0) continue;
            return data;
        }
        return 0;
    }
}

