/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.stats.bonus;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.util.NumberUT;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.config.EngineCfg;
import studio.magemonkey.divinity.hooks.external.FabledHook;
import studio.magemonkey.divinity.stats.items.ItemStats;
import studio.magemonkey.divinity.stats.items.api.ItemLoreStat;
import studio.magemonkey.divinity.stats.items.attributes.AmmoAttribute;
import studio.magemonkey.divinity.stats.items.attributes.DamageAttribute;
import studio.magemonkey.divinity.stats.items.attributes.DefenseAttribute;
import studio.magemonkey.divinity.stats.items.attributes.FabledAttribute;
import studio.magemonkey.divinity.stats.items.attributes.HandAttribute;
import studio.magemonkey.divinity.stats.items.attributes.api.SimpleStat;
import studio.magemonkey.divinity.stats.items.attributes.api.TypedStat;

public class BonusMap {
    private final Map<ItemLoreStat<?>, BiFunction<Boolean, Double, Double>> bonus = new HashMap();

    public BonusMap() {
    }

    public BonusMap(@NotNull BonusMap from) {
        this();
        this.bonus.putAll(from.bonus);
    }

    public void clear() {
        this.bonus.clear();
    }

    public boolean isEmpty() {
        return this.bonus.isEmpty();
    }

    @NotNull
    public Map<ItemLoreStat<?>, BiFunction<Boolean, Double, Double>> getBonuses() {
        return this.bonus;
    }

    @NotNull
    public Map<SimpleStat, BiFunction<Boolean, Double, Double>> getStatBonuses() {
        return this.bonus.entrySet().stream().filter(entry -> entry.getKey() instanceof SimpleStat).collect(Collectors.toMap(key -> (SimpleStat)key.getKey(), Map.Entry::getValue, (has, add) -> has));
    }

    @NotNull
    public Map<DamageAttribute, BiFunction<Boolean, Double, Double>> getDamageBonuses() {
        return this.bonus.entrySet().stream().filter(entry -> entry.getKey() instanceof DamageAttribute).collect(Collectors.toMap(key -> (DamageAttribute)key.getKey(), Map.Entry::getValue, (has, add) -> has));
    }

    @NotNull
    public Map<DefenseAttribute, BiFunction<Boolean, Double, Double>> getDefenseBonuses() {
        return this.bonus.entrySet().stream().filter(entry -> entry.getKey() instanceof DefenseAttribute).collect(Collectors.toMap(key -> (DefenseAttribute)key.getKey(), Map.Entry::getValue, (has, add) -> has));
    }

    @NotNull
    public Map<FabledAttribute, BiFunction<Boolean, Double, Double>> getFabledAttributeBonuses() {
        return this.bonus.entrySet().stream().filter(entry -> entry.getKey() instanceof FabledAttribute).collect(Collectors.toMap(key -> (FabledAttribute)key.getKey(), Map.Entry::getValue, (has, add) -> has));
    }

    @NotNull
    public Map<AmmoAttribute, BiFunction<Boolean, Double, Double>> getAmmoBonuses() {
        return this.bonus.entrySet().stream().filter(entry -> entry.getKey() instanceof AmmoAttribute).collect(Collectors.toMap(key -> (AmmoAttribute)key.getKey(), Map.Entry::getValue, (has, add) -> has));
    }

    @NotNull
    public Map<HandAttribute, BiFunction<Boolean, Double, Double>> getHandBonuses() {
        return this.bonus.entrySet().stream().filter(entry -> entry.getKey() instanceof HandAttribute).collect(Collectors.toMap(key -> (HandAttribute)key.getKey(), Map.Entry::getValue, (has, add) -> has));
    }

    @Nullable
    public BiFunction<Boolean, Double, Double> getBonus(@NotNull ItemLoreStat<?> stat) {
        return this.bonus.getOrDefault(stat, null);
    }

    public void loadStats(@NotNull JYML cfg, @NotNull String path) {
        for (String id : cfg.getSection(path)) {
            TypedStat.Type dt = TypedStat.Type.getByName(id);
            if (dt == null) continue;
            ItemLoreStat mainStat = (ItemLoreStat)((Object)ItemStats.getStat(dt));
            String sVal = cfg.getString(path + "." + id);
            if (sVal == null) continue;
            String[] split = sVal.split("%", 2);
            boolean perc = split.length == 2 && split[1].isEmpty();
            double val = StringUT.getDouble((String)split[0], (double)0.0, (boolean)true);
            BiFunction<Boolean, Double, Double> func = (isBonus, apply) -> perc == isBonus ? apply + val : apply;
            this.bonus.put(mainStat, func);
        }
    }

    public void loadDamages(@NotNull JYML cfg, @NotNull String path) {
        for (String id : cfg.getSection(path)) {
            String sVal;
            DamageAttribute dt = ItemStats.getDamageById(id);
            if (dt == null || (sVal = cfg.getString(path + "." + id)) == null) continue;
            String[] split = sVal.split("%", 2);
            boolean perc = split.length == 2 && split[1].isEmpty();
            double val = StringUT.getDouble((String)split[0], (double)0.0, (boolean)true);
            BiFunction<Boolean, Double, Double> func = (bonus, apply) -> perc == bonus ? apply + val : apply;
            this.bonus.put(dt, func);
        }
    }

    public void loadDefenses(@NotNull JYML cfg, @NotNull String path) {
        for (String id : cfg.getSection(path)) {
            String sVal;
            DefenseAttribute dt = ItemStats.getDefenseById(id);
            if (dt == null || (sVal = cfg.getString(path + "." + id)) == null) continue;
            String[] split = sVal.split("%", 2);
            boolean perc = split.length == 2 && split[1].isEmpty();
            double val = StringUT.getDouble((String)split[0], (double)0.0, (boolean)true);
            BiFunction<Boolean, Double, Double> func = (bonus, apply) -> perc == bonus ? apply + val : apply;
            this.bonus.put(dt, func);
        }
    }

    public void loadFabledAttributes(@NotNull JYML cfg, @NotNull String path) {
        for (String id : cfg.getSection(path)) {
            String sVal;
            Collection<FabledAttribute> attributes;
            FabledAttribute stat;
            FabledHook fabledHook = (FabledHook)Divinity.getInstance().getHook("Fabled");
            if (fabledHook == null || (stat = (FabledAttribute)(attributes = fabledHook.getAttributes()).stream().filter(attribute -> attribute.getId().equalsIgnoreCase(id)).findAny().orElse(null)) == null || (sVal = cfg.getString(path + "." + id)) == null) continue;
            String[] split = sVal.split("%", 2);
            boolean perc = split.length == 2 && split[1].isEmpty();
            double val = StringUT.getDouble((String)split[0], (double)0.0, (boolean)true);
            BiFunction<Boolean, Double, Double> func = (isBonus, apply) -> perc == isBonus ? apply + val : apply;
            this.bonus.put(stat, func);
        }
    }

    public void loadAmmo(@NotNull JYML cfg, @NotNull String path) {
        for (String id : cfg.getSection(path)) {
            AmmoAttribute stat;
            try {
                stat = ItemStats.getAmmo(AmmoAttribute.Type.valueOf(id.toUpperCase()));
                if (stat == null) {
                }
            }
            catch (IllegalArgumentException e) {}
            continue;
            String sVal = cfg.getString(path + "." + id);
            if (sVal == null) continue;
            String[] split = sVal.split("%", 2);
            boolean perc = split.length == 2 && split[1].isEmpty();
            double val = StringUT.getDouble((String)split[0], (double)0.0, (boolean)true);
            BiFunction<Boolean, Double, Double> func = (isBonus, apply) -> perc == isBonus ? apply + val : apply;
            this.bonus.put(stat, func);
        }
    }

    public void loadHands(@NotNull JYML cfg, @NotNull String path) {
        for (String id : cfg.getSection(path)) {
            HandAttribute stat;
            try {
                stat = ItemStats.getHand(HandAttribute.Type.valueOf(id.toUpperCase()));
                if (stat == null) {
                }
            }
            catch (IllegalArgumentException e) {}
            continue;
            String sVal = cfg.getString(path + "." + id);
            if (sVal == null) continue;
            String[] split = sVal.split("%", 2);
            boolean perc = split.length == 2 && split[1].isEmpty();
            double val = StringUT.getDouble((String)split[0], (double)0.0, (boolean)true);
            BiFunction<Boolean, Double, Double> func = (isBonus, apply) -> perc == isBonus ? apply + val : apply;
            this.bonus.put(stat, func);
        }
    }

    @NotNull
    public String replacePlaceholders(@NotNull String str) {
        for (Map.Entry<ItemLoreStat<?>, BiFunction<Boolean, Double, Double>> e : this.bonus.entrySet()) {
            double valRaw = e.getValue().apply(false, 0.0);
            double valBonus = e.getValue().apply(true, 0.0);
            double valTotal = valRaw != 0.0 ? valRaw : valBonus;
            Object valFormat = NumberUT.format((double)valTotal);
            String valStr = valBonus != 0.0 ? (valFormat = (String)valFormat + EngineCfg.LORE_CHAR_PERCENT) : valFormat;
            str = str.replace(e.getKey().getPlaceholder(), valStr);
        }
        return str;
    }
}

