/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.stats.bonus;

import java.util.List;
import java.util.function.BiFunction;

public class BonusCalculator {
    public static final BiFunction<Double, List<BiFunction<Boolean, Double, Double>>, Double> SIMPLE_FULL = (input, bonuses) -> {
        double value = input;
        double percent = 0.0;
        for (BiFunction bif : bonuses) {
            value = (Double)bif.apply(false, value);
            percent = (Double)bif.apply(true, percent);
        }
        return value * (1.0 + percent / 100.0);
    };
    public static final BiFunction<Double, List<BiFunction<Boolean, Double, Double>>, Double> SIMPLE_BONUS = (input, bonuses) -> {
        double value = 0.0;
        double percent = 0.0;
        for (BiFunction bif : bonuses) {
            value = (Double)bif.apply(false, value);
            percent = (Double)bif.apply(true, percent);
        }
        if (value == 0.0 && percent != 0.0) {
            value = input;
        }
        if (percent == 0.0) {
            percent = 100.0;
        }
        return value * (percent / 100.0);
    };
    public static final BiFunction<Double, List<BiFunction<Boolean, Double, Double>>, Double> SIMPLE_DEFAULT = (input, bonuses) -> {
        double result = SIMPLE_BONUS.apply((Double)input, (List<BiFunction<Boolean, Double, Double>>)bonuses);
        return result == 0.0 ? input : result;
    };
    public static final BiFunction<double[], List<BiFunction<Boolean, double[], double[]>>, double[]> RANGE_FULL = (input, bonuses) -> {
        double[] value = input;
        double[] percent = new double[]{0.0};
        for (BiFunction bif : bonuses) {
            value = (double[])bif.apply(false, value);
            percent = (double[])bif.apply(true, percent);
        }
        return new double[]{value[0] * (1.0 + percent[0] / 100.0), value[1] * (1.0 + percent[0] / 100.0)};
    };
}

