/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.sell;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.hooks.external.VaultHK;
import studio.magemonkey.codex.manager.api.gui.ContentType;
import studio.magemonkey.codex.manager.api.gui.GuiClick;
import studio.magemonkey.codex.manager.api.gui.GuiItem;
import studio.magemonkey.codex.manager.api.gui.NGUI;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.NumberUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.list.sell.SellManager;
import studio.magemonkey.divinity.modules.list.sell.event.PlayerPreSellItemEvent;
import studio.magemonkey.divinity.modules.list.sell.event.PlayerSellItemEvent;

class SellGUI
extends NGUI<Divinity> {
    private final int[] itemSlots;
    private final VaultHK vault;

    public SellGUI(@NotNull SellManager sellManager) {
        super((CodexPlugin)((Divinity)sellManager.plugin), sellManager.getJYML(), "gui.");
        JYML cfg = sellManager.getJYML();
        String path = "gui.";
        this.vault = ((Divinity)this.plugin).getVault();
        this.itemSlots = cfg.getIntArray(path + "item-slots");
        GuiClick click = (p, type, e) -> {
            if (type == ContentType.ACCEPT) {
                Inventory inv = e.getInventory();
                HashMap<ItemStack, Double> priceMap = new HashMap<ItemStack, Double>();
                double priceTotal = 0.0;
                for (int slot : this.itemSlots) {
                    ItemStack target = inv.getItem(slot);
                    if (target == null) continue;
                    double price = ((Divinity)this.plugin).getWorthManager().getItemWorth(target);
                    if (price <= 0.0) {
                        ItemUT.addItem((Player)p, (ItemStack[])new ItemStack[]{target});
                        continue;
                    }
                    priceTotal += price;
                    priceMap.computeIfAbsent(target, price2 -> 0.0);
                    priceMap.computeIfPresent(target, (itemKey, priceVal) -> priceVal + price);
                }
                inv.setContents(new ItemStack[0]);
                if (priceTotal > 0.0) {
                    PlayerPreSellItemEvent event1 = new PlayerPreSellItemEvent(p, priceMap);
                    ((Divinity)this.plugin).getPluginManager().callEvent((Event)event1);
                    if (event1.isCancelled()) {
                        sellManager.actionsError.process((Entity)p);
                        return;
                    }
                    this.vault.give((OfflinePlayer)p, event1.getPrice());
                    PlayerSellItemEvent event = new PlayerSellItemEvent(p, event1.getPriceMap());
                    ((Divinity)this.plugin).getPluginManager().callEvent((Event)event);
                }
                p.closeInventory();
            } else if (type == ContentType.EXIT) {
                p.closeInventory();
            }
        };
        for (String itemId : cfg.getSection(path + "content")) {
            GuiItem gi = cfg.getGuiItem(path + "content." + itemId, ContentType.class);
            if (gi == null) continue;
            if (gi.getType() != null) {
                gi.setClick(click);
            }
            this.addButton(gi);
        }
    }

    protected void onCreate(@NotNull Player player, @NotNull Inventory inv, int page) {
    }

    protected void onReady(@NotNull Player player, @NotNull Inventory inv, int page) {
        super.onReady(player, inv, page);
        this.update(inv);
    }

    protected boolean ignoreNullClick() {
        return false;
    }

    protected boolean cancelClick(int slot) {
        return slot < this.getSize() && !ArrayUtils.contains((int[])this.itemSlots, (int)slot);
    }

    protected boolean cancelPlayerClick() {
        return false;
    }

    public void click(Player player, @Nullable ItemStack item, int slot, InventoryClickEvent e) {
        if (!this.cancelClick(slot)) {
            ((Divinity)this.plugin).getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.update(e.getInventory()));
        }
        super.click(player, item, slot, e);
    }

    public void onClose(@NotNull Player player, @NotNull InventoryCloseEvent e) {
        Inventory inv = e.getInventory();
        for (int slot : this.itemSlots) {
            ItemStack item = inv.getItem(slot);
            if (item == null) continue;
            ItemUT.addItem((Player)player, (ItemStack[])new ItemStack[]{item});
        }
    }

    private void update(@NotNull Inventory inv) {
        for (GuiItem guiItem : this.getContent().values()) {
            List lore;
            ItemStack item = guiItem.getItem();
            ItemMeta meta = item.getItemMeta();
            if (meta == null) continue;
            String cost = NumberUT.format((double)this.getTotalPrice(inv));
            if (meta.hasDisplayName()) {
                meta.setDisplayName(meta.getDisplayName().replace("%cost%", cost));
            }
            if ((lore = meta.getLore()) != null) {
                lore.replaceAll(str -> str.replace("%cost%", cost));
                meta.setLore(lore);
            }
            item.setItemMeta(meta);
            for (int i : guiItem.getSlots()) {
                inv.setItem(i, item);
            }
        }
    }

    private double getTotalPrice(@NotNull Inventory inv) {
        double cost = 0.0;
        for (int i : this.itemSlots) {
            ItemStack item = inv.getItem(i);
            if (item == null) continue;
            cost += ((Divinity)this.plugin).getWorthManager().getItemWorth(item);
        }
        return cost;
    }
}

