/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.itemgenerator.editor.trimmings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.manager.api.menu.Slot;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.AbstractEditorGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.EditorGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.trimmings.TrimmingGUI;

public class TrimmingListGUI
extends AbstractEditorGUI {
    public TrimmingListGUI(Player player, AbstractEditorGUI.ItemGeneratorReference itemGenerator) {
        super(player, 6, "Editor/" + EditorGUI.ItemType.ARMOR_TRIMINGS.getTitle(), itemGenerator);
    }

    public void setContents() {
        ArmorTrim armorTrim;
        ArmorTrim armorTrim2;
        ArmorTrim armorTrim3;
        ArrayList<ArmorTrim> list = new ArrayList<ArmorTrim>();
        HashMap<ArmorTrim, Double> map = new HashMap<ArmorTrim, Double>();
        ConfigurationSection cfg = this.itemGenerator.getConfig().getConfigurationSection(EditorGUI.ItemType.ARMOR_TRIMINGS.getPath());
        if (cfg != null) {
            for (Object key : cfg.getKeys(false)) {
                TrimPattern trimPattern;
                Iterator trimMaterial;
                if (((String)key).equals("none")) {
                    map.put(null, cfg.getDouble((String)key));
                    continue;
                }
                String[] split = ((String)key).toLowerCase().split(":");
                if (split.length != 2) continue;
                if (split[0].equals("*")) {
                    trimMaterial = null;
                } else {
                    trimMaterial = (TrimMaterial)Registry.TRIM_MATERIAL.get(NamespacedKey.minecraft((String)split[0]));
                    if (trimMaterial == null) continue;
                }
                if (split[1].equals("*")) {
                    trimPattern = null;
                } else {
                    trimPattern = (TrimPattern)Registry.TRIM_PATTERN.get(NamespacedKey.minecraft((String)split[1]));
                    if (trimPattern == null) continue;
                }
                armorTrim3 = new ArmorTrim((TrimMaterial)trimMaterial, trimPattern);
                map.put(armorTrim3, cfg.getDouble((String)key));
                list.add(armorTrim3);
            }
        }
        ArmorTrim next = null;
        block1: for (TrimMaterial trimMaterial : Registry.TRIM_MATERIAL) {
            for (TrimPattern trimPattern : Registry.TRIM_PATTERN) {
                armorTrim3 = new ArmorTrim(trimMaterial, trimPattern);
                if (map.containsKey(armorTrim3)) continue;
                next = armorTrim3;
                break block1;
            }
        }
        if (next == null) {
            for (TrimMaterial trimMaterial : Registry.TRIM_MATERIAL) {
                armorTrim2 = new ArmorTrim(trimMaterial, null);
                if (map.containsKey(armorTrim2)) continue;
                next = armorTrim2;
                break;
            }
        }
        if (next == null) {
            for (TrimPattern trimPattern : Registry.TRIM_PATTERN) {
                armorTrim2 = new ArmorTrim(null, trimPattern);
                if (map.containsKey(armorTrim2)) continue;
                next = armorTrim2;
                break;
            }
        }
        if (next == null && !map.containsKey(armorTrim = new ArmorTrim(null, null))) {
            next = armorTrim;
        }
        if (next != null) {
            list.add(null);
        }
        int i = 0;
        for (final ArmorTrim trim : list) {
            if (++i % this.inventory.getSize() == 53) {
                this.setSlot(i, this.getNextButton());
                ++i;
            } else if (i % 9 == 8) {
                ++i;
            }
            if (i % this.inventory.getSize() == 45) {
                this.setSlot(i, this.getPrevButton());
                ++i;
            } else if (i % 9 == 0) {
                ++i;
            }
            if (i == 1) {
                final double weight = map.getOrDefault(null, 0.0);
                this.setSlot(i, new Slot(TrimmingListGUI.createItem(Material.FLINT, "&eNone", "&bWeight: &a" + weight, "&6Left-Click: &eModify", "&6Right-Click: &eRemove")){

                    public void onLeftClick() {
                        TrimmingListGUI.this.sendSetMessage("weight for this trim", String.valueOf(weight), s -> {
                            TrimmingListGUI.this.itemGenerator.getConfig().set(TrimmingListGUI.getPath(null), (Object)Double.parseDouble(s));
                            TrimmingListGUI.this.saveAndReopen();
                        });
                    }

                    public void onRightClick() {
                        TrimmingListGUI.this.itemGenerator.getConfig().remove(TrimmingListGUI.getPath(null));
                        TrimmingListGUI.this.saveAndReopen();
                    }
                });
                ++i;
            }
            if (trim == null) {
                final ArmorTrim finalNext = Objects.requireNonNull(next);
                this.setSlot(i, new Slot(TrimmingListGUI.createItem(Material.REDSTONE, "&eAdd new trimming", new String[0])){

                    public void onLeftClick() {
                        TrimmingListGUI.this.itemGenerator.getConfig().set(TrimmingListGUI.getPath(finalNext), (Object)0);
                        TrimmingListGUI.this.saveAndReopen();
                    }
                });
                continue;
            }
            final double weight = (Double)map.get(trim);
            this.setSlot(i, new Slot(trim.toItemStack(weight)){

                public void onLeftClick() {
                    TrimmingListGUI.this.openSubMenu(new TrimmingGUI(TrimmingListGUI.this.player, TrimmingListGUI.this.itemGenerator, new TrimmingEntry(trim, weight)));
                }

                public void onRightClick() {
                    TrimmingListGUI.this.itemGenerator.getConfig().remove(TrimmingListGUI.getPath(trim));
                    TrimmingListGUI.this.saveAndReopen();
                }
            });
        }
        if (list.get(list.size() - 1) == null) {
            list.remove(list.size() - 1);
        }
        this.setSlot(this.getPages() * this.inventory.getSize() - 9, this.getPrevButton());
        this.setSlot(this.getPages() * this.inventory.getSize() - 1, this.getNextButton());
    }

    public static String getPath(ArmorTrim armorTrim) {
        return EditorGUI.ItemType.ARMOR_TRIMINGS.getPath() + "." + (String)(armorTrim == null ? "none" : (armorTrim.getMaterial() == null ? "*" : armorTrim.getMaterial().getKey().getKey()) + ":" + (armorTrim.getPattern() == null ? "*" : armorTrim.getPattern().getKey().getKey()));
    }

    public static class ArmorTrim {
        private TrimMaterial trimMaterial;
        private TrimPattern trimPattern;

        public ArmorTrim(TrimMaterial material, TrimPattern pattern) {
            this.trimMaterial = material;
            this.trimPattern = pattern;
        }

        @Nullable
        public TrimMaterial getMaterial() {
            return this.trimMaterial;
        }

        public void setMaterial(@Nullable TrimMaterial trimMaterial) {
            this.trimMaterial = trimMaterial;
        }

        @Nullable
        public TrimPattern getPattern() {
            return this.trimPattern;
        }

        public void setPattern(@Nullable TrimPattern trimPattern) {
            this.trimPattern = trimPattern;
        }

        public ItemStack toItemStack(double weight) {
            Material material = this.trimMaterial == null ? (this.trimPattern == null ? Material.CRAFTING_TABLE : TrimmingGUI.fromPattern(this.trimPattern)) : (this.trimPattern == null ? TrimmingGUI.fromMaterial(this.trimMaterial) : Material.NETHERITE_CHESTPLATE);
            String trimMaterial = this.trimMaterial == null ? "*" : this.trimMaterial.getKey().getKey();
            String trimPattern = this.trimPattern == null ? "*" : this.trimPattern.getKey().getKey();
            ItemStack itemStack = TrimmingListGUI.createItem(material, "&e" + trimMaterial.substring(0, 1).toUpperCase() + trimMaterial.substring(1) + " " + trimPattern, new String[]{"&bWeight: &a" + weight, "&6Left-Click: &eModify", "&6Right-Click: &eRemove"});
            ItemMeta meta = itemStack.getItemMeta();
            if (meta instanceof ArmorMeta) {
                ((ArmorMeta)meta).setTrim(new org.bukkit.inventory.meta.trim.ArmorTrim(this.trimMaterial, this.trimPattern));
                itemStack.setItemMeta(meta);
            }
            return itemStack;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArmorTrim armorTrim = (ArmorTrim)o;
            return Objects.equals(this.trimMaterial, armorTrim.trimMaterial) && Objects.equals(this.trimPattern, armorTrim.trimPattern);
        }

        public int hashCode() {
            return Objects.hash(this.trimMaterial, this.trimPattern);
        }
    }

    public static class TrimmingEntry {
        private ArmorTrim armorTrim;
        private double weight;

        public TrimmingEntry(ArmorTrim armorTrim, double weight) {
            this.armorTrim = armorTrim;
            this.weight = weight;
        }

        @Generated
        public ArmorTrim getArmorTrim() {
            return this.armorTrim;
        }

        @Generated
        public double getWeight() {
            return this.weight;
        }

        @Generated
        public void setArmorTrim(ArmorTrim armorTrim) {
            this.armorTrim = armorTrim;
        }

        @Generated
        public void setWeight(double weight) {
            this.weight = weight;
        }
    }
}

