/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.api.socketing.merchant;

import org.bukkit.command.CommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.commands.api.ISubCommand;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.manager.api.Loadable;
import studio.magemonkey.codex.modules.IModuleExecutor;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.Perms;
import studio.magemonkey.divinity.modules.api.socketing.ModuleSocket;
import studio.magemonkey.divinity.modules.api.socketing.merchant.MerchantCmd;
import studio.magemonkey.divinity.modules.api.socketing.merchant.MerchantGUI;

public class MerchantSocket
implements Loadable {
    private Divinity plugin;
    private ModuleSocket<?> moduleSocket;
    private JYML cfg;
    private int socketChanceBonusAmount;
    private int socketChanceBonusMax;
    private boolean socketSilentRateEnabled;
    private double socketWorthModifier;
    private double itemWorthModifier;
    private MerchantGUI merchantGUI;

    public MerchantSocket(@NotNull ModuleSocket<?> moduleSocket) {
        this.plugin = (Divinity)moduleSocket.plugin;
        this.moduleSocket = moduleSocket;
    }

    public void setup() {
        try {
            this.cfg = JYML.loadOrExtract((CodexPlugin)this.plugin, (String)(this.moduleSocket.getPath() + "merchant.yml"));
        }
        catch (InvalidConfigurationException e) {
            this.plugin.error("Failed to load merchant config (" + this.moduleSocket.getPath() + "merchant.yml): Configuration error");
            e.printStackTrace();
            this.shutdown();
            return;
        }
        String path = "socketing.";
        this.socketChanceBonusAmount = this.cfg.getInt(path + "chance.merchant-bonus.amount", 15);
        this.socketChanceBonusMax = this.cfg.getInt(path + "chance.merchant-bonus.maximal", 80);
        this.socketSilentRateEnabled = this.cfg.getBoolean(path + "silent-rate-bonus.enabled", false);
        path = "price.";
        this.socketWorthModifier = this.cfg.getDouble(path + "socket-worth-modifier", 1.0);
        this.itemWorthModifier = this.cfg.getDouble(path + "item-worth-modifier", 0.6);
        this.merchantGUI = new MerchantGUI(this.moduleSocket, this);
        IModuleExecutor exec = this.moduleSocket.getExecutor();
        if (exec != null) {
            exec.addSubCommand((ISubCommand)new MerchantCmd(this.moduleSocket, this));
        }
    }

    public void shutdown() {
        if (this.merchantGUI != null) {
            this.merchantGUI.shutdown();
            this.merchantGUI = null;
        }
        this.cfg = null;
    }

    public void openMerchantGUI(@NotNull Player player, boolean force) {
        if (!force && !player.hasPermission(Perms.getSocketGuiMerchant(this.moduleSocket))) {
            this.plugin.lang().Error_NoPerm.send((CommandSender)player);
            return;
        }
        this.getMerchantGUI().open(player, 1);
    }

    @NotNull
    public JYML getConfig() {
        return this.cfg;
    }

    @NotNull
    public MerchantGUI getMerchantGUI() {
        return this.merchantGUI;
    }

    public int getSocketChanceBonusAmount() {
        return this.socketChanceBonusAmount;
    }

    public int getSocketChanceBonusMax() {
        return this.socketChanceBonusMax;
    }

    public boolean isSocketSilentRateEnabled() {
        return this.socketSilentRateEnabled;
    }

    public double getSocketWorthModifier() {
        return this.socketWorthModifier;
    }

    public double getItemWorthModifier() {
        return this.itemWorthModifier;
    }
}

