/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.api.socketing;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.compat.VersionManager;
import studio.magemonkey.codex.util.CollectionsUT;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.codex.util.actions.ActionManipulator;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.Perms;
import studio.magemonkey.divinity.manager.interactions.api.AnimatedSuccessBar;
import studio.magemonkey.divinity.modules.SocketItem;
import studio.magemonkey.divinity.modules.api.QModuleDrop;
import studio.magemonkey.divinity.modules.api.socketing.UserGUI;
import studio.magemonkey.divinity.modules.api.socketing.merchant.MerchantSocket;
import studio.magemonkey.divinity.stats.items.ItemStats;
import studio.magemonkey.divinity.stats.items.attributes.SocketAttribute;
import studio.magemonkey.divinity.stats.items.requirements.ItemRequirements;
import studio.magemonkey.divinity.stats.items.requirements.item.ItemSocketRequirement;

public abstract class ModuleSocket<I extends SocketItem>
extends QModuleDrop<I> {
    protected SocketAttribute.Type socketType;
    protected boolean allowDuplicatedSockets;
    protected ActionManipulator actionsComplete;
    protected ActionManipulator actionsError;
    protected AnimatedSuccessBar.Builder animation;
    protected TreeMap<Integer, Integer> silentRateBonusMap;
    protected int silentRateBonusCap;
    protected Map<String, Integer> userSilentRateBonusMap;
    protected boolean failDestroyTarget;
    protected boolean failDestroySource;
    protected boolean failWipeSockets;
    protected UserGUI guiUser;
    protected MerchantSocket merchant;

    public ModuleSocket(@NotNull Divinity plugin, @NotNull Class<I> clazz) {
        super(plugin, clazz);
    }

    @Override
    protected void loadSettings() {
        super.loadSettings();
        String path = "socketing.";
        this.allowDuplicatedSockets = this.cfg.getBoolean(path + "allow-duplicated-items");
        String path2 = path + "animated-bar.";
        this.cfg.addMissing(path2 + "enabled", (Object)true);
        this.cfg.addMissing(path2 + "bar-title", (Object)"&e&lSocketing...");
        this.cfg.addMissing(path2 + "bar-char", (Object)"\u25fc");
        this.cfg.addMissing(path2 + "bar-size", (Object)20);
        this.cfg.addMissing(path2 + "bar-format", (Object)"&a&l%success%%&r %bar%&r &c&l%failure%%");
        this.cfg.addMissing(path2 + "color-neutral", (Object)ChatColor.DARK_GRAY.name());
        this.cfg.addMissing(path2 + "color-success", (Object)ChatColor.GREEN.name());
        this.cfg.addMissing(path2 + "color-failure", (Object)ChatColor.RED.name());
        this.cfg.addMissing(path2 + "fill-interval", (Object)1);
        this.cfg.addMissing(path2 + "fill-amount", (Object)1);
        this.cfg.addMissing(path2 + "min-success", (Object)50);
        if (this.cfg.getBoolean(path + "animated-bar.enabled")) {
            String barTitle = this.cfg.getString(path2 + "bar-title", "&e&lSocketing...");
            String barChar = this.cfg.getString(path2 + "bar-char", "\u25fc");
            String barFormat = this.cfg.getString(path2 + "bar-format", "%bar%");
            int barSize = this.cfg.getInt(path2 + "bar-size", 20);
            ChatColor barColorNeutral = (ChatColor)CollectionsUT.getEnum((String)this.cfg.getString(path2 + "color-neutral", "DARK_GRAY"), ChatColor.class);
            ChatColor barColorGood = (ChatColor)CollectionsUT.getEnum((String)this.cfg.getString(path2 + "color-success", "GREEN"), ChatColor.class);
            ChatColor barColorBad = (ChatColor)CollectionsUT.getEnum((String)this.cfg.getString(path2 + "color-failure", "RED"), ChatColor.class);
            long fillInterval = this.cfg.getLong(path2 + "fill-interval", 1L);
            int fillAmount = this.cfg.getInt(path2 + "fill-amount", 1);
            this.animation = new AnimatedSuccessBar.Builder((Divinity)this.plugin, barTitle, barChar).setBarFormat(barFormat).setColorNeutral(barColorNeutral == null ? ChatColor.DARK_GRAY : barColorNeutral).setColorSuccess(barColorGood == null ? ChatColor.GREEN : barColorGood).setColorBad(barColorBad == null ? ChatColor.RED : barColorBad).setBarSize(barSize).setFillInterval(fillInterval).setFillAmount(fillAmount);
        }
        this.actionsComplete = new ActionManipulator((CodexPlugin)this.plugin, this.cfg, path + "actions-complete");
        this.actionsError = new ActionManipulator((CodexPlugin)this.plugin, this.cfg, path + "actions-error");
        path = "socketing.failure.";
        this.failDestroyTarget = this.cfg.getBoolean(path + "destroy-target", true);
        this.failDestroySource = this.cfg.getBoolean(path + "destroy-source");
        this.failWipeSockets = this.cfg.getBoolean(path + "wipe-filled-sockets");
        this.guiUser = new UserGUI(this);
        path = "socketing.merchant";
        this.cfg.addMissing(path + "enabled", (Object)true);
        if (this.cfg.getBoolean(path + "enabled")) {
            this.merchant = new MerchantSocket(this);
            this.merchant.setup();
        }
        if (!this.cfg.contains((path = "socketing.failure.silent-rate-bonus.") + "by-item-sockets")) {
            this.cfg.set(path + "by-item-sockets.0", (Object)7);
            this.cfg.set(path + "by-item-sockets.1", (Object)5);
            this.cfg.set(path + "by-item-sockets.2", (Object)3);
        }
        this.silentRateBonusMap = new TreeMap();
        for (String sLvl : this.cfg.getSection(path + "by-item-sockets")) {
            int lvl = StringUT.getInteger((String)sLvl, (int)-1);
            if (lvl < 0) continue;
            this.silentRateBonusMap.put(lvl, this.cfg.getInt(path + "by-item-sockets." + sLvl));
        }
        this.userSilentRateBonusMap = new HashMap<String, Integer>();
        this.cfg.saveChanges();
    }

    @Override
    public void unload() {
        if (this.merchant != null) {
            this.merchant.shutdown();
            this.merchant = null;
        }
        if (this.guiUser != null) {
            this.guiUser.shutdown();
            this.guiUser = null;
        }
        if (this.userSilentRateBonusMap != null) {
            this.userSilentRateBonusMap.clear();
            this.userSilentRateBonusMap = null;
        }
        if (this.silentRateBonusMap != null) {
            this.silentRateBonusMap.clear();
            this.silentRateBonusMap = null;
        }
        this.animation = null;
        super.unload();
    }

    @Override
    protected boolean onDragDrop(@NotNull Player player, @NotNull ItemStack src, @NotNull ItemStack target, @NotNull I mItem, @NotNull InventoryClickEvent e) {
        if (!player.hasPermission(Perms.getSocketGuiUser(this))) {
            ((Divinity)this.plugin).lang().Error_NoPerm.send((CommandSender)player);
            return false;
        }
        String id = mItem.getId();
        if (!this.allowDuplicatedSockets && this.hasSocketItem(target, id)) {
            ((Divinity)this.plugin).lang().Module_Item_Socketing_Error_AlreadyHave.replace("%item%", (Object)ItemUT.getItemName((ItemStack)target)).send((CommandSender)player);
            return false;
        }
        if (((Divinity)this.plugin).getInteractionManager().isInAction(player)) {
            ((Divinity)this.plugin).lang().Module_Item_Socketing_Error_InAction.send((CommandSender)player);
            return false;
        }
        VersionManager.getCompat().setCursor((InventoryEvent)e, null);
        this.startSocketing(player, target, src);
        src.setAmount(0);
        return true;
    }

    @NotNull
    public final SocketAttribute.Type getSocketType() {
        if (this.socketType == null) {
            this.socketType = SocketAttribute.Type.getByModule(this);
        }
        return this.socketType;
    }

    @Nullable
    public MerchantSocket getMerchant() {
        return this.merchant;
    }

    @Nullable
    public AnimatedSuccessBar.Builder getAnimation() {
        if (this.animation == null) {
            return null;
        }
        return this.animation.clone();
    }

    public final boolean isDestroyTargetOnFail() {
        return this.failDestroyTarget;
    }

    public final boolean isDestroySourceOnFail() {
        return this.failDestroySource;
    }

    public final boolean isWipeSocketsOnFail() {
        return this.failWipeSockets;
    }

    public final int getSilentRateBonusCap() {
        return this.silentRateBonusCap;
    }

    protected final int getSilentRateBonusBySockets(int lvl) {
        Map.Entry<Integer, Integer> e = this.silentRateBonusMap.floorEntry(lvl);
        if (e == null) {
            return 0;
        }
        return e.getValue();
    }

    public final void addSilentRateBonus(@NotNull Player player, int lvl) {
        int stack = this.getSilentRateBonusBySockets(lvl);
        if (stack == 0) {
            return;
        }
        String key = player.getName();
        if (this.userSilentRateBonusMap.containsKey(key)) {
            stack += this.userSilentRateBonusMap.get(key).intValue();
        }
        this.userSilentRateBonusMap.put(key, Math.min(this.getSilentRateBonusCap(), stack));
    }

    public final int getSilentRateBonus(@NotNull Player player) {
        return this.userSilentRateBonusMap.getOrDefault(player.getName(), 0);
    }

    public final void clearSilentRateBonus(@NotNull Player player) {
        this.userSilentRateBonusMap.remove(player.getName());
    }

    @NotNull
    public final List<Map.Entry<I, Integer>> getItemSockets(@NotNull ItemStack item) {
        ArrayList<Map.Entry<I, Integer>> sockets = new ArrayList<Map.Entry<I, Integer>>();
        ItemMeta meta = item.getItemMeta();
        for (SocketAttribute socket : ItemStats.getSockets(this.getSocketType())) {
            for (String[] v : this.getFilledSocketKeys(meta, socket.getId()).values()) {
                int lvl;
                String id = v[0];
                SocketItem mItem = (SocketItem)this.getItemById(id);
                if (mItem == null || (lvl = StringUT.getInteger((String)v[1], (int)-1)) < 0) continue;
                AbstractMap.SimpleEntry<SocketItem, Integer> entry = new AbstractMap.SimpleEntry<SocketItem, Integer>(mItem, lvl);
                sockets.add(entry);
            }
        }
        return sockets;
    }

    public final boolean hasSocketItem(@NotNull ItemStack item, @NotNull String itemId) {
        ItemMeta meta = item.getItemMeta();
        for (SocketAttribute socket : ItemStats.getSockets(this.getSocketType())) {
            for (String[] values : this.getFilledSocketKeys(meta, socket.getId()).values()) {
                String id = values[0];
                if (!id.equalsIgnoreCase(itemId)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean hasSocketItems(@NotNull ItemStack item, @NotNull String socketCat) {
        return this.getFilledSocketsAmount(item, socketCat) > 0;
    }

    @NotNull
    public final Map<Integer, String[]> getFilledSocketKeys(@NotNull ItemStack item, @NotNull String socketId) {
        TreeMap<Integer, String[]> sockets = new TreeMap<Integer, String[]>();
        SocketAttribute socket = ItemStats.getSocket(this.getSocketType(), socketId);
        if (socket != null) {
            int total = socket.getAmount(item);
            for (int index = 0; index < total; ++index) {
                String[] values = (String[])socket.getRaw(item, index);
                if (values == null || socket.isEmpty(values)) continue;
                sockets.put(index, values);
            }
        }
        return sockets;
    }

    @NotNull
    public final Map<Integer, String[]> getFilledSocketKeys(ItemMeta meta, String socketId) {
        TreeMap<Integer, String[]> sockets = new TreeMap<Integer, String[]>();
        SocketAttribute socket = ItemStats.getSocket(this.getSocketType(), socketId);
        if (socket != null) {
            int total = socket.getAmount(meta);
            for (int index = 0; index < total; ++index) {
                String[] values = (String[])socket.getRaw(meta, index);
                if (values == null || socket.isEmpty(values)) continue;
                sockets.put(index, values);
            }
        }
        return sockets;
    }

    public final int getFilledSocketsAmount(@NotNull ItemStack item, @NotNull String socketId) {
        SocketAttribute socket = ItemStats.getSocket(this.getSocketType(), socketId);
        return socket != null ? socket.getFilledAmount(item) : 0;
    }

    public final int getFreeSocketsAmount(@NotNull ItemStack item, @NotNull String socketId) {
        SocketAttribute socket = ItemStats.getSocket(this.getSocketType(), socketId);
        return socket != null ? socket.getEmptyAmount(item) : 0;
    }

    @NotNull
    public List<ItemStack> extractSocket(@NotNull ItemStack target, @NotNull String socketId, int index) {
        SocketAttribute socket = ItemStats.getSocket(this.getSocketType(), socketId);
        if (socket == null) {
            this.error("Attempt to extract invalid socket type: '" + socketId + "' !");
            return Collections.singletonList(target);
        }
        String[] value = (String[])socket.getRaw(target, index);
        if (value == null || socket.isEmpty(value)) {
            return Collections.singletonList(target);
        }
        SocketItem sock = (SocketItem)this.getItemById(value[0]);
        ItemStack mSockItem = sock.create(Integer.valueOf(value[1]));
        ArrayList<ItemStack> returnItems = new ArrayList<ItemStack>();
        returnItems.add(mSockItem);
        socket.add(target, socket.getDefaultValue(), index, -1);
        returnItems.add(0, target);
        return returnItems;
    }

    public final void startSocketing(@NotNull Player p, @NotNull ItemStack target, @NotNull ItemStack src) {
        this.splitDragItem(p, src, target);
        this.guiUser.open(p, target, src);
    }

    @NotNull
    public ItemStack insertSocket(@NotNull ItemStack item, @NotNull ItemStack src) {
        ItemSocketRequirement socketReq = ItemRequirements.getItemRequirement(ItemSocketRequirement.class);
        if (socketReq == null) {
            return item;
        }
        String[] reqValue = (String[])socketReq.getRaw(src);
        if (reqValue == null || reqValue.length != 2) {
            return item;
        }
        String socketId = reqValue[1];
        SocketAttribute socket = ItemStats.getSocket(this.getSocketType(), socketId);
        if (socket == null) {
            return item;
        }
        int index = socket.getFirstEmptyIndex(item);
        String[] socketValue = new String[]{this.getItemId(src), String.valueOf(ItemStats.getLevel(src))};
        socket.add(item, socketValue, index, -1);
        return item;
    }
}

