/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.manager.listener;

import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.manager.api.Loadable;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.config.EngineCfg;
import studio.magemonkey.divinity.hooks.HookListener;
import studio.magemonkey.divinity.manager.listener.object.DynamicStatListener;
import studio.magemonkey.divinity.manager.listener.object.ItemDurabilityListener;
import studio.magemonkey.divinity.manager.listener.object.ItemHandListener;
import studio.magemonkey.divinity.manager.listener.object.ItemRequirementListener;
import studio.magemonkey.divinity.manager.listener.object.ItemUpdaterListener;
import studio.magemonkey.divinity.manager.listener.object.VanillaWrapperListener;
import studio.magemonkey.divinity.stats.items.ItemStats;
import studio.magemonkey.divinity.stats.items.attributes.stats.DurabilityStat;
import studio.magemonkey.divinity.stats.items.requirements.ItemRequirements;

public class ListenerManager
implements Loadable {
    private final Divinity plugin;
    private ItemDurabilityListener lisDurability;
    private ItemHandListener lisHand;
    private ItemRequirementListener lisReq;
    private DynamicStatListener lisDynamic;
    private ItemUpdaterListener updater;
    private VanillaWrapperListener lisQuantum;
    private HookListener hookListener;

    public ListenerManager(@NotNull Divinity plugin) {
        this.plugin = plugin;
    }

    public void setup() {
        DurabilityStat duraStat = ItemStats.getStat(DurabilityStat.class);
        if (duraStat != null) {
            this.lisDurability = new ItemDurabilityListener(this.plugin, duraStat);
            this.lisDurability.registerListeners();
        }
        if (!ItemStats.getHands().isEmpty()) {
            this.lisHand = new ItemHandListener(this.plugin);
            this.lisHand.registerListeners();
        }
        if (!ItemRequirements.getUserRequirements().isEmpty()) {
            this.lisReq = new ItemRequirementListener(this.plugin);
            this.lisReq.registerListeners();
        }
        this.lisDynamic = new DynamicStatListener(this.plugin);
        this.lisDynamic.registerListeners();
        if (!EngineCfg.LEGACY_COMBAT) {
            this.lisQuantum = new VanillaWrapperListener(this.plugin);
            this.lisQuantum.registerListeners();
            Divinity.getInstance().getLogger().info("Loaded " + ((Object)((Object)this.lisQuantum)).getClass().getSimpleName());
        } else {
            Divinity.getInstance().getLogger().info("Skipped " + VanillaWrapperListener.class.getSimpleName() + " due to legacy combat being enabled.");
        }
        this.updater = new ItemUpdaterListener(this.plugin);
        this.updater.registerListeners();
        this.hookListener = new HookListener(this.plugin);
        this.hookListener.registerListeners();
    }

    public void shutdown() {
        if (this.lisDurability != null) {
            this.lisDurability.unregisterListeners();
            this.lisDurability = null;
        }
        if (this.lisHand != null) {
            this.lisHand.unregisterListeners();
            this.lisHand = null;
        }
        if (this.lisReq != null) {
            this.lisReq.unregisterListeners();
            this.lisReq = null;
        }
        if (this.lisQuantum != null) {
            this.lisQuantum.unregisterListeners();
            this.lisQuantum = null;
        }
    }
}

