/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.manager.effects.main;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.divinity.manager.effects.IEffectType;
import studio.magemonkey.divinity.manager.effects.IExpirableEffect;

public final class ResistEffect
extends IExpirableEffect {
    private Map<IEffectType, Double> resist = new HashMap<IEffectType, Double>();

    private ResistEffect(@NotNull Builder builder) {
        super(builder);
    }

    @Override
    @NotNull
    public IEffectType getType() {
        return IEffectType.RESIST;
    }

    public double getResist(@NotNull IEffectType type) {
        return this.resist.getOrDefault((Object)type, 0.0);
    }

    @Override
    public boolean onTrigger(boolean force) {
        return force;
    }

    @Override
    public void onClear() {
    }

    @Override
    public boolean resetOnDeath() {
        return true;
    }

    public static class Builder
    extends IExpirableEffect.Builder<Builder> {
        private Map<IEffectType, Double> resist = new HashMap<IEffectType, Double>();

        public Builder(double lifeTime) {
            super(lifeTime);
        }

        @NotNull
        public Builder withResist(@NotNull IEffectType type, double resist) {
            this.resist.put(type, resist);
            return this.self();
        }

        @Override
        @NotNull
        public ResistEffect build() {
            return new ResistEffect(this);
        }

        @Override
        @NotNull
        protected Builder self() {
            return this;
        }
    }
}

