/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.hooks.external.mimic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.endlesscode.mimic.classes.BukkitClassSystem;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.divinity.api.DivinityAPI;
import studio.magemonkey.divinity.modules.list.classes.ClassManager;
import studio.magemonkey.divinity.modules.list.classes.api.RPGClass;

public class DivinityClassSystem
extends BukkitClassSystem {
    private static final String ID = "divinity";
    private final ClassManager classManager = DivinityAPI.getModuleManager().getClassManager();

    public DivinityClassSystem(@NotNull Player player) {
        super(player);
    }

    @NotNull
    public List<String> getClasses() {
        RPGClass playerClass = this.getClassData();
        if (playerClass == null) {
            return Collections.emptyList();
        }
        ArrayList<RPGClass> classes = new ArrayList<RPGClass>();
        classes.add(playerClass);
        classes.addAll(playerClass.getParents());
        return classes.stream().map(RPGClass::getName).map(StringUT::colorOff).collect(Collectors.toList());
    }

    @Nullable
    private RPGClass getClassData() {
        return Objects.requireNonNull(this.classManager.getUserData(this.getPlayer())).getPlayerClass();
    }

    public static class Provider
    implements BukkitClassSystem.Provider {
        @NotNull
        public BukkitClassSystem getSystem(@NotNull Player player) {
            return new DivinityClassSystem(player);
        }
    }
}

