/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.data.api;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.data.users.IAbstractUser;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.data.api.UserProfile;

public class DivinityUser
extends IAbstractUser<Divinity> {
    private final Map<String, UserProfile> profiles;
    private transient UserProfile activeProfile;

    public DivinityUser(@NotNull Divinity plugin, @NotNull Player player) {
        this(plugin, player.getUniqueId(), player.getName(), System.currentTimeMillis(), new LinkedHashMap<String, UserProfile>());
    }

    public DivinityUser(@NotNull Divinity plugin, @NotNull UUID uuid, @NotNull String name, long lastOnline, @NotNull Map<String, UserProfile> profiles) {
        super((CodexPlugin)plugin, uuid, name, lastOnline);
        this.profiles = profiles;
        if (this.profiles.isEmpty()) {
            this.setupDefaultProfile();
        } else {
            this.setupActiveProfileByDefault();
        }
    }

    private void setupDefaultProfile() {
        ((Divinity)this.plugin).info("Setup default profile for '" + String.valueOf(this.uuid) + "'");
        this.setActiveProfile(new UserProfile());
        this.profiles.put(this.activeProfile.getIdName(), this.activeProfile);
    }

    private void setupActiveProfileByDefault() {
        block1: {
            UserProfile prof;
            Iterator<UserProfile> iterator = this.profiles.values().iterator();
            while (iterator.hasNext()) {
                prof = iterator.next();
                if (!prof.isDefault()) continue;
                this.setActiveProfile(prof);
                break;
            }
            if (this.activeProfile != null || !(iterator = this.profiles.values().iterator()).hasNext()) break block1;
            prof = iterator.next();
            this.setActiveProfile(prof);
            this.getActiveProfile().setDefault(true);
        }
    }

    @NotNull
    public UserProfile getActiveProfile() {
        return this.activeProfile;
    }

    public void setActiveProfile(@NotNull UserProfile profile) {
        this.activeProfile = profile;
    }

    @NotNull
    public Map<String, UserProfile> getProfileMap() {
        return this.profiles;
    }

    @Nullable
    public UserProfile getProfile(@NotNull String profileId) {
        return this.profiles.get(profileId.toLowerCase());
    }

    public boolean setDefaultProfile(@NotNull String profileId) {
        UserProfile profile = this.getProfile(profileId);
        if (profile == null) {
            return false;
        }
        this.getProfileMap().values().forEach(prof -> prof.setDefault(false));
        profile.setDefault(true);
        return true;
    }

    public boolean addProfile(@NotNull String profileId) {
        UserProfile profile = new UserProfile(profileId, false);
        return this.profiles.put(profileId.toLowerCase(), profile) == null;
    }

    public boolean switchProfile(@NotNull String profileId) {
        UserProfile profile = this.getProfile(profileId);
        if (profile == null) {
            return false;
        }
        this.setActiveProfile(profile);
        return true;
    }

    public boolean deleteProfile(@NotNull String profileId) {
        UserProfile profile = this.getProfile(profileId);
        if (profile == null || profile.getIdName().equalsIgnoreCase("default")) {
            return false;
        }
        if (this.getActiveProfile().equals(profile)) {
            return false;
        }
        this.profiles.remove(profile.getIdName());
        if (profile.isDefault()) {
            this.getProfileMap().values().stream().findFirst().get().setDefault(true);
        }
        profile = null;
        return true;
    }
}

