/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.utils.actions.executors;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.util.actions.actions.IActionExecutor;
import studio.magemonkey.codex.util.actions.params.IParamResult;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.utils.ParticleUtils;

public class ActionParticlePulse
extends IActionExecutor {
    public ActionParticlePulse(@NotNull Divinity plugin) {
        super((CodexPlugin)plugin, "PARTICLE_PULSE");
    }

    public void registerParams() {
        this.registerParam("DELAY");
        this.registerParam("TARGET");
        this.registerParam("NAME");
    }

    protected void execute(Entity exe, Set<Entity> targets, IParamResult result) {
        String name = result.getParamValue("NAME").getString("REDSTONE-CRIT_MAGIC");
        String[] split = name.split("-");
        String eff1 = split[0];
        String eff2 = "";
        if (split.length > 1) {
            eff2 = split[1];
        }
        if (!targets.isEmpty()) {
            for (Entity e : targets) {
                ParticleUtils.spiral(e.getLocation(), eff1, eff2);
            }
        } else {
            ParticleUtils.spiral(exe.getLocation(), eff1, eff2);
        }
    }

    public boolean mustHaveTarget() {
        return false;
    }

    @NotNull
    public List<String> getDescription() {
        return Arrays.asList("Draws a particle wave");
    }
}

