/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.runes;

import java.util.Map;
import java.util.TreeMap;
import net.citizensnpcs.api.trait.TraitInfo;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.hooks.external.citizens.CitizensHK;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.SocketItem;
import studio.magemonkey.divinity.modules.api.socketing.ModuleSocket;
import studio.magemonkey.divinity.modules.list.runes.merchant.MerchantTrait;
import studio.magemonkey.divinity.stats.EntityStats;

public class RuneManager
extends ModuleSocket<Rune> {
    public RuneManager(@NotNull Divinity plugin) {
        super(plugin, Rune.class);
    }

    @NotNull
    public String getId() {
        return "runes";
    }

    @NotNull
    public String version() {
        return "1.21";
    }

    public void setup() {
    }

    public void shutdown() {
    }

    @Override
    protected void onPostSetup() {
        super.onPostSetup();
        CitizensHK citizensHook = ((Divinity)this.plugin).getCitizens();
        if (citizensHook != null) {
            TraitInfo trait = TraitInfo.create(MerchantTrait.class);
            citizensHook.registerTrait((CodexPlugin)this.plugin, trait);
        }
    }

    public void addRuneEffects(@NotNull LivingEntity entity) {
        EntityStats stats = EntityStats.get(entity);
        for (ItemStack item : stats.getEquipment()) {
            for (Map.Entry e : this.getItemSockets(item)) {
                int lvl;
                Rune rune = (Rune)e.getKey();
                PotionEffect effect = rune.getEffect(lvl = e.getValue().intValue());
                if (effect == null) continue;
                stats.addPermaPotionEffect(effect);
            }
        }
    }

    public class Rune
    extends SocketItem {
        private final TreeMap<Integer, PotionEffect> effects;

        public Rune(@NotNull Divinity plugin, JYML cfg) {
            super(plugin, cfg, (ModuleSocket<?>)RuneManager.this);
            PotionEffectType type = PotionEffectType.getByName((String)cfg.getString("effect", "").toUpperCase());
            if (type == null) {
                throw new IllegalArgumentException("Invalid potion effect for rune: '" + cfg.getFile().getName() + "'.");
            }
            int dur = 140;
            if (type == PotionEffectType.NIGHT_VISION) {
                dur *= 5;
            }
            this.effects = new TreeMap();
            for (int lvl = this.getMinLevel() - 1; lvl < this.getMaxLevel(); ++lvl) {
                PotionEffect pe = new PotionEffect(type, dur, Math.max(0, lvl));
                this.effects.put(lvl + 1, pe);
            }
        }

        @Nullable
        public PotionEffect getEffect(int lvl) {
            Map.Entry<Integer, PotionEffect> e = this.effects.floorEntry(lvl);
            return e != null ? e.getValue() : null;
        }
    }
}

