/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.repair;

import java.util.HashSet;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.manager.api.gui.ContentType;
import studio.magemonkey.codex.manager.api.gui.GuiClick;
import studio.magemonkey.codex.manager.api.gui.GuiItem;
import studio.magemonkey.codex.manager.api.gui.JIcon;
import studio.magemonkey.codex.manager.api.gui.NGUI;
import studio.magemonkey.codex.util.DataUT;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.NamespaceResolver;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.list.repair.RepairManager;

public class AnvilGUI
extends NGUI<Divinity> {
    protected RepairManager repairManager;
    protected int itemSlot;
    protected int sourceSlot;
    protected int resultSlot;
    private static final NamespacedKey META_KEY_REPAIR_SELECT = new NamespacedKey((Plugin)Divinity.getInstance(), "QRPG_REPAIR_GUI_SELECTOR");

    public AnvilGUI(@NotNull RepairManager repairManager) {
        super((CodexPlugin)((Divinity)repairManager.plugin), repairManager.getJYML(), "gui.");
        GuiItem guiItem;
        this.repairManager = repairManager;
        JYML cfg = repairManager.getJYML();
        String path = "gui.";
        this.itemSlot = cfg.getInt(path + "item-slot");
        this.sourceSlot = cfg.getInt(path + "source-slot");
        this.resultSlot = cfg.getInt(path + "result-slot");
        GuiClick clickMain = (p, type, e) -> {
            if (type == ContentType.EXIT) {
                p.closeInventory();
            } else if (type == ContentType.ACCEPT) {
                Inventory inv = e.getInventory();
                ItemStack result = this.getItem(inv, this.resultSlot);
                if (result.getType() == Material.AIR) {
                    return;
                }
                ItemStack target = this.getItem(inv, this.itemSlot);
                RepairManager.RepairType rerpairType = this.getSelectedType(inv);
                if (rerpairType == null) {
                    repairManager.actionsError.process((Entity)p);
                    ((Divinity)this.plugin).lang().Repair_Error_TypeNotSelected.send((CommandSender)p);
                    return;
                }
                if (!repairManager.payForRepair(p, rerpairType, target)) {
                    repairManager.actionsError.process((Entity)p);
                    ((Divinity)this.plugin).lang().Repair_Error_TooExpensive.send((CommandSender)p);
                    return;
                }
                ItemUT.addItem((Player)p, (ItemStack[])new ItemStack[]{result});
                ItemStack src = this.getItem(inv, this.sourceSlot);
                inv.setItem(this.itemSlot, null);
                inv.setItem(this.resultSlot, null);
                repairManager.actionsComplete.process((Entity)p);
                ((Divinity)this.plugin).lang().Repair_Done.replace("%item%", (Object)ItemUT.getItemName((ItemStack)target)).send((CommandSender)p);
                this.open(p, null, src, rerpairType);
            }
        };
        for (String itemId : cfg.getSection(path + "content")) {
            guiItem = cfg.getGuiItem(path + "content." + itemId, ContentType.class);
            if (guiItem == null) continue;
            if (guiItem.getType() != null) {
                guiItem.setClick(clickMain);
            }
            this.addButton(guiItem);
        }
        for (String itemId : cfg.getSection(path + "repair-types")) {
            RepairManager.RepairType repairType;
            Enum type2;
            guiItem = cfg.getGuiItem(path + "repair-types." + itemId, RepairManager.RepairType.class);
            if (guiItem == null || (type2 = guiItem.getType()) != null && type2.getClass().equals(RepairManager.RepairType.class) && !(repairType = (RepairManager.RepairType)type2).isEnabled()) continue;
            this.addButton(guiItem);
        }
    }

    public void open(@NotNull Player player, @Nullable ItemStack target, @Nullable ItemStack source, @Nullable RepairManager.RepairType type) {
        if (target == null) {
            target = new ItemStack(Material.AIR);
        }
        if (source == null) {
            source = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta meta = (SkullMeta)source.getItemMeta();
            if (meta == null) {
                return;
            }
            meta.setDisplayName(player.getName());
            meta.setOwningPlayer((OfflinePlayer)player);
            source.setItemMeta((ItemMeta)meta);
        }
        this.clearUserCache(player);
        this.LOCKED_CACHE.add(player.getName());
        this.addButton(player, new JIcon(target), new int[]{this.itemSlot});
        this.addButton(player, new JIcon(source), new int[]{this.sourceSlot});
        this.addButton(player, new JIcon(this.repairManager.getResult(new ItemStack(target), player)), new int[]{this.resultSlot});
        for (GuiItem guiItem : new HashSet(this.getContent().values())) {
            final Enum type2 = guiItem.getType();
            if (type2 == null || !type2.getClass().equals(RepairManager.RepairType.class)) continue;
            RepairManager.RepairType repairType = (RepairManager.RepairType)type2;
            ItemStack itemGlow = guiItem.getItem();
            this.replaceCostHave(player, target, itemGlow, repairType);
            if (type2 == type) {
                itemGlow.addUnsafeEnchantment(NamespaceResolver.getEnchantment((String[])new String[]{"POWER", "ARROW_DAMAGE"}), 1);
                DataUT.setData((ItemStack)itemGlow, (NamespacedKey)META_KEY_REPAIR_SELECT, (Object)"true");
            }
            GuiClick clickRepair = new GuiClick(){

                public void click(@NotNull Player p, @Nullable Enum<?> type, @NotNull InventoryClickEvent e) {
                    Inventory inv = e.getInventory();
                    ItemStack target = inv.getItem(AnvilGUI.this.itemSlot);
                    ItemStack src = inv.getItem(AnvilGUI.this.sourceSlot);
                    inv.setItem(AnvilGUI.this.itemSlot, null);
                    inv.setItem(AnvilGUI.this.sourceSlot, null);
                    AnvilGUI.this.open(p, target, src, (RepairManager.RepairType)type2);
                }
            };
            JIcon active = new JIcon(itemGlow);
            active.setClick(clickRepair);
            for (int slot : guiItem.getSlots()) {
                this.addButton(player, active, new int[]{slot});
            }
        }
        super.open(player, 1);
    }

    protected void onCreate(@NotNull Player player, @NotNull Inventory inv, int page) {
    }

    @Nullable
    private RepairManager.RepairType getSelectedType(@NotNull Inventory inv) {
        for (GuiItem guiItem : this.getContent().values()) {
            Enum type2 = guiItem.getType();
            if (type2 == null || !type2.getClass().equals(RepairManager.RepairType.class)) continue;
            for (int slot : guiItem.getSlots()) {
                String data;
                ItemStack item = inv.getItem(slot);
                if (item == null || (data = DataUT.getStringData((ItemStack)item, (NamespacedKey)META_KEY_REPAIR_SELECT)) == null || !data.equalsIgnoreCase("true")) continue;
                return (RepairManager.RepairType)type2;
            }
        }
        return null;
    }

    private void replaceCostHave(@NotNull Player player, @NotNull ItemStack target, @NotNull ItemStack item, @Nullable RepairManager.RepairType type) {
        List lore;
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        String strCost = String.valueOf(this.repairManager.calcCost(target, type));
        String strHave = String.valueOf(this.repairManager.getPlayerBalance(player, type, target));
        String strMat = this.repairManager.getMaterialName(target);
        if (meta.hasDisplayName()) {
            String name = meta.getDisplayName().replace("%cost%", strCost).replace("%have%", strHave).replace("%mat%", strMat);
            meta.setDisplayName(name);
        }
        if ((lore = meta.getLore()) != null) {
            for (int i = 0; i < lore.size(); ++i) {
                lore.set(i, ((String)lore.get(i)).replace("%cost%", strCost).replace("%have%", strHave).replace("%mat%", strMat));
            }
            meta.setLore(lore);
        }
        item.setItemMeta(meta);
    }

    public void click(@NotNull Player player, @Nullable ItemStack item, int slot, InventoryClickEvent e) {
        Inventory inv = e.getInventory();
        ItemStack target = this.getItem(inv, this.itemSlot);
        ItemStack source = this.getItem(inv, this.sourceSlot);
        if (slot >= inv.getSize() && target.getType() == Material.AIR) {
            this.repairManager.openAnvilGUI(player, item, source, this.getSelectedType(inv), true);
            return;
        }
        if (slot < inv.getSize() && slot == this.itemSlot && target.getType() != Material.AIR) {
            inv.setItem(this.sourceSlot, null);
            this.open(player, null, source, this.getSelectedType(inv));
            return;
        }
        super.click(player, item, slot, e);
    }

    public void onClose(@NotNull Player player, @NotNull InventoryCloseEvent e) {
        Inventory inv = e.getInventory();
        ItemStack item = inv.getItem(this.itemSlot);
        if (item != null) {
            ItemUT.addItem((Player)player, (ItemStack[])new ItemStack[]{item});
        }
    }

    protected boolean cancelClick(int slot) {
        return true;
    }

    protected boolean cancelPlayerClick() {
        return true;
    }

    protected boolean ignoreNullClick() {
        return true;
    }
}

