/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.itemgenerator.generators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.util.NumberUT;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.codex.util.random.Rnd;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.list.itemgenerator.ItemGeneratorManager;
import studio.magemonkey.divinity.modules.list.itemgenerator.api.AbstractAttributeGenerator;
import studio.magemonkey.divinity.modules.list.itemgenerator.api.DamageInformation;
import studio.magemonkey.divinity.stats.bonus.BonusCalculator;
import studio.magemonkey.divinity.stats.bonus.StatBonus;
import studio.magemonkey.divinity.stats.items.ItemStats;
import studio.magemonkey.divinity.stats.items.api.DuplicableItemLoreStat;
import studio.magemonkey.divinity.stats.items.api.ItemLoreStat;
import studio.magemonkey.divinity.stats.items.attributes.SocketAttribute;
import studio.magemonkey.divinity.stats.items.attributes.api.SimpleStat;
import studio.magemonkey.divinity.stats.items.attributes.api.TypedStat;
import studio.magemonkey.divinity.stats.items.attributes.stats.DurabilityStat;
import studio.magemonkey.divinity.utils.LoreUT;

public class TypedStatGenerator
extends AbstractAttributeGenerator {
    protected Map<TypedStat, DamageInformation> attributes;

    public TypedStatGenerator(@NotNull Divinity plugin, @NotNull ItemGeneratorManager.GeneratorItem generatorItem, @NotNull String path, @NotNull Collection<TypedStat> attributesAll, @NotNull String placeholder) {
        super(plugin, generatorItem, placeholder);
        JYML cfg = this.generatorItem.getConfig();
        this.minAmount = cfg.getInt(path + "minimum");
        this.maxAmount = cfg.getInt(path + "maximum");
        this.loreFormat = StringUT.color((List)cfg.getStringList(path + "lore-format"));
        this.attributes = new HashMap<TypedStat, DamageInformation>();
        attributesAll.forEach(att -> {
            double m2;
            String path2 = path + "list." + att.getId() + ".";
            boolean isSocket = att instanceof SocketAttribute;
            cfg.addMissing(path2 + "chance", (Object)0.0);
            if (!isSocket) {
                cfg.addMissing(path2 + "scale-by-level", (Object)1.0);
                cfg.addMissing(path2 + "min", (Object)0);
                cfg.addMissing(path2 + "max", (Object)0);
                cfg.addMissing(path2 + "flat-range", (Object)false);
                if (!this.getPlaceholder().equalsIgnoreCase("%GENERATOR_FABLED_ATTR%")) {
                    cfg.addMissing(path2 + "round", (Object)false);
                }
            }
            if (!this.loreFormat.contains(att.getPlaceholder())) {
                this.loreFormat.add(att.getPlaceholder());
                cfg.set(path + "lore-format", (Object)this.loreFormat);
            }
            double chance = cfg.getDouble(path2 + "chance");
            double m1 = cfg.getDouble(path2 + "min", 0.0);
            if (m1 > (m2 = cfg.getDouble(path2 + "max", 0.0))) {
                double temp = m1;
                m1 = m2;
                m2 = temp;
            }
            double scale = cfg.getDouble(path2 + "scale-by-level", 1.0);
            boolean flatRange = cfg.getBoolean(path2 + "flat-range", false);
            boolean roundValues = cfg.getBoolean(path2 + "round", false);
            DamageInformation damageInfo = new DamageInformation(chance, m1, m2, scale, flatRange, roundValues);
            this.attributes.put((TypedStat)att, damageInfo);
        });
    }

    @Override
    public void generate(@NotNull ItemStack item, int itemLevel) {
        int max;
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        List lore = meta.getLore();
        if (lore == null) {
            return;
        }
        boolean isSocket = false;
        boolean isValid = true;
        Map<TypedStat, DamageInformation> stats = this.getAttributes();
        int generatorPos = lore.indexOf(this.placeholder);
        int min = this.getMinAmount();
        int n = max = isSocket ? this.getMaxAmount() : Math.min(stats.size(), this.getMaxAmount());
        if (generatorPos < 0 || max == 0 || stats.isEmpty() || !isValid) {
            LoreUT.replacePlaceholder(item, this.placeholder, null);
            return;
        }
        boolean isMaxUnlimited = max < 0;
        boolean isMinUnlimited = min < 0;
        int maxSize = stats.size();
        int rollMax = isMaxUnlimited ? maxSize : max;
        int rollMin = isMinUnlimited || isMinUnlimited && isMaxUnlimited ? Rnd.get((int)(rollMax + 1)) : min;
        int roll = Rnd.get((int)(isMaxUnlimited ? rollMax : rollMin), (int)rollMax);
        if (roll <= 0) {
            LoreUT.replacePlaceholder(item, this.placeholder, null);
            return;
        }
        HashMap<TypedStat, Double> mapChance = new HashMap<TypedStat, Double>();
        stats.forEach((stat, values) -> mapChance.put((TypedStat)stat, values.getChance()));
        boolean noStats = true;
        for (int count = 0; count < roll; ++count) {
            DamageInformation values2;
            Map<TypedStat, Double> filtered;
            TypedStat stat2 = count < rollMin ? ((filtered = mapChance.keySet().stream().filter(a -> (Double)mapChance.get(a) >= 100.0).collect(Collectors.toMap(a -> a, mapChance::get, (a1, b) -> b))).isEmpty() ? (TypedStat)Rnd.getRandomItem(mapChance) : (TypedStat)Rnd.getRandomItem(filtered)) : (TypedStat)Rnd.get(new ArrayList(mapChance.keySet()));
            if (stat2 == null || (values2 = stats.get(stat2)) == null) continue;
            if (count >= rollMin && (double)Rnd.get((boolean)true) >= values2.getChance()) {
                if (isSocket) continue;
                mapChance.remove(stat2);
                continue;
            }
            if (noStats) {
                for (String format : this.getLoreFormat()) {
                    generatorPos = LoreUT.addToLore(lore, generatorPos, format);
                }
                lore.remove(this.placeholder);
                meta.setLore(lore);
                item.setItemMeta(meta);
                noStats = false;
            }
            if (stat2.hasPlaceholder(item)) {
                BiFunction<Boolean, Double, Double> vMod = this.generatorItem.getMaterialModifiers(item, (ItemLoreStat)((Object)stat2));
                double vScale = this.generatorItem.getScaleOfLevel(values2.getScaleByLevel(), itemLevel);
                double vMin = BonusCalculator.SIMPLE_FULL.apply(values2.getMin(), Arrays.asList(vMod)) * vScale;
                double vMax = BonusCalculator.SIMPLE_FULL.apply(values2.getMax(), Arrays.asList(vMod)) * vScale;
                double vFin = NumberUT.round((double)Rnd.getDouble((double)vMin, (double)vMax));
                if (values2.isRound()) {
                    vFin = Math.round(vFin);
                }
                if (vFin != 0.0) {
                    ItemLoreStat rStat;
                    if (stat2 instanceof SimpleStat) {
                        TypedStat dStat;
                        rStat = (SimpleStat)stat2;
                        ((DuplicableItemLoreStat)rStat).add(item, new StatBonus(new double[]{vFin}, false, null), -1);
                        TypedStat.Type depend = ((SimpleStat)rStat).getDependStat();
                        if (depend != null && ((SimpleStat)rStat).isMainItem(item) && (dStat = ItemStats.getStat(depend)) != null && !dStat.isApplied(item)) {
                            mapChance.put(dStat, 100.0);
                            --count;
                        }
                    } else if (stat2 instanceof DurabilityStat) {
                        rStat = (DurabilityStat)stat2;
                        rStat.add(item, new double[]{vFin, vFin}, -1);
                    }
                }
                for (StatBonus statBonus : this.generatorItem.getClassBonuses((ItemLoreStat)((Object)stat2))) {
                    ((ItemLoreStat)((Object)stat2)).add(item, statBonus, -1);
                }
                for (StatBonus statBonus : this.generatorItem.getRarityBonuses((ItemLoreStat)((Object)stat2))) {
                    ((ItemLoreStat)((Object)stat2)).add(item, statBonus, -1);
                }
                for (StatBonus statBonus : this.generatorItem.getMaterialBonuses(item, (ItemLoreStat)((Object)stat2))) {
                    ((ItemLoreStat)((Object)stat2)).add(item, statBonus, -1);
                }
            }
            mapChance.remove(stat2);
        }
        if (noStats) {
            LoreUT.replacePlaceholder(item, this.placeholder, null);
        }
    }

    @NotNull
    public Map<TypedStat, DamageInformation> getAttributes() {
        return this.attributes;
    }
}

