/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.itemgenerator.editor.requirements;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import studio.magemonkey.codex.manager.api.menu.Slot;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.AbstractEditorGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.EditorGUI;

public class RequirementsGUI
extends AbstractEditorGUI {
    private final String path;
    private final Material material;

    public RequirementsGUI(Player player, AbstractEditorGUI.ItemGeneratorReference itemGenerator, String path, Material material) {
        super(player, 6, "Editor/" + EditorGUI.ItemType.REQUIREMENTS.getTitle(), itemGenerator);
        this.path = path;
        this.material = material;
    }

    public void setContents() {
        TreeMap<Integer, String> requirements = this.getRequirements();
        ArrayList<Integer> levels = new ArrayList<Integer>(requirements.keySet());
        levels.add(null);
        int i = 0;
        for (final Integer level : levels) {
            if (++i % this.inventory.getSize() == 53) {
                this.setSlot(i, this.getNextButton());
                ++i;
            } else if (i % 9 == 8) {
                ++i;
            }
            if (i % this.inventory.getSize() == 45) {
                this.setSlot(i, this.getPrevButton());
                ++i;
            } else if (i % 9 == 0) {
                ++i;
            }
            this.setSlot(i, level == null ? new Slot(RequirementsGUI.createItem(Material.REDSTONE, "&eAdd new requirement", new String[0])){

                public void onLeftClick() {
                    RequirementsGUI.this.sendSetMessage("level for the new requirement", null, s -> {
                        final int newLevel = Integer.parseInt(s);
                        new BukkitRunnable(){

                            public void run() {
                                RequirementsGUI.this.sendSetMessage("requirement for level " + newLevel, null, s1 -> {
                                    TreeMap<Integer, String> requirements = RequirementsGUI.this.getRequirements();
                                    requirements.put(newLevel, (String)s1);
                                    RequirementsGUI.this.setRequirements(requirements);
                                    RequirementsGUI.this.saveAndReopen();
                                });
                            }
                        }.runTask((Plugin)Divinity.getInstance());
                    });
                }
            } : new Slot(RequirementsGUI.createItem(this.material, "&e" + level, "&bCurrent: &a" + requirements.get(level), "&6Left-Click: &eSet", "&6Right-Click: &eRemove")){

                public void onLeftClick() {
                    RequirementsGUI.this.sendSetMessage("requirement for level " + level, null, s -> {
                        TreeMap<Integer, String> requirements = RequirementsGUI.this.getRequirements();
                        requirements.put(level, (String)s);
                        RequirementsGUI.this.setRequirements(requirements);
                        RequirementsGUI.this.saveAndReopen();
                    });
                }

                public void onRightClick() {
                    TreeMap<Integer, String> requirements = RequirementsGUI.this.getRequirements();
                    requirements.remove(level);
                    RequirementsGUI.this.setRequirements(requirements);
                    RequirementsGUI.this.saveAndReopen();
                }
            });
        }
        levels.remove(levels.size() - 1);
        this.setSlot(this.getPages() * this.inventory.getSize() - 9, this.getPrevButton());
        this.setSlot(this.getPages() * this.inventory.getSize() - 1, this.getNextButton());
    }

    protected TreeMap<Integer, String> getRequirements() {
        ConfigurationSection requirementsSection = this.itemGenerator.getConfig().getConfigurationSection(this.path);
        TreeMap<Integer, String> requirements = new TreeMap<Integer, String>();
        if (requirementsSection != null) {
            for (String key : requirementsSection.getKeys(false)) {
                String requirement;
                int itemLvl = StringUT.getInteger((String)key, (int)-1);
                if (itemLvl <= 0 || (requirement = requirementsSection.getString(key)) == null || requirement.isEmpty()) continue;
                requirements.put(itemLvl, requirement);
            }
        }
        return requirements;
    }

    protected void setRequirements(TreeMap<Integer, String> requirements) {
        this.itemGenerator.getConfig().remove(this.path);
        for (Map.Entry<Integer, String> entry : requirements.entrySet()) {
            this.itemGenerator.getConfig().set(this.path + "." + String.valueOf(entry.getKey()), (Object)entry.getValue());
        }
    }
}

