/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.api.socketing;

import java.util.function.Function;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.manager.api.gui.ContentType;
import studio.magemonkey.codex.manager.api.gui.GuiClick;
import studio.magemonkey.codex.manager.api.gui.GuiItem;
import studio.magemonkey.codex.manager.api.gui.JIcon;
import studio.magemonkey.codex.manager.api.gui.NGUI;
import studio.magemonkey.codex.util.ClickText;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.random.Rnd;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.manager.interactions.api.AnimatedSuccessBar;
import studio.magemonkey.divinity.modules.SocketItem;
import studio.magemonkey.divinity.modules.api.socketing.ModuleSocket;
import studio.magemonkey.divinity.modules.api.socketing.merchant.MerchantGUI;
import studio.magemonkey.divinity.modules.api.socketing.merchant.MerchantSocket;
import studio.magemonkey.divinity.modules.list.fortify.FortifyManager;

public abstract class ISocketGUI
extends NGUI<Divinity> {
    protected ModuleSocket<?> module;
    protected int itemSlot;
    protected int sourceSlot;
    protected int resultSlot;

    protected ISocketGUI(@NotNull ModuleSocket<?> module, @NotNull JYML cfg) {
        super((CodexPlugin)((Divinity)module.plugin), cfg, "gui.");
        this.module = module;
        String path = "gui.";
        this.itemSlot = cfg.getInt(path + "item-slot");
        this.sourceSlot = cfg.getInt(path + "source-slot");
        this.resultSlot = cfg.getInt(path + "result-slot");
        GuiClick clickHandler = (p, type, e) -> {
            if (type == null) {
                return;
            }
            if (!type.getClass().equals(ContentType.class)) {
                return;
            }
            ContentType type2 = (ContentType)type;
            if (type2 == ContentType.EXIT) {
                this.takeItem(e.getInventory(), this.getResultSlot());
                p.closeInventory();
            }
            if (type2 == ContentType.ACCEPT) {
                this.startSocketing(p, e);
            }
        };
        for (String id : cfg.getSection(path + "content")) {
            GuiItem guiItem = cfg.getGuiItem(path + "content." + id + ".", ContentType.class);
            if (guiItem == null) continue;
            if (guiItem.getType() != null) {
                guiItem.setClick(clickHandler);
            }
            this.addButton(guiItem);
        }
    }

    protected void startSocketing(@NotNull Player player, @NotNull InventoryClickEvent e) {
        int chance = this.getChance(player, e.getInventory());
        Function<Boolean, Void> resultHandler = this.getResultHandler(player, e.getInventory());
        player.closeInventory();
        AnimatedSuccessBar.Builder animator = this.module.getAnimation();
        if (animator != null) {
            animator.setChance(chance).setResult(resultHandler).build().act(player);
        } else {
            resultHandler.apply(Rnd.get((boolean)true) < (float)chance);
        }
    }

    protected abstract int getChance(@NotNull Player var1, @NotNull Inventory var2);

    @NotNull
    protected final Function<Boolean, Void> getResultHandler(@NotNull Player p, @NotNull Inventory inv) {
        ItemStack target = this.takeItem(inv, this.getItemSlot());
        ItemStack gem = this.takeItem(inv, this.getSourceSlot());
        ItemStack result = this.takeItem(inv, this.getResultSlot());
        Function<Boolean, Void> resultHandler = isSuccess -> {
            boolean fSave;
            FortifyManager fortify;
            p.closeInventory();
            if (isSuccess.booleanValue()) {
                this.getResultMessage(result, gem, true, false).send((CommandSender)p);
                ItemUT.addItem((Player)p, (ItemStack[])new ItemStack[]{result});
                if (this.module.getItemCharges(gem) != 0) {
                    this.module.takeItemCharge(gem);
                    ItemUT.addItem((Player)p, (ItemStack[])new ItemStack[]{gem});
                }
                this.module.clearSilentRateBonus(p);
                this.module.actionsComplete.process((Entity)p);
                return null;
            }
            SocketItem mItem = (SocketItem)this.module.getModuleItem(gem);
            if (mItem == null) {
                this.module.error("Attempt to socket invalid item!");
                return null;
            }
            String socketId = mItem.getTargetSocketIdRequirement();
            int socketHas = this.module.getFilledSocketsAmount(target, socketId);
            MerchantSocket merchant = this.module.getMerchant();
            boolean isMerchant = this instanceof MerchantGUI;
            if (!isMerchant || isMerchant && merchant != null && merchant.isSocketSilentRateEnabled()) {
                this.module.addSilentRateBonus(p, socketHas);
            }
            boolean fActive = (fortify = ((Divinity)this.plugin).getModuleCache().getFortifyManager()) != null && fortify.canFortify(target, this.module);
            boolean bl = fSave = fortify != null && fActive && fortify.tryFortify(target);
            if (fActive && fortify != null) {
                fortify.unfortifyItem(target);
                if (fSave) {
                    ((Divinity)this.plugin).lang().Fortify_Enchanting_Success.replace("%item%", (Object)ItemUT.getItemName((ItemStack)target)).send((CommandSender)p);
                } else {
                    ((Divinity)this.plugin).lang().Fortify_Enchanting_Failure.replace("%item%", (Object)ItemUT.getItemName((ItemStack)target)).send((CommandSender)p);
                }
            }
            this.getResultMessage(target, gem, false, fSave).send((CommandSender)p);
            if (fSave || !this.module.isDestroyTargetOnFail()) {
                if (!fSave && this.module.isWipeSocketsOnFail()) {
                    for (int i = 0; i < socketHas; ++i) {
                        this.module.extractSocket(target, socketId, 0);
                    }
                }
                ItemUT.addItem((Player)p, (ItemStack[])new ItemStack[]{target});
            }
            if (!this.module.isDestroySourceOnFail() && this.module.getItemCharges(gem) != 0) {
                this.module.takeItemCharge(gem);
                ItemUT.addItem((Player)p, (ItemStack[])new ItemStack[]{gem});
            }
            this.module.actionsError.process((Entity)p);
            return null;
        };
        return resultHandler;
    }

    public final int getItemSlot() {
        return this.itemSlot;
    }

    public final int getSourceSlot() {
        return this.sourceSlot;
    }

    public final int getResultSlot() {
        return this.resultSlot;
    }

    public void open(@NotNull Player player, @NotNull ItemStack target, @NotNull ItemStack src) {
        ItemStack result = new ItemStack(this.module.insertSocket(new ItemStack(target), new ItemStack(src)));
        this.addButton(player, new JIcon(target), new int[]{this.itemSlot});
        this.addButton(player, new JIcon(src), new int[]{this.sourceSlot});
        this.addButton(player, new JIcon(result), new int[]{this.resultSlot});
        super.open(player, 1);
    }

    public void onClose(@NotNull Player player, @NotNull InventoryCloseEvent e) {
        Inventory inv = e.getInventory();
        ItemStack item = inv.getItem(this.getItemSlot());
        ItemStack src = inv.getItem(this.getSourceSlot());
        if (item != null) {
            ItemUT.addItem((Player)player, (ItemStack[])new ItemStack[]{item});
        }
        if (src != null) {
            ItemUT.addItem((Player)player, (ItemStack[])new ItemStack[]{src});
        }
        super.onClose(player, e);
    }

    @NotNull
    private ClickText getResultMessage(@NotNull ItemStack target, @NotNull ItemStack src, boolean isSuccess, boolean fSave) {
        String result = ((Divinity)this.plugin).lang().Module_Item_Socketing_Result_Total.normalizeLines();
        String stateTarget = ((Divinity)this.plugin).lang().Module_Item_Socketing_Result_State_Success.getMsg();
        if (!isSuccess) {
            stateTarget = fSave || !this.module.isDestroyTargetOnFail() ? ((Divinity)this.plugin).lang().Module_Item_Socketing_Result_State_Saved.getMsg() : (this.module.isWipeSocketsOnFail() ? ((Divinity)this.plugin).lang().Module_Item_Socketing_Result_State_Wiped.getMsg() : ((Divinity)this.plugin).lang().Module_Item_Socketing_Result_State_Destroyed.getMsg());
        }
        String stateSource = ((Divinity)this.plugin).lang().Module_Item_Socketing_Result_State_Consumed.getMsg();
        if (!isSuccess && this.module.isDestroySourceOnFail()) {
            stateSource = ((Divinity)this.plugin).lang().Module_Item_Socketing_Result_State_Destroyed.getMsg();
        }
        result = result.replace("%state-target%", stateTarget).replace("%state-source%", stateSource);
        ClickText text = new ClickText(result);
        text.createPlaceholder("%item-target%", ItemUT.getItemName((ItemStack)target)).showItem(target);
        text.createPlaceholder("%item-source%", ItemUT.getItemName((ItemStack)src)).showItem(src);
        return text;
    }

    protected boolean ignoreNullClick() {
        return true;
    }

    protected boolean cancelClick(int slot) {
        return true;
    }

    protected boolean cancelPlayerClick() {
        return true;
    }
}

