/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.api;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.compat.VersionManager;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.codex.util.random.Rnd;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.config.Config;
import studio.magemonkey.divinity.config.EngineCfg;
import studio.magemonkey.divinity.modules.ModuleItem;
import studio.magemonkey.divinity.modules.api.QModule;
import studio.magemonkey.divinity.stats.items.ItemStats;
import studio.magemonkey.divinity.stats.items.attributes.ChargesAttribute;
import studio.magemonkey.divinity.stats.items.requirements.ItemRequirements;
import studio.magemonkey.divinity.stats.tiers.Tier;
import studio.magemonkey.divinity.stats.tiers.Tiered;

public abstract class QModuleDrop<I extends ModuleItem>
extends QModule {
    public static final String RANDOM_ID = "random";
    protected Class<I> clazz;
    protected Map<String, I> items;
    protected ChargesAttribute chargesAtt;
    private String itemNameFormat;
    private List<String> itemLoreFormat;

    public QModuleDrop(@NotNull Divinity plugin, @NotNull Class<I> clazz) {
        super(plugin);
        this.clazz = clazz;
        this.chargesAtt = ItemStats.getAttribute(ChargesAttribute.class);
    }

    @NotNull
    public final String getItemsFolder() {
        return this.getPath() + "items";
    }

    protected void loadSettings() {
        String path = "item-format.";
        this.cfg.addMissing(path + "name", (Object)"%ITEM_NAME%");
        this.cfg.addMissing(path + "lore", Arrays.asList("%ITEM_LORE%"));
        this.cfg.saveChanges();
        this.itemNameFormat = StringUT.color((String)this.cfg.getString(path + "name", "%ITEM_NAME%"));
        this.itemLoreFormat = StringUT.color((List)this.cfg.getStringList(path + "lore"));
    }

    protected void loadItems() {
        this.items = new TreeMap<String, I>();
        ((Divinity)this.plugin).getConfigManager().extractFullPath(String.valueOf(((Divinity)this.plugin).getDataFolder()) + this.getItemsFolder());
        for (JYML cfg : JYML.loadAll((String)(String.valueOf(((Divinity)this.plugin).getDataFolder()) + this.getItemsFolder()), (boolean)true)) {
            ModuleItem item;
            block7: {
                try {
                    Constructor<I> ctor = this.clazz.getDeclaredConstructor(((Object)((Object)this)).getClass(), Divinity.class, JYML.class);
                    item = (ModuleItem)((Object)ctor.newInstance(new Object[]{this, this.plugin, cfg}));
                    if (item == null) {
                    }
                    break block7;
                }
                catch (InvocationTargetException ite) {
                    this.error("Could not load item '" + cfg.getFile().getName() + "'");
                    if (ite.getCause() instanceof IllegalArgumentException) {
                        this.error(" - " + ite.getCause().getMessage());
                        continue;
                    }
                    if (ite.getCause().getClass().getSimpleName().equals("FabledNotEnabledException")) {
                        this.error(" - It looks like this item uses skills from Fabled, but Fabled is not enabled yet");
                        continue;
                    }
                    ite.printStackTrace();
                }
                catch (Exception e) {
                    this.error("Could not load item '" + cfg.getFile().getName() + "'");
                    e.printStackTrace();
                }
                continue;
            }
            this.items.put(item.getId().toLowerCase(), (I)((Object)item));
        }
    }

    @NotNull
    public String getItemNameFormat() {
        return this.itemNameFormat;
    }

    @NotNull
    public List<String> getItemLoreFormat() {
        return this.itemLoreFormat;
    }

    @Nullable
    public I getItemById(@NotNull String id, @Nullable String sTier) {
        Tier tier;
        if (this.items == null || this.items.isEmpty()) {
            return null;
        }
        Tier tier2 = tier = sTier == null || sTier.isBlank() || sTier.equalsIgnoreCase(RANDOM_ID) ? null : Config.getTier(sTier);
        if (id.equalsIgnoreCase(RANDOM_ID)) {
            return (I)((Object)((ModuleItem)((Object)Rnd.get(this.getItems().stream().filter(item -> tier == null || !(item instanceof Tiered) || item instanceof Tiered && ((Tiered)((Object)item)).getTier() == tier).collect(Collectors.toList())))));
        }
        return (I)((Object)((ModuleItem)((Object)this.items.get(id.toLowerCase()))));
    }

    @Nullable
    public I getItemById(@NotNull String id) {
        return this.getItemById(id, null);
    }

    @NotNull
    public Collection<I> getItems() {
        if (this.items == null) {
            return Collections.emptyList();
        }
        return this.items.values();
    }

    @NotNull
    public List<String> getItemIds() {
        ArrayList<String> list = new ArrayList<String>(this.items.keySet());
        list.add(RANDOM_ID);
        return list;
    }

    @Nullable
    public final String getItemId(@NotNull ItemStack item) {
        if (!this.isItemOfThisModule(item)) {
            return null;
        }
        return ItemStats.getId(item);
    }

    @Nullable
    public I getModuleItem(@NotNull ItemStack item) {
        String id = this.getItemId(item);
        if (id == null) {
            return null;
        }
        return this.getItemById(id);
    }

    public final boolean isItemOfThisModule(@NotNull ItemStack item) {
        QModuleDrop<?> e = ItemStats.getModule(item);
        return e != null && ((Object)e).equals((Object)this);
    }

    public void unload() {
        if (this.items != null) {
            this.items.clear();
            this.items = null;
        }
        super.unload();
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public final void onDragDropEvent(InventoryClickEvent e) {
        if (e.getInventory().getType() != InventoryType.CRAFTING) {
            return;
        }
        if (e.getSlotType() == InventoryType.SlotType.CRAFTING) {
            return;
        }
        if (e.getSlotType() == InventoryType.SlotType.ARMOR || e.getSlot() == 40) {
            return;
        }
        ItemStack target = e.getCurrentItem();
        if (target == null || target.getType() == Material.AIR) {
            return;
        }
        ItemStack src = e.getCursor();
        if (src == null || src.getType() == Material.AIR) {
            return;
        }
        if (target.isSimilar(src)) {
            return;
        }
        I mItem = this.getModuleItem(src);
        if (mItem == null) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        if (p.getGameMode() == GameMode.CREATIVE) {
            ((Divinity)this.plugin).lang().Module_Item_Interact_Error_Creative.send((CommandSender)p);
            return;
        }
        if (!ItemRequirements.canApply(p, src, target)) {
            return;
        }
        ItemStack current = src.clone();
        if (this.onDragDrop(p, current, target.clone(), mItem, e)) {
            e.setCancelled(true);
            if (current.getAmount() > 0) {
                VersionManager.getCompat().setCursor((InventoryEvent)e, current);
            } else if (current.getType() == Material.AIR) {
                VersionManager.getCompat().setCursor((InventoryEvent)e, null);
            }
        }
    }

    public final void splitDragItem(@NotNull Player p, @Nullable ItemStack src, @Nullable ItemStack target) {
        if (src != null) {
            ItemStack srcConsumed = new ItemStack(src);
            srcConsumed.setAmount(src.getAmount() - 1);
            src.setAmount(1);
            ItemUT.addItem((Player)p, (ItemStack[])new ItemStack[]{srcConsumed});
        }
        if (target != null) {
            p.getInventory().removeItem(new ItemStack[]{target});
            this.splitDragItem(p, target, null);
        }
    }

    protected boolean onDragDrop(@NotNull Player p, @NotNull ItemStack src, @NotNull ItemStack target, @NotNull I mItem, @NotNull InventoryClickEvent e) {
        return false;
    }

    protected final void takeChargeClickEvent(@NotNull Player p, @NotNull ItemStack src, @NotNull InventoryClickEvent e) {
        ItemStack toModify;
        ItemStack toSave;
        int uses = this.getItemCharges(src);
        if (uses < 0) {
            return;
        }
        if (src.getAmount() > 1) {
            toSave = new ItemStack(src);
            toSave.setAmount(src.getAmount() - 1);
            toModify = src;
            toModify.setAmount(1);
        } else {
            toModify = src;
            toSave = null;
        }
        if (uses == 0) {
            toModify.setAmount(0);
        } else {
            this.takeItemCharge(toModify);
        }
        if (!ItemUT.isAir((ItemStack)toModify)) {
            VersionManager.getCompat().setCursor((InventoryEvent)e, toModify);
            if (toSave != null) {
                ItemUT.addItem((Player)p, (ItemStack[])new ItemStack[]{toSave});
            }
        } else if (toSave != null) {
            VersionManager.getCompat().setCursor((InventoryEvent)e, toSave);
        }
    }

    public final void takeItemCharge(@NotNull ItemStack item) {
        if (this.chargesAtt == null) {
            return;
        }
        boolean doBreak = EngineCfg.CHARGES_BREAK_ITEMS_ENABLED && !EngineCfg.CHARGES_BREAK_ITEMS_STOP_MODULES.contains(this.getId());
        this.chargesAtt.takeCharges(item, 1, doBreak);
    }

    public final int getItemCharges(@NotNull ItemStack stack) {
        if (this.chargesAtt == null) {
            return 0;
        }
        int[] values = (int[])this.chargesAtt.getRaw(stack);
        if (values == null) {
            return 0;
        }
        return values[0];
    }
}

