/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.Codex;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.api.items.ItemType;
import studio.magemonkey.codex.api.items.exception.MissingItemException;
import studio.magemonkey.codex.api.items.exception.MissingProviderException;
import studio.magemonkey.codex.api.items.providers.VanillaProvider;
import studio.magemonkey.codex.api.meta.NBTAttribute;
import studio.magemonkey.codex.compat.VersionManager;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.manager.LoadableItem;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.NamespaceResolver;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.codex.util.random.Rnd;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.api.QModuleDrop;
import studio.magemonkey.divinity.modules.list.identify.IdentifyManager;
import studio.magemonkey.divinity.modules.list.itemgenerator.ItemGeneratorManager;
import studio.magemonkey.divinity.stats.items.ItemStats;
import studio.magemonkey.divinity.stats.items.requirements.ItemRequirements;
import studio.magemonkey.divinity.stats.items.requirements.user.UntradeableRequirement;
import studio.magemonkey.divinity.utils.LoreUT;

public abstract class ModuleItem
extends LoadableItem {
    protected final QModuleDrop<?> module;
    protected Divinity plugin;
    protected String name;
    protected ItemType material;
    protected List<String> lore;
    protected int modelData;
    protected int durability;
    protected int[] color;
    protected boolean enchanted;
    protected String hash;
    protected Set<ItemFlag> flags;
    protected boolean isUnbreakable;
    protected Map<Enchantment, Integer> enchants;
    protected String armorTrim;
    protected Map<Attribute, AttributeModifier> attributes;

    @Deprecated
    public ModuleItem(@NotNull Divinity plugin, String path, QModuleDrop<?> module) throws InvalidConfigurationException {
        super((CodexPlugin)plugin, path);
        this.module = module;
        this.plugin = plugin;
    }

    public ModuleItem(@NotNull Divinity plugin, @NotNull JYML cfg, @NotNull QModuleDrop<?> module) {
        super((CodexPlugin)plugin, cfg);
        this.plugin = plugin;
        this.module = module;
        this.updateConfig(cfg);
        if (this instanceof ItemGeneratorManager.GeneratorItem || this instanceof IdentifyManager.UnidentifiedItem) {
            this.material = new VanillaProvider.VanillaItemType(Material.LEATHER_HELMET);
        } else {
            String[] matSplit = cfg.getString("material", "STONE").split(":");
            try {
                this.material = CodexEngine.get().getItemManager().getItemType(matSplit[0]);
            }
            catch (MissingItemException | MissingProviderException e) {
                throw new IllegalArgumentException("Invalid item material!", e);
            }
        }
        this.name = StringUT.color((String)cfg.getString("name", this.getId()));
        this.name = module.getItemNameFormat().replace("%ITEM_NAME%", this.name);
        this.processLore(cfg, module);
        this.modelData = cfg.getInt("model-data", -1);
        this.durability = cfg.getInt("durability", -1);
        String color = cfg.getString("color");
        if (color != null) {
            String[] rgb = color.split(",");
            int r = StringUT.getInteger((String)rgb[0], (int)-1);
            int g = rgb.length >= 2 ? StringUT.getInteger((String)rgb[1], (int)-1) : 0;
            int b = rgb.length >= 3 ? StringUT.getInteger((String)rgb[2], (int)-1) : 0;
            this.color = new int[]{r, g, b};
        }
        this.enchanted = cfg.getBoolean("enchanted");
        this.hash = cfg.getString("skull-hash");
        this.armorTrim = cfg.getString("armor-trim");
        this.flags = new HashSet<ItemFlag>();
        for (String flag : cfg.getStringList("item-flags")) {
            if (flag.equals("*")) {
                this.flags.addAll(Arrays.asList(ItemFlag.values()));
                break;
            }
            try {
                this.flags.add(ItemFlag.valueOf((String)flag.toUpperCase()));
            }
            catch (IllegalArgumentException ex) {}
        }
        this.isUnbreakable = cfg.getBoolean("unbreakable");
        this.enchants = new HashMap<Enchantment, Integer>();
        for (String sId : cfg.getSection("enchantments")) {
            Enchantment en = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)sId.toLowerCase()));
            if (en == null) {
                plugin.error("Invalid enchantment provided: " + sId + " (" + cfg.getFile().getName() + ")");
                continue;
            }
            int level = cfg.getInt("enchantments." + sId, 1);
            this.enchants.put(en, level);
        }
        this.attributes = new HashMap<Attribute, AttributeModifier>();
        for (String attr : cfg.getSection("attributes")) {
            String[] attrData = cfg.getString("attributes." + attr, "").split(":");
            double value = Double.parseDouble(attrData[0]);
            String operation = attrData.length > 1 ? attrData[1] : "ADD_NUMBER";
            String equipmentSlot = attrData.length > 2 ? attrData[2] : null;
            NBTAttribute nbtAttr = NBTAttribute.valueOf((String)attr.toUpperCase());
            AttributeModifier attrModifier = VersionManager.getCompat().createAttributeModifier(nbtAttr, value, AttributeModifier.Operation.valueOf((String)operation));
            if (attrModifier == null) {
                Codex.warn((String)("Invalid attribute provided: " + attr + " (" + cfg.getFile().getName() + ")"));
                continue;
            }
            if (equipmentSlot != null) {
                EquipmentSlot slot = EquipmentSlot.valueOf((String)equipmentSlot.toUpperCase());
                attrModifier = new AttributeModifier(attrModifier.getUniqueId(), attrModifier.getName(), attrModifier.getAmount(), attrModifier.getOperation(), slot);
                Bukkit.getLogger().info("Registered attribute " + nbtAttr.name() + " with value " + value + ", operation " + operation + " and equipment slot " + equipmentSlot + " for item " + this.getId());
            }
            this.attributes.put(nbtAttr.getAttribute(), attrModifier);
        }
        cfg.saveChanges();
    }

    protected String applyLoreReplacements(String lore) {
        return lore;
    }

    protected void processLore(@NotNull JYML cfg, @NotNull QModuleDrop<?> module) {
        this.lore = new ArrayList<String>();
        for (String mLore : module.getItemLoreFormat()) {
            if (mLore.equalsIgnoreCase("%ITEM_LORE%")) {
                for (String itemLore : StringUT.color((List)cfg.getStringList("lore"))) {
                    this.lore.add(this.applyLoreReplacements(itemLore));
                }
                continue;
            }
            this.lore.add(this.applyLoreReplacements(mLore));
        }
    }

    private void updateConfig(@NotNull JYML cfg) {
        cfg.saveChanges();
    }

    protected void save(@NotNull JYML cfg) {
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public ItemType getMaterial() {
        return this.material;
    }

    @NotNull
    public List<String> getLore() {
        return this.lore;
    }

    public int[] getColor() {
        return this.color == null ? null : Arrays.copyOf(this.color, 3);
    }

    public Set<ItemFlag> getFlags() {
        return new HashSet<ItemFlag>(this.flags);
    }

    public boolean isUnbreakable() {
        return this.isUnbreakable;
    }

    @NotNull
    public QModuleDrop<?> getModule() {
        return this.module;
    }

    @NotNull
    public ItemStack create() {
        return this.build();
    }

    @NotNull
    protected ItemStack build() {
        return this.build(this.getMaterial().create());
    }

    @NotNull
    protected ItemStack build(@NotNull ItemStack item) {
        List<String> modifiedLore;
        ItemUT.addSkullTexture((ItemStack)item, (String)this.hash, (String)this.getId());
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        meta.setDisplayName(StringUT.colorSensitiveStrip((String)this.name.replace("%BASE_NAME%", meta.getDisplayName())));
        List baseLore = meta.getLore();
        if (baseLore == null || baseLore.isEmpty()) {
            modifiedLore = new ArrayList<String>(this.lore);
            modifiedLore.remove("%BASE_LORE%");
        } else {
            modifiedLore = StringUT.replace(this.lore, (String)"%BASE_LORE%", (List)baseLore);
        }
        meta.setLore(modifiedLore);
        if (this.modelData > 0) {
            meta.setCustomModelData(Integer.valueOf(this.modelData));
        }
        if (this.durability >= 0 && meta instanceof Damageable) {
            Damageable dMeta = (Damageable)meta;
            dMeta.setDamage(this.durability);
        }
        if (!ArrayUtils.isEmpty((int[])this.color)) {
            int b;
            int r = this.color[0] >= 0 ? this.color[0] : Rnd.get((int)255);
            int n = this.color[1] >= 0 ? this.color[1] : Rnd.get((int)255);
            int n2 = b = this.color[2] >= 0 ? this.color[2] : Rnd.get((int)255);
            if (meta instanceof LeatherArmorMeta) {
                LeatherArmorMeta lm = (LeatherArmorMeta)meta;
                lm.setColor(Color.fromRGB((int)r, (int)n, (int)b));
                if (this.armorTrim != null) {
                    String[] trimData = this.armorTrim.split(":");
                    VersionManager.getArmorUtil().addTrim(meta, trimData[0].toLowerCase(), trimData[1].toLowerCase());
                }
            } else if (meta instanceof PotionMeta) {
                PotionMeta pm = (PotionMeta)meta;
                pm.setColor(Color.fromRGB((int)r, (int)n, (int)b));
            } else if (meta instanceof ArmorMeta && this.armorTrim != null) {
                String[] trimData = this.armorTrim.split(":");
                VersionManager.getArmorUtil().addTrim(meta, trimData[0].toLowerCase(), trimData[1].toLowerCase());
            }
        }
        meta.addItemFlags(this.flags.toArray(new ItemFlag[this.flags.size()]));
        meta.setUnbreakable(this.isUnbreakable);
        if (this.enchanted) {
            meta.addEnchant(NamespaceResolver.getEnchantment((String[])new String[]{"POWER", "ARROW_DAMAGE"}), 1, true);
        }
        for (Map.Entry<Attribute, AttributeModifier> entry : this.attributes.entrySet()) {
            if (entry == null) continue;
            AttributeModifier mod = new AttributeModifier(entry.getValue().getName(), entry.getValue().getAmount(), entry.getValue().getOperation());
            meta.addAttributeModifier(entry.getKey(), entry.getValue());
        }
        item.setItemMeta(meta);
        for (Map.Entry<Object, Object> entry : this.enchants.entrySet()) {
            Enchantment enchant = (Enchantment)entry.getKey();
            int enchLevel = (Integer)entry.getValue();
            if (enchLevel < 1) continue;
            item.addUnsafeEnchantment(enchant, enchLevel);
        }
        ItemStats.setId(item, this.getId());
        ItemStats.setModule(item, this.getModule().getId());
        this.replacePlaceholders(item);
        return item;
    }

    private void replacePlaceholders(@NotNull ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        String name = meta.getDisplayName();
        meta.setDisplayName(name);
        List metaLore = meta.getLore();
        List lore = metaLore != null ? metaLore : new ArrayList();
        for (int i = 0; i < lore.size(); ++i) {
            String line = (String)lore.get(i);
            lore.set(i, StringUT.color((String)line));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        UntradeableRequirement reqUntrade = ItemRequirements.getUserRequirement(UntradeableRequirement.class);
        if (reqUntrade != null && reqUntrade.hasPlaceholder(item)) {
            reqUntrade.add(item, -1);
        }
        LoreUT.replacePlaceholder(item, "%ITEM_UNTRADEABLE%", null);
    }
}

