/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.manager;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityEquipmentSnapshot
implements EntityEquipment {
    private final UUID id;
    private final ItemStack[] armorContents;
    private final ItemStack mainHand;
    private final ItemStack offHand;

    public EntityEquipmentSnapshot(@NotNull LivingEntity entity) {
        this.id = entity.getUniqueId();
        EntityEquipment equipment = entity.getEquipment();
        if (equipment == null) {
            this.armorContents = new ItemStack[4];
            this.mainHand = null;
            this.offHand = null;
            return;
        }
        this.armorContents = equipment.getArmorContents();
        this.mainHand = equipment.getItemInMainHand();
        this.offHand = equipment.getItemInOffHand();
    }

    public void setItem(@NotNull EquipmentSlot equipmentSlot, @Nullable ItemStack itemStack) {
    }

    public void setItem(@NotNull EquipmentSlot equipmentSlot, @Nullable ItemStack itemStack, boolean b) {
    }

    @NotNull
    public ItemStack getItem(@NotNull EquipmentSlot equipmentSlot) {
        switch (equipmentSlot) {
            case HAND: {
                return this.mainHand;
            }
            case OFF_HAND: {
                return this.offHand;
            }
            case FEET: {
                return this.armorContents[0];
            }
            case LEGS: {
                return this.armorContents[1];
            }
            case CHEST: {
                return this.armorContents[2];
            }
            case HEAD: {
                return this.armorContents[3];
            }
        }
        throw new IllegalArgumentException();
    }

    @NotNull
    public ItemStack getItemInMainHand() {
        return this.mainHand;
    }

    public void setItemInMainHand(@Nullable ItemStack itemStack) {
    }

    public void setItemInMainHand(@Nullable ItemStack itemStack, boolean b) {
    }

    @NotNull
    public ItemStack getItemInOffHand() {
        return this.offHand;
    }

    public void setItemInOffHand(@Nullable ItemStack itemStack) {
    }

    public void setItemInOffHand(@Nullable ItemStack itemStack, boolean b) {
    }

    @NotNull
    public ItemStack getItemInHand() {
        return this.mainHand;
    }

    public void setItemInHand(@Nullable ItemStack itemStack) {
    }

    @Nullable
    public ItemStack getHelmet() {
        return this.armorContents[3];
    }

    public void setHelmet(@Nullable ItemStack itemStack) {
    }

    public void setHelmet(@Nullable ItemStack itemStack, boolean b) {
    }

    @Nullable
    public ItemStack getChestplate() {
        return this.armorContents[2];
    }

    public void setChestplate(@Nullable ItemStack itemStack) {
    }

    public void setChestplate(@Nullable ItemStack itemStack, boolean b) {
    }

    @Nullable
    public ItemStack getLeggings() {
        return this.armorContents[1];
    }

    public void setLeggings(@Nullable ItemStack itemStack) {
    }

    public void setLeggings(@Nullable ItemStack itemStack, boolean b) {
    }

    @Nullable
    public ItemStack getBoots() {
        return this.armorContents[0];
    }

    public void setBoots(@Nullable ItemStack itemStack) {
    }

    public void setBoots(@Nullable ItemStack itemStack, boolean b) {
    }

    @NotNull
    public ItemStack[] getArmorContents() {
        return this.armorContents;
    }

    public void setArmorContents(@NotNull ItemStack[] itemStacks) {
    }

    public void clear() {
    }

    public float getItemInHandDropChance() {
        return 0.0f;
    }

    public void setItemInHandDropChance(float v) {
    }

    public float getItemInMainHandDropChance() {
        return 0.0f;
    }

    public void setItemInMainHandDropChance(float v) {
    }

    public float getItemInOffHandDropChance() {
        return 0.0f;
    }

    public void setItemInOffHandDropChance(float v) {
    }

    public float getHelmetDropChance() {
        return 0.0f;
    }

    public void setHelmetDropChance(float v) {
    }

    public float getChestplateDropChance() {
        return 0.0f;
    }

    public void setChestplateDropChance(float v) {
    }

    public float getLeggingsDropChance() {
        return 0.0f;
    }

    public void setLeggingsDropChance(float v) {
    }

    public float getBootsDropChance() {
        return 0.0f;
    }

    public void setBootsDropChance(float v) {
    }

    @Nullable
    public Entity getHolder() {
        return Bukkit.getEntity((UUID)this.id);
    }
}

