/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.commands.api.ISubCommand;
import studio.magemonkey.codex.util.CollectionsUT;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.stats.bonus.StatBonus;
import studio.magemonkey.divinity.stats.items.ItemStats;
import studio.magemonkey.divinity.stats.items.attributes.AmmoAttribute;
import studio.magemonkey.divinity.stats.items.attributes.DamageAttribute;
import studio.magemonkey.divinity.stats.items.attributes.DefenseAttribute;
import studio.magemonkey.divinity.stats.items.attributes.HandAttribute;
import studio.magemonkey.divinity.stats.items.attributes.SocketAttribute;
import studio.magemonkey.divinity.stats.items.attributes.api.SimpleStat;
import studio.magemonkey.divinity.stats.items.attributes.api.TypedStat;
import studio.magemonkey.divinity.stats.items.attributes.stats.DurabilityStat;
import studio.magemonkey.divinity.stats.items.requirements.ItemRequirements;
import studio.magemonkey.divinity.stats.items.requirements.user.ClassRequirement;
import studio.magemonkey.divinity.stats.items.requirements.user.LevelRequirement;
import studio.magemonkey.divinity.utils.ItemUtils;

public class SetCommand
extends ISubCommand<Divinity> {
    private static final String[] ARGS = new String[]{"level", "socket", "class", "damage", "defense", "stat", "ammo", "hand"};

    public SetCommand(@NotNull Divinity plugin) {
        super((CodexPlugin)plugin, new String[]{"set"}, "quantumrpg.admin");
    }

    @NotNull
    public String usage() {
        return "";
    }

    @NotNull
    public String description() {
        return "Add item attributes.";
    }

    public boolean playersOnly() {
        return true;
    }

    @NotNull
    public List<String> getTab(@NotNull Player player, int i, @NotNull String[] args) {
        if (i == 1) {
            return Arrays.asList(ARGS);
        }
        String arg = args[1];
        if (i == 2) {
            if (arg.equalsIgnoreCase(ARGS[0])) {
                return Arrays.asList("<level>", "-1", "0", "1", "10");
            }
            if (arg.equalsIgnoreCase(ARGS[1])) {
                return CollectionsUT.getEnumsList(SocketAttribute.Type.class);
            }
            if (arg.equalsIgnoreCase(ARGS[2])) {
                return Arrays.asList("class1,class2,class3");
            }
            if (arg.equalsIgnoreCase(ARGS[3])) {
                ArrayList<String> list = new ArrayList<String>();
                for (DamageAttribute d : ItemStats.getDamages()) {
                    list.add(d.getId());
                }
                return list;
            }
            if (arg.equalsIgnoreCase(ARGS[4])) {
                ArrayList<String> list = new ArrayList<String>();
                for (DefenseAttribute d : ItemStats.getDefenses()) {
                    list.add(d.getId());
                }
                return list;
            }
            if (arg.equalsIgnoreCase(ARGS[5])) {
                return CollectionsUT.getEnumsList(TypedStat.Type.class);
            }
            if (arg.equalsIgnoreCase(ARGS[6])) {
                return CollectionsUT.getEnumsList(AmmoAttribute.Type.class);
            }
            if (arg.equalsIgnoreCase(ARGS[7])) {
                return CollectionsUT.getEnumsList(HandAttribute.Type.class);
            }
        }
        if (i == 3) {
            SocketAttribute.Type type;
            if (arg.equalsIgnoreCase(ARGS[1]) && (type = SocketAttribute.Type.getByName(args[2])) != null) {
                ArrayList<String> sockets = new ArrayList<String>();
                ItemStats.getSockets(type).forEach(socket -> sockets.add(socket.getId()));
                return sockets;
            }
            if (arg.equalsIgnoreCase(ARGS[0]) || arg.equalsIgnoreCase(ARGS[2]) || arg.equalsIgnoreCase(ARGS[6]) || arg.equalsIgnoreCase(ARGS[7])) {
                return Arrays.asList("[position]");
            }
            if (arg.equalsIgnoreCase(ARGS[3])) {
                return Arrays.asList("<min>");
            }
            if (arg.equalsIgnoreCase(ARGS[4]) || arg.equalsIgnoreCase(ARGS[5])) {
                return Arrays.asList("<value>");
            }
        }
        if (i == 4) {
            if (arg.equalsIgnoreCase(ARGS[3])) {
                return Arrays.asList("<max>");
            }
            if (arg.equalsIgnoreCase(ARGS[4]) || arg.equals(ARGS[1]) || arg.equalsIgnoreCase(ARGS[5])) {
                return Arrays.asList("[position]");
            }
        }
        if (i == 5 && arg.equalsIgnoreCase(ARGS[3])) {
            return Arrays.asList("[position]");
        }
        return super.getTab(player, i, args);
    }

    public void perform(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) {
        if (args.length <= 1) {
            this.printHelp(sender);
            return;
        }
        Player player = (Player)sender;
        ItemStack item = player.getInventory().getItemInMainHand();
        if (ItemUT.isAir((ItemStack)item)) {
            ((Divinity)this.plugin).lang().Error_NoItem.send((CommandSender)player);
            return;
        }
        int line = -1;
        switch (args[1].toLowerCase()) {
            case "level": {
                LevelRequirement r1;
                if (args.length < 3) {
                    this.printHelp((CommandSender)player);
                    return;
                }
                int level = this.getNumI(sender, args[2], -1);
                if (args.length == 4) {
                    line = this.getNumI(sender, args[3], -1);
                }
                if ((r1 = ItemRequirements.getUserRequirement(LevelRequirement.class)) == null) {
                    sender.sendMessage("Level Requirement is not registered!");
                    return;
                }
                r1.add(item, new int[]{level}, line);
                player.getInventory().setItemInMainHand(item);
                break;
            }
            case "socket": {
                if (args.length < 4) {
                    this.printUsage(sender);
                    return;
                }
                SocketAttribute.Type socketType = SocketAttribute.Type.getByName(args[2].toUpperCase());
                if (socketType == null) {
                    this.errType(sender, SocketAttribute.Type.class);
                    return;
                }
                String socketId = args[3];
                SocketAttribute sb = ItemStats.getSocket(socketType, socketId);
                if (sb == null) {
                    sender.sendMessage("No Such Socket Attribute!");
                    return;
                }
                sb.add(item, sb.getDefaultValue(), -1);
                break;
            }
            case "class": {
                ClassRequirement r1;
                if (args.length < 3) {
                    this.printHelp((CommandSender)player);
                    return;
                }
                if (args.length == 4) {
                    line = this.getNumI(sender, args[3], -1);
                }
                if ((r1 = ItemRequirements.getUserRequirement(ClassRequirement.class)) == null) {
                    sender.sendMessage("Class Requirement is not registered!");
                    return;
                }
                r1.add(item, args[2].split(","), line);
                player.getInventory().setItemInMainHand(item);
                break;
            }
            case "damage": {
                DamageAttribute dt;
                if (args.length < 5) {
                    this.printHelp((CommandSender)player);
                    return;
                }
                double val1 = StringUT.getDouble((String)args[3], (double)0.0, (boolean)true);
                double val2 = StringUT.getDouble((String)args[4], (double)0.0, (boolean)true);
                if (args.length == 6) {
                    line = this.getNumI(sender, args[5], -1);
                }
                if ((dt = ItemStats.getDamageById(args[2])) == null) {
                    sender.sendMessage(((Divinity)this.plugin).lang().Prefix.getMsg() + "Invalid damage type!");
                    return;
                }
                dt.add(item, new StatBonus(new double[]{val1, val2}, false, null), line);
                player.getInventory().setItemInMainHand(item);
                break;
            }
            case "defense": {
                DefenseAttribute dt;
                if (args.length < 4) {
                    this.printHelp((CommandSender)player);
                    return;
                }
                double amount = StringUT.getDouble((String)args[3], (double)0.0, (boolean)true);
                if (args.length == 5) {
                    line = this.getNumI(sender, args[4], -1);
                }
                if ((dt = ItemStats.getDefenseById(args[2])) == null) {
                    sender.sendMessage(((Divinity)this.plugin).lang().Prefix.getMsg() + "Invalid defense type!");
                    return;
                }
                dt.add(item, new StatBonus(new double[]{amount}, false, null), line);
                player.getInventory().setItemInMainHand(item);
                break;
            }
            case "ammo": {
                AmmoAttribute ammo;
                AmmoAttribute.Type dt;
                if (args.length < 3) {
                    this.printHelp((CommandSender)player);
                    return;
                }
                if (!ItemUtils.isBow(item)) {
                    ((Divinity)this.plugin).lang().Error_InvalidItem.send((CommandSender)player);
                    return;
                }
                try {
                    dt = AmmoAttribute.Type.valueOf(args[2].toUpperCase());
                }
                catch (IllegalArgumentException ex) {
                    this.errType(sender, AmmoAttribute.Type.class);
                    return;
                }
                if (args.length == 4) {
                    line = this.getNumI(sender, args[3], -1);
                }
                if ((ammo = ItemStats.getAmmo(dt)) == null) break;
                ammo.add(item, ammo.getType().name(), line);
                break;
            }
            case "hand": {
                HandAttribute.Type dt;
                if (args.length < 3) {
                    this.printHelp((CommandSender)player);
                    return;
                }
                try {
                    dt = HandAttribute.Type.valueOf(args[2].toUpperCase());
                }
                catch (IllegalArgumentException ex) {
                    this.errType(sender, HandAttribute.Type.class);
                    return;
                }
                HandAttribute hand = ItemStats.getHand(dt);
                if (hand == null) {
                    return;
                }
                if (args.length == 4) {
                    line = this.getNumI(sender, args[3], -1);
                }
                hand.add(item, "", line);
                break;
            }
            case "stat": {
                if (args.length < 4) {
                    this.printHelp((CommandSender)player);
                    return;
                }
                TypedStat.Type at = TypedStat.Type.getByName(args[2]);
                if (at == null) {
                    this.errType(sender, TypedStat.Type.class);
                    return;
                }
                TypedStat stat = ItemStats.getStat(at);
                if (stat == null) {
                    sender.sendMessage("Stat is not registered!");
                    return;
                }
                double val = StringUT.getDouble((String)args[3], (double)0.0, (boolean)true);
                if (args.length == 5) {
                    line = this.getNumI(sender, args[4], -1);
                }
                if (stat instanceof SimpleStat) {
                    SimpleStat rs = (SimpleStat)stat;
                    rs.add(item, new StatBonus(new double[]{val}, false, null), line);
                } else {
                    DurabilityStat ms = (DurabilityStat)stat;
                    ms.add(item, new double[]{val, val}, line);
                }
                player.getInventory().setItemInMainHand(item);
                break;
            }
            default: {
                this.printHelp((CommandSender)player);
                return;
            }
        }
        ((Divinity)this.plugin).lang().Command_Modify_Done.send((CommandSender)player);
    }

    private void printHelp(CommandSender p) {
        ((Divinity)this.plugin).lang().Command_Set_List.send(p);
    }
}

