/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.utils;

import java.util.Iterator;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.Codex;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.api.items.ItemType;
import studio.magemonkey.codex.api.items.PrefixHelper;
import studio.magemonkey.codex.api.items.exception.MissingItemException;
import studio.magemonkey.codex.api.items.exception.MissingProviderException;
import studio.magemonkey.codex.api.items.providers.ICodexItemProvider;
import studio.magemonkey.codex.modules.IModule;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.LeveledItem;
import studio.magemonkey.divinity.modules.ModuleItem;
import studio.magemonkey.divinity.modules.api.QModuleDrop;
import studio.magemonkey.divinity.modules.list.itemgenerator.ItemGeneratorManager;
import studio.magemonkey.divinity.stats.items.ItemStats;

public class DivinityProvider
implements ICodexItemProvider<DivinityItemType> {
    public static final String NAMESPACE = "DIVINITY";
    private static Pattern levelPattern = Pattern.compile(".*~level:(\\d+).*");
    private static Pattern materialPattern = Pattern.compile(".*~material:(\\w+).*");

    public String pluginName() {
        return "Divinity";
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public ICodexItemProvider.Category getCategory() {
        return ICodexItemProvider.Category.PRO;
    }

    public DivinityItemType getItem(String id) {
        Matcher materialMatcher;
        if (id == null || id.isBlank()) {
            return null;
        }
        id = PrefixHelper.stripPrefix((String)NAMESPACE, (String)id);
        int level = -1;
        ItemType material = null;
        Matcher levelMatcher = levelPattern.matcher(id);
        if (levelMatcher.matches()) {
            try {
                level = Integer.parseInt(levelMatcher.group(1));
            }
            catch (NumberFormatException ignored) {
                Codex.warn((String)("Failed to get level for Divinity item " + id + ". Using -1 instead."));
            }
            id = id.replace("~level:" + levelMatcher.group(1), "");
        }
        if ((materialMatcher = materialPattern.matcher(id)).matches()) {
            try {
                material = CodexEngine.get().getItemManager().getItemType(materialMatcher.group(1));
            }
            catch (MissingItemException | MissingProviderException ignored) {
                Codex.warn((String)("Failed to get material item for Divinity item " + id + ". Using the item's configuration instead."));
            }
            id = id.replace("~material:" + materialMatcher.group(1), "");
        }
        String[] split = id.split(":", 2);
        ModuleItem moduleItem = null;
        if (split.length >= 2) {
            IModule module = Divinity.getInstance().getModuleManager().getModule(split[0]);
            if (!(module instanceof QModuleDrop)) {
                return null;
            }
            moduleItem = (ModuleItem)((Object)((QModuleDrop)module).getItemById(split[1]));
        } else {
            IModule module;
            Iterator iterator = Divinity.getInstance().getModuleManager().getModules().iterator();
            while (iterator.hasNext() && (!((module = (IModule)iterator.next()) instanceof QModuleDrop) || (moduleItem = (ModuleItem)((Object)((QModuleDrop)module).getItemById(id))) == null)) {
            }
        }
        if (moduleItem != null) {
            return new DivinityItemType(moduleItem, level, material);
        }
        return null;
    }

    @Nullable
    public DivinityItemType getItem(ItemStack itemStack) {
        String id = ItemStats.getId(itemStack);
        if (id == null) {
            return null;
        }
        return this.getItem(id);
    }

    public boolean isCustomItem(ItemStack item) {
        return ItemStats.getId(item) != null;
    }

    public boolean isCustomItemOfId(ItemStack item, String id) {
        id = PrefixHelper.stripPrefix((String)NAMESPACE, (String)id);
        String itemId = ItemStats.getId(item);
        return itemId != null && itemId.equals(id);
    }

    public static class DivinityItemType
    extends ItemType {
        private final ModuleItem moduleItem;
        private final int level;
        @Nullable
        private ItemType material;

        public DivinityItemType(ModuleItem moduleItem, int level, @Nullable ItemType material) {
            this.moduleItem = moduleItem;
            this.level = level;
            this.material = material;
        }

        public String getNamespace() {
            return DivinityProvider.NAMESPACE;
        }

        public String getID() {
            return this.moduleItem.getId();
        }

        public ICodexItemProvider.Category getCategory() {
            return ICodexItemProvider.Category.PRO;
        }

        public ItemStack create() {
            if (this.moduleItem instanceof ItemGeneratorManager.GeneratorItem) {
                return ((ItemGeneratorManager.GeneratorItem)this.moduleItem).create(this.level, -1, this.material);
            }
            if (this.moduleItem instanceof LeveledItem) {
                return ((LeveledItem)this.moduleItem).create(this.level);
            }
            return this.moduleItem.create();
        }

        public boolean isInstance(@Nullable ItemStack itemStack) {
            if (itemStack == null) {
                return false;
            }
            String id = ItemStats.getId(itemStack);
            return id != null && id.equals(this.moduleItem.getId()) && Objects.equals(ItemStats.getModule(itemStack), this.moduleItem.getModule());
        }

        @Generated
        public ModuleItem getModuleItem() {
            return this.moduleItem;
        }

        @Generated
        public int getLevel() {
            return this.level;
        }

        @Nullable
        @Generated
        public ItemType getMaterial() {
            return this.material;
        }
    }
}

