/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.stats.items.requirements.user;

import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.config.api.ILangMsg;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.list.soulbound.SoulboundManager;
import studio.magemonkey.divinity.stats.items.requirements.user.AbstractOwnerRequirement;

public class UntradeableRequirement
extends AbstractOwnerRequirement {
    public UntradeableRequirement(@NotNull String name, @NotNull String format) {
        super("untradeable", name, format, "%ITEM_UNTRADEABLE%");
    }

    @Override
    @NotNull
    public String getBypassPermission() {
        return "quantumrpg.bypass.requirement.untradeable";
    }

    @Override
    public boolean canUse(@NotNull Player player, @Nullable UUID value) {
        return value == null || value.equals(DUMMY_ID) || player.getUniqueId().equals(value);
    }

    @Override
    @NotNull
    public String formatValue(@NotNull ItemStack item, @NotNull UUID value) {
        if (value.equals(DUMMY_ID)) {
            return SoulboundManager.UNTRADE_FORMAT_FREE;
        }
        String user = Divinity.getInstance().getServer().getOfflinePlayer(value).getName();
        if (user == null) {
            user = "null";
        }
        return SoulboundManager.UNTRADE_FORMAT_APPLIED.replace("%player%", user);
    }

    @Override
    @NotNull
    public ILangMsg getDenyMessage(@NotNull Player player, @NotNull ItemStack src) {
        String name;
        UUID value = (UUID)this.getRaw(src);
        String user = "null";
        if (value != null && (name = Divinity.getInstance().getServer().getOfflinePlayer(value).getName()) != null) {
            user = name;
        }
        return Divinity.getInstance().lang().Module_Item_Interact_Error_Owner.replace("%owner%", (Object)user);
    }
}

