/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.stats.items.requirements.item;

import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.config.api.ILangMsg;
import studio.magemonkey.codex.util.DataUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.stats.items.ItemStats;
import studio.magemonkey.divinity.stats.items.attributes.SocketAttribute;
import studio.magemonkey.divinity.stats.items.requirements.api.ItemRequirement;

public class ItemSocketRequirement
extends ItemRequirement<String[]> {
    public ItemSocketRequirement(@NotNull String name, @NotNull String format) {
        super("socket", name, format, "%TARGET_SOCKET%", "REQ_ITEM_SOCKET", DataUT.STRING_ARRAY);
        this.keys.add(NamespacedKey.fromString((String)"prorpgitems:req_item_socket"));
        this.keys.add(NamespacedKey.fromString((String)"prorpgitems:qrpg_req_item_socketsocket"));
        this.keys.add(NamespacedKey.fromString((String)"quantumrpg:qrpg_req_item_socketsocket"));
    }

    @Override
    @NotNull
    public Class<String[]> getParameterClass() {
        return String[].class;
    }

    @Override
    public boolean canApply(@NotNull ItemStack src, @NotNull ItemStack target) {
        String[] req = (String[])this.getRaw(src);
        if (req == null || req.length != 2 || req[0].isEmpty() || req[1].isEmpty()) {
            return false;
        }
        SocketAttribute.Type type = SocketAttribute.Type.getByName(req[0]);
        if (type == null) {
            return false;
        }
        SocketAttribute socket = ItemStats.getSocket(type, req[1]);
        if (socket == null) {
            return false;
        }
        return socket.getFirstEmptyIndex(target) >= 0;
    }

    @Override
    public ILangMsg getApplyMessage(@NotNull ItemStack src, @NotNull ItemStack target) {
        ILangMsg msg = Divinity.getInstance().lang().Module_Item_Apply_Error_Socket;
        Object[] arr = (String[])this.getRaw(src);
        if (arr == null || ArrayUtils.isEmpty((Object[])arr) || arr.length != 2) {
            return msg;
        }
        SocketAttribute.Type type = SocketAttribute.Type.getByName((String)arr[0]);
        if (type == null) {
            return msg;
        }
        SocketAttribute socket = ItemStats.getSocket(type, (String)arr[1]);
        if (socket == null) {
            return msg;
        }
        return msg.replace("%socket%", (Object)socket.getName());
    }

    @Override
    @NotNull
    public String formatValue(@NotNull ItemStack item, @NotNull String[] arr) {
        if (ArrayUtils.isEmpty((Object[])arr) || arr.length != 2) {
            Divinity.getInstance().error("Empty/Incomplete arguments for Socket Requirement!");
            return "";
        }
        SocketAttribute.Type type = SocketAttribute.Type.getByName(arr[0]);
        if (type == null) {
            Divinity.getInstance().error("Invalid Socket Type '" + arr[0] + "' for Socket Requirement!");
            return "";
        }
        SocketAttribute socket = ItemStats.getSocket(type, arr[1]);
        if (socket == null) {
            Divinity.getInstance().error("Invalid Socket Attribute Id '" + arr[1] + "' for Socket Requirement!");
            return "";
        }
        return socket.getName();
    }
}

