/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.soulbound;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.commands.CommandRegister;
import studio.magemonkey.codex.commands.api.ISubCommand;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.api.QModule;
import studio.magemonkey.divinity.modules.list.soulbound.SoulGUI;
import studio.magemonkey.divinity.modules.list.soulbound.command.SoulboundSoulCmd;
import studio.magemonkey.divinity.modules.list.soulbound.command.SoulboundUntradeCmd;
import studio.magemonkey.divinity.stats.items.requirements.ItemRequirements;
import studio.magemonkey.divinity.stats.items.requirements.user.SoulboundRequirement;
import studio.magemonkey.divinity.stats.items.requirements.user.UntradeableRequirement;

public class SoulboundManager
extends QModule {
    private boolean bindOnDrop;
    private boolean bindOnPickup;
    private boolean bindOnClick;
    private boolean bindOnUse;
    private Set<String> interactBlockedCmds;
    private boolean interactAllowDrop;
    private boolean interactAllowDeathDrop;
    private SoulGUI gui;
    private SoulboundRequirement reqSoul;
    private UntradeableRequirement reqUntrade;
    public static String SOULBOUND_FORMAT_FREE;
    public static String SOULBOUND_FORMAT_APPLIED;
    public static String UNTRADE_FORMAT_FREE;
    public static String UNTRADE_FORMAT_APPLIED;

    public SoulboundManager(@NotNull Divinity plugin) {
        super(plugin);
    }

    @NotNull
    public String getId() {
        return "soulbound";
    }

    @NotNull
    public String version() {
        return "1.6.0";
    }

    public void setup() {
        String reqName;
        String reqFormat;
        String path2;
        String path = "item-requirements.";
        if (this.cfg.getBoolean(path + "soulbound.enabled")) {
            path2 = "item-requirements.soulbound.";
            reqFormat = this.cfg.getString(path2 + "format.main", "&6%state%%name%: %value%");
            reqName = this.cfg.getString(path2 + "name", "Soulbound");
            SOULBOUND_FORMAT_FREE = StringUT.color((String)this.cfg.getString(path2 + "format.value.free", "Required"));
            SOULBOUND_FORMAT_APPLIED = StringUT.color((String)this.cfg.getString(path2 + "format.value.applied", "%player%"));
            this.reqSoul = new SoulboundRequirement(reqName, reqFormat);
            ItemRequirements.registerUserRequirement(this.reqSoul);
            this.moduleCommand.addSubCommand((ISubCommand)new SoulboundSoulCmd(this, this.reqSoul));
        }
        if (this.cfg.getBoolean(path + "untradeable.enabled")) {
            path2 = "item-requirements.untradeable.";
            reqFormat = this.cfg.getString(path2 + "format.main", "&6%state%%name%: %value%");
            reqName = this.cfg.getString(path2 + "name", "Trade State");
            UNTRADE_FORMAT_FREE = StringUT.color((String)this.cfg.getString(path2 + "format.value.free", "Will be untradeable on pickup"));
            UNTRADE_FORMAT_APPLIED = StringUT.color((String)this.cfg.getString(path2 + "format.value.applied", "Untradeable"));
            this.reqUntrade = new UntradeableRequirement(reqName, reqFormat);
            ItemRequirements.registerUserRequirement(this.reqUntrade);
            this.moduleCommand.addSubCommand((ISubCommand)new SoulboundUntradeCmd(this, this.reqUntrade));
        }
        path = "bind-to-player.";
        this.bindOnDrop = this.cfg.getBoolean(path + "on-item-drop");
        this.bindOnPickup = this.cfg.getBoolean(path + "on-item-pickup");
        this.bindOnClick = this.cfg.getBoolean(path + "on-item-click");
        this.bindOnUse = this.cfg.getBoolean(path + "on-item-interact");
        path = "interact.";
        this.interactBlockedCmds = new HashSet<String>(this.cfg.getStringList(path + "blocked-commands"));
        this.interactAllowDrop = this.cfg.getBoolean(path + "allow-drop");
        this.interactAllowDeathDrop = this.cfg.getBoolean(path + "drop-on-death");
        this.gui = new SoulGUI(this);
    }

    public void shutdown() {
        if (this.gui != null) {
            this.gui.shutdown();
            this.gui = null;
        }
        if (this.interactBlockedCmds != null) {
            this.interactBlockedCmds.clear();
            this.interactBlockedCmds = null;
        }
    }

    private boolean hasOwner(@NotNull ItemStack item) {
        return this.getOwner(item) != null;
    }

    private boolean isOwner(@NotNull ItemStack item, @NotNull Player player) {
        UUID id = this.getOwner(item);
        return id != null && id.equals(player.getUniqueId());
    }

    @Nullable
    private UUID getOwner(@NotNull ItemStack item) {
        if (this.reqSoul != null && this.reqSoul.isApplied(item) && !this.reqSoul.isRequired(item)) {
            return (UUID)this.reqSoul.getRaw(item);
        }
        if (this.reqUntrade != null && this.reqUntrade.isApplied(item) && !this.reqUntrade.isRequired(item)) {
            return (UUID)this.reqUntrade.getRaw(item);
        }
        return null;
    }

    private void openGUI(@NotNull Player player, @NotNull ItemStack item) {
        if (this.reqSoul == null) {
            return;
        }
        ItemStack src = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)src.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(StringUT.color((String)("&c" + player.getName())));
            meta.setOwningPlayer((OfflinePlayer)player);
            src.setItemMeta((ItemMeta)meta);
        }
        ItemStack result = new ItemStack(item);
        this.reqSoul.add(result, player.getUniqueId(), -1);
        this.gui.open(player, item, src, result);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onSoulPickup(EntityPickupItemEvent e) {
        if (!(e.getEntity() instanceof Player)) {
            return;
        }
        ItemStack item = e.getItem().getItemStack();
        Player player = (Player)e.getEntity();
        if (this.hasOwner(item)) {
            if (!this.isOwner(item, player)) {
                e.setCancelled(true);
                ((Divinity)this.plugin).lang().Soulbound_Item_Interact_Error_Pickup.send((CommandSender)player);
            }
            return;
        }
        if (this.reqUntrade != null && this.reqUntrade.isApplied(item) && this.bindOnPickup) {
            this.reqUntrade.add(item, player.getUniqueId(), -1);
            this.reqUntrade.updateItem(player, item);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onSoulStart(InventoryClickEvent e) {
        if (e.getSlotType() == InventoryType.SlotType.CRAFTING) {
            return;
        }
        if (e.getSlotType() == InventoryType.SlotType.ARMOR || e.getSlot() == 40) {
            return;
        }
        ItemStack item = e.getCurrentItem();
        if (item == null || !item.hasItemMeta()) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        Inventory inv = e.getInventory();
        if (inv.getType() == InventoryType.CRAFTING) {
            if (this.reqSoul != null && this.reqSoul.isRequired(item) && e.isRightClick() && !e.isShiftClick()) {
                this.openGUI(p, item);
                e.setCurrentItem(null);
                e.setCancelled(true);
                return;
            }
        } else if (this.hasOwner(item) && !this.isOwner(item, p) && !p.hasPermission("quantumrpg.bypass.requirement.untradeable")) {
            e.setCancelled(true);
            return;
        }
        if (this.reqUntrade != null && this.reqUntrade.isApplied(item) && !this.hasOwner(item) && this.bindOnClick) {
            this.reqUntrade.add(item, p.getUniqueId(), -1);
            this.reqUntrade.updateItem(p, item);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBindUntradeUse(PlayerInteractEvent e) {
        if (this.reqUntrade == null) {
            return;
        }
        if (e.useItemInHand() == Event.Result.DENY) {
            return;
        }
        ItemStack item = e.getItem();
        if (item == null) {
            return;
        }
        if (this.reqUntrade.isApplied(item) && !this.hasOwner(item) && this.bindOnUse) {
            Player p = e.getPlayer();
            this.reqUntrade.add(item, p.getUniqueId(), -1);
            this.reqUntrade.updateItem(p, item);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBindItemDrop(PlayerDropItemEvent e) {
        Item drop = e.getItemDrop();
        ItemStack item = drop.getItemStack();
        if (this.hasOwner(item)) {
            if (!this.interactAllowDrop) {
                e.setCancelled(true);
            }
            return;
        }
        if (this.reqUntrade != null && this.reqUntrade.isApplied(item) && this.bindOnDrop) {
            Player p = e.getPlayer();
            this.reqUntrade.add(item, p.getUniqueId(), -1);
            this.reqUntrade.updateItem(p, item);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onSoulboundCommands(PlayerCommandPreprocessEvent e) {
        if (this.interactBlockedCmds.isEmpty()) {
            return;
        }
        Player player = e.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        ItemStack item2 = player.getInventory().getItemInOffHand();
        if (!ItemUT.isAir((ItemStack)item) && this.hasOwner(item) || !ItemUT.isAir((ItemStack)item2) && this.hasOwner(item2)) {
            String msg = e.getMessage();
            String cmd = StringUT.extractCommandName((String)msg);
            for (String alias : CommandRegister.getAliases((String)cmd)) {
                if (!this.interactBlockedCmds.contains(alias)) continue;
                e.setCancelled(true);
                ((Divinity)this.plugin).lang().Soulbound_Item_Interact_Error_Command.send((CommandSender)player);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onSoulboundHopper(InventoryPickupItemEvent e) {
        ItemStack item = e.getItem().getItemStack();
        if (e.getInventory().getType() == InventoryType.HOPPER && this.hasOwner(item)) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onSoulboundDeath(PlayerDeathEvent e) {
        if (this.interactAllowDeathDrop) {
            return;
        }
        final ArrayList<ItemStack> list2 = new ArrayList<ItemStack>();
        for (ItemStack item : new ArrayList(e.getDrops())) {
            if (!this.hasOwner(item)) continue;
            e.getDrops().remove(item);
            list2.add(item);
        }
        final Player player = e.getEntity();
        ((Divinity)this.plugin).getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                for (ItemStack i : list2) {
                    player.getInventory().addItem(new ItemStack[]{i});
                }
            }
        });
    }
}

