/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.itemgenerator.generators;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.manager.api.ClickType;
import studio.magemonkey.codex.util.DataUT;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.codex.util.random.Rnd;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.list.itemgenerator.ItemGeneratorManager;
import studio.magemonkey.divinity.modules.list.itemgenerator.api.AbstractAttributeGenerator;
import studio.magemonkey.divinity.utils.LoreUT;

public class AbilityGenerator
extends AbstractAttributeGenerator {
    public static NamespacedKey LEGACY_KEY;
    public static NamespacedKey ABILITY_KEY;
    public static NamespacedKey SKILL_LORE_KEY;
    private final Map<Ability, Double> abilities;

    public AbilityGenerator(@NotNull Divinity plugin, @NotNull ItemGeneratorManager.GeneratorItem generatorItem, @NotNull String placeholder) {
        super(plugin, generatorItem, placeholder);
        LEGACY_KEY = NamespacedKey.fromString((String)"prorpgitems:skills");
        ABILITY_KEY = NamespacedKey.fromString((String)"skills", (Plugin)plugin);
        SKILL_LORE_KEY = NamespacedKey.fromString((String)"skill-lore", (Plugin)plugin);
        JYML cfg = this.generatorItem.getConfig();
        String path = "generator.skills.";
        this.minAmount = cfg.getInt(path + "minimum");
        this.maxAmount = Math.min(cfg.getInt(path + "maximum"), ClickType.values().length);
        this.abilities = new HashMap<Ability, Double>();
        for (String abilityId : cfg.getSection(path + "list")) {
            String path2 = path + "list." + abilityId + ".";
            double chance = cfg.getDouble(path2 + "chance");
            if (chance <= 0.0) continue;
            Ability ability = new Ability(abilityId, cfg.getInt(path2 + "min-level", 1), cfg.getInt(path2 + "max-level", 1), cfg.getStringList(path2 + "lore-format"));
            this.abilities.put(ability, chance);
        }
    }

    public static void updateNamespace(@NotNull ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        String[] abilityArray = DataUT.getStringArrayData((ItemStack)item, (NamespacedKey)LEGACY_KEY);
        if (abilityArray == null) {
            return;
        }
        DataUT.setData((ItemStack)item, (NamespacedKey)ABILITY_KEY, (Object)abilityArray);
    }

    @Nullable
    public Ability getAbility(String id) {
        return this.abilities.keySet().stream().filter(ability -> ability.getId().equalsIgnoreCase(id)).findFirst().orElse(null);
    }

    @Override
    public void generate(@NotNull ItemStack item, int itemLevel) {
        Ability ability;
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        int min = this.getMinAmount();
        int max = this.getMaxAmount();
        if (max == 0 || this.abilities.isEmpty()) {
            LoreUT.replacePlaceholder(item, this.placeholder, null);
            return;
        }
        HashMap<Ability, Double> abilityMap = new HashMap<Ability, Double>(this.abilities);
        boolean isMaxUnlimited = max < 0;
        boolean isMinUnlimited = min < 0;
        int rollMax = isMaxUnlimited ? 0x7FFFFFFE : max;
        int rollMin = isMinUnlimited ? Rnd.get((int)(rollMax + 1)) : min;
        int roll = Rnd.get((int)(isMaxUnlimited ? rollMax : rollMin), (int)rollMax);
        if (roll <= 0) {
            LoreUT.replacePlaceholder(item, this.placeholder, null);
            return;
        }
        HashMap<Ability, Integer> abilityAdd = new HashMap<Ability, Integer>();
        for (int count = 0; count < roll && !abilityMap.isEmpty() && (ability = (Ability)Rnd.getRandomItem(abilityMap, (boolean)true)) != null; ++count) {
            if (count >= rollMin) {
                double chance = (Double)abilityMap.get(ability);
                if ((double)Rnd.get((boolean)true) > chance) {
                    abilityMap.remove(ability);
                    continue;
                }
            }
            int level = ability.getRndLevel();
            abilityAdd.put(ability, level);
            abilityMap.remove(ability);
        }
        item.setItemMeta(meta);
        int i = 0;
        String[] abilityArray = new String[abilityAdd.size()];
        for (Map.Entry entry : abilityAdd.entrySet()) {
            abilityArray[i] = ((Ability)entry.getKey()).getId() + ":" + String.valueOf(entry.getValue()) + ":item";
            ++i;
        }
        DataUT.setData((ItemStack)item, (NamespacedKey)ABILITY_KEY, (Object)abilityArray);
        this.updateLore(item);
    }

    public static Map<String, AbilityInfo> getAbilities(ItemStack item) {
        HashMap<String, AbilityInfo> map = new HashMap<String, AbilityInfo>();
        if (item == null) {
            return map;
        }
        String[] stringAbilities = DataUT.getStringArrayData((ItemStack)item, (NamespacedKey)ABILITY_KEY);
        if (stringAbilities == null) {
            return map;
        }
        for (String stringAbility : stringAbilities) {
            AbilityInfo info = new AbilityInfo();
            String[] split = stringAbility.split(":");
            if (split.length < 2) continue;
            info.setId(split[0]);
            try {
                info.setLevel(Integer.parseInt(split[1]));
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (split.length > 2) {
                info.setSource(split[2]);
            }
            map.put(info.getId(), info);
        }
        return map;
    }

    public void updateLore(ItemStack item) {
        Map<String, AbilityInfo> abilities = AbilityGenerator.getAbilities(item);
        if (abilities.isEmpty()) {
            return;
        }
        List<Ability> abilityList = this.abilities.keySet().stream().filter(ability -> abilities.containsKey(ability.getId())).collect(Collectors.toList());
        AbilityGenerator.updateLore(item, abilities, abilityList);
    }

    public static void updateLore(ItemStack item, Map<String, AbilityInfo> abilities, List<Ability> abilityList) {
        if (abilityList.isEmpty()) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        List lore = meta.getLore();
        if (lore == null) {
            return;
        }
        StringBuilder loreTag = new StringBuilder();
        String storedTag = ItemUT.getLoreTag((ItemStack)item, (String)SKILL_LORE_KEY.getKey());
        String[] storedLines = storedTag != null ? storedTag.split("__x__") : new String[]{};
        int pos = lore.indexOf("%GENERATOR_SKILLS%");
        if (pos < 0) {
            if (storedLines.length > 0) {
                int index;
                int firstIndex = -1;
                for (String storedLine : storedLines) {
                    ++firstIndex;
                    if (!StringUT.colorOff((String)storedLine).isEmpty()) break;
                }
                if ((index = lore.indexOf(storedLines[firstIndex]) - firstIndex) >= 0) {
                    pos = index;
                    for (int count = 0; count < storedLines.length; ++count) {
                        lore.remove(index);
                    }
                }
            }
            if (pos < 0) {
                return;
            }
        } else {
            lore.remove(pos);
        }
        for (Ability ability : abilityList) {
            int level = abilities.get(ability.getId()).getLevel();
            for (String format : ability.getLoreFormat()) {
                String loreLine = format.replace("%level%", String.valueOf(level));
                pos = LoreUT.addToLore(lore, pos, loreLine);
                loreTag.append(loreLine).append("__x__");
            }
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        if (loreTag.length() > 0) {
            loreTag.setLength(loreTag.length() - "__x__".length());
            ItemUT.addLoreTag((ItemStack)item, (String)SKILL_LORE_KEY.getKey(), (String)loreTag.toString());
        }
    }

    public static class Ability {
        private final String id;
        private final int minLevel;
        private final int maxLevel;
        private final List<String> loreFormat;

        public Ability(@NotNull String id, int minLevel, int maxLevel, @NotNull List<String> loreFormat) {
            this.id = id.toLowerCase();
            this.minLevel = minLevel;
            this.maxLevel = maxLevel;
            this.loreFormat = StringUT.color(loreFormat);
        }

        @NotNull
        public String getId() {
            return this.id;
        }

        public int getRndLevel() {
            return Rnd.get((int)this.minLevel, (int)this.maxLevel);
        }

        @NotNull
        public List<String> getLoreFormat() {
            return this.loreFormat;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Ability ability = (Ability)o;
            return this.id.equals(ability.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }

    public static class AbilityInfo {
        private String id;
        private int level;
        private String source;

        public String getSource() {
            return Objects.requireNonNullElse(this.source, "item");
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public int getLevel() {
            return this.level;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setLevel(int level) {
            this.level = level;
        }

        @Generated
        public void setSource(String source) {
            this.source = source;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AbilityInfo)) {
                return false;
            }
            AbilityInfo other = (AbilityInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLevel() != other.getLevel()) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$source = this.getSource();
            String other$source = other.getSource();
            return !(this$source == null ? other$source != null : !this$source.equals(other$source));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AbilityInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLevel();
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : $source.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AbilityGenerator.AbilityInfo(id=" + this.getId() + ", level=" + this.getLevel() + ", source=" + this.getSource() + ")";
        }

        @Generated
        public AbilityInfo() {
        }

        @Generated
        public AbilityInfo(String id, int level, String source) {
            this.id = id;
            this.level = level;
            this.source = source;
        }
    }
}

