/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.itemgenerator.editor;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import studio.magemonkey.codex.core.Version;
import studio.magemonkey.codex.manager.api.menu.Slot;
import studio.magemonkey.codex.util.ItemUT;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.codex.util.random.Rnd;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.AbstractEditorGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.AmmoTypesGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.HandTypesGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.ItemFlagsGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.LoreGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.TierGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.UsesByLevelGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.bonuses.MainBonusesGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.enchantments.EnchantmentsGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.materials.MainMaterialsGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.requirements.MainRequirementsGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.skills.MainSkillsGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.sockets.MainSocketsGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.stats.MainStatsGUI;
import studio.magemonkey.divinity.modules.list.itemgenerator.editor.trimmings.TrimmingListGUI;

public class EditorGUI
extends AbstractEditorGUI {
    public EditorGUI(Player player, AbstractEditorGUI.ItemGeneratorReference itemGenerator) {
        super(player, 5, "Editor", itemGenerator);
    }

    public void setContents() {
        ArrayList<CallSite> lore;
        ItemMeta itemMeta;
        ItemStack itemStack;
        this.setSlot(0, new Slot(EditorGUI.createItem(Material.NAME_TAG, "&eName format", (List<String>)StringUT.replace((String)"%current%", (List)StringUT.wrap((String)this.itemGenerator.getHandle().getName().substring("\u00a7r\u00a7f".length()), (int)30), (String[])new String[]{"&bCurrent: &a%current%", "&6Left-Click: &eSet", "&6Right-Click: &eSet to default value"}))){

            public void onLeftClick() {
                EditorGUI.this.sendSetMessage(ItemType.NAME.getTitle(), EditorGUI.this.itemGenerator.getHandle().getName().substring("\u00a7r\u00a7f".length()).replace('\u00a7', '&'), s -> {
                    EditorGUI.this.itemGenerator.getConfig().set(ItemType.NAME.getPath(), s);
                    EditorGUI.this.saveAndReopen();
                });
            }

            public void onRightClick() {
                EditorGUI.this.setDefault(ItemType.NAME.getPath());
                EditorGUI.this.saveAndReopen();
            }
        });
        this.setSlot(1, new Slot(EditorGUI.createItem(Material.IRON_INGOT, "&eMaterials", "&6Left-Click: &eModify")){

            public void onLeftClick() {
                EditorGUI.this.openSubMenu(new MainMaterialsGUI(EditorGUI.this.player, EditorGUI.this.itemGenerator));
            }
        });
        this.setSlot(2, new Slot(EditorGUI.createItem(Material.WRITABLE_BOOK, "&eLore format", (List<String>)StringUT.replace((String)"%current%", (List)this.itemGenerator.getConfig().getStringList(ItemType.LORE.getPath()), (String[])new String[]{"&bCurrent:", "&a----------", "&f%current%", "&a----------", "&6Left-Click: &eModify", "&6Right-Click: &eSet to default value"}))){

            public void onLeftClick() {
                EditorGUI.this.openSubMenu(new LoreGUI(EditorGUI.this.player, "[&d" + EditorGUI.this.itemGenerator.getId() + "&r] editor/" + ItemType.LORE.getTitle(), EditorGUI.this.itemGenerator, ItemType.LORE.getPath()));
            }

            public void onRightClick() {
                EditorGUI.this.setDefault(ItemType.LORE.getPath());
                EditorGUI.this.saveAndReopen();
            }
        });
        this.setSlot(3, new Slot(EditorGUI.createItem(Material.END_CRYSTAL, "&eCustom Model Data", "&bCurrent: &a" + this.itemGenerator.getConfig().getInt(ItemType.MODEL_DATA.getPath(), 0), "&6Left-Click: &eSet", "&6Shift-Left-Click: &eDecrease", "&6Shift-Right-Click: &eIncrease", "&6Right-Click: &eSet to default value")){

            public void onShiftLeftClick() {
                EditorGUI.this.itemGenerator.getConfig().set(ItemType.MODEL_DATA.getPath(), (Object)Math.max(0, EditorGUI.this.itemGenerator.getConfig().getInt(ItemType.MODEL_DATA.getPath(), 0) - 1));
                EditorGUI.this.saveAndReopen();
            }

            public void onShiftRightClick() {
                EditorGUI.this.itemGenerator.getConfig().set(ItemType.MODEL_DATA.getPath(), (Object)Math.max(0, EditorGUI.this.itemGenerator.getConfig().getInt(ItemType.MODEL_DATA.getPath(), 0) + 1));
                EditorGUI.this.saveAndReopen();
            }

            public void onLeftClick() {
                EditorGUI.this.sendSetMessage(ItemType.MODEL_DATA.getTitle(), String.valueOf(EditorGUI.this.itemGenerator.getConfig().getInt(ItemType.MODEL_DATA.getPath(), 0)), s -> {
                    int cmd = Integer.parseInt(s);
                    if (cmd < 0) {
                        throw new IllegalArgumentException();
                    }
                    EditorGUI.this.itemGenerator.getConfig().set(ItemType.MODEL_DATA.getPath(), (Object)cmd);
                    EditorGUI.this.saveAndReopen();
                });
            }

            public void onRightClick() {
                EditorGUI.this.itemGenerator.getConfig().remove(ItemType.MODEL_DATA.getPath());
                EditorGUI.this.saveAndReopen();
            }
        });
        final int[] color = this.itemGenerator.getHandle().getColor();
        if (color == null) {
            itemStack = EditorGUI.createItem(Material.GLASS_BOTTLE, "&eColor", "&bCurrent: &anull", "&6Left-Click: &eSet", "&6Drop: &eRemove");
        } else {
            itemStack = EditorGUI.createItem(Material.POTION, "&eColor", "&bCurrent: &a" + color[0] + "," + color[1] + "," + color[2], "&6Left-Click: &eSet", "&6Right-Click: &eRemove");
            ItemMeta meta = itemStack.getItemMeta();
            if (meta instanceof PotionMeta) {
                int r = color[0] >= 0 ? color[0] : Rnd.get((int)255);
                int g = color[1] >= 0 ? color[1] : Rnd.get((int)255);
                int b = color[2] >= 0 ? color[2] : Rnd.get((int)255);
                ((PotionMeta)meta).setColor(Color.fromRGB((int)r, (int)g, (int)b));
                itemStack.setItemMeta(meta);
            }
        }
        this.setSlot(4, new Slot(itemStack){

            public void onLeftClick() {
                EditorGUI.this.sendSetMessage(ItemType.COLOR.getTitle(), (String)(color == null ? "null" : color[0] + "," + color[1] + "," + color[2]), s -> {
                    String[] splitString = s.split(",");
                    if (splitString.length != 3) {
                        throw new IllegalArgumentException();
                    }
                    int[] rgb = new int[]{Integer.parseInt(splitString[0].strip()), Integer.parseInt(splitString[1].strip()), Integer.parseInt(splitString[2].strip())};
                    EditorGUI.this.itemGenerator.getConfig().set(ItemType.COLOR.getPath(), (Object)(rgb[0] + "," + rgb[1] + "," + rgb[2]));
                    EditorGUI.this.saveAndReopen();
                });
            }

            public void onRightClick() {
                EditorGUI.this.itemGenerator.getConfig().remove(ItemType.COLOR.getPath());
                EditorGUI.this.saveAndReopen();
            }
        });
        this.setSlot(5, new Slot(EditorGUI.createItem(Material.ANVIL, "&eDurability", "&bCurrent: &a" + this.itemGenerator.getConfig().getInt(ItemType.DURABILITY.getPath(), 0), "&6Left-Click: &eSet", "&6Shift-Left-Click: &eDecrease", "&6Shift-Right-Click: &eIncrease", "&6Right-Click: &eSet to default value")){

            public void onShiftLeftClick() {
                EditorGUI.this.itemGenerator.getConfig().set(ItemType.DURABILITY.getPath(), (Object)Math.max(0, EditorGUI.this.itemGenerator.getConfig().getInt(ItemType.DURABILITY.getPath(), 0) - 1));
                EditorGUI.this.saveAndReopen();
            }

            public void onShiftRightClick() {
                EditorGUI.this.itemGenerator.getConfig().set(ItemType.DURABILITY.getPath(), (Object)Math.max(0, EditorGUI.this.itemGenerator.getConfig().getInt(ItemType.DURABILITY.getPath(), 0) + 1));
                EditorGUI.this.saveAndReopen();
            }

            public void onLeftClick() {
                EditorGUI.this.sendSetMessage(ItemType.DURABILITY.getTitle(), String.valueOf(EditorGUI.this.itemGenerator.getConfig().getInt(ItemType.DURABILITY.getPath(), 0)), s -> {
                    int durability = Integer.parseInt(s);
                    if (durability < 0) {
                        throw new IllegalArgumentException();
                    }
                    EditorGUI.this.itemGenerator.getConfig().set(ItemType.DURABILITY.getPath(), (Object)durability);
                    EditorGUI.this.saveAndReopen();
                });
            }

            public void onRightClick() {
                EditorGUI.this.itemGenerator.getConfig().remove(ItemType.DURABILITY.getPath());
                EditorGUI.this.saveAndReopen();
            }
        });
        itemStack = EditorGUI.createItem(Material.ELYTRA, "&eUnbreakable", "&bCurrent: &a" + this.itemGenerator.getHandle().isUnbreakable(), "&6Left-Click: &eToggle", "&6Right-Click: &eSet to default value");
        if (!this.itemGenerator.getHandle().isUnbreakable() && (itemMeta = itemStack.getItemMeta()) instanceof Damageable) {
            ((Damageable)itemMeta).setDamage(432);
            itemStack.setItemMeta(itemMeta);
        }
        this.setSlot(6, new Slot(itemStack){

            public void onLeftClick() {
                EditorGUI.this.itemGenerator.getConfig().set(ItemType.UNBREAKABLE.getPath(), (Object)(!EditorGUI.this.itemGenerator.getHandle().isUnbreakable() ? 1 : 0));
                EditorGUI.this.saveAndReopen();
            }

            public void onRightClick() {
                EditorGUI.this.setDefault(ItemType.UNBREAKABLE.getPath());
                EditorGUI.this.saveAndReopen();
            }
        });
        this.setSlot(7, new Slot(EditorGUI.createItem(Material.BROWN_MUSHROOM, "&ePrefix Chance", List.of("&bCurrent: &a" + this.itemGenerator.getHandle().getPrefixChance(), "&6Left-Click: &eSet", "&6Right-Click: &eSet to default value"))){

            public void onLeftClick() {
                EditorGUI.this.sendSetMessage(ItemType.PREFIX_CHANCE.getTitle(), String.valueOf(EditorGUI.this.itemGenerator.getHandle().getPrefixChance()), s -> {
                    EditorGUI.this.itemGenerator.getConfig().set(ItemType.PREFIX_CHANCE.getPath(), (Object)Double.parseDouble(s));
                    EditorGUI.this.saveAndReopen();
                });
            }

            public void onRightClick() {
                EditorGUI.this.setDefault(ItemType.PREFIX_CHANCE.getPath());
                EditorGUI.this.saveAndReopen();
            }
        });
        this.setSlot(8, new Slot(EditorGUI.createItem(Material.RED_MUSHROOM, "&eSuffix Chance", "&bCurrent: &a" + this.itemGenerator.getHandle().getSuffixChance(), "&6Left-Click: &eSet", "&6Right-Click: &eSet to default value")){

            public void onLeftClick() {
                EditorGUI.this.sendSetMessage(ItemType.SUFFIX_CHANCE.getTitle(), String.valueOf(EditorGUI.this.itemGenerator.getHandle().getSuffixChance()), s -> {
                    EditorGUI.this.itemGenerator.getConfig().set(ItemType.SUFFIX_CHANCE.getPath(), (Object)Double.parseDouble(s));
                    EditorGUI.this.saveAndReopen();
                });
            }

            public void onRightClick() {
                EditorGUI.this.setDefault(ItemType.SUFFIX_CHANCE.getPath());
                EditorGUI.this.saveAndReopen();
            }
        });
        if (Version.CURRENT.isHigher(Version.V1_19_R3)) {
            lore = new ArrayList<CallSite>();
            this.setSlot(11, new Slot(EditorGUI.createItem(Material.SENTRY_ARMOR_TRIM_SMITHING_TEMPLATE, "&eArmor Trimmings", (List<String>)StringUT.replace((String)"%current%", lore, (String[])new String[]{"&bCurrent:", "&a%current%", "&6Left-Click: &eModify"}))){

                public void onLeftClick() {
                    EditorGUI.this.openSubMenu(new TrimmingListGUI(EditorGUI.this.player, EditorGUI.this.itemGenerator));
                }
            });
        }
        lore = new ArrayList();
        for (ItemFlag flag : this.itemGenerator.getHandle().getFlags()) {
            lore.add((CallSite)((Object)("- " + flag.name().toLowerCase())));
        }
        this.setSlot(12, new Slot(EditorGUI.createItem(Material.OAK_SIGN, "&eItemFlags", (List<String>)StringUT.replace((String)"%current%", lore, (String[])new String[]{"&bCurrent:", "&a%current%", "&6Left-Click: &eModify", "&6Right-Click: &eSet to default value"}))){

            public void onLeftClick() {
                EditorGUI.this.openSubMenu(new ItemFlagsGUI(EditorGUI.this.player, EditorGUI.this.itemGenerator));
            }

            public void onRightClick() {
                EditorGUI.this.setDefault(ItemType.ITEM_FLAGS.getPath());
                EditorGUI.this.saveAndReopen();
            }
        });
        boolean enchanted = this.itemGenerator.getConfig().getBoolean(ItemType.ENCHANTED.getPath(), false);
        this.setSlot(13, new Slot(EditorGUI.createItem(enchanted ? Material.ENCHANTED_BOOK : Material.BOOK, "&eEnchanted", "&bCurrent: &a" + enchanted, "&6Left-Click: &eToggle", "&6Right-Click: &eSet to default value")){

            public void onLeftClick() {
                EditorGUI.this.itemGenerator.getConfig().set(ItemType.ENCHANTED.getPath(), (Object)(!EditorGUI.this.itemGenerator.getConfig().getBoolean(ItemType.ENCHANTED.getPath()) ? 1 : 0));
                EditorGUI.this.saveAndReopen();
            }

            public void onRightClick() {
                EditorGUI.this.itemGenerator.getConfig().remove(ItemType.ENCHANTED.getPath());
                EditorGUI.this.saveAndReopen();
            }
        });
        String hash = this.itemGenerator.getConfig().getString(ItemType.SKULL_HASH.getPath());
        itemStack = EditorGUI.createItem(Material.PLAYER_HEAD, "&eSkull Hash", (List<String>)StringUT.replace((String)"%current%", (List)StringUT.wrap((String)(hash == null ? "\"\"" : hash), (int)30), (String[])new String[]{"&bCurrent: &a%current%", "&6Left-Click: &eSet", "&6Right-Click: &eSet to default value"}));
        if (hash != null) {
            ItemUT.addSkullTexture((ItemStack)itemStack, (String)hash, (String)this.itemGenerator.getId());
        }
        this.setSlot(14, new Slot(itemStack){

            public void onLeftClick() {
                String current = EditorGUI.this.itemGenerator.getConfig().getString(ItemType.SKULL_HASH.getPath());
                EditorGUI.this.sendSetMessage(ItemType.SKULL_HASH.getTitle(), current == null ? "" : current, s -> {
                    EditorGUI.this.itemGenerator.getConfig().set(ItemType.SKULL_HASH.getPath(), s);
                    EditorGUI.this.saveAndReopen();
                });
            }

            public void onRightClick() {
                EditorGUI.this.itemGenerator.getConfig().remove(ItemType.SKULL_HASH.getPath());
                EditorGUI.this.saveAndReopen();
            }
        });
        this.setSlot(15, new Slot(EditorGUI.createItem(Material.GOLD_INGOT, "&eStat Bonuses", "&6Left-Click: &eModify")){

            public void onLeftClick() {
                EditorGUI.this.openSubMenu(new MainBonusesGUI(EditorGUI.this.player, EditorGUI.this.itemGenerator));
            }
        });
        this.setSlot(20, new Slot(EditorGUI.createItem(Material.EXPERIENCE_BOTTLE, "&eMinimum Level", "&bCurrent: &a" + this.itemGenerator.getConfig().getInt(ItemType.MIN_LEVEL.getPath()), "&6Left-Click: &eSet", "&6Shift-Left-Click: &eDecrease", "&6Shift-Right-Click: &eIncrease", "&6Right-Click: &eSet to default value")){

            public void onShiftLeftClick() {
                EditorGUI.this.itemGenerator.getConfig().set(ItemType.MIN_LEVEL.getPath(), (Object)Math.max(0, EditorGUI.this.itemGenerator.getHandle().getMinLevel() - 1));
                EditorGUI.this.saveAndReopen();
            }

            public void onShiftRightClick() {
                EditorGUI.this.itemGenerator.getConfig().set(ItemType.MIN_LEVEL.getPath(), (Object)Math.max(0, EditorGUI.this.itemGenerator.getHandle().getMinLevel() + 1));
                EditorGUI.this.saveAndReopen();
            }

            public void onLeftClick() {
                EditorGUI.this.sendSetMessage(ItemType.MIN_LEVEL.getTitle(), String.valueOf(EditorGUI.this.itemGenerator.getHandle().getMinLevel()), s -> {
                    int level = Integer.parseInt(s);
                    if (level < 0) {
                        throw new IllegalArgumentException();
                    }
                    EditorGUI.this.itemGenerator.getConfig().set(ItemType.MIN_LEVEL.getPath(), (Object)level);
                    EditorGUI.this.saveAndReopen();
                });
            }

            public void onRightClick() {
                EditorGUI.this.setDefault(ItemType.MIN_LEVEL.getPath());
                EditorGUI.this.saveAndReopen();
            }
        });
        this.setSlot(21, new Slot(EditorGUI.createItem(Material.EXPERIENCE_BOTTLE, "&eMaximum Level", "&bCurrent: &a" + this.itemGenerator.getConfig().getInt(ItemType.MAX_LEVEL.getPath()), "&6Left-Click: &eSet", "&6Shift-Left-Click: &eDecrease", "&6Shift-Right-Click: &eIncrease", "&6Right-Click: &eSet to default value")){

            public void onShiftLeftClick() {
                EditorGUI.this.itemGenerator.getConfig().set(ItemType.MAX_LEVEL.getPath(), (Object)(EditorGUI.this.itemGenerator.getHandle().getMaxLevel() - 1));
                EditorGUI.this.saveAndReopen();
            }

            public void onShiftRightClick() {
                EditorGUI.this.itemGenerator.getConfig().set(ItemType.MAX_LEVEL.getPath(), (Object)(EditorGUI.this.itemGenerator.getHandle().getMaxLevel() + 1));
                EditorGUI.this.saveAndReopen();
            }

            public void onLeftClick() {
                EditorGUI.this.sendSetMessage(ItemType.MAX_LEVEL.getTitle(), String.valueOf(EditorGUI.this.itemGenerator.getHandle().getMaxLevel()), s -> {
                    int level = Integer.parseInt(s);
                    if (level < 0) {
                        throw new IllegalArgumentException();
                    }
                    EditorGUI.this.itemGenerator.getConfig().set(ItemType.MAX_LEVEL.getPath(), (Object)level);
                    EditorGUI.this.saveAndReopen();
                });
            }

            public void onRightClick() {
                EditorGUI.this.setDefault(ItemType.MAX_LEVEL.getPath());
                EditorGUI.this.saveAndReopen();
            }
        });
        this.setSlot(22, new Slot(EditorGUI.createItem(Material.DIAMOND, "&eTier", (List<String>)StringUT.replace((String)"%current%", (List)StringUT.wrap((String)this.itemGenerator.getHandle().getTier().getName(), (int)12), (String[])new String[]{"&bCurrent: &a%current%", "&6Left-Click: &eSet", "&6Right-Click: &eSet to default value"}))){

            public void onLeftClick() {
                EditorGUI.this.openSubMenu(new TierGUI(EditorGUI.this.player, EditorGUI.this.itemGenerator));
            }

            public void onRightClick() {
                EditorGUI.this.setDefault(ItemType.TIER.getPath());
                EditorGUI.this.saveAndReopen();
            }
        });
        lore = new ArrayList();
        ConfigurationSection ammoSection = this.itemGenerator.getConfig().getConfigurationSection(ItemType.AMMO_TYPES.getPath());
        if (ammoSection != null) {
            for (String ammoType : ammoSection.getKeys(false)) {
                lore.add((CallSite)((Object)("&a " + ammoType + ": &f" + ammoSection.getDouble(ammoType))));
            }
        }
        this.setSlot(23, new Slot(EditorGUI.createItem(Material.ARROW, "&eAmmo Types", (List<String>)StringUT.replace((String)"%current%", lore, (String[])new String[]{"&bCurrent:", "%current%", "&6Left-Click: &eModify"}))){

            public void onLeftClick() {
                EditorGUI.this.openSubMenu(new AmmoTypesGUI(EditorGUI.this.player, EditorGUI.this.itemGenerator));
            }
        });
        lore = new ArrayList();
        ConfigurationSection handSection = this.itemGenerator.getConfig().getConfigurationSection(ItemType.HAND_TYPES.getPath());
        if (handSection != null) {
            for (String string : handSection.getKeys(false)) {
                lore.add((CallSite)((Object)("&a " + string + ": &f" + handSection.getDouble(string))));
            }
        }
        this.setSlot(24, new Slot(EditorGUI.createItem(Material.STICK, "&eHand Types", (List<String>)StringUT.replace((String)"%current%", lore, (String[])new String[]{"&bCurrent:", "%current%", "&6Left-Click: &eModify"}))){

            public void onLeftClick() {
                EditorGUI.this.openSubMenu(new HandTypesGUI(EditorGUI.this.player, EditorGUI.this.itemGenerator));
            }
        });
        this.setSlot(27, new Slot(EditorGUI.createItem(Material.IRON_SWORD, "&eDamage Types", "&6Left-Click: &eModify")){

            public void onLeftClick() {
                EditorGUI.this.openSubMenu(new MainStatsGUI(EditorGUI.this.player, EditorGUI.this.itemGenerator, ItemType.DAMAGE_TYPES));
            }
        });
        this.setSlot(28, new Slot(EditorGUI.createItem(Material.IRON_CHESTPLATE, "&eDefense Types", "&6Left-Click: &eModify")){

            public void onLeftClick() {
                EditorGUI.this.openSubMenu(new MainStatsGUI(EditorGUI.this.player, EditorGUI.this.itemGenerator, ItemType.DEFENSE_TYPES));
            }
        });
        this.setSlot(29, new Slot(EditorGUI.createItem(Material.PAPER, "&eItem Stats", "&6Left-Click: &eModify")){

            public void onLeftClick() {
                EditorGUI.this.openSubMenu(new MainStatsGUI(EditorGUI.this.player, EditorGUI.this.itemGenerator, ItemType.ITEM_STATS));
            }
        });
        this.setSlot(30, new Slot(EditorGUI.createItem(Material.BOOK, "&eFabled Attributes", "&6Left-Click: &eModify")){

            public void onLeftClick() {
                EditorGUI.this.openSubMenu(new MainStatsGUI(EditorGUI.this.player, EditorGUI.this.itemGenerator, ItemType.FABLED_ATTRIBUTES));
            }
        });
        this.setSlot(31, new Slot(EditorGUI.createItem(Material.EMERALD, "&eSockets", "&6Left-Click: &eModify")){

            public void onLeftClick() {
                EditorGUI.this.openSubMenu(new MainSocketsGUI(EditorGUI.this.player, EditorGUI.this.itemGenerator));
            }
        });
        this.setSlot(32, new Slot(EditorGUI.createItem(Material.REDSTONE, "&eRequirements", "&6Left-Click: &eModify")){

            public void onLeftClick() {
                EditorGUI.this.openSubMenu(new MainRequirementsGUI(EditorGUI.this.player, EditorGUI.this.itemGenerator));
            }
        });
        this.setSlot(33, new Slot(EditorGUI.createItem(Material.ENCHANTED_BOOK, "&eEnchantments", "&6Left-Click: &eModify")){

            public void onLeftClick() {
                EditorGUI.this.openSubMenu(new EnchantmentsGUI(EditorGUI.this.player, EditorGUI.this.itemGenerator));
            }
        });
        this.setSlot(34, new Slot(EditorGUI.createItem(Material.FIRE_CHARGE, "&eSkills", "&6Left-Click: &eModify")){

            public void onLeftClick() {
                EditorGUI.this.openSubMenu(new MainSkillsGUI(EditorGUI.this.player, EditorGUI.this.itemGenerator));
            }
        });
        lore = new ArrayList();
        for (Map.Entry entry : UsesByLevelGUI.getUsesByLevel(this.itemGenerator.getConfig()).entrySet()) {
            lore.add((CallSite)((Object)("&a " + String.valueOf(entry.getKey()) + ": &f" + String.valueOf(entry.getValue()))));
        }
        this.setSlot(35, new Slot(EditorGUI.createItem(Material.CAULDRON, "&eUses by level", (List<String>)StringUT.replace((String)"%current%", lore, (String[])new String[]{"&bCurrent:", "&a%current%", "&6Left-Click: &eModify"}))){

            public void onLeftClick() {
                EditorGUI.this.openSubMenu(new UsesByLevelGUI(EditorGUI.this.player, EditorGUI.this.itemGenerator));
            }
        });
        this.setSlot(40, new Slot(this.itemGenerator.getHandle().create(-1, -1, null)){

            public void onLeftClick() {
                EditorGUI.this.saveAndReopen();
            }
        });
    }

    public static enum ItemType {
        NAME("name"),
        MATERIALS("generator.materials"),
        LORE("lore"),
        MODEL_DATA("model-data"),
        COLOR("color"),
        DURABILITY("durability"),
        UNBREAKABLE("unbreakable"),
        PREFIX_CHANCE("generator.prefix-chance"),
        SUFFIX_CHANCE("generator.suffix-chance"),
        ARMOR_TRIMINGS("generator.armor-trimmings"),
        ITEM_FLAGS("item-flags"),
        ENCHANTED("enchanted"),
        SKULL_HASH("skull-hash"),
        BONUSES("generator.bonuses"),
        MIN_LEVEL("level.min"),
        MAX_LEVEL("level.max"),
        TIER("tier"),
        AMMO_TYPES("generator.ammo-types"),
        HAND_TYPES("generator.hand-types"),
        DAMAGE_TYPES("generator.damage-types"),
        DEFENSE_TYPES("generator.defense-types"),
        ITEM_STATS("generator.item-stats"),
        FABLED_ATTRIBUTES("generator.fabled-attributes"),
        SOCKETS("generator.sockets"),
        REQUIREMENTS("user-requirements-by-level"),
        ENCHANTMENTS("generator.enchantments"),
        SKILLS("generator.skills"),
        USES_BY_LEVEL("uses-by-level"),
        SAMPLE(null);

        private final String path;

        private ItemType(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public String getTitle() {
            return this.name().replace('_', ' ').toLowerCase();
        }
    }
}

