/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.divinity.modules.list.drops;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexPlugin;
import studio.magemonkey.codex.commands.api.ISubCommand;
import studio.magemonkey.codex.config.api.JYML;
import studio.magemonkey.codex.hooks.Hooks;
import studio.magemonkey.codex.manager.api.MobGroup;
import studio.magemonkey.codex.util.actions.ActionManipulator;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.api.DivinityAPI;
import studio.magemonkey.divinity.hooks.external.MyPetHK;
import studio.magemonkey.divinity.hooks.external.mythicmobs.AbstractMythicMobsHK;
import studio.magemonkey.divinity.modules.api.QModule;
import studio.magemonkey.divinity.modules.list.drops.commands.DropsDropCmd;
import studio.magemonkey.divinity.modules.list.drops.commands.DropsGiveCmd;
import studio.magemonkey.divinity.modules.list.drops.object.Drop;
import studio.magemonkey.divinity.modules.list.drops.object.DropItem;
import studio.magemonkey.divinity.modules.list.drops.object.DropMob;
import studio.magemonkey.divinity.modules.list.drops.object.DropNonItem;
import studio.magemonkey.divinity.modules.list.drops.object.DropTable;
import studio.magemonkey.divinity.stats.EntityStats;
import studio.magemonkey.divinity.stats.items.attributes.api.TypedStat;

public class DropManager
extends QModule {
    private static final String META_DROP_MOB = "QRPG_NO_MOB_DROP";
    private Map<String, Float> dropModifier;
    private Map<String, DropMob> dropNpc;
    private Map<String, DropTable> dropTables;
    private AbstractMythicMobsHK mmHook;
    private MyPetHK myPetHook;

    public DropManager(@NotNull Divinity plugin) {
        super(plugin);
    }

    @NotNull
    public String getId() {
        return "drops";
    }

    @NotNull
    public String version() {
        return "2.1.0";
    }

    public void setup() {
        this.moduleCommand.addSubCommand((ISubCommand)new DropsDropCmd(this));
        this.moduleCommand.addSubCommand((ISubCommand)new DropsGiveCmd(this));
        ((Divinity)this.plugin).getConfigManager().extract(this.getPath() + "mobs");
        ((Divinity)this.plugin).getConfigManager().extract(this.getPath() + "tables");
        this.dropModifier = new HashMap<String, Float>();
        this.dropNpc = new HashMap<String, DropMob>();
        this.dropTables = new HashMap<String, DropTable>();
        JYML cfg_main = this.cfg;
        for (String s : cfg_main.getSection("multipliers")) {
            double d = cfg_main.getDouble("multipliers." + s);
            this.dropModifier.put(s.toLowerCase(), Float.valueOf((float)d));
        }
        for (JYML cfg : JYML.loadAll((String)(this.getFullPath() + "/tables/"), (boolean)true)) {
            try {
                DropTable dropTable = new DropTable((Divinity)this.plugin, cfg);
                this.dropTables.put(dropTable.getId(), dropTable);
            }
            catch (Exception ex) {
                this.error("Could not load Drop Table: " + cfg.getFile().getName());
                ex.printStackTrace();
            }
        }
        for (JYML cfg : JYML.loadAll((String)(this.getFullPath() + "/mobs/"), (boolean)true)) {
            try {
                DropMob npc = new DropMob((Divinity)this.plugin, cfg, this);
                this.dropNpc.put(npc.getId(), npc);
            }
            catch (Exception ex) {
                this.error("Could not load Mob Table: " + cfg.getFile().getName());
                ex.printStackTrace();
            }
        }
        this.mmHook = (AbstractMythicMobsHK)((Divinity)this.plugin).getHook(AbstractMythicMobsHK.class);
        this.myPetHook = (MyPetHK)((Divinity)this.plugin).getHook(MyPetHK.class);
    }

    public void shutdown() {
        if (this.dropModifier != null) {
            this.dropModifier.clear();
            this.dropModifier = null;
        }
        if (this.dropNpc != null) {
            this.dropNpc.clear();
            this.dropNpc = null;
        }
        if (this.dropTables != null) {
            this.dropTables.clear();
            this.dropTables = null;
        }
    }

    public List<DropTable> getTables() {
        return this.dropTables.values().stream().collect(Collectors.toList());
    }

    @Nullable
    public DropTable getTableById(@NotNull String id) {
        return this.dropTables.get(id.toLowerCase());
    }

    private String getMobType(Entity entity) {
        if (this.mmHook != null && this.mmHook.isMythicMob(entity)) {
            return this.mmHook.getMythicNameByEntity(entity);
        }
        return entity.getType().name();
    }

    @NotNull
    private boolean isVanillaCancelled(@NotNull Entity entity) {
        boolean cancelled = false;
        if (!(entity instanceof LivingEntity)) {
            return cancelled;
        }
        String mobType = this.getMobType(entity);
        boolean isMythic = this.mmHook != null && this.mmHook.isMythicMob(entity);
        for (DropMob dropNpc : this.dropNpc.values()) {
            MobGroup group;
            boolean contains;
            Set<String> mobList = isMythic ? dropNpc.getMythic() : dropNpc.getEntities();
            boolean bl = contains = mobList.contains("*") || mobList.contains(mobType);
            if (!isMythic && mobList.contains((group = MobGroup.getMobGroup((Entity)entity)).name())) {
                contains = true;
            }
            if (!contains || dropNpc.isVanillaDrops()) continue;
            cancelled = true;
            break;
        }
        return cancelled;
    }

    @NotNull
    private Set<DropMob> getDropsForEntity(@NotNull Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return Collections.emptySet();
        }
        String mobType = this.getMobType(entity);
        boolean isMythic = this.mmHook != null && this.mmHook.isMythicMob(entity);
        HashSet<DropMob> tables = new HashSet<DropMob>();
        for (DropMob dropNpc : this.dropNpc.values()) {
            MobGroup group;
            Set<String> mobList = isMythic ? dropNpc.getMythic() : dropNpc.getEntities();
            if (mobList.contains("*")) {
                tables.add(dropNpc);
                continue;
            }
            if (!isMythic && mobList.contains((group = MobGroup.getMobGroup((Entity)entity)).name())) {
                tables.add(dropNpc);
                continue;
            }
            if (!mobList.contains(mobType)) continue;
            tables.add(dropNpc);
        }
        ArrayList tableNames = new ArrayList();
        tables.forEach(table -> table.getDropTables().forEach(t -> tableNames.add(t.getGroupName())));
        return tables;
    }

    private float getMultiplier(@NotNull Player player, @NotNull LivingEntity dead) {
        float mult = 0.0f;
        float multGroup = 0.0f;
        float multStat = 0.0f;
        String group = Hooks.getPermGroup((Player)player);
        if (this.dropModifier.containsKey(group)) {
            multGroup += (this.dropModifier.get(group).floatValue() - 1.0f) * 100.0f;
        }
        multStat = (float)((double)multStat + EntityStats.get((LivingEntity)player).getItemStat(TypedStat.Type.LOOT_RATE, false));
        mult = 1.0f + (multGroup + multStat) / 100.0f;
        return mult;
    }

    @NotNull
    private List<ItemStack> methodRoll(@NotNull Player killer, @NotNull LivingEntity dead) {
        ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
        Set<DropMob> mobs = this.getDropsForEntity((Entity)dead);
        float modifier = this.getMultiplier(killer, dead);
        HashMap<String, Set<Entity>> mapTarget = new HashMap<String, Set<Entity>>();
        mapTarget.put("player", Sets.newHashSet((Object[])new Entity[]{killer}));
        mapTarget.put("entity", Sets.newHashSet((Object[])new Entity[]{dead}));
        for (DropMob dropNpc : mobs) {
            Set<Drop> drop = dropNpc.dropCalculator(killer, dead, modifier);
            for (Drop dropItem : drop) {
                DropItem dropConfig = dropItem.getDropConfig();
                List<String> dropConditions = dropConfig.getConditions();
                if (!ActionManipulator.processConditions((CodexPlugin)((CodexPlugin)this.plugin), (Entity)killer, dropConditions, mapTarget)) continue;
                String itemId = dropConfig.getItemId();
                String tierId = dropConfig.getTierId();
                for (int i = 0; i < dropItem.getCount(); ++i) {
                    int itemLvl = dropConfig.getLevel(killer, dead);
                    ItemStack dropStack = DivinityAPI.getItemByModule(dropConfig.getModuleId(), itemId, itemLvl, -1, -1, tierId);
                    if (dropStack == null || dropStack.getType() == Material.AIR) continue;
                    dropConfig.executeActions(killer, mapTarget);
                    loot.add(dropStack);
                }
            }
            for (DropTable table : dropNpc.getDropTables()) {
                for (DropNonItem nonItemDrop : table.getNonItemDrops()) {
                    nonItemDrop.execute(killer);
                }
            }
        }
        return loot;
    }

    public List<ItemStack> rollTable(Player target, DropTable table, int itemLvl) {
        float modifier = 1.0f;
        ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
        LivingEntity dead = (LivingEntity)target.getWorld().spawnEntity(target.getLocation(), EntityType.BAT);
        HashMap<String, Set<Entity>> mapTarget = new HashMap<String, Set<Entity>>();
        mapTarget.put("player", Sets.newHashSet((Object[])new Entity[]{target}));
        mapTarget.put("entity", Sets.newHashSet((Object[])new Entity[]{dead}));
        Set<Drop> drop = table.dropCalculator(target, dead, modifier);
        for (Drop dropItem : drop) {
            DropItem dropConfig = dropItem.getDropConfig();
            List<String> dropConditions = dropConfig.getConditions();
            if (!ActionManipulator.processConditions((CodexPlugin)((CodexPlugin)this.plugin), (Entity)target, dropConditions, mapTarget)) continue;
            String itemId = dropConfig.getItemId();
            String tierId = dropConfig.getTierId();
            for (int i = 0; i < dropItem.getCount(); ++i) {
                ItemStack dropStack = DivinityAPI.getItemByModule(dropConfig.getModuleId(), itemId, itemLvl, -1, -1, tierId);
                if (dropStack == null || dropStack.getType() == Material.AIR) continue;
                dropConfig.executeActions(target, mapTarget);
                loot.add(dropStack);
            }
        }
        for (DropNonItem nonItemDrops : table.getNonItemDrops()) {
            nonItemDrops.execute(target);
        }
        dead.remove();
        return loot;
    }

    public List<ItemStack> rollTable(Location loc, DropTable table, int itemLvl) {
        float modifier = 1.0f;
        ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
        LivingEntity dead = (LivingEntity)loc.getWorld().spawnEntity(loc, EntityType.BAT);
        Set<Drop> drop = table.dropCalculator(null, dead, modifier);
        for (Drop dropItem : drop) {
            DropItem dropConfig = dropItem.getDropConfig();
            String itemId = dropConfig.getItemId();
            String tierId = dropConfig.getTierId();
            for (int i = 0; i < dropItem.getCount(); ++i) {
                ItemStack dropStack = DivinityAPI.getItemByModule(dropConfig.getModuleId(), itemId, itemLvl, -1, -1, tierId);
                if (dropStack == null || dropStack.getType() == Material.AIR) continue;
                loot.add(dropStack);
            }
        }
        dead.remove();
        return loot;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onDropDeath(EntityDeathEvent e) {
        LivingEntity dead = e.getEntity();
        if (dead.hasMetadata(META_DROP_MOB)) {
            return;
        }
        Player killer = dead.getKiller();
        if (killer == null) {
            EntityDamageByEntityEvent ede;
            Entity damager;
            EntityDamageEvent e2;
            if (this.myPetHook != null && (e2 = dead.getLastDamageCause()) instanceof EntityDamageByEntityEvent && this.myPetHook.isPet(damager = (ede = (EntityDamageByEntityEvent)e2).getDamager())) {
                killer = this.myPetHook.getPetOwner(damager);
            }
            if (killer == null) {
                return;
            }
        }
        if (this.isVanillaCancelled((Entity)dead)) {
            e.getDrops().clear();
        }
        e.getDrops().addAll(this.methodRoll(killer, dead));
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onDropSpawn(final CreatureSpawnEvent e) {
        new BukkitRunnable(){

            public void run() {
                LivingEntity entity = e.getEntity();
                Set<DropMob> mobs = DropManager.this.getDropsForEntity((Entity)entity);
                if (mobs.isEmpty()) {
                    return;
                }
                String reason = e.getSpawnReason().name();
                for (DropMob dropNpc : mobs) {
                    if (!dropNpc.getReasons().contains(reason)) continue;
                    entity.setMetadata(DropManager.META_DROP_MOB, (MetadataValue)new FixedMetadataValue((Plugin)DropManager.this.plugin, (Object)"yes"));
                    break;
                }
            }
        }.runTask((Plugin)this.plugin);
    }
}

